package tm.tmdiagram.tmdeditor.model.command;

import org.eclipse.gef.commands.Command;

import tm.tmdiagram.tmdeditor.model.ConnectableElement;
import tm.tmdiagram.tmdeditor.model.Entity;
import tm.tmdiagram.tmdeditor.model.Identifier;
import tm.tmdiagram.tmdeditor.model.Relationship;
import tm.tmdiagram.tmdeditor.model.AbstractEntityModel.EntityType;

public class Resource2EventConnectionCreateCommand extends Command {
	private Entity source, target;
	private Relationship connection;

	@Override
	public boolean canExecute() {
		return source != null && target != null;
	}
	@Override
	public void execute() {
		System.out.println(getClass().toString() + "#execute()");
		switchEntity();
		connection.attachSource();
		connection.attachTarget();
		target.addReuseKey(new Identifier(source.getIdentifier().getName()));
//		if (source.getEntityType().equals(EntityType.E) && target.getEntityType().equals(EntityType.R)) {
//			source.addReuseKey(new Identifier(target.getIdentifier().getName()));
//		} else if (source.getEntityType().equals(EntityType.R) && target.getEntityType().equals(EntityType.E)) {
//			target.addReuseKey(new Identifier(source.getIdentifier().getName()));
//		}
	}
	private void switchEntity() {
		if (source.getEntityType().equals(EntityType.E)) {
			Entity originalSource = source;
			setSource(target);
			setTarget(originalSource);
		}
	}
	@Override
	public void undo() {
		connection.detachSource();
		connection.detachTarget();
	}

	public void setConnection(Object connection) {
		this.connection = (Relationship) connection;
	}
	
	public void setSource(Object source) {
		this.source = (Entity) source;
		this.connection.setSource(this.source);
	}
	
	public void setTarget(Object target) {
		this.target = (Entity) target;
		this.connection.setTarget(this.target);
	}
	/**
	 * @return the connection
	 */
	public Relationship getConnection() {
		return connection;
	}
	/**
	 * @return the source
	 */
	public ConnectableElement getSource() {
		return source;
	}
	/**
	 * @return the target
	 */
	public ConnectableElement getTarget() {
		return target;
	}

}
