﻿//Reversi Project
//Thanks to : Masanori Ueno & Hiroshi Ibaraki
//copyright(c)2014 NANDENJIN Laboratory / Kazumi Inada 

if(!reversi){
	var reversi={};
}
if(!reversi.style){
	reversi.style={};
}
reversi.DIRECTIONS=['t','b','l','r','tl','tr','bl','br'];

reversi.style.dnp='position:absolute;top:10%;left:10%;width:80%;height:80%;border-radius:50%;background:transparent;text-align:center;';

//ボードオブジェクト
reversi.Board=function(w,h){
	var b=[];
	for(var i=0;i<h;i++){
		b[i]=[];
		for(var j=0;j<w;j++){
			b[i][j]=0;
		}
	}
	
	
	//ボード内に存在するセルか検査
	//isDefine(reversi.Cursor):Boolean
	var isDefine=function(c){
		if(c.x<0||c.y<0||c.x>=w||c.y>=h){
			return false;
		}else{
			return true;
		}
	};
	
	//イベントリスナ起動
	var callEventListeners=function(){
		bObj.eventListeners.forEach(function(f){
			f();
		});
	};
	
	var bObj={
		width:w,
		height:h,
		board:b,
		reaching:[],
		eventListeners:[],
		result:[],
		
		//カーソルからボード内のデータを取得
		getDataByCursor:function(c){
			return this.board[c.y][c.x];
		},
		
		//カーソルから上下左右のセルのカーソルを取得
		getCursorByDirection:function(c,dir){
			if(dir.indexOf('l')>=0){
				c.x--;
			}else if(dir.indexOf('r')>=0){
				c.x++;
			}
			if(dir.indexOf('b')>=0){
				c.y++;
			}else if(dir.indexOf('t')>=0){
				c.y--;
			}
			if(isDefine(c)){
				return c;
			}else{
				return null;
			}
		},
		
		//ピースを置くことができるか判定
		countScoreByCursor:function(c,r){
			var cnt=0;
			var reaching=[];
			this.reaching=[];
			if(b[c.y][c.x]!=0){
				return 0;
			}
			reversi.DIRECTIONS.forEach((function(obj){
				return function(d){
					var dirCnt=0;
					var cur=new reversi.Cursor(c.x,c.y);
					while(true){
						cur=obj.getCursorByDirection(cur,d);
						if(!cur){
							dirCnt=0;
							reaching=[];
							break;
						}
						
						var dt=cur.getDataByBoard(obj);
						if(dt===0){
							dirCnt=0;
							reaching=[];
							break;
						}else if(dt!=r){
							dirCnt++;
							reaching.push(new reversi.Cursor(cur.x,cur.y));
						}else if(dt==r){
							cnt+=dirCnt;
							for(var l=0;l<reaching.length;l++){
								obj.reaching.push(reaching[l]);
							}
							reaching=[];
							break;
						}
					}
				};
			})(this));
			return cnt;
		},
		
		//ピースを置くことができるセルを取得
		getAbleToPut:function(r){
			var result=[],rtn=[];
			for(var i=0;i<b.length;i++){
				for(var j=0;j<b[i].length;j++){
					var cs=new reversi.Cursor(j,i);
					var sc=this.countScoreByCursor(cs,r);
				
					if(sc>0&&this.getDataByCursor(cs)==0){
						result.push(cs.clone());
						rtn.push(sc);
					}
				}
			}
			this.result=result;
			return rtn;
		},
		
		//プレーヤとしてピースを置く
		putDataByCursor:function(c,r,su){
			var score=this.countScoreByCursor(c,r);
			if(score>0||su){
				b[c.y][c.x]=r;
				this.reaching.forEach((function(b){
					return function(l){
						b[l.y][l.x]=r;
					};
				})(this.board));
				callEventListeners();
				return true;
			}else{
				return false;
			}
		},
		
		//クローンを作成
		clone:function(){
			var c=new reversi.Board(w,h);
			for(var i=0;i<h;i++){
				for(var j=0;j<w;j++){
					c.board[i][j]=this.board[i][j];
				}
			}
			return c;
		},
		
		//プレーヤ毎の点数を換算
		countPlayerScore:function(){
			var rtn=[0,0,0];
			for(var i=0;i<this.board.length;i++){
				for(var j=0;j<this.board[i].length;j++){
					rtn[this.board[i][j]]++;
				}
			}
			return rtn;
		}
	};
	
	return bObj;
};
reversi.Cursor=function(x,y){
	return {
		x:x,
		y:y,
		//ボードを渡してデータを取得
		getDataByBoard:function(b){
			return b.board[this.y][this.x];
		},
		//プレーヤとしてピースを置く(ボード側メソッドへのエイリアス)
		putDataByBoard:function(b,r){
			b.putDataByCursor(this,r);
		},
		
		//クローンを作成
		clone:function(){
			var rtn=new reversi.Cursor(x,y);
			return rtn;
		}
	};
};

//ビジュアライザ
reversi.Visualizer=function(b){
	var w=b.width,h=b.height;
	
	//DOMノードを生成
	var perNodes=[],perBlocks=[];
	var dom=document.createElement('div');
	dom.style.position='relative';
	dom.style.width='500px';
	dom.style.height='500px';
	for(var y=0;y<b.height;y++){
		perNodes[y]=[],perBlocks[y]=[];
		for(var x=0;x<b.width;x++){
			var dnp=document.createElement('div');
			dnp.style.cssText=reversi.style.dnp;
 			var dn=document.createElement('div');
			dn.style.position='absolute';
			dn.style.top=(100/h)*y+'%';
			dn.style.left=(100/w)*x+'%';
			dn.style.width=100/w+'%';
			dn.style.height=100/h+'%';
			dn.style.border='1px solid #000';
			dn.style.background='#888';
			dn.appendChild(dnp);
			//dn.style.borderRadius='50%';
			dom.appendChild(dn);
			perBlocks[y][x]=dn;
			perNodes[y][x]=dnp;
		}
	}
	
	//生成時に最初の盤面を取得し表示
	var catche=[];
	for(var j=0;j<b.height;j++){
		catche[j]=[];
		for(var k=0;k<b.width;k++){
			catche[j][k]=b.board[j][k];
			if(catche[j][k]==1){
				perNodes[j][k].style.background='#000';
			}else if(catche[j][k]==2){
				perNodes[j][k].style.background='#CCC';
			}
		}
	}
	
	//盤面を再描画
	var update=function(){
		for(var j=0;j<b.height;j++){
			for(var k=0;k<b.width;k++){
				if(obj.displayScore>0){
					perNodes[j][k].innerHTML=b.countScoreByCursor(new reversi.Cursor(k,j),obj.displayScore);
				}
				if(catche[j][k]==b.board[j][k]){
					perNodes[j][k].style.opacity=0.7;
					continue;
				}else{
					perNodes[j][k].style.opacity=1;
				}
				catche[j][k]=b.board[j][k];
				if(catche[j][k]==1){
					perNodes[j][k].style.background='#000';
				}else if(catche[j][k]==2){
					perNodes[j][k].style.background='#FFF';
				}
			}
		}
	};
	
	//DOMからイベントを入力
	var addEvent=function(f){
		for(var l=0;l<perNodes.length;l++){
			for(var m=0;m<perNodes[l].length;m++){
				perBlocks[l][m].addEventListener('click',(function(m,l){
					return function(){
						f(m,l);
					};
				})(m,l));
			}
		}
	};
	
	//ボードからのイベントを取得
	b.eventListeners.push(update);
	
	var obj={
		target:b,
		dom:dom,
		update:update,
		displayScore:0,
		eventListeners:[],
		addEvent:addEvent
	};

	
	return obj;
};