#include <CoreFoundation/CoreFoundation.h>
#include <CoreServices/CoreServices.h>
#include <QuickLook/QuickLook.h>
#include <Cocoa/Cocoa.h>
#import "ECScene.h"

/* -----------------------------------------------------------------------------
   Generate a preview for file

   This function's job is to create preview for designated file
   ----------------------------------------------------------------------------- */

OSStatus GeneratePreviewForURL(void *thisInterface, QLPreviewRequestRef preview, CFURLRef url, CFStringRef contentTypeUTI, CFDictionaryRef options)
{
    id pool = [[NSAutoreleasePool alloc] init];
    ECScene *scene = [[ECScene alloc] initWithContentsOfURL: (id)url];
    CGSize size = [scene size];
    CGContextRef context = QLPreviewRequestCreateContext(preview,size,true,nil);
    [scene drawSceneWithContext: context];
    
    QLPreviewRequestFlushContext(preview, context);
    CFRelease(context);
    [scene release];
    [pool release];
    return noErr;
}

void CancelPreviewGeneration(void* thisInterface, QLPreviewRequestRef preview)
{
    // implement only if supported
}
