//
//  ECDSegment.h
//  Etokicho
//
//  Created by 二鏡 on 11/12/06.
//  Copyright (c) 2011年 二鏡庵. All rights reserved.
//

#import <Foundation/Foundation.h>
#import <CoreData/CoreData.h>
#import "ECRenderer.h"

extern NSString *plistSegmentMsecKey;
extern NSString *plistSegmentTypeKey;

extern NSString *ECDPasteboardTypeSegment;

@class ECDTimeline;

@interface ECDSegment : NSManagedObject <ECRendererSegment>

@property (nonatomic) int64_t msec;
@property (nonatomic, retain) ECDTimeline *timeline;

@property (readwrite) BOOL lightPreview;

+ (id)standardRenderAttributes;
+ (NSURL*)propertyListForLocation:(NSURL*)URL;
+ (CGImageRef)allocBlackImage:(CGSize)size;

// file I/O
+ (id)attachSegmentWithContentsOfURL:(NSURL*)URL
                           inContext:(NSManagedObjectContext*)context;


// --- subclass override ---
+ (NSString*)segmentType;
- (id)loadContentsOfURL:(NSURL*)URL
           propertyList:(NSDictionary*)plist
              inContext:(NSManagedObjectContext*)context;
- (BOOL)writeToURL:(NSURL*)URL;
- (void)resolveTemporaryResources;
- (id)cloneInContext:(NSManagedObjectContext*)context;
@end
