//
//  ECDTimeline.h
//  Etokicho
//
//  Created by 二鏡 on 11/12/06.
//  Copyright (c) 2011年 二鏡庵. All rights reserved.
//

#import <Foundation/Foundation.h>
#import <CoreData/CoreData.h>

@class ECDSegment;

@interface ECDTimeline : NSManagedObject

@property (nonatomic) int64_t fps;  // 生成FPS
@property (nonatomic, retain) NSOrderedSet *segments;
@end

@interface ECDTimeline (CoreDataGeneratedAccessors)

- (void)insertObject:(ECDSegment *)value inSegmentsAtIndex:(NSUInteger)idx;
- (void)removeObjectFromSegmentsAtIndex:(NSUInteger)idx;
- (void)insertSegments:(NSArray *)value atIndexes:(NSIndexSet *)indexes;
- (void)removeSegmentsAtIndexes:(NSIndexSet *)indexes;
- (void)replaceObjectInSegmentsAtIndex:(NSUInteger)idx withObject:(ECDSegment *)value;
- (void)replaceSegmentsAtIndexes:(NSIndexSet *)indexes withSegments:(NSArray *)values;
- (void)addSegmentsObject:(ECDSegment *)value;
- (void)removeSegmentsObject:(ECDSegment *)value;
- (void)addSegments:(NSArray *)values;
- (void)removeSegments:(NSOrderedSet *)values;
@end
