//
//  ECDTransitionSegment.h
//  Etokicho
//
//  Created by 二鏡 on 11/12/06.
//  Copyright (c) 2011年 二鏡庵. All rights reserved.
//

#import <Foundation/Foundation.h>
#import <CoreData/CoreData.h>
#import "ECDSegment.h"
#import "ECQCCompositionItem.h"

@interface ECDTransitionSegment : ECDSegment
{
    // 遷移用の画像データ。レンダリング前に外から与える揮発性データで、外部に保存しない。
    // 終了後にnilクリアしてメモリ解放するべき
    CIImage *srcImage;
    CIImage *dstImage;
}

@property (nonatomic, retain) NSString * templateName; // 本当はcopyがいいけど面倒だし
@property (nonatomic) BOOL flipHorizontal;
@property (nonatomic,copy) ECQCCompositionItem* item;

- (void)setSourceImage:(CIImage*)image;
- (void)setDestinationImage:(CIImage*)image;
- (void)clearImage;

@end

// Transitionは常にcurrentパラメータからインスタンス化する
// autoreleased
@interface ECDTransitionSegment (CurrentTransition)
+ (id)attachNewTransitionInContext:(NSManagedObjectContext*)context;
@end
