//
//  ECScenePropertyPanelController.m
//  Etokicho
//
//  Created by 二鏡 on 11/11/18.
//  Copyright 2011年 二鏡庵. All rights reserved.
//

#import "ECScenePropertyPanelController.h"
#import "ECSceneComposition.h"
#import "ECLayer_Defaults.h"
#import "ECScene.h"

static id _si = nil;

@implementation ECScenePropertyPanelController

+ (id)sharedPanel
{
    if(_si == nil)
    {
        _si = [[self alloc] initWithWindowNibName: @"ScenePropertyPanel"];
        [_si window];
    }
    return _si;
}

- (void)awakeFromNib
{
    [self setWindowFrameAutosaveName: @"ScenePropertyPanelFrame"];
}

- (NSUndoManager *)windowWillReturnUndoManager:(NSWindow *)window
{
    ECSceneComposition *sceneProxy = [[sceneController selection] valueForKey: @"self"];
    return sceneProxy.undo;
}

- (IBAction)up:(id)sender
{
    ECSceneComposition *sceneProxy = [[sceneController selection] valueForKey: @"self"];
    [sceneProxy up];
}

- (IBAction)down:(id)sender
{
    ECSceneComposition *sceneProxy = [[sceneController selection] valueForKey: @"self"];
    [sceneProxy down];
}

- (IBAction)insert:(id)sender
{
    ECSceneComposition *sceneProxy = [[sceneController selection] valueForKey: @"self"];
    [sceneProxy insertRegular];
}

- (IBAction)remove:(id)sender
{
    ECSceneComposition *sceneProxy = [[sceneController selection] valueForKey: @"self"];
    [sceneProxy remove];
}
@end
