//
//  ECTransitionEditorPanelController.h
//  Etokicho
//
//  Created by 二鏡 on 11/11/25.
//  Copyright 2011年 二鏡庵. All rights reserved.
//

#import <Cocoa/Cocoa.h>
#import <Quartz/Quartz.h>
@class ECTransitionSampleView;

@interface ECTransitionEditorPanelController : NSWindowController
{
    NSString *name;
    NSString *compositionID;
    NSDictionary *parameters;
    BOOL flipHorizontal;
    NSInteger duration; // msec
    
    BOOL simulating;
    
    CGFloat transition;
    struct {
        CGFloat step;
        CGFloat passed;
    } simulation;
    
    CGImageRef customSource;
    CGImageRef customDestination;
    
    QCRenderer *renderer; // -> composition & parameters
    CGSize rendererSize;
    IBOutlet QCCompositionParameterView *parameterView;
    IBOutlet QCCompositionPickerView *pickerView;
    IBOutlet NSPopover *popover;
    IBOutlet ECTransitionSampleView *renderView;
}
+ (id)sharedTransitionEditor;
// for simulation
@property (readwrite) CGFloat transition;
@property (readonly) BOOL simulating;
@property (readonly) BOOL hasComposition;
@property (readonly) BOOL hasName;
@property (readwrite) CGImageRef customSource; // CGImageRefとする
@property (readwrite) CGImageRef customDestination;

@property (readwrite) BOOL flipHorizontal;
@property (readwrite,copy) NSString *name;
@property (readwrite,copy) NSString *compositionID;
@property (readwrite,copy) NSDictionary *parameters;
@property (readwrite) NSInteger duration; // Core Data互換なのでinteger扱いする
- (void)loadInitialState;
- (void)loadCompositionWithParameters;

- (NSInteger)startModal;

- (IBAction)ok:(id)sender;
- (IBAction)cancel:(id)sender;
- (IBAction)simulate:(id)sender;
- (IBAction)showComposition:(id)sender;
@end
