//
//  NewProjectPanelController.h
//  Etokicho
//
//  Created by 二鏡 on 11/11/17.
//  Copyright 2011年 二鏡庵. All rights reserved.
//

#import <Cocoa/Cocoa.h>

typedef enum {
    eNicoWideMode = 0, // 16x9 640x360  
    eNicoStdMode,      //  4x3 512x384
    eNicoNoMode,       // termination
} eResolutionMode;

typedef enum {
    e1FPS = 0,
    e5FPS,
    e15FPS,
    e20FPS,
    e24FPS,
    e30FPS,
    e60FPS,
    eNoneFPS,
} eFrameMode;

// one shot panel
@interface NewProjectPanelController : NSWindowController
{
    eResolutionMode mode;
    eFrameMode frameMode;
}
@property (readwrite) eResolutionMode mode;
@property (readwrite) eFrameMode frameMode;
+ (id)sharedPanel;
- (void)beginWithCompletionHandler:(void (^)(NSInteger))handler;

- (NSSize)sizeForMode:(eResolutionMode)mode;
- (NSInteger)frameRateForMode:(eFrameMode)mode;
- (IBAction)ok:(id)sender;
- (IBAction)cancel:(id)sender;
@end
