//
//  NewProjectPanelController.m
//  Etokicho
//
//  Created by 二鏡 on 11/11/17.
//  Copyright 2011年 二鏡庵. All rights reserved.
//

#import "NewProjectPanelController.h"
#import "MainController.h"

static
NSSize sceneSizes[] = {
    {640,360},
    {512,384},
};

static
NSUInteger frames[] = {
    1,5,15,20,24,30,60,
};

static id _si ;

@implementation NewProjectPanelController
@synthesize mode, frameMode;
+ (id)sharedPanel
{
    if(_si == nil)
    {
        _si = [[self alloc] initWithWindowNibName: @"NewProjectPanel"];
        [_si window];
    }
    return _si;
}

- (void)beginWithCompletionHandler:(void (^)(NSInteger))handler
{
    NSWindow *window = [self window];
    [window center];
    self.mode = eNicoWideMode;
    self.frameMode = e20FPS;
    [window orderFront: self];
    NSInteger ret = [NSApp runModalForWindow: window];
    handler(ret);

    [[self window] close];
}

- (NSSize)sizeForMode:(eResolutionMode)aMode
{
    return sceneSizes[aMode];
}

- (NSInteger)frameRateForMode:(eFrameMode)aMode
{
    return frames[aMode];
}

- (IBAction)ok:(id)sender
{
    [NSApp stopModalWithCode: NSOKButton];
    [[self window] close];
}

- (IBAction)cancel:(id)sender
{
    [NSApp stopModalWithCode: NSCancelButton];
}

@end
