//
//  MSScriptItem.m
//  ScriptItemTest
//
//  Created by 木谷 洋 on 12/03/31.
//  Copyright (c) 2012年 二鏡庵. All rights reserved.
//

#import "MSScriptItem.h"

static NSRegularExpression* filenamePattern;
static NSRegularExpression* inputPattern;
static NSRegularExpression* outputPattern;
static SEL sAction;

@interface MSScriptItem ()
@property (readwrite,copy) NSURL *URL;
@property (readwrite,copy) NSString *name;
- (id)initWithURL:(NSURL*)aURL; // 内部用
@end

@interface MSScriptActionItem ()
@property (readwrite,copy) NSString *keyEquivalent;
@property (readwrite) NSInteger modifierFlag;
@property (readwrite) eScriptItemInputMode inputMode;
@property (readwrite) eScriptItemOutputMode outputMode;
@end

@interface MSScriptSubmenuItem ()
@property (readwrite,copy) NSArray *subItems;
@end

@implementation MSScriptItem
@synthesize URL, name;
+ (void)initialize
{
    filenamePattern = [NSRegularExpression regularExpressionWithPattern: @"[^-]*-([^-]*)-([^-]*)"
                                                                options: 0 
                                                                  error: nil];
    inputPattern    = [NSRegularExpression regularExpressionWithPattern: @"%%%\\{ManuscriptXInput=(.*)\\}%%%"
                                                                options: 0
                                                                  error: nil];
    outputPattern   = [NSRegularExpression regularExpressionWithPattern: @"%%%\\{ManuscriptXOutput=(.*)\\}%%%" 
                                                                options: 0 
                                                                  error: nil];
}

+ (id)itemWithURL:(NSURL*)aURL
{
    id path = [aURL path];
    id body = [[aURL lastPathComponent] stringByDeletingPathExtension];
    id match = [filenamePattern firstMatchInString: body options: 0 range: NSMakeRange(0,[body length])];
    
    // 合わないファイル名
    if(match == nil)
        return nil;
    
    // nameが省略されている場合はセパレータと見なす
    id name = [body substringWithRange: [match rangeAtIndex: 1]];
    if([name isEqualToString: @""])
        return [[MSScriptSeparatorItem alloc] init];
    
    BOOL isDir;
    id fm = [NSFileManager defaultManager];
    [fm fileExistsAtPath: path isDirectory: &isDir];
    if(isDir)
        return [[MSScriptSubmenuItem alloc] initWithURL: aURL];
    else
        return [[MSScriptActionItem alloc] initWithURL: aURL];
}

+ (id)itemsOfDirectoryAtURL:(NSURL*)aURL
{
    id fm = [NSFileManager defaultManager];
    id files = [fm contentsOfDirectoryAtPath: [aURL path]
                                       error: nil];
    files = [files sortedArrayUsingSelector: @selector(compare:)];
    
    id ret = [NSMutableArray array];
    for(id aFile in files)
    {
        id itemURL = [aURL URLByAppendingPathComponent: aFile];
        id item = [self itemWithURL: itemURL];
        if(item)
            [ret addObject: item];
    }
    
    return [ret copy];
}

+ (void)setAction:(SEL)aSelector
{
    sAction = aSelector;
}

- (id)initWithURL:(NSURL*)aURL
{
    return nil;
}

- (NSMenuItem*)menuItem
{
    return nil;
}
@end


@implementation MSScriptActionItem
@synthesize keyEquivalent, modifierFlag, inputMode, outputMode;
- (id)initWithURL:(NSURL*)aURL
{
    id fm = [NSFileManager defaultManager];
    id path = [aURL path];
    if([fm isExecutableFileAtPath: path] == NO)
        return nil;
    
    id body = [[path lastPathComponent] stringByDeletingPathExtension];
    id match = [filenamePattern firstMatchInString: body options: 0 range: NSMakeRange(0,[body length])];
    
    self.name = [body substringWithRange: [match rangeAtIndex: 1]];
    self.URL = aURL;
    
    [self _testKeyEquivalent: [body substringWithRange: [match rangeAtIndex:2]]];
    if([self _testContent:aURL] == NO)
        return nil;
    
    return self;
}

- (void)_testKeyEquivalent:(NSString*)string
{
    NSInteger flag = 0;
    NSRange range;
    id scanner = [NSScanner scannerWithString: string];
    id modifierKeys = [NSCharacterSet characterSetWithCharactersInString: @"@#~^"];
    id modStr = nil, keyStr = nil;
    [scanner scanCharactersFromSet: modifierKeys
                        intoString: &modStr];
    [scanner scanUpToString: @"" intoString: &keyStr];
    
    if(modStr)
    {
        range = [modStr rangeOfString: @"@"];
        if(range.location != NSNotFound)
            flag |= NSCommandKeyMask;
        range = [modStr rangeOfString: @"#"];
        if(range.location != NSNotFound)
            flag |= NSShiftKeyMask;
        range = [modStr rangeOfString: @"~"];
        if(range.location != NSNotFound)
            flag |= NSAlternateKeyMask;
        range = [modStr rangeOfString: @"^"];
        if(range.location != NSNotFound)
            flag |= NSControlKeyMask;
        self.modifierFlag = flag;
    }
    
    if(keyStr)
    {
        if([keyStr length]>0)
        {
            self.keyEquivalent = [keyStr substringWithRange: NSMakeRange(0,1)];
            return;
        }
    }
    self.keyEquivalent = @""; // 当てはまらない場合は空文字列
}

- (BOOL)_testContent:(NSURL*)aURL
{
    id content = [NSString stringWithContentsOfURL: aURL encoding: NSUTF8StringEncoding error: nil];
    if(content == nil)
        return NO;
    
    NSRange range = NSMakeRange(0, [content length]);
    
    id inputMatch = [inputPattern firstMatchInString: content options: 0 range: range];
    id outputMatch = [outputPattern firstMatchInString: content options: 0 range: range];
    
    if(inputMatch != nil)
    {
        id mode = [content substringWithRange: [inputMatch rangeAtIndex: 1]];
        if([mode isEqualToString: @"None"])
            self.inputMode = eInputModeNone;
        else if([mode isEqualToString: @"Selection"])
            self.inputMode = eInputModeSelection;
        else if([mode isEqualToString: @"All"])
            self.inputMode = eInputModeAll;
    }
    
    if(outputMatch != nil)
    {
        id mode = [content substringWithRange: [outputMatch rangeAtIndex: 1]];
        if([mode isEqualToString: @"Discard"])
            self.outputMode = eOutputModeDiscard;
        else if([mode isEqualToString: @"ReplaceSelection"])
            self.outputMode = eOutputModeReplaceSelection;
        else if([mode isEqualToString: @"ReplaceAll"])
            self.outputMode = eOutputModeReplaceAll;
        else if([mode isEqualToString: @"InsertAfter"])
            self.outputMode = eOutputModeInsertAfter;
        else if([mode isEqualToString: @"Append"])
            self.outputMode = eOutputModeAppend;
        else if([mode isEqualToString: @"Pasteboard"])
            self.outputMode = eOutputModePasteboard;
    }
    
    return YES;
}

- (NSMenuItem*)menuItem
{
    id item = [[NSMenuItem alloc] initWithTitle: self.name
                                         action: sAction
                                  keyEquivalent: self.keyEquivalent];
    [item setKeyEquivalentModifierMask: self.modifierFlag];
    [item setRepresentedObject: self];
    return item;
}
@end

@implementation MSScriptSeparatorItem
- (id)initWithURL:(NSURL*)aURL
{
    return self; // do nothing
}

- (NSMenuItem*)menuItem
{
    return [NSMenuItem separatorItem];
}
@end

@implementation MSScriptSubmenuItem
@synthesize subItems;
- (id)initWithURL:(NSURL*)aURL
{
    id body = [[aURL lastPathComponent] stringByDeletingPathExtension];
    id match = [filenamePattern firstMatchInString: body options: 0 range: NSMakeRange(0,[body length])];
    self.name = [body substringWithRange: [match rangeAtIndex: 1]];
    self.subItems = [MSScriptItem itemsOfDirectoryAtURL: aURL];
    
    return self;
}

- (NSString*)description
{
    return [subItems description];
}

- (NSMenuItem*)menuItem
{
    id item = [[NSMenuItem alloc] initWithTitle: self.name
                                         action: nil
                                  keyEquivalent: @""];
    
    id menu = [[NSMenu alloc] init];
    for( id aScriptItem in self.subItems )
    {
        id aMenuItem = [aScriptItem menuItem];
        [menu addItem: aMenuItem];
    }
    
    [item setSubmenu: menu];
    
    return item;
}
@end
