//
//  MSTextView.h
//  Okusa
//
//  Created by 木谷 洋 on 12/02/11.
//  Copyright (c) 2012年 二鏡庵. All rights reserved.
//


#import <Cocoa/Cocoa.h>
#import "MSTextViewHelper.h"
#import "NSTextInputClientSupport.h"

@protocol MSTextViewDelegate
- (NSAttributedString*)normalizeAttributedString:(NSAttributedString*)aStr;
@end

@class MSPager;
@interface MSTextView : NSView 
{
    NSTextInputClient_Trait inputState;
    MSPager *pager_;
    id delegate_;
    CaretState caretState;

    NSSize minSize_;
    NSTimer *caretTimer; // intaract timer
    
    struct
    {
        NSRect bounds;
        NSRect visible;
        NSSize clipSize;
    } scrollRegion_;
    
    // drag
    struct {
        BOOL onSelection;
    } _dragState;
    
    // drop
    struct {
        BOOL dragging;
    } _dropState;

}
@property (readwrite) id delegate;
@property (readwrite) NSSize minSize;
@property (readwrite) MSPager *pager;
@property (readwrite) NSRange selectedRange;
@property (readwrite) NSRange markedRange;

- (void)sizeToFit;
- (void)startCaretTimer;
- (void)stopCaretTimer;
@end

@interface MSTextView (NSTextInputClient) <NSTextInputClient>
@end
