package jp.gr.java_conf.noboru.android.droidcube;

import java.nio.FloatBuffer;

import javax.microedition.khronos.opengles.GL10;

import android.content.Context;
import android.opengl.GLU;

public class GameView extends GLTutorialBase {
	float[] box = new float[] {
			// FRONT
			-0.15f, -0.15f,  0.15f,
			 0.15f, -0.15f,  0.15f,
			-0.15f,  0.15f,  0.15f,
			 0.15f,  0.15f,  0.15f,
			// BACK
			-0.15f, -0.15f, -0.15f,
			-0.15f,  0.15f, -0.15f,
			 0.15f, -0.15f, -0.15f,
			 0.15f,  0.15f, -0.15f,
			// LEFT
			-0.15f, -0.15f,  0.15f,
			-0.15f,  0.15f,  0.15f,
			-0.15f, -0.15f, -0.15f,
			-0.15f,  0.15f, -0.15f,
			// RIGHT
			 0.15f, -0.15f, -0.15f,
			 0.15f,  0.15f, -0.15f,
			 0.15f, -0.15f,  0.15f,
			 0.15f,  0.15f,  0.15f,
			// TOP
			-0.15f,  0.15f,  0.15f,
			 0.15f,  0.15f,  0.15f,
			-0.15f,  0.15f, -0.15f,
			 0.15f,  0.15f, -0.15f,
			// BOTTOM
			-0.15f, -0.15f,  0.15f,
			-0.15f, -0.15f, -0.15f,
			 0.15f, -0.15f,  0.15f,
			 0.15f, -0.15f, -0.15f,
		};

	/** 頂点座標バッファ */
	FloatBuffer cubeBuff;
	
	float xrot = 0.0f;
	float yrot = 0.0f;

	int i = 0;

	public GameView(Context c) {
		super(c, 20);
		cubeBuff = makeFloatBuffer(box);
	}

	protected void init(GL10 gl) {
		// バックグラウンドカラーの設定
		gl.glClearColor(0.0f, 0.0f, 0.0f, 1.0f);
		
		// デプスバッファ
		gl.glEnable(GL10.GL_DEPTH_TEST);
		gl.glEnable(GL10.GL_CULL_FACE);
		gl.glDepthFunc(GL10.GL_LEQUAL);
		gl.glClearDepthf(1.0f);

		// シェーディング
		gl.glShadeModel(GL10.GL_SMOOTH);
	}
	
	protected void drawFrame(GL10 gl) {
		// 塗りつぶし
		gl.glClear(GL10.GL_COLOR_BUFFER_BIT | GL10.GL_DEPTH_BUFFER_BIT);

		// モデルビュー行列の指定
		gl.glMatrixMode(GL10.GL_MODELVIEW);
		gl.glLoadIdentity();
		GLU.gluLookAt(gl, 0, 0, 3, 0, 0, 0, 0, 1, 0);

		// 頂点配列の指定
		gl.glVertexPointer(3, GL10.GL_FLOAT, 0, cubeBuff);
		gl.glEnableClientState(GL10.GL_VERTEX_ARRAY);

		// 回転の指定
		gl.glRotatef(xrot, 1, 0, 0);
		gl.glRotatef(yrot, 0, 1, 0);

		// 前面と背面のプリミティブの描画
		gl.glColor4f(1.0f, 0, 0, 1.0f);
		gl.glDrawArrays(GL10.GL_TRIANGLE_STRIP, 0, 4);
		gl.glDrawArrays(GL10.GL_TRIANGLE_STRIP, 4, 4);

		// 左面と右面のプリミティブの描画
		gl.glColor4f(0, 1.0f, 0, 1.0f);
		gl.glDrawArrays(GL10.GL_TRIANGLE_STRIP, 8, 4);
		gl.glDrawArrays(GL10.GL_TRIANGLE_STRIP, 12, 4);

		// 上面と下面のプリミティブの描画
		gl.glColor4f(0, 0, 1.0f, 1.0f);
		gl.glDrawArrays(GL10.GL_TRIANGLE_STRIP, 16, 4);
		gl.glDrawArrays(GL10.GL_TRIANGLE_STRIP, 20, 4);
	}

	public void rotate(float xrotDiff, float yrotDiff) {
		xrot += xrotDiff;
		yrot += yrotDiff;
	}
}