#!/usr/bin/env python
# coding:UTF-8
"""
PiLog HMR2300用ロギングプログラム

"""
import serial
import time
from datetime import datetime
import ConfigParser
import signal
import sys
import logging
import logging.handlers
import os
# PiLog関連
from pilog import cmdsend, resrcv, fileout
import pilog
import hmr2300

if not __name__ == '__main__':
    exit

# SIGINTハンドラ
def sigint_func(num, frame):
#    print 'func(): %d, %s' % (num, str(frame))
    my_logger.info(my_scriptname + ' SIGINT received')
#    print "SIGINT received"
    port.close
    my_logger.info(my_scriptname + ' end')
    logging.shutdown
    sys.exit(0)
#
# MAIN code
#
# SIGINT(Ctrl-C)
signal.signal(signal.SIGINT, sigint_func)

# Open syslog
my_logger = logging.getLogger('MyLogger')
my_logger.setLevel(logging.DEBUG)
handler = logging.handlers.SysLogHandler(address = '/dev/log')
my_logger.addHandler(handler)
my_scriptname = os.path.basename(__file__)
my_logger.info(my_scriptname + ' start')

# Read config
my_scriptdir = os.path.dirname(__file__)
try:
    inifile = ConfigParser.SafeConfigParser()
    inifile.read(my_scriptdir + "/log_hmr2300.conf")
    recdir = inifile.get("settings","recdir")
    print "recdir=" + recdir
    serial_dev = inifile.get("settings","serial_dev")
    print "serial_dev=" + serial_dev
except:
    print "ERR: config read"

print "pySerial Ver" + serial.VERSION
# Open serial
try:
    port = serial.Serial(serial_dev, baudrate=9600, timeout=3.0)
except:
    print "ERR: serial open"
    sys.exit(1)
# EOL
pilog.eol = hmr2300.eol
# Init device
hmr2300.init_device(port)
# Poll measurement data
x=0;y=0;z=0
nowb = datetime.now()
while True:
    while True:
        now = datetime.now()
        if nowb.second != now.second:
            nowb = now
            break
    tstamp = now.strftime("%y/%m/%d %H:%M:%S")
    fname = now.strftime("%y%m%d") + ".txt"
#    print tstamp
#    print fname
    cmdsend(port, "*99P")
    rcv = resrcv(port)
    # 磁場値抽出
    x,y,z = hmr2300.decode(rcv)
    data = '{0:6d},{1:6d},{2:6d}'.format(x, y, z)
    fileout(recdir, fname, tstamp, data)
