!
! Copyright (C) 2017 Mitsuaki Kawamura
! This file is distributed under the terms of the
! GNU General Public License. See the file `License'
! in the root directory of the present distribution,
! or http://www.gnu.org/copyleft/gpl.txt .
!
!>
!> Compute screened Coulomb interaction and interpolate it
!>
PROGRAM sctk_kel
  !
  USE io_global, ONLY : stdout
  USE control_ph, ONLY : start_q, last_q
  USE environment,ONLY : environment_start, environment_end
  USE mp_global,  ONLY : mp_startup, mp_global_end
  !
  USE sctk_val, ONLY : laddxc
  !
  USE sctk_read_files, ONLY : read_a2Fsave
  USE sctk_stdin, ONLY : stdin_Kel, stdin_control
  USE sctk_wfc, ONLY : get_wfcg, fft_wfc
  USE sctk_dmuxc, ONLY : read_dmxc, apply_xc
  USE sctk_coulomb, ONLY : make_scrn, make_kel, alloc_Kel_Chebyshev, &
  &                       prepare_q, Chebyshev_interpol, write_Kel_Chebyshev
  USE sctk_invert, ONLY : invert
  !
  IMPLICIT NONE
  !
  INTEGER :: iq
  !
  ! initialise environment
  !
#if defined(__MPI)
  CALL mp_startup ( )
#endif
  CALL environment_start ( 'COULOMB_KERNEL' )
  !
  WRITE(stdout,*)
  WRITE(stdout,*) "#####  Read from data-file.xml  #####"
  WRITE(stdout,*)
  CALL stdin_control()
  CALL read_xml_file ( )
  CALL read_a2Fsave()
  !
  WRITE(stdout,*)
  WRITE(stdout,*) "#####  Read from STDIN  #####"
  WRITE(stdout,*)
  CALL stdin_Kel()
  !
  WRITE(stdout,*)
  WRITE(stdout,*) "#####  Read gvectors.dat & evc.dat  #####"
  WRITE(stdout,*)
  CALL get_wfcg()
  !
  WRITE(stdout,*)
  WRITE(stdout,*) "#####  FFT wfc(G) -> wfc(r)  #####"
  WRITE(stdout,*)
  CALL fft_wfc()
  !
  IF(laddxc == 1) THEN
     !
     WRITE(stdout,*)
     WRITE(stdout,*) "#####  Read dmuxc.dat  #####"
     WRITE(stdout,*)
     CALL read_dmxc()
     !
  END IF
  !
  WRITE(stdout,*)
  WRITE(stdout,*) "#####  Set frequency grid  #####"
  WRITE(stdout,*)
  CALL alloc_Kel_Chebyshev()
  !
  WRITE(stdout,*)
  WRITE(stdout,*) "#####  Compute K_el  #####"
  WRITE(stdout,*)
  !
  DO iq = start_q, last_q
     !
     CALL prepare_q(iq)
     CALL make_scrn(iq)
     !
     CALL apply_xc()
     CALL invert()
     !
     CALL make_kel(linfinite = .TRUE.)
     !
     CALL Chebyshev_interpol()
     CALL write_Kel_Chebyshev(iq)
     !
  END DO
  !
  CALL environment_end ( 'COULOMB_KERNEL' )
#if defined(__MPI)
  CALL mp_global_end ( )
#endif
  !
END PROGRAM sctk_kel
