!
! Copyright (C) 2017 Mitsuaki Kawamura
! This file is distributed under the terms of the
! GNU General Public License. See the file `License'
! in the root directory of the present distribution,
! or http://www.gnu.org/copyleft/gpl.txt .
!
!> @mainpage Density Functional theory for superconductors
!>
!> This package contains the following programs.
!>
!> ### scdft.x ( scdft.f90 ) ###
!>
!> Compute @f$\Delta_{n k}@f$ by solving the Kohn-Sham gap equation.
!>
!> ### rpa_el.x ( rpa_el.f90 ) ###
!>
!> Compute electron-electron Coulomb interaction via RPA
!>
!> ### rpa.x ( rpa.f90 ) ###
!>
!> Compute electron-electron Coulomb interaction via RPA
!>
!> ### get_eigval.x ( get_eigval.f90 ) ###
!>
!> It perform a pre-prosess for scdft.x and rpa_el.x .
!> Collect Kohn-Sham eigenvalues (mesured from @f$\varepsilon_{\rm F}@f$)
!> from the output of pw.x
!>
!> ### deltaf.x ( deltaf.f90 ) ###
!>
!> It perform a post process of scdft.x
!> Compute @f$\Delta_{n k}@f$ on a dense @f$k@f$ grid with non-scf
!> calculation and  output them for the fermisurfer
!>
!> ### qpdos.x ( qpdos.f90 ) ###
!> 
!> It perform a post process of scdft.x
!> Compute the quasi particle DOS 
!> @f[
!>  D(\varepsilon) = \sum_{n k} \delta \left(\varepsilon_{n k} - 
!>  \sqrt{\xi_{n k}^2 + |\Delta_{n k}|^2} \right)
!> @f]
!> 
!> ### ultrasonic.x ( ultrasonic.f90 ) ###
!> 
!> It perform a post process of scdft.x
!> Compute the ultrasonic attenuation coefficient 
!> 
!
!> SCDFT\@QE Main routine to solve the gap equation
!> @f[
!>   \Delta_{n k} = - \frac{1}{2} \sum_{n' k'} K_{n k n' k'} 
!>   \frac{\Delta_{n' k'}}{E_{n' k'}}
!>   \tanh \left( \frac{\beta E_{n' k'}}{2} \right)
!> @f]
!> and obtain @f$\Delta_{n k}@f$ .
!>
!> @author Mitsuaki Kawamura
!> 
PROGRAM sctk_main
  !
  USE io_global, ONLY : stdout
  USE environment,ONLY : environment_start, environment_end
  USE mp_global,  ONLY : mp_startup, mp_global_end
  !
  USE sctk_stdin, ONLY : stdin_scdft, stdin_control
  USE sctk_read_files, ONLY : read_elph, read_Coulomb, read_a2Fsave
  USE sctk_rotate_kernel, ONLY : expand_g_v
  USE sctk_ini_delta, ONLY : ini_delta
  USE sctk_z, ONLY : make_Z
  USE sctk_gapeq_rhs, ONLY : make_effint
  USE sctk_broyden, ONLY : broyden_gapeq
  !
  IMPLICIT NONE
  !
  ! initialise environment
  !
#if defined(__MPI)
  CALL mp_startup ( )
#endif
  CALL environment_start ( 'SCDFT' )
  !
  WRITE(stdout,*)
  WRITE(stdout,*) "#####  Read from data-file.xml  #####"
  WRITE(stdout,*)
  CALL stdin_control()
  CALL read_xml_file ( )
  CALL read_a2Fsave()
  !
  WRITE(stdout,*)
  WRITE(stdout,*) "#####  Read from STDIN  #####"
  WRITE(stdout,*)
  CALL stdin_scdft()
  !
  WRITE(stdout,*)
  WRITE(stdout,*) "#####  Read from elph*.dat  #####"
  WRITE(stdout,*)
  CALL read_elph()
  !
  WRITE(stdout,*)
  WRITE(stdout,*) "#####  Read from vc*.dat  #####"
  WRITE(stdout,*)
  CALL read_Coulomb()
  !
  WRITE(stdout,*)
  WRITE(stdout,*) "#####  Set or read initial delta  #####"
  WRITE(stdout,*)
  CALL ini_delta()
  !
  WRITE(stdout,*)
  WRITE(stdout,*) "#####  Average matrix in grid  #####"
  WRITE(stdout,*)
  CALL expand_g_v()
  !
  WRITE(stdout,*)
  WRITE(stdout,*) "#####  Compute renormalization fuctor : Z  #####"
  WRITE(stdout,*)
  CALL make_Z()
  !
  WRITE(stdout,*)
  WRITE(stdout,*) "#####  Compute effective interaction  #####"
  WRITE(stdout,*)
  CALL make_effint()
  !
  WRITE(stdout,*)
  WRITE(stdout,*) "#####  Solve gap equation  #####"
  WRITE(stdout,*)
  CALL broyden_gapeq()
  !
  CALL environment_end ( 'SCDFT' )
#if defined(__MPI)
  CALL mp_global_end ( )
#endif
  !
END PROGRAM sctk_main
