!
! Copyright (C) 2017 Mitsuaki Kawamura
! This file is distributed under the terms of the
! GNU General Public License. See the file `License'
! in the root directory of the present distribution,
! or http://www.gnu.org/copyleft/gpl.txt .
!
MODULE sctk_wfc
  !
  IMPLICIT NONE
  !
CONTAINS
!
! read g-vector & wfc
!
SUBROUTINE get_wfcg()
  !
  USE wvfct, ONLY : nbnd, npwx
  USE kinds, ONLY : DP
  USE io_files, ONLY : prefix, tmp_dir
  USE xml_io_base, ONLY : read_wfc
  USE mp, ONLY : mp_max
  USE mp_world, ONLY : world_comm
  USE klist, ONLY : ngk, igk_k
  USE mp, ONLY : mp_max
  !
  USE sctk_val, ONLY : nqbz, wfc
  USE sctk_cnt_dsp, ONLY : cnt_and_dsp
  !
  IMPLICIT NONE
  !
  INTEGER :: fi, ik, ii, ik_g
  INTEGER :: cnt, dsp, cntmax
  CHARACTER(LEN=320) :: filename
  !
  INTEGER :: nk_dummy, ispin_dummy, nspin_dummy, npw_dummy
  REAL(dp) :: scalef_dummy
  !
  CHARACTER(LEN=6), EXTERNAL :: int_to_char
  INTEGER, EXTERNAL :: find_free_unit
  !
  fi = find_free_unit()
  !
  CALL cnt_and_dsp(nqbz,cnt,dsp)
  cntmax = cnt
  CALL mp_max(cntmax, world_comm)
  !
  ALLOCATE(wfc(npwx,nbnd,cntmax,2))
  wfc(1:npwx,1:nbnd,1:cntmax,1:2) = CMPLX(0.0_dp, 0.0_dp, KIND=dp)
  !
  ! Read Wfc(k)
  !
  DO ii = 1, 2
     !
     DO ik = 1, cnt
        !
        ik_g = nqbz * (ii - 1) + dsp + ik
        filename = TRIM(tmp_dir) // TRIM(prefix) // '.save/' // 'wfc' // TRIM(int_to_char(ik_g))
        !
        !??CALL read_wfc(fi, ik_g, nk_dummy, ispin_dummy, nspin_dummy, &
        !??&  wfc(1:ngk(ik_g),1:nbnd,ik,ii), npw_dummy, nbnd, igk_k(1:ngk(ik_g),ik_g),   &
        !??&  ngk(ik_g), filename, scalef_dummy, &
        !??&  .TRUE., 0, world_comm )
        !
     END DO ! ik
     !
  END DO ! ii
  !
END SUBROUTINE get_wfcg
!
! FFT wavefunctions
!
SUBROUTINE fft_wfc()
  !
  USE wvfct, ONLY : nbnd
  USE kinds, ONLY : DP
  USE disp, ONLY : nqs
  USE mp, ONLY : mp_max
  USE mp_world, ONLY : world_comm
  USE sctk_val, ONLY : igmin, igv, nf, nftot, npw, wfc, &
  &                     wfc1, wfc2, wfc1q, wfc2q
  !
  USE sctk_cnt_dsp, ONLY : cnt_and_dsp
  !
  IMPLICIT NONE
  !
  INTEGER :: ig, ik, ib, igv2(3), ig2, cnt, dsp, cntmax
  INTEGER(8) :: plan
  COMPLEX(dp) :: wfcin(nftot), wfcout(nftot)
  !
  CALL cnt_and_dsp(nqs,cnt,dsp)
  cntmax = cnt
  CALL mp_max(cntmax, world_comm)
  !
  ALLOCATE(wfc1(nftot, nbnd, cntmax), wfc2(nftot, nbnd, cntmax))
  ALLOCATE(wfc1q(nftot, nbnd, cntmax), wfc2q(nftot, nbnd, cntmax))
  wfc1(1:nftot,1:nbnd,1:cntmax) = CMPLX(0.0_dp, 0.0_dp, KIND=dp)
  wfc2(1:nftot,1:nbnd,1:cntmax) = CMPLX(0.0_dp, 0.0_dp, KIND=dp)
  !
  !???CALL dfftw_plan_dft_3d(plan, nf(1), nf(2), nf(3), wfcin, wfcout, &
  !???&                      FFTW_BACKWARD, FFTW_ESTIMATE)
  !
  !$OMP PARALLEL DEFAULT(NONE) &
  !$OMP & SHARED(plan,cnt,dsp,nf,nbnd,npw,igmin,wfc,wfc1,wfc2,igv,nftot) &
  !$OMP & PRIVATE(wfcin,wfcout,ik,ig,ig2,igv2,ib)
  !
  ! Fourier trans. wfc(G) -> wfc(r)
  ! 
  !$OMP DO
  DO ik = 1, cnt
     !
     DO ig = 1, npw(ik,1)
        igv2(1:3) = igv(1:3,ig,ik,1) - igmin(1:3) + 1
        ig2 = 1 + (igv2(1) - 1) + nf(1) * (igv2(2) - 1) + nf(1) * nf(2) * (igv2(3) - 1)
        wfc1(ig2, 1:nbnd, ik) = wfc(ig, 1:nbnd, ik, 1)
     END DO
     !
     DO ig = 1, npw(ik,2)
        igv2(1:3) = igv(1:3,ig,ik,2) - igmin(1:3) + 1
        ig2 = 1 + (igv2(1) - 1) + nf(1) * (igv2(2) - 1) + nf(1) * nf(2) * (igv2(3) - 1)
        wfc2(ig2, 1:nbnd, ik) = wfc(ig, 1:nbnd, ik, 2)
     END DO
     !
     DO ib = 1, nbnd
        !
        wfcin(1:nftot) = wfc1(1:nftot, ib, ik)
        !???CALL dfftw_execute_dft(plan, wfcin, wfcout)
        wfc1(1:nftot, ib, ik) = wfcout(1:nftot)
        !
        wfcin(1:nftot) = wfc2(1:nftot, ib, ik)
        !????CALL dfftw_execute_dft(plan, wfcin, wfcout)
        wfc2(1:nftot, ib, ik) = wfcout(1:nftot)
        !
     END DO
     !
  END DO
  !$OMP END DO
  !$OMP END PARALLEL
  !
  !???CALL dfftw_destroy_plan(plan)
  !
  DEALLOCATE(wfc, igv, npw)
  !
END SUBROUTINE fft_wfc
!
END MODULE sctk_wfc
