!
! Copyright (C) 2017 Mitsuaki Kawamura
! This file is distributed under the terms of the
! GNU General Public License. See the file `License'
! in the root directory of the present distribution,
! or http://www.gnu.org/copyleft/gpl.txt .
!
!>
!> Compute the ultrasonic attenuation coefficient
!>
PROGRAM ultrasonic
  !
  USE io_global, ONLY : stdout
  USE environment,ONLY : environment_start, environment_end
  USE mp_global,  ONLY : mp_startup, mp_global_end
  !
  USE sctk_stdin, ONLY : stdin_scdft, stdin_control
  USE sctk_read_files, ONLY : read_elph, read_Coulomb, read_a2Fsave
  USE sctk_io_delta, ONLY : read_delta
  USE sctk_z, ONLY : make_Z_f
  USE sctk_gapeq_rhs, ONLY : gapeq_rhs_f
  USE sctk_rotate_kernel, ONLY : expand_g_v_f
  USE calc_usonic_mod, ONLY : calc_fvel, calc_usonic
  !
  IMPLICIT NONE
  !
#if defined(__MPI)
  CALL mp_startup ( )
#endif
  CALL environment_start ( 'ULTRASONIC' )
  !
  WRITE(stdout,*)
  WRITE(stdout,*) "#####  Read from data-file.xml  #####"
  WRITE(stdout,*)
  CALL stdin_control()
  CALL read_xml_file ( )
  CALL read_a2Fsave()
  !
  WRITE(stdout,*)
  WRITE(stdout,*) "#####  Read from STDIN  #####"
  WRITE(stdout,*)
  CALL stdin_scdft()
  !
  WRITE(stdout,*)
  WRITE(stdout,*) "#####  Read from elph*.dat  #####"
  WRITE(stdout,*)
  CALL read_elph()
  !
  WRITE(stdout,*)
  WRITE(stdout,*) "#####  Read from vc*.dat  #####"
  WRITE(stdout,*)
  CALL read_Coulomb()
  !
  WRITE(stdout,*)
  WRITE(stdout,*) "#####  Average matrix in grid  #####"
  WRITE(stdout,*)
  CALL expand_g_v_f()
  !
  WRITE(stdout,*)
  WRITE(stdout,*) "#####  Set or read initial delta  #####"
  WRITE(stdout,*)
  CALL read_delta()
  !
  WRITE(stdout,*)
  WRITE(stdout,*) "#####  Compute renormalization fuctor : Z  #####"
  WRITE(stdout,*)
  CALL make_Z_f()
  !
  WRITE(stdout,*)
  WRITE(stdout,*) "#####  Integrate gapeq  #####"
  WRITE(stdout,*)
  CALL gapeq_rhs_f()
  !
  WRITE(stdout,*)
  WRITE(stdout,*) "#####  Compute ultrasonic attenuation  #####"
  WRITE(stdout,*)
  CALL calc_fvel()
  CALL calc_usonic()
  !
  CALL environment_end ( 'ULTRASONIC' )
#if defined(__MPI)
  CALL mp_global_end ( )
#endif
  !
END PROGRAM ultrasonic

