/* _/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/
|
|   Card.h
|       J[h
+ -------------------------------------------------------------------------------------------------
|
|	J[h̕`
|	J[h̃f[^m_ci̒ɂ܂Ƃ߂ĊǗ(ĂяoȂ邯)
|
|
+ _/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/ */

#pragma once

class animeCalcClass;
class Scene;
class TextureManager;
class CardData;

// _obt@̃tH[}bg`
#define CARD_VERTEX_FVF (D3DFVF_XYZ | D3DFVF_DIFFUSE | D3DFVF_TEX2)

// _obt@\
typedef struct
{
	VEC3	p;		// W
	DWORD	color;	// F
	VEC2	t1;		// eNX`W
	VEC2	t2;		// eNX`W
}CARD_VERTEX;

// J[hXe[g
enum{
	CARD_AWAKE,		// AEFCN
	CARD_FALL,		// tH[
};

// J[h\
enum{
	CARD_FRONT,		// \
	CARD_BACK,		// 
};

// I
enum{
	SELECT_NON,
	SELECT_ON,
	SELECT_LOCK,
};

// J[hf[^
enum{
	CI_NAME,
	CI_CARDNO,
	CI_COLOR,
	CI_POWER,
	CI_GUARD,
	CI_LEVEL,
	CI_STRIKE,
	CI_LINK,
	CI_FRAME,
	CI_BOOST,
	CI_TYPE,
	CI_LINKREQ,
	CI_SKILLTYPE,
	CI_RACE,
	CI_SERNO,
	CD_REVERSE,
	CD_SELECT,
	CD_AWAKE,
};

// J[hNX
class Card
{
	private:
		animeCalcClass*	m_anime;			// Aj
		animeCalcClass* m_pBrightAnime;		// Aj
		Scene*			m_pCamera;			// J
		TextureManager*	m_pTexMan;			// eNX`Ǘ
		CardData*		m_pCardData;		// J[hf[^

	public:
		LPDIRECT3DVERTEXBUFFER9	m_pVB;		// _obt@
		D3DXMATRIX	m_world;				// [hs
		VEC3		m_vPos[4];				// _W([J)
		bool		m_isCreate;				// tO
		bool		m_isTransDraw;			// ߕ`tO
		VEC3		m_pos;					// W
		VEC3		m_degree;				// px
		float		m_scale;				// g嗦
		int			m_id;					// ʎq
		int			m_texID;				// eNX`ԍ
		int			m_sleeveTexID;			// X[ueNX`ԍ
		int			m_brightTexID;			// eNX`ԍ
		VecCE		m_listEffect;			// eJ[hXg
		CARD_INFO	m_ci;					// J[h
		int			m_reverse;				// \
		int			m_awake;				// AEFCNEtH[
		bool		m_focus;				// tH[JX邩
		int			m_select;				// IĂ邩
		int			m_zone;					// ][
		int			m_num;					// ʒu
		int			m_ply;					// vC[
		int			m_useSkill[SKILL_MAX];	// ʎgp
		VecTV		m_addPower;				// Zp[
		VecTV		m_addLink;				// ZN
		VecTV		m_addStrike;			// ZXgCN
		VecTV		m_addLevel;				// Zx

	private:
		void	release(void);

	public:
		Card();
		~Card();

		void	init(CardData* pCD);
		void	update	(void);
		void	draw	(void);

		// J[hf[^j
		void	deleteData		(void);
		// J[ho^mF
		inline bool	isExistData	(void){ return((m_ci.serNo != NON_CARD)); };
		// eXgɊ܂܂Ă邩
		bool	isExistEffect	(CARD_EFFECT ce);

		void setData	(int serNo);
		void setPos		(float x, float y, float z);
		void setPos		(VEC3 pos);
		void setDegree	(float x, float y, float z);
		void setDegree	(VEC3 deg);
		void setScale	(float scale);

		void setAwake	(void){ m_awake = CARD_AWAKE; }
		void setFall	(void){ m_awake = CARD_FALL; }
		bool isAwake	(void){ return(m_awake == CARD_AWAKE); }
		bool isFall		(void){ return(m_awake == CARD_FALL); }

		void setFront	(void){ m_reverse = CARD_FRONT; }
		void setBack	(void){ m_reverse = CARD_BACK; }
		bool isFront	(void){ return(m_reverse == CARD_FRONT); }
		bool isBack		(void){ return(m_reverse == CARD_BACK); }

		VEC3 getDispPos	(void);

		// Zl擾
		int getAddPower	(void);
		int getAddStrike(void);
		int getAddLink	(void);
		int getAddLevel	(void);
		// vl擾
		inline int getSumPower	(void){ return(m_ci.power	+ getAddPower()	); };
		inline int getSumStrike	(void){ return(m_ci.strike	+ getAddStrike()	); };
		inline int getSumLink	(void){ return(m_ci.link	+ getAddLink()		); };
		inline int getSumLevel	(void){ return(m_ci.level	+ getAddLevel()	); };

		animeCalcClass*	getAnimeCalc(void){ return(m_anime); }
};

typedef vector<Card*>				VecpCard;
typedef vector<Card*>::iterator		ItepCard;

