
/* _/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/

	FILE	: CardData.h

+ ------ Explanation of file --------------------------------------------------------------------------

	J[hf[^A[f[^AfbLf[^̊Ǘ

+ _/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/ */

#pragma once

//! J[h
struct CARD_DATA{
	string	serStr;		// V[Y
	int		serNum;		// V[Yԍ
	string	name;		// O
	int		color;		// F
	int		power;		// p[
	int		guard;		// K[h
	int		level;		// x
	int		strike;		// XgCN
	int		frame;		// t[
	int		boost;		// u[Xg
	int		type;		// ^Cv
	string	race;		// 푰
	int		serNo;		// ݌vԍ(Ǎ)
};

typedef vector<CARD_DATA*>				vecCard;
typedef	vector<CARD_DATA*>::iterator	iteCard;

//! eLXg
struct TEXT_DATA{
	string	serStr;		// V[Y
	int		serNum;		// V[Yԍ
	string	text;		// eLXg
	int		serNo;		// ݌vԍ(Ǎ)
};

typedef vector<TEXT_DATA*>				vecText;
typedef	vector<TEXT_DATA*>::iterator	iteText;

//! ֎~
struct PROH_DATA{
	string	serStr;		// V[Y
	int		serNum;		// V[Yԍ
	int		serNo;		// ݌vԍ(Ǎ)
};

typedef vector<PROH_DATA*>				vecProh;
typedef	vector<PROH_DATA*>::iterator	iteProh;

//! 
struct REST_DATA{
	string	serStr;		// V[Y
	int		serNum;		// V[Yԍ
	int		num;		// 
	int		serNo;		// ݌vԍ(Ǎ)
};

typedef vector<REST_DATA*>				vecRest;
typedef	vector<REST_DATA*>::iterator	iteRest;

//! Rr
struct COMB_DATA{
	string	serStr[2];	// V[Y
	int		serNum[2];	// V[Yԍ
	int		serNo[2];	// ݌vԍ(Ǎ)
};

typedef vector<COMB_DATA*>				vecComb;
typedef	vector<COMB_DATA*>::iterator	iteComb;

//! fbL
struct DECK_DATA{
	string	serStr;		// V[Y
	int		serNum;		// V[Yԍ
	int		serNo;		// ݌vԍ(Ǎ)
};

class CardData
{
	private:
		vecCard		m_cardList;						// J[hXg
		vecText		m_textList;						// eLXgXg
		vecProh		m_prohList;						// ֎~Xg
		vecRest		m_restList;						// Xg
		vecComb		m_combList;						// R{Xg
		DECK_DATA	m_deckList[PLY_NUM][DECK_MAX];	// fbLXg

	private:
		void release(void);

	public:
		CardData();
		~CardData();

		void readBinary(void);													// oCiǂݍ
		void readDeck(int ply, const char* fileName);							// fbLǂݍ
		void getCardData(int serNo, CARD_INFO* pCI);							// J[hf[^擾
		void getCardText(int serNo, char* pStr);								// J[heLXg擾
		DECK_DATA* getDeck(int ply, int num){return(&m_deckList[ply][num]); }	// fbL擾
};

