﻿
/* _/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/

	FILE	: CardDataRead.cpp

+ ------ Explanation of file --------------------------------------------------------------------------

	カード情報をテキストから読み込みする

+ _/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/ */

#include <windows.h>
#include <stdio.h>

#include "Common.h"

#include "CardData.h"
#include "Field.h"
#include "Skill.h"

#include "CardDataRead.h"

/* ----------------------------------------------------- */
//	指定カードの情報読み込み
/* ----------------------------------------------------- */
bool cardDataRead(CARD_INFO* card, DWORD no)
{
	FILE	*fp;
	char	fname[64];
	TCHAR	name[64];
	int		col, pw, gd, level, strike, li, lf, boost, type, no1, no2;
	bool	bb;			// fscanfでboolを使用するとズレで上手く取得できないので処理場的にintで取得し使用時にboolに変換する
	int		ret;

	switch(HIWORD(no)){
		case SERIES_B1:		wsprintf(fname, "Data/card_B1.txt");		break;
		case SERIES_B2:		wsprintf(fname, "Data/card_B2.txt");		break;
		case SERIES_B3:		wsprintf(fname, "Data/card_B3.txt");		break;
		case SERIES_B4:		wsprintf(fname, "Data/card_B4.txt");		break;
		case SERIES_E1:		wsprintf(fname, "Data/card_E1.txt");		break;
		case SERIES_PR:		wsprintf(fname, "Data/card_PR.txt");		break;
		case SERIES_S1:		wsprintf(fname, "Data/card_S1.txt");		break;
		case SERIES_S2:		wsprintf(fname, "Data/card_S2.txt");		break;
	}

	// ファイル読み込み
	fopen_s(&fp, fname, "r");
	if(fp == NULL){
		printf("%sが開けません\n", fname);
		return(false);
	}

	while(true){
		// データ取得
		ret = fscanf_s(fp, "%[^,],%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d",
					name, _countof(name), &col, &pw, &gd, &level, &strike, &li, &lf, &boost, &type, &no1, &no2);

		// 読み込み失敗
		if(ret == EOF){
			printf("データ検索中にEOFに到達しました\n");
			return(false);
		}

		// 指定番号まで到達
		if(no2 == LOWORD(no)){
			printf("%s,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d", name, col, pw, gd, level, strike, li, lf, boost, type, no1, no2);

			// 変換
			if(boost == 0){
				bb = false;
			}else{
				bb = true;
			}

			break;
		}
	}

	fclose(fp);
	return(true);
}

// デッキ読み込み
void readDeckData(CARD_INFO* card, char* name)
{
	FILE	*fp;
	int		ser = -1;
	int		ret;

	// ファイル読み込み
	fopen_s(&fp, name, "r");
	if(fp == NULL){
		printf("%sが開けません\n", name);
		return;
	}

	for(int i = 0; i < DECK_MAX; i++){
		// データ取得
		ret = fscanf_s(fp, "%d", ser);

		// 読み込み失敗
		if(ret == EOF){
			printf("デッキの読み込みに失敗しました(%d枚目)\n", i+1);
			return;
		}

		GetCardData(ser, card);
		card++;
	}

	fclose(fp);
}

// デッキが正規かチェック
int  checkDeck(CARD_INFO* card)
{
	CARD_INFO* cpy = card;
	int iRet = DECK_CHECK_OK;
	int cnt = 0;

	// デッキ枚数チェック
	for(int i = 0; i < DECK_MAX; i++){
		if(card->serNo == -1){
			iRet |= DECK_CHECK_NOT_DATA;
			break;
		}
	}
	card = cpy;

	// 同名チェック
	int dm[DECK_MAX][2];
	for(int i = 0; i < DECK_MAX; i++){
		dm[i][0] = -1;
		dm[i][1] = 0;
	}
	for(int i = 0; i < DECK_MAX; i++){
		for(int j = 0; j < DECK_MAX; j++){
			if(dm[j][0] == -1){
				dm[j][0] = card->serNo;
				dm[j][1]++;
				break;
			}
			else if(dm[j][0] == card->serNo){
				dm[j][1]++;
				break;
			}
		}
		card++;
	}
	card = cpy;
	for(int i = 0; i < DECK_MAX; i++){
		if(dm[i][1] > 4){
			iRet |= DECK_CHECK_SAME_OVER;
			break;
		}
	}

	// Lv0チェック
	for(int i = 0; i < DECK_MAX; i++){
		if(card->level == 0){
			cnt++;
		}
		card++;
	}
	card = cpy;
	if(cnt < 4){
		iRet |= DECK_CHECK_LV0_UNDER;
	}
	else if(cnt > 4){
		iRet |= DECK_CHECK_LV0_OVER;
	}

	// フレームチェック
	cnt = 0;
	for(int i = 0; i < DECK_MAX; i++){
		if(card->level > 0 && card->frame != FRAME_NON){
			cnt++;
		}
		card++;
	}
	card = cpy;
	if(cnt < 16){
		iRet |= DECK_CHECK_FRAME_UNDER;
	}
	else if(cnt > 16){
		iRet |= DECK_CHECK_FRAME_OVER;
	}

	// キーパーチェック
	Card cd;
	ZeroMemory(&cd, sizeof(cd));
	cnt = 0;
	for(int i = 0; i < DECK_MAX; i++){
		cd.m_ci = *card;
		if(skill.invoke(&cd, 0, SKILL_CODE_GET_CONTENT) == SKILL_RET_KEEPER){
			cnt++;
		}
		card++;
	}
	card = cpy;
	if(cnt > 4){
		iRet |= DECK_CHECK_KEEPER_OVER;
	}

	// エースチェック
	int acnt[6];
	ZeroMemory(&acnt, sizeof(acnt));
	for(int i = 0; i < DECK_MAX; i++){
		cd.m_ci = *card;
		if(skill.invoke(&cd, 0, SKILL_CODE_GET_CONTENT) == SKILL_RET_ACE){
			acnt[card->level]++;
		}
		card++;
	}
	card = cpy;
	for(int i = 0; i < 6; i++){
		if(acnt[i] > 4){
			iRet |= DECK_CHECK_ACE_OVER;
			break;
		}
	}

	return(iRet);
}