
/* _/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/

	FILE	: CardList.cpp

+ ------ Explanation of file --------------------------------------------------------------------------

+ _/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/ */

#include "Common.h"

#include "Renderer.h"
#include "animeCalc.h"
#include "Mouse.h"

#include "CardList.h"

#define GETTIME		(float)(timeGetTime() / 1000.0f)

// RXgN^
CardList::CardList()
{
	m_isCreate = false;
}

// fXgN^
CardList::~CardList()
{
	SAFE_DELETE(m_pBrightAnime);

	close();
}

void CardList::init(Mouse* pMouse)
{
	m_pBrightAnime = new animeCalcClass();
	m_pMouse = pMouse;
	m_base.init();

	m_pBrightAnime->clear();
	m_pBrightAnime->set(0, 0.0f, VEC3(0.0f, 0.75f, 0.0f), VEC3(0.0f, 0.0f, 0.0f), 1.0f);
	m_pBrightAnime->set(1, 1.0f, VEC3(0.0f, 0.0f, 0.0f), VEC3(0.0f, 0.0f, 0.0f), 1.0f);
	m_pBrightAnime->set(2, 1.0f, VEC3(0.0f, 0.0f, 0.0f), VEC3(0.0f, 0.0f, 0.0f), 1.0f);
	m_pBrightAnime->setLoop(true);

	float delay = GETTIME;
	float time = m_pBrightAnime->getSumTime();
	while(delay > time){
		delay -= time;
	}
	delay = time - delay;
	m_pBrightAnime->setDelay(delay);
	m_pBrightAnime->start();
}

// 
int CardList::create(int posx, int posy, int sizew, int sizeh, int imgw, int imgh, int xmax, int spw, int sph)
{
	m_base.create(posx, posy, sizew, sizeh, D3DXCOLOR(0.2f, 0.2f, 0.2f, 1.0f));

	m_pos.x = (float)posx;
	m_pos.y = (float)posy;
	m_dispSize.x = sizew;
	m_dispSize.y = sizeh;
	m_imgSize.x = imgw;
	m_imgSize.y = imgh;
	m_space.x = spw;
	m_space.y = sph;
	m_curPos.x = spw;
	m_curPos.y = sph;
	m_xMax = xmax;
	m_selMax = 0;

	m_isCreate = true;

	return(TRUE);
}

// `
void CardList::draw(void)
{
	if(!m_isCreate) { return; }

	// }XN
	renderer.m_clip.beginMask(true);
	{
		m_base.draw();
	}
	renderer.m_clip.endMask();

	// NbsO`
	renderer.m_clip.beginClip();
	{
		// 摜`
		for(ItepBtn it = m_image.begin(); it != m_image.end(); it++){
			// ł郍[JWĂȂ̂ňړWZ
			(*it)->m_pos.x += m_pos.x + m_curPos.x;
			(*it)->m_pos.y += m_pos.y + m_curPos.y;
			(*it)->draw();
			(*it)->m_pos.x -= m_pos.x + m_curPos.x;
			(*it)->m_pos.y -= m_pos.y + m_curPos.y;
		}
	}
	renderer.m_clip.endClip();
}

// I
void CardList::close(void)
{
	m_isCreate = false;
	m_base.close();

	// CX^X̉
	while(!m_image.empty()){
		delete m_image.back();
		m_image.pop_back();
	}
	// IĂ邯ǈꉞ
	m_image.clear();
}

// XV
void CardList::update(void)
{
	m_base.update();

	// zC[XN[
	m_curPos.y += m_pMouse->getWheel() * 30;

	// 
	int num = (int)m_image.size();
	int xd, yd;
	if(m_xMax > 0){
		xd = (num < m_xMax ? num : m_xMax);
		yd = num / m_xMax;
	}
	else{
		xd = num;
		yd = 0;
	}
	int x = (xd * m_imgSize.x) + ((xd-1) * m_space.x);	// 󔒐͌-1
	int y = ((yd+1) * m_imgSize.y) + (yd * m_space.y);	// Z͌-1

	// ɂďɒt悤
	if(m_curPos.x + x < m_dispSize.x - m_space.x){
		m_curPos.x = m_dispSize.x - m_space.x - x;
	}
	if(m_curPos.y + y < m_dispSize.y - m_space.x){
		m_curPos.y = m_dispSize.y - m_space.y - y;
	}
	if(m_curPos.x > m_space.x){
		m_curPos.x = m_space.x;
	}
	if(m_curPos.y > m_space.y){
		m_curPos.y = m_space.y;
	}

	VecInt vList;
	getSelList(&vList);
	bool isAdd = (vList.size() < (unsigned int)m_selMax);
	// tH[JXXV
	for(ItepBtn it = m_image.begin(); it != m_image.end(); it++){
		Button* pBtn = *it;
		pBtn->m_pos.x += m_pos.x + m_curPos.x;
		pBtn->m_pos.y += m_pos.y + m_curPos.y;
		pBtn->update(isAdd);
		pBtn->m_pos.x -= m_pos.x + m_curPos.x;
		pBtn->m_pos.y -= m_pos.y + m_curPos.y;
		pBtn->m_scale = (pBtn->isFocus() || pBtn->isSelect() ? 1.05f : 1.0f);

		if(pBtn->isSelect()){
			pBtn->setTexture(1, TEXLOAD_CARDBRIGHT);
			if(m_pBrightAnime->isRun()){
				VEC3 pos = m_pBrightAnime->getPos();
				IMAGE2D_VERTEX* v;
				pBtn->m_pVB->Lock(0, 0, (void**)&v, 0);
				v[0].t2 = VEC2(1.0f, pos.y);
				v[1].t2 = VEC2(0.0f, pos.y);
				v[2].t2 = VEC2(1.0f, pos.y + 0.25f);
				v[3].t2 = VEC2(0.0f, pos.y + 0.25f);
				pBtn->m_pVB->Unlock();
			}else{
				IMAGE2D_VERTEX* v;
				pBtn->m_pVB->Lock(0, 0, (void**)&v, 0);
				v[0].t2 = VEC2(1.0f, 0.0f);
				v[1].t2 = VEC2(0.0f, 0.0f);
				v[2].t2 = VEC2(1.0f, 0.0f);
				v[3].t2 = VEC2(0.0f, 0.0f);
				pBtn->m_pVB->Unlock();
			}
		}else{
			pBtn->setTexture(1, NULL);
		}
	}
}

// 摜ǉ
void CardList::addImage(int cardNo)
{
	// Jgł̍Wݒ
	unsigned int num = m_image.size();
	int xd, yd;
	if(m_xMax > 0){
		xd = num % m_xMax;
		yd = num / m_xMax;
	}
	else{
		xd = num;
		yd = 0;
	}
	int x = (xd * m_imgSize.x) + (xd * m_space.x);
	int y = (yd * m_imgSize.y) + (yd * m_space.y);

	// ǉ
	m_image.push_back(new Button());
	m_image.back()->init();
	m_image.back()->create(x, y, m_imgSize.x, m_imgSize.y);
	m_image.back()->setID(cardNo);
	char str[256] = {};
	int cno = SNtCN(cardNo);
	wsprintf(str, TEXLOAD_CARD, SNtSS(HIWORD(cno)), LOWORD(cno));
	m_image.back()->setTexture(0, str);
}

// IJ[h擾
void CardList::getSelList(VecInt* vList)
{
	for(ItepBtn it = m_image.begin(); it != m_image.end(); it++){
		if((*it)->isSelect()){
			vList->push_back((*it)->getID());
		}
	}
}

// tH[JXJ[h擾
int CardList::getFocus(void)
{
	int ret = -1;
	for(ItepBtn it = m_image.begin(); it != m_image.end(); it++){
		if((*it)->isFocus()){
			ret = (*it)->getID();
			break;
		}
	}

	return(ret);
}