
/* _/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/

	FILE	: Common.cpp

+ ------ Explanation of file --------------------------------------------------------------------------

	O[of[^錾
	ef[^.hextern(cppƂKvĖʓ|)
	externĂ{̐錾Ă̂˂

+ _/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/ */

#include "Common.h"
#include "ConsoleWindow.h"
#include "Renderer.h"
#include "Field.h"
#include "Phase.h"

/* -----------------------------------------------------------------------------------------
|
|       O[oϐ
|
+ --------------------------------------------------------------------------------------- */

//#if defined (_DEBUG)
ConsoleWindow	consoleWindow;
//#endif

// NX
Renderer        renderer;	// _[
Field			field;		// tB[h
Phase			phase;		// tFCY

/* -----------------------------------------------------------------------------------------
|
|       O[o֐
|
+ --------------------------------------------------------------------------------------- */

LPDIRECT3DDEVICE9 GetDevice(void)
{
	return(renderer.m_pD3DDevice);
}
// [hs񐶐
void GetWorldMatrix(D3DXMATRIX* pMatrix, VEC3* pos, VEC3* degree, float scale)
{
	D3DXMatrixIdentity(pMatrix);
	// ]ĂȂȂ
	if(degree->x == 0.0f && degree->y == 0.0f && degree->z == 0.0f){
		pMatrix->_41 = pos->x;
		pMatrix->_42 = pos->y;
		pMatrix->_43 = pos->z;
		pMatrix->_11 = scale;
		pMatrix->_22 = scale;
		pMatrix->_33 = scale;
		return;
	}

	D3DXMATRIX mPos, mRotate[3], mScale;
	D3DXMatrixIdentity(&mPos);
	D3DXMatrixIdentity(&mRotate[0]);
	D3DXMatrixIdentity(&mRotate[1]);
	D3DXMatrixIdentity(&mRotate[2]);
	D3DXMatrixIdentity(&mScale);

	D3DXMatrixTranslation(&mPos, pos->x, pos->y, pos->z);
	D3DXMatrixRotationX(&mRotate[0], D3DXToRadian(degree->x));
	D3DXMatrixRotationY(&mRotate[1], D3DXToRadian(degree->y));
	D3DXMatrixRotationZ(&mRotate[2], D3DXToRadian(degree->z));
	D3DXMatrixScaling(&mScale, scale, scale, scale);

	D3DXMatrixMultiply(pMatrix, pMatrix, &mRotate[0]);
	D3DXMatrixMultiply(pMatrix, pMatrix, &mRotate[1]);
	D3DXMatrixMultiply(pMatrix, pMatrix, &mRotate[2]);
	D3DXMatrixMultiply(pMatrix, pMatrix, &mScale);
	D3DXMatrixMultiply(pMatrix, pMatrix, &mPos);
}

// O
VEC3 crossProduct3D(VEC3 v1, VEC3 v2)
{
	VEC3 ret;
	ret.x = v1.y * v2.z - v1.z * v2.y;
	ret.y = v1.z * v2.x - v1.x * v2.z;
	ret.z = v1.x * v2.y - v1.y * v2.x;

	return(ret);
}
// 
float dotProcuct3D(VEC3 v1, VEC3 v2)
{
	return(v1.x * v2.x + v1.y * v2.y + v1.z * v2.z);
}

// J[hԍto݌vԍ
int CNtSN(DWORD no)
{
	int ret = 0;

	switch(HIWORD(no)){
		case SERIES_S5:		ret += SER_S4_MAX;
		case SERIES_S4:		ret += SER_S3_MAX;
		case SERIES_S3:		ret += SER_S2_MAX;
		case SERIES_S2:		ret += SER_S1_MAX;
		case SERIES_S1:		ret += SER_PR_MAX;
		case SERIES_PR:		ret += SER_E1_MAX;
		case SERIES_E1:		ret += SER_B6_MAX;
		case SERIES_B6:		ret += SER_B5_MAX;
		case SERIES_B5:		ret += SER_B4_MAX;
		case SERIES_B4:		ret += SER_B3_MAX;
		case SERIES_B3:		ret += SER_B2_MAX;
		case SERIES_B2:		ret += SER_B1_MAX;
		case SERIES_B1:
			ret += LOWORD(no) - 1;	// lo1Jn̂-1
			break;
		default:
			ret = -1;
			break;
	}

	return(ret);
}

// ݌vԍtoJ[hԍ
DWORD SNtCN(int no)
{
	DWORD ret = 0;
	int max[] = {
		SER_B1_MAX, SER_B2_MAX, SER_B3_MAX, SER_B4_MAX, SER_B5_MAX, SER_B6_MAX,
		SER_E1_MAX, SER_PR_MAX,
		SER_S1_MAX, SER_S2_MAX, SER_S3_MAX, SER_S4_MAX, SER_S5_MAX,
	};

	for(int i = 0; i < SERIES_MAX; i++){
		if(no < max[i]){
			ret = MDW(i, no + 1);
			break;
		}
		no -= max[i];
	}
	return(ret);
}

const char* gSeriesStr[SERIES_MAX] = {
	"B1", "B2", "B3", "B4", "B5", "B6",
	"E1", "PR",
	"S1", "S2", "S3", "S4", "S5",
};

// V[YtoV[Yԍ
int SStSN(const char* pStr)
{
	int ret = -1;

	for(int i = 0; i < SERIES_MAX; i++){
		if(strcmp(pStr, gSeriesStr[i]) == 0){
			ret = i;
			break;
		}
	}

	return(ret);
}

// V[YԍtoV[Y
const char* SNtSS(int ser)
{
	return(0 <= ser && ser < SERIES_MAX ? gSeriesStr[ser] : NULL);
}

