/* _/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/

	FILE	: Field.h

+ ------ Explanation of file --------------------------------------------------------------------------

	tB[h̃J[h

	gCardNXJ[hmۂĂ̂
	{Iɂ܂Ƃ߂Ă邾Ȃ̂ŎۂɃf[^ŝm_xxx[ply][num].XXXɂȂ
	m_xxx[ply][num].XXX		J[h̕`
	m_xxx[ply][num].m_ci	J[h̏

	--- Process ---
	J[hɑ΂Q[ł̑܂Ƃ߂
	{Iɂ͊Om_xxxĂяoɏs߂ɂ

+ _/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/ */

#pragma once

#include "Card.h"

class TextureManager;
class Mouse;
class Scene;
class Phase;
class Dialog;
class FieldMenu;
class CardData;


#define CARD_ANIME_SPEED	0.2f	// 1Aj̎

struct CARDMOVE{
	int		id;			// AjID
	Card*	pCard;		// ΏۃJ[h
	int		ply;		// ړvC[
	int		zone;		// ړ][
	int		num;		// ړʒu
	int		size;		// ړTCY
	bool	isAwake;	// AEFCNtO
	bool	isFront;	// \tO
	int		bply;		// ړvC[
	int		bzone;		// ړ][
	int		bnum;		// ړʒu
	bool	isAnime;	// AjJntO
	float	time;		// Aj

	CARDMOVE(int id, Card* pCard, int ply, int zone, int num, int size,
				bool isAwake, bool isFront, int bply, int bzone, int bnum, float time)
	{
		this->id = id;
		this->pCard = pCard;
		this->ply = ply;
		this->zone = zone;
		this->num = num;
		this->isAwake = isAwake;
		this->isFront = isFront;
		this->bply = bply;
		this->bzone = bzone;
		this->bnum = bnum;
		this->size = size;
		this->isAnime = false;
		this->time = time;
	}
};
typedef vector<CARDMOVE>			vecCardMove;
typedef vector<CARDMOVE>::iterator	iteCardMove;

class Field
{
	private:
		TextureManager*	m_pTexMan;		// eNX`Ǘ
		Mouse*			m_pMouse;		// }EX
		Scene*			m_pCamera;		// J
		Phase*			m_pPhase;		// tFCY
		Dialog*			m_pDialog;		// _CAO
		FieldMenu*		m_pMenu;		// j[

		Card*	m_pCard		[PLY_NUM][DECK_MAX];		// J[hf[^

		Card*	m_pDeck		[PLY_NUM][DECK_MAX];		// fbL
		Card*	m_pDisCard	[PLY_NUM][DISCARD_MAX];		// ̎D
		Card*	m_pExcude	[PLY_NUM][EXCUDE_MAX];		// O
		Card*	m_pHand		[PLY_NUM][HAND_MAX];		// D
		Card*	m_pProgress	[PLY_NUM][PROGRESS_MAX];	// vOX
		Card*	m_pEnergy	[PLY_NUM][ENERGY_MAX];		// GiW[
		Card*	m_pDamage	[PLY_NUM][DAMAGE_MAX];		// _[W
		Card*	m_pAction	[PLY_NUM];					// ANV
		Card*	m_pTemp		[PLY_NUM][TEMP_MAX];		// 
		Card*	m_pPrgDmy	[PLY_NUM][PROGRESS_MAX];	// vOX_~[

		vecCardMove m_moveList;			// J[hړXg

	private:
		void release(void);

	public:
		Field();
		~Field();

		bool m_shiftPRG	[PLY_NUM][PROGRESS_MAX];		// VtgFvOX
		bool m_shiftAC	[PLY_NUM];							// VtgFANV

		// ---------------------------------------------------------------------------------------------
		void init(Phase* pPhase, Dialog* pDialog, FieldMenu* pMenu, CardData* pCardData);	// 
		void update(void);			// XV
		void draw(void);			// `

		void updateMove		(void);	// ړXV
		void updateSelect	(void);	// IXV

		// IJ[h擾
		Card* getSelect		(int num = 0);
		// tH[JXJ[h擾
		Card* getFocus		(void);

		// ړ
		bool isMoveRun		(void){ return(m_moveList.size() ? true : false); }

		// J[hl
		void fillZone		(int ply, int zone);
		void fillDeck		(int ply);
		void fillDisCard	(int ply);
		void fillExcude		(int ply);
		void fillHand		(int ply);
		void fillEnergy		(int ply);
		void fillDamage		(int ply);
		void fillTemp		(int ply);

		// fbL󂯂
		void liftDeck		(int ply);

		// J[h擾
		Card* getZone		(int ply, int zone, int num, bool isMove = false);
		Card* getCard		(int ply, int num){ return(m_pCard[ply][num]); }
		Card* getDeck		(int ply, int num){ return(m_pDeck[ply][num]); }
		Card* getDisCard	(int ply, int num){ return(m_pDisCard[ply][num]); }
		Card* getExcude		(int ply, int num){ return(m_pExcude[ply][num]); }
		Card* getHand		(int ply, int num){ return(m_pHand[ply][num]); }
		Card* getProgress	(int ply, int num){ return(m_pProgress[ply][num]); }
		Card* getEnergy		(int ply, int num){ return(m_pEnergy[ply][num]); }
		Card* getDamage		(int ply, int num){ return(m_pDamage[ply][num]); }
		Card* getAction		(int ply)		  { return(m_pAction[ply]); }
		Card* getTemp		(int ply, int num){ return(m_pTemp[ply][num]); }
		Card* getPrgDmy		(int ply, int num){ return(m_pPrgDmy[ply][num]); }

		// J[hZbg
		void setZone	(int ply, int zone, int num, Card* pCard, bool isAwake, bool isFront);
		void setDeck	(int ply, int num, Card* pCard, bool isFront);
		void setDisCard	(int ply, int num, Card* pCard, bool isFront);
		void setExcude	(int ply, int num, Card* pCard, bool isFront);
		void setHand	(int ply, int num, Card* pCard, bool isFront);
		void setProgress(int ply, int num, Card* pCard, bool isFront, bool isAwake);
		void setEnergy	(int ply, int num, Card* pCard, bool isFront, bool isAwake);
		void setDamage	(int ply, int num, Card* pCard, bool isFront);
		void setAction	(int ply,		   Card* pCard, bool isFront, bool isAwake);
		void setTemp	(int ply, int num, Card* pCard, bool isFront);

		// ړZbg
		void setMove	(Card* pCard, int id, int ply, int zone, int num, bool isAwake = true, int isFront = -1, bool isShift = true, float time = CARD_ANIME_SPEED);
		// AjZbg
		void setAnime	(Card* pCard, int isAwake = -1, int isFront = -1);
		// Ajҋ@
		void wait		(float time = 0.5f);

		// W擾
		VEC3 getFieldPos	(int ply, int zone, int num, int max = -1);
		// px擾
		VEC3 getFieldDegree	(int ply, int zone, int num, bool isAwake, bool isFront);

		// 擾
		int getZoneMax		(int zone);
		int getZoneNum		(int ply, int zone, bool isMove = false);
		int getDeckNum		(int ply);
		int getDisCardNum	(int ply);
		int getExcudeNum	(int ply);
		int getHandNum		(int ply);
		int getProgressNum	(int ply);
		int getEnergyNum	(int ply);
		int getDamageNum	(int ply);
		int getTempNum		(int ply);

		// L擾
		int getAwakeEnergyNum	(int ply);
		int getFallEnergyNum	(int ply);

		// f[^폜
		void deleteZone		(Card* pCard);
		void deleteDeck		(int ply, int num);
		void deleteDisCard	(int ply, int num);
		void deleteExcude	(int ply, int num);
		void deleteHand		(int ply, int num);
		void deleteProgress	(int ply, int num);
		void deleteEnergy	(int ply, int num);
		void deleteDamage	(int ply, int num);
		void deleteAction	(int ply);
		void deleteTemp		(int ply, int num);

		// Process -------------------------------------------------------------------------------------

		// J[hh[
		bool drawCard		(int ply);

		// fbLZbg
		bool addEnergy		(int ply, bool isAwake = true);
		bool addDamage		(int ply);
		bool addTemp		(int ply);

		// vOXVtg
		void shiftProgress	(int ply, int hand, int prg);
		// ANVVtg
		void shiftAction	(int ply, int hand);
		
		// U錾
		Card* attackProgress(int ply, int prg);
		// vOX̃K[hAbv
		void guardProgress	(int ply, int hand, int prg);
		// Uʉߔ
		bool isSuccessAttack(int ply, int prg);
		// _[W^
		void giveDamage		(int ply, int num);

		// _[Wo[X
		void damageReverse(int ply, int num);

		// CN
		void remakeDeck		(int ply, int dis);

		// Vbt
		void shuffleDeck	(int ply);
		void shuffleHand	(int ply);

		// Zbg
		void setZeroProgress(int ply);
		void playZeroProgress(int ply, int num);

		// VtgvZ
		int getShiftCost	(Card* pMaterial, Card* pShift);

		// GiW[gp
		void useEnergy		(int ply, int num);

		// vOXvC
		void playHand		(int ply, int hand, int prg, bool isAwake = true);

		// vOXo
		void entryDeck		(int ply, int deck, int prg, bool isAwake = true);
		void entryDisCard	(int ply, int dis, int prg, bool isAwake = true);

		// ̎Dɑ
		bool dumpDeck		(int ply, int num);
		void dumpHand		(int ply, int num);
		void dumpProgress	(int ply, int num);
		void dumpDamage		(int ply, int num);
		void dumpAction		(int ply);
		void dumpTemp		(int ply, int num);

		// fbLɖ߂
		void backProgress	(int ply, int prg, int deck);
		
		// Dɖ߂
		void bounceProgress	(int ply, int num);

		// Dɉ
		void searchDeck		(int ply, int num);
		void searchDisCard	(int ply, int num);
		void searchTemp		(int ply, int num);

		// AEFCNEtI[
		void awakeProgress	(int ply, int num);
		void fallProgress	(int ply, int num);
		void awakeEnergy	(int ply, int num);
		void fallEnergy		(int ply, int num);
		void awakeAction	(int ply);
		void fallAction		(int ply);

		// Ԃ
		void reverseDeck	(int ply, int num, bool isFront);
		void reverseProgress(int ply, int num, bool isFront);
		void reverseDamage	(int ply, int num, bool isFront);

		// ւ
		void replaceCard	(Card* pCard1, Card* pCard2, bool isFront1, bool isAwake1, bool isFront2, bool isAwake2);

		// ړ
		void toTemp			(int ply, int zone, int num);
		void fromTemp		(int ply, int zone, int num, int temp = -1);

		// IbN
		void selLockAll			(int lock);
		void selLockPly			(int ply, int lock);
		void selLockZone		(int ply, int zone, int lock);
		void selLockOnce		(int ply, int zone, int num, int lock = SELECT_LOCK);
		void selLockZoneExcept	(int ply, int zone);
		int  selLockValue		(int ply, int zone, int data, int value, char* ope = "==", int lock = SELECT_LOCK);
		int  selLockValueExcept	(int ply, int zone, int data, int value, char* ope = "==");
		void selLockPrgDmy		(int ply, int lock, int num = -1);

		// I𐔂̎擾(Ŝ𐔂)
		int getSelectNum	(void);
		// J[hf[^̎擾
		int getValueNum		(int ply, int zone, int data, int value, char* ope = "==");
		// J[hf[^̃|C^擾
		void getValueCard	(int ply, int zone, int data, int value, VecpCard* vCard, char* ope = "==");
	private:
		void _getValueData	(Card* pCard, int* d, int data);
};

extern Field field;

