
/* _/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/

	FILE	: FieldMenu.h

+ ------ Explanation of file --------------------------------------------------------------------------

+ _/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/ */

#include "Common.h"

#include "Renderer.h"
#include "CardData.h"
#include "Image2D.h"

#include "FieldMenu.h"

//! RXgN^
FieldMenu::FieldMenu()
{
	m_isCreate = false;
}

//! fXgN^
FieldMenu::~FieldMenu()
{
	close();
}

//! 
void FieldMenu::init(CardData* pCardData)
{
	m_pCardData = pCardData;
}

//! 
int FieldMenu::create(int set_x, int set_y, int set_w, int set_h)
{
	m_base.create(set_x, set_y, set_w, set_h, D3DXCOLOR(0.6f, 0.6f, 0.6f, 1.0f));

	m_pos.x = (float)set_x;
	m_pos.y = (float)set_y;

	m_isCreate = true;

	m_cardImg.init();
	m_cardImg.create(35, 23, 144, 200);
	m_cardImg.setTexture(0, TEXLOAD_SLEEVE1);

	return(TRUE);
}

//! `
void FieldMenu::draw(void)
{
	if(!m_isCreate) { return; }

	m_base.draw();

	m_cardImg.draw();
	for(int i = 0; i < FMENU_INFO_NUM; i++){
		m_text[i].draw();
	}
}

//! I
void FieldMenu::close(void)
{
	m_isCreate = false;
	m_base.close();
	m_cardImg.close();
}

//! J[hXV
void FieldMenu::updateData(Card* card)
{
#define	COL(c)		(c >= 0 ? 0x00ff0000 : 0x0000ff00)
	if(card && card->m_reverse == CARD_FRONT){
		char text[1000];
		int top = 235;
		// J[h摜
		wsprintf(text, TEXLOAD_CARD, SNtSS(HIWORD(card->m_ci.cardNo)), LOWORD(card->m_ci.cardNo));
		m_cardImg.setTexture(0, text);
		// V[Y
		wsprintf(text,"%s-%03d", SNtSS(HIWORD(card->m_ci.cardNo)), LOWORD(card->m_ci.cardNo));
		m_text[FMENU_INFO_SERIES].create(text, 10, top, 290, top+15, 14);
		top += 35;
		// O
		m_text[FMENU_INFO_NAME].create(card->m_ci.name, 10, top, 290, top+15, 14);
		// Zp[
		top += 25;
		if(card->getAddPower() != 0){
			if(card->getAddPower() > 0){
				wsprintf(text, "+%5d", card->getAddPower());
			}else{
				wsprintf(text, "-%5d", abs(card->getAddPower()));
			}
		}else{
			wsprintf(text, "");
		}
		m_text[FMENU_INFO_ADD_POWER].create(text, 55, top, 150, top+15, 14, COL(card->getAddPower()));
		// p[
		top += 15;
		wsprintf(text, "p[:%5d", card->getSumPower());
		m_text[FMENU_INFO_POWER].create(text, 10, top, 120, top+15, 14);
		// K[h
		wsprintf(text, "K[h:%d", card->m_ci.guard);
		m_text[FMENU_INFO_GUARD].create(text, 130, top, 290, top+15, 14);
		// Zx
		top += 20;
		if(card->getAddLevel() != 0){
			if(card->getAddLevel() > 0){
				wsprintf(text, "+%1d", card->getAddLevel());
			}else{
				wsprintf(text, "-%1d", abs(card->getAddLevel()));
			}
		}else{
			wsprintf(text, "");
		}
		m_text[FMENU_INFO_ADD_LEVEL].create(text, 55, top, 150, top+15, 14, COL(card->getAddLevel()));
		// ZXgCN
		if(card->getAddStrike() != 0){
			if(card->getAddStrike() > 0){
				wsprintf(text, "+%1d", card->getAddStrike());
			}else{
				wsprintf(text, "-%1d", abs(card->getAddStrike()));
			}
		}else{
			wsprintf(text, "");
		}
		m_text[FMENU_INFO_ADD_STRIKE].create(text, 205, top, 290, top+15, 14, COL(card->getAddStrike()));
		// x
		top += 15;
		wsprintf(text, "x:%d", card->getSumLevel());
		m_text[FMENU_INFO_LEVEL	].create(text, 10, top, 120, top+15, 14);
		// XgCN
		wsprintf(text, "XgCN:%d", card->getSumStrike());
		m_text[FMENU_INFO_STRIKE].create(text, 130, top, 250, top+15, 14);
		// t[
		top += 35;
		switch(card->m_ci.frame){
			case FRAME_SIGMA:	wsprintf(text, "t[:");	break;
			case FRAME_OMEGA:	wsprintf(text, "t[:");	break;
			case FRAME_ALL:		wsprintf(text, "t[:");	break;
			case FRAME_NON:		wsprintf(text, "t[:");	break;
		}
		m_text[FMENU_INFO_FRAME].create(text, 10, top, 120, top+15, 14);
		// ʐ
		top += 35;
		m_pCardData->getCardText(card->m_ci.serNo, text);
		m_text[FMENU_INFO_SKILL].create(text, 10, top, 280, MENU_H - 10, 14);
	}else{
		// J[h
		if(card){
			if(card->m_ply == PLY_1P){
//				m_cardImg.m_pTexture = &renderer.m_pTexture[TEX_SLEEVE1];
				m_cardImg.setTexture(0, TEXLOAD_SLEEVE1);
			}else{
//				m_cardImg.m_pTexture = &renderer.m_pTexture[TEX_SLEEVE2];
				m_cardImg.setTexture(0, TEXLOAD_SLEEVE2);
			}
		}

		for(int i = 0; i < FMENU_INFO_NUM; i++){
			m_text[i].create("", 0, 0, 0, 0, 14);
		}
	}
#undef COL
}

//! J[hXV
void FieldMenu::updateData(int cardNo)
{
	if(cardNo >= 0){
		CARD_INFO ci;
		m_pCardData->getCardData(cardNo, &ci);

		char text[1000];
		int top = 235;
		// J[h摜
		wsprintf(text, TEXLOAD_CARD, SNtSS(HIWORD(ci.cardNo)), LOWORD(ci.cardNo));
		m_cardImg.setTexture(0, text);
		// O
		m_text[FMENU_INFO_NAME].create(ci.name, 10, top, 290, top+15, 14);
		// Zp[
		top += 25;
		wsprintf(text, "");
		m_text[FMENU_INFO_ADD_POWER].create(text, 55, top, 150, top+15, 14, 0x00ff0000);
		// p[
		top += 15;
		wsprintf(text, "p[:%5d", ci.power);
		m_text[FMENU_INFO_POWER].create(text, 10, top, 120, top+15, 14);
		// K[h
		wsprintf(text, "K[h:%d", ci.guard);
		m_text[FMENU_INFO_GUARD].create(text, 130, top, 290, top+15, 14);
		// Zx
		top += 20;
		wsprintf(text, "");
		m_text[FMENU_INFO_ADD_LEVEL].create(text, 55, top, 150, top+15, 14, 0x00ff0000);
		// ZXgCN
		wsprintf(text, "");
		m_text[FMENU_INFO_ADD_STRIKE].create(text, 205, top, 290, top+15, 14, 0x00ff0000);
		// x
		top += 15;
		wsprintf(text, "x:%d", ci.level);
		m_text[FMENU_INFO_LEVEL	].create(text, 10, top, 120, top+15, 14);
		// XgCN
		wsprintf(text, "XgCN:%d", ci.strike);
		m_text[FMENU_INFO_STRIKE].create(text, 130, top, 250, top+15, 14);
		// t[
		top += 35;
		switch(ci.frame){
			case FRAME_SIGMA:	wsprintf(text, "t[:");	break;
			case FRAME_OMEGA:	wsprintf(text, "t[:");	break;
			case FRAME_ALL:		wsprintf(text, "t[:");	break;
			case FRAME_NON:		wsprintf(text, "t[:");	break;
		}
		m_text[FMENU_INFO_FRAME].create(text, 10, top, 120, top+15, 14);
		// ʐ
		top += 35;
		m_pCardData->getCardText(ci.serNo, text);
		m_text[FMENU_INFO_SKILL].create(text, 10, top, 280, MENU_H - 10, 14);
	}else{
		// J[h
//		m_cardImg.m_pTexture = &renderer.m_pTexture[TEX_SLEEVE1];
		m_cardImg.setTexture(0, TEXLOAD_SLEEVE1);
		for(int i = 0; i < FMENU_INFO_NUM; i++){
			m_text[i].create("", 0, 0, 0, 0, 14);
		}
	}
}

