
/* _/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/

	FILE	: FieldMenu.h

+ ------ Explanation of file --------------------------------------------------------------------------

+ _/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/ */

#pragma once

#include "Card.h"
#include "Image2D.h"
#include "Graphic_Text.h"

class CardData;

enum{
	FMENU_INFO_SERIES,
	FMENU_INFO_NAME,
	FMENU_INFO_ADD_POWER,
	FMENU_INFO_POWER,
//	FMENU_INFO_ADD_GUARD,
	FMENU_INFO_GUARD,
	FMENU_INFO_ADD_LEVEL,
	FMENU_INFO_LEVEL,
	FMENU_INFO_ADD_STRIKE,
	FMENU_INFO_STRIKE,
	FMENU_INFO_FRAME,
	FMENU_INFO_SKILL,

	FMENU_INFO_NUM,
};

class FieldMenu
{
	private:
		CardData*		m_pCardData;			// J[hf[^

	public:
		FieldMenu();
		~FieldMenu();

		Image2D			m_base;					// y
		VEC3			m_pos;					// W
		bool			m_isCreate;				// tO
		Image2D			m_cardImg;				// J[h摜
		TextGraphic		m_text[FMENU_INFO_NUM];	// J[h

		void	init	(CardData* pCardData);
		int		create	(int x, int y, int w, int h);
		void	draw	(void);
		void	close	(void);

		void	updateData	(Card* card);
		void	updateData	(int cardNo);
};





