
/* _/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/

	FILE	: Image2D.h

+ ------ Explanation of file --------------------------------------------------------------------------

	`2D`

+ _/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/ */

#pragma once

class Mouse;
class TextureManager;

// _obt@̃tH[}bg`
#define IMAGE2D_VERTEX_FVF (D3DFVF_XYZ | D3DFVF_DIFFUSE | D3DFVF_TEX2)

// _obt@\
typedef struct
{
	VEC3		p;		// W
	DWORD		color;	// F
	VEC2		t1;		// eNX`W
	VEC2		t2;		// eNX`W
}IMAGE2D_VERTEX;

class Image2D
{
	protected:
		TextureManager*	m_pTexMan;		// eNX`Ǘ

	public:
		Image2D();
		~Image2D();

		LPDIRECT3DVERTEXBUFFER9	m_pVB;			// _obt@
		D3DXMATRIX				m_world;		// [hs
		bool					m_isCreate;		// tO
		VEC3					m_pos;			// W()
		VEC3					m_degree;		// px
		float					m_scale;		// g嗦
		VEC2					m_size;			// 
		VEC2					m_center;		// ]S(0.0`1.0)
		int						m_texPart;		// eNX`ԍ
		int						m_texID[2];		// eNX`ԍ

		void	init	(void);
		int		create	(int set_x, int set_y, int set_w, int set_h, D3DXCOLOR color = D3DXCOLOR(0.0f, 0.0f, 0.0f, 1.0f), float set_xc = 0.5f, float set_yc = 0.5f);
		void	update	(void);
		void	draw	(void);
		void	close	(void);

		void	setTexture(int stage, char* name, int xPart = 1, int yPart = 1, bool isRev = false);
		void	setTexPart(int part);
};

typedef vector<Image2D>						VecImg2D;
typedef vector<Image2D>::iterator			IteImg2D;
typedef vector<Image2D*>					VecpImg2D;
typedef vector<Image2D*>::iterator			ItepImg2D;

