
/* _/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/

	FILE	: Mouse.h

+ ------ Explanation of file --------------------------------------------------------------------------

+ _/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/ */


#include "Common.h"

#include "windowManager.h"
#include "RayTrace.h"

#include "Mouse.h"

//! 
void Mouse::release(void)
{
	SAFE_DELETE(m_pRayTrace);
}

//! 
void Mouse::init(void)
{
	m_pWinMan = WindowManager::getInstance();
	m_pRayTrace = new RayTrace();
	getRayTrace()->Init(WINDOW_W-MENU_W, WINDOW_H, MENU_W, 0);
}

//! XV
void Mouse::update(void)
{
	if(GetActiveWindow() == getWinMan()->getHWnd()){
		// W擾
		POINT cPos;
		GetCursorPos(&cPos);
		ScreenToClient(getWinMan()->getHWnd(), &cPos);
		m_pos.x = (float)cPos.x;
		m_pos.y = (float)cPos.y;

		// L͏Ԏ擾
		if(GetAsyncKeyState(VK_LBUTTON) < 0){
			if(m_inputL == MOUSE_PULL){
				m_inputL = MOUSE_PUSH;
			}else{
				m_inputL = MOUSE_HOLD;
			}
		}else{
			m_inputL = MOUSE_PULL;
		}

		// R͏Ԏ擾
		if(GetAsyncKeyState(VK_RBUTTON) < 0){
			if(m_inputR == MOUSE_PULL){
				m_inputR = MOUSE_PUSH;
			}else{
				m_inputR = MOUSE_HOLD;
			}
		}else{
			m_inputR = MOUSE_PULL;
		}

		// zC[
		if(m_updateWheel != 0){
			m_wheel = m_updateWheel;
			m_updateWheel = 0;
		}else{
			m_wheel = 0;
		}
	}else{
		m_pos.x = -1.0f;
		m_pos.y = -1.0f;
		m_wheel = 0;
	}
}

//! 3DʂƂ̃qbg`FbN
bool Mouse::isHitPlane(VEC3* pPos, D3DXMATRIX* pWorld, VEC3* pHit)
{
	return(getRayTrace()->GetPosFromScreen(&m_pos, pPos, pWorld, pHit));
}

