
/* _/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/

	FILE	: Phase.cpp

+ ------ Explanation of file --------------------------------------------------------------------------

	tFCYǗ
	vC[ƂS

+ _/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/ */

#include "Common.h"

#include "systemManager.h"
#include "Renderer.h"
#include "Field.h"
#include "Mouse.h"
#include "Dialog.h"
#include "Skill.h"
#include "CardData.h"
#include "Scene.h"
#include "animeCalc.h"
#include "Graphic_Text.h"

#include "Phase.h"

//! RXgN^
Phase::Phase()
{
	m_my = PLY_1P;
	m_phase = PHASE_NON;
	m_state = PHASE_NON;

#if defined (_LOCAL_)
	m_isChange = false;
#endif
}

//! fXgN^
Phase::~Phase()
{
	release();
}

//! 
void Phase::release(void)
{
	for(int ply = 0; ply < PLY_NUM; ply++){
		for(int i = 0; i < DISPTEXT_MAX; i++){
			SAFE_DELETE(m_pDispText[ply][i]);
		}
	}
}

//! 
void Phase::init(Field* pField, Skill* pSkill, Dialog* pDlg)
{
	m_pCamera = SystemManager::getInstance()->getCamera();
	m_pMouse = SystemManager::getInstance()->getMouse();
	m_pField = pField;
	m_pSkill = pSkill;
	m_pDialog = pDlg;

	for(int ply = 0; ply < PLY_NUM; ply++){
		for(int i = 0; i < DISPTEXT_MAX; i++){
			m_pDispText[ply][i] = new TextGraphic();
		}
	}

	m_phase = PHASE_INIT;
	m_state = PHASE_INIT_ZERO;
	m_canOpenDlg = false;
	m_selectNum = 0xff;
	m_isRemake = false;
	m_drawNum = 0;
	m_drawNow = 0;

	for(int i = 0; i < PHASE_NUM; i++){
		m_btn[i].init();
	}

	int x = 200;
	int y = 20;
	for(int i = 0; i < PHASE_NUM; i++){
		m_btn[i].create(x, y, BTN_NORMAL_W, BTN_NORMAL_H);
		m_btn[i].setTexture(0, TEXLOAD_BUTTON);
		m_btn[i].setEnable(false);
		y += 35;
	}
	m_btn[PHASE_AWAKE	].setID(BTN_ID_P_AWAKE);
	m_btn[PHASE_DRAW	].setID(BTN_ID_P_DRAW);
	m_btn[PHASE_ENERGY	].setID(BTN_ID_P_ENERGY);
	m_btn[PHASE_MAIN	].setID(BTN_ID_P_MAIN);
	m_btn[PHASE_ATTACK	].setID(BTN_ID_P_ATTACK);
	m_btn[PHASE_END		].setID(BTN_ID_P_END);

	m_btn[PHASE_AWAKE	].setTexType(BUTTONPART(BTNPART_AWAKE));
	m_btn[PHASE_DRAW	].setTexType(BUTTONPART(BTNPART_DRAW));
	m_btn[PHASE_ENERGY	].setTexType(BUTTONPART(BTNPART_ENERGY));
	m_btn[PHASE_MAIN	].setTexType(BUTTONPART(BTNPART_MAIN));
	m_btn[PHASE_ATTACK	].setTexType(BUTTONPART(BTNPART_ATTACK));
	m_btn[PHASE_END		].setTexType(BUTTONPART(BTNPART_END));
}

//! XV
void Phase::update(void)
{
	// Q[I
	if(m_pField->getDamageNum(PLY_MY) == DAMAGE_MAX || m_pField->getDamageNum(PLY_OPPO) == DAMAGE_MAX){
		return;
	}

	// ړ
	if(m_pField->isMoveRun()){
		return;
	}

	if(m_isRemake){
		updateRemake();
		return;
	}

	for(int i = 0; i < PHASE_NUM; i++){
		m_btn[i].update();
	}

	updatePhase();
	updateGuide();
	updateList();

	if(m_pField->getDamageNum(PLY_1P) == DAMAGE_MAX){
		printf("Ȕł\n");
	}else if(m_pField->getDamageNum(PLY_2P) == DAMAGE_MAX){
		printf("Ȕł\n");
	}
}

//! `
void Phase::draw(void)
{
	for(int i = 0; i < PHASE_NUM; i++){
		m_btn[i].draw();
	}
	for(int ply = 0; ply < PLY_NUM; ply++){
		for(int i = 0; i < DISPTEXT_MAX; i++){
			m_pDispText[ply][i]->draw();
		}
	}

}

//! KChXV
void Phase::updateGuide(void)
{
	Card* pCard;
	for(int ply = 0; ply < PLY_NUM; ply++){
		for(int i = 0; i < DISPTEXT_MAX; i++){
			char	text[12] = {};
			VEC3	pos;
			int		size;
			int		col = 0x00ffff00;
			switch(i){
				// vOXp[
				case DISPTEXT_PRG1:
				case DISPTEXT_PRG2:
				case DISPTEXT_PRG3:
				case DISPTEXT_PRG4:
					size = 14;
					pCard = m_pField->getProgress(ply, i);
					if(pCard && pCard->m_reverse == CARD_FRONT){
						pos = pCard->getDispPos();
						pos.y += ((m_isChange ? !ply : ply) ? -35 : 45);
						wsprintf(text, "%d", pCard->getSumPower());
						if(pCard->getAddPower() > 0){
							col = 0x00ff0000;
						}else if(pCard->getAddPower() < 0){
							col = 0x000000ff;
						}
						m_pDispText[ply][i]->create(text, (int)pos.x - 50, (int)pos.y - 10, (int)pos.x + 50, (int)pos.y + 10, size, col);
						m_pDispText[ply][i]->SetTextAlign(AlignCenter);
					}else{
						m_pDispText[ply][i]->create("", 0, 0, 0, 0, size, col);
					}
					break;
				// fbL
				case DISPTEXT_DECK:
					size = 20;
					wsprintf(text, "%d", m_pField->getDeckNum(ply));
					pos = renderer.conv3Dto2D(m_pField->getFieldPos(ply, ZONE_DECK, 0));
					if(ply == PLY_MY){
						pos.x -= 40;
					}else{
						pos.x += 40;
					}
					m_pDispText[ply][i]->create(text, (int)pos.x - 50, (int)pos.y - 10, (int)pos.x + 50, (int)pos.y + 10, size, col);
					m_pDispText[ply][i]->SetTextAlign(AlignCenter);
					break;
				// ̎D
				case DISPTEXT_DISCARD:
					size = 20;
					wsprintf(text, "%d", m_pField->getDisCardNum(ply));
					pos = renderer.conv3Dto2D(m_pField->getFieldPos(ply, ZONE_DISCARD, 0));
					if(ply == PLY_MY){
						pos.x -= 48;
						pos.y -= 24;
					}else{
						pos.x += 36;
						pos.y += 16;
					}
					m_pDispText[ply][i]->create(text, (int)pos.x - 50, (int)pos.y - 10, (int)pos.x + 50, (int)pos.y + 10, size, col);
					m_pDispText[ply][i]->SetTextAlign(AlignCenter);
					break;
				// ̎Dt[
				case DISPTEXT_DISCARD_FRAME:{
					size = 16;
					col = 0x00ffaa00;
					int num = m_pField->getValueNum(ply, ZONE_DISCARD, CI_FRAME, FRAME_SIGMA) +
								m_pField->getValueNum(ply, ZONE_DISCARD, CI_FRAME, FRAME_OMEGA);
					wsprintf(text, "%d", num);
					pos = renderer.conv3Dto2D(m_pField->getFieldPos(ply, ZONE_DISCARD, 0));
					if(ply == PLY_MY){
						pos.x -= 46;
					}else{
						pos.x += 38;
					}
					m_pDispText[ply][i]->create(text, (int)pos.x - 50, (int)pos.y - 10, (int)pos.x + 50, (int)pos.y + 10, size, col);
					m_pDispText[ply][i]->SetTextAlign(AlignCenter);
					break;
				}
				// ̎D0t[
				case DISPTEXT_DISCARD_ALL:{
					size = 16;
					col = 0x00aaff00;
					int num = m_pField->getValueNum(ply, ZONE_DISCARD, CI_FRAME, FRAME_ALL);
					wsprintf(text, "%d", num);
					pos = renderer.conv3Dto2D(m_pField->getFieldPos(ply, ZONE_DISCARD, 0));
					if(ply == PLY_MY){
						pos.x -= 44;
						pos.y += 24;
					}else{
						pos.x += 40;
						pos.y -= 16;
					}
					m_pDispText[ply][i]->create(text, (int)pos.x - 50, (int)pos.y - 10, (int)pos.x + 50, (int)pos.y + 10, size, col);
					m_pDispText[ply][i]->SetTextAlign(AlignCenter);
					break;
				}
				// O
				case DISPTEXT_EXCUDE:
					size = 20;
					wsprintf(text, "%d", m_pField->getExcudeNum(ply));
					pos = renderer.conv3Dto2D(m_pField->getFieldPos(ply, ZONE_EXCUDE, 0));
					if(ply == PLY_MY){
						pos.x -= 52;
					}else{
						pos.x += 54;
					}
					m_pDispText[ply][i]->create(text, (int)pos.x - 50, (int)pos.y - 10, (int)pos.x + 50, (int)pos.y + 10, size, col);
					m_pDispText[ply][i]->SetTextAlign(AlignCenter);
					break;
			}
		}
	}
}
//! CNXV
void Phase::updateRemake(void)
{
	if(m_pDialog->isExist()){
		VecInt selList;
		m_pDialog->m_cardList.getSelList(&selList);
		// 1Iꂽ
		if(selList.size() >= 1){
			// IJ[h
			int dcNum = m_pField->getDisCardNum(PLY_MY);
			for(int i = 0; i < dcNum; i++){
				// v珜OăCN
				if(m_pField->getDisCard(PLY_MY, i)->m_ci.serNo == selList.back()){
					m_pField->remakeDeck(PLY_MY, i);
					m_pDialog->close();
					// c̃h[ɖ߂
					m_isRemake = false;
					break;
				}
			}
		}
	}else{
		// J[hXgI[v
		m_pDialog->open(DLG_CARDLIST, DLG_PLACE_CENTER);
		m_pDialog->m_btnList[0]->setEnable(false);
		m_pDialog->m_cardList.m_selMax = 1;
		// t[̂ݒǉ
		int dcNum = m_pField->getDisCardNum(PLY_MY);
		int cnt = 0;
		for(int i = 0; i < dcNum; i++){
			Card* pCard = m_pField->getDisCard(PLY_MY, i);
			if(!pCard) continue;
			if(pCard->m_ci.frame != FRAME_NON){
				m_pDialog->m_cardList.addImage(pCard->m_ci.serNo);
				cnt++;
			}
		}
		if(cnt == 0){
printf("Ołt[݂܂Ał\n");
		}
	}
}
//! tFCYXV
void Phase::updatePhase(void)
{
	switch(m_phase){
		case PHASE_INIT:	initPhase();	break;
		case PHASE_AWAKE:	awakePhase();	break;
		case PHASE_DRAW:	drawPhase();	break;
		case PHASE_ENERGY:	energyPhase();	break;
		case PHASE_MAIN:	mainPhase();	break;
		case PHASE_ATTACK:	attackPhase();	break;
		case PHASE_END:		endPhase();		break;
		case PHASE_TURN:	turnPhase();	break;
	}

	// tFCYڍs
	for(int i = 0; i < PHASE_NUM; i++){
		if(m_btn[i].isSelect()){
			if(m_phase == i){
				continue;
			}
			changePhase(i);
			break;
		}
	}

}
//! XgXV
void Phase::updateList(void)
{
	if(m_pDialog->isExist()){
		DWORD retCode = m_pDialog->getResult();
		if((HIWORD(retCode) == DLG_LIST) && (LOWORD(retCode) == BTN_ID_LIST)){
			m_pDialog->close();
			m_pDialog->open(DLG_CARDLIST, DLG_PLACE_CENTER);
			m_pDialog->m_cardList.m_selMax = 3;
			// {^ɏ㏑ƍ
			m_canOpenDlg = false;

			int selPly = m_pField->getSelect()->m_ply;
			switch(m_pField->getSelect()->m_zone){
				//̎D
				case ZONE_DISCARD:
					for(int i = 0; i < m_pField->getDisCardNum(selPly); i++){
						Card* pCard = m_pField->getDisCard(selPly, i);
						if(!pCard) continue;
						m_pDialog->m_cardList.addImage(pCard->m_ci.serNo);
					}
					break;
				//O
				case ZONE_EXCUDE:
					for(int i = 0; i < m_pField->getExcudeNum(selPly); i++){
						Card* pCard = m_pField->getExcude(selPly, i);
						if(!pCard) continue;
						m_pDialog->m_cardList.addImage(pCard->m_ci.serNo);
					}
					break;
			}
		}else if((HIWORD(retCode) == DLG_CARDLIST) && (LOWORD(retCode) == BTN_ID_CLOSE)){
			m_pDialog->close();
			m_canOpenDlg = true;
		}
	}
}

//! tFCYύX
void Phase::changePhase(int phase)
{
	m_phase = phase;
	m_pDialog->close();
	m_selectNum = 1;
	m_canOpenDlg = false;
	m_pField->selLockAll(SELECT_NON);

	for(int j = 0; j < PHASE_NUM; j++){
		m_btn[j].setEnable(false);
	}

	switch(phase){
		//AEFCN
		case PHASE_AWAKE:
			m_btn[PHASE_AWAKE].setEnable(true);
printf("AEFCNtFCY\n");
			break;
		//h[
		case PHASE_DRAW:
			m_btn[PHASE_DRAW].setEnable(true);
printf("h[tFCY\n");
			break;
		//GiW[
		case PHASE_ENERGY:
			m_btn[PHASE_ENERGY].setEnable(true);
printf("GiW[tFCY\n");
			break;
		//C
		case PHASE_MAIN:
			m_btn[PHASE_MAIN].setEnable(true);
			m_btn[PHASE_ATTACK].setEnable(true);
			m_btn[PHASE_END].setEnable(true);
			m_state = PHASE_MAIN_FREE;
			m_canOpenDlg = true;
printf("CtFCY\n");
			break;
		//A^bN
		case PHASE_ATTACK:
			m_btn[PHASE_ATTACK].setEnable(true);
			m_btn[PHASE_END].setEnable(true);
			m_state = PHASE_ATTACK_SELECT;
			m_canOpenDlg = true;
printf("A^bNtFCY\n");
			break;
		//Gh
		case PHASE_END:
#if defined (_LOCAL_)
			m_btn[PHASE_END].setEnable(false);
#else
			m_btn[PHASE_END].setEnable(true);
#endif
			m_state = PHASE_END_RESET;
printf("GhtFCY\n");
			break;
	}
}


//! tFCY
void Phase::initPhase(void)
{
	switch(m_state){
		//Lv0Zbg
		case PHASE_INIT_ZERO:
			for(int i = 0; i < PHASE_NUM; i++){
				m_btn[i].setEnable(false);
			}

#if 1
			for(int ply = 0; ply < PLY_NUM; ply++){
				m_pField->setZeroProgress(ply);
			}

			// I
			m_state = PHASE_INIT_SHUFFLE;
#else	// 蓮
			for(int ply = 0; ply < PLY_NUM; ply++){
				if(ply == PLY_MY){
					const int	deckNum = m_pField->getDeckNum(ply);		// fbL
					Card* pCard;
					for(int i = 0; i < deckNum; i++){
						pCard = m_pField->getDeck(ply, i);
						if(pCard && (pCard->m_ci.level == 0) && (pCard->m_ci.type == TYPE_PG)){
							// DɃZbg
							m_pField->searchDeck(ply, i);
						}
					}
				}else if(ply == PLY_2P){
					for(int i = 0; i < PROGRESS_MAX; i++){
							m_pField->setZeroProgress(ply);
					}
				}
			}
			m_pField->fillDeck(PLY_MY);

			// I
			m_state = PHASE_INIT_ZERO_PUT;
			m_pField->selLockZoneExcept(PLY_MY, ZONE_HAND);
			m_selectNum = 1;
#endif
			break;

		//Lv0DZbg
		case PHASE_INIT_ZERO_PUT:
			if(m_pField->getHandNum(PLY_MY) > 0){
				// IJ[hׂĂ
				if(m_pField->getSelect()){
					m_pField->playZeroProgress(PLY_MY, m_pField->getSelect()->m_num);
				}
			}else{
				// I
				m_state = PHASE_INIT_SHUFFLE;
			}
			break;

		//fbLVbt
		case PHASE_INIT_SHUFFLE:
			for(int ply = 0; ply < PLY_NUM; ply++){
				m_pField->shuffleDeck(ply);
			}

			// I
			m_state = PHASE_INIT_JANKEN;
			break;

		//񂯂
		case PHASE_INIT_JANKEN:
			// I
			m_turn = PLY_MY;
			m_state = PHASE_INIT_DRAW;
			break;

		//h[
		case PHASE_INIT_DRAW:
			for(int ply = 0; ply < PLY_NUM; ply++){
				// ŏȂ̂Ń`FbN
				for(int i = 0; i < 5; i++){
					m_pField->drawCard(ply);
				}
			}

			// I
			m_state = PHASE_INIT_HAND;
			m_pField->selLockZoneExcept(PLY_MY, ZONE_HAND);
			m_selectNum = m_pField->getHandNum(PLY_MY);
			m_canOpenDlg = true;
			m_pDialog->open(DLG_TEXT, DLG_PLACE_CENTER, NULL, "Dł܂\nENbNŏI");
			m_canOpenDlg = false;
			break;

		//D
		case PHASE_INIT_HAND:
			if(m_pMouse->getInputR() == MOUSE_PUSH){
				int dumpCnt = 0;
				// D̂Ă
				while(1){
					// ڂŉE
					Card* pCard = m_pField->getSelect(m_pField->getSelectNum()-1);
					if(!pCard) break;
					m_pField->dumpHand(pCard->m_ply, pCard->m_num);
					dumpCnt++;
				}
				m_pField->fillHand(PLY_MY);
				// h[(`FbN)
				for(int i = 0; i < dumpCnt; i++){
					m_pField->drawCard(PLY_MY);
				}

				// I
				m_state = PHASE_INIT_ENERGY;
				m_pField->selLockAll(SELECT_NON);
				m_pDialog->close();
			}
			break;

		//GiW[Zbg
		case PHASE_INIT_ENERGY:
#if defined(_LOCAL_)
			if(m_turn == PLY_MY){
				m_pField->addEnergy(PLY_MY);
				m_pField->addEnergy(PLY_OPPO);
				m_pField->addEnergy(PLY_OPPO);
			}else{
				m_pField->addEnergy(PLY_OPPO);
				m_pField->addEnergy(PLY_MY);
				m_pField->addEnergy(PLY_MY);
			}
#elif defined(_NET_)
			if(m_turn == PLY_MY){
				m_pField->addEnergy(PLY_MY);
			}
			else{
				m_pField->addEnergy(PLY_MY);
				m_pField->addEnergy(PLY_MY);
			}
#endif
			// I
			m_state = PHASE_INIT_OPEN;
			break;

		//Lv0\
		case PHASE_INIT_OPEN:
			for(int ply = 0; ply < PLY_NUM; ply++){
				for(int i = 0; i < PROGRESS_MAX; i++){
					m_pField->reverseProgress(ply, i, true);
				}
			}
			changePhase(PHASE_AWAKE);
			break;
	}	
}
//! AEFCNtFCY
void Phase::awakePhase(void)
{
	Card* pCard;

	// vOX
	for(int i = 0; i < PROGRESS_MAX; i++){
		pCard = m_pField->getProgress(PLY_MY, i);
		if(pCard && pCard->m_awake == CARD_FALL){
			m_pField->awakeProgress(PLY_MY, i);
		}
	}

	// GiW[
	for(int i = 0; i < ENERGY_MAX; i++){
		pCard = m_pField->getEnergy(PLY_MY, i);
		if(pCard && pCard->m_awake == CARD_FALL){
			m_pField->awakeEnergy(PLY_MY, i);
		}
	}

	// ANV
	pCard = m_pField->getAction(PLY_MY);
	if(pCard && pCard->m_awake == CARD_FALL){
		m_pField->awakeAction(PLY_MY);
	}

	changePhase(PHASE_DRAW);
}
//! h[tFCY
void Phase::drawPhase(void)
{
	if(checkDraw(2, m_pField->drawCard(PLY_MY))){
		changePhase(PHASE_ENERGY);
	}
}
//! GiW[tFCY
void Phase::energyPhase(void)
{
// DEBUG
int cnt = 1;
if(GetKeyState('2') < 0)cnt = 2;
if(GetKeyState('3') < 0)cnt = 3;
if(GetKeyState('4') < 0)cnt = 4;
if(GetKeyState('5') < 0)cnt = 5;
if(GetKeyState('6') < 0)cnt = 6;
if(GetKeyState('7') < 0)cnt = 7;
	if(checkDraw(cnt, m_pField->addEnergy(PLY_MY))){
		changePhase(PHASE_MAIN);
	}
}
//! CtFCY
void Phase::mainPhase(void)
{
	switch(m_state){
		//ڍs
		case PHASE_MAIN_FREE:
			mainFree();
			break;

		//PRGVtgΏۑI
		case PHASE_MAIN_SHIFT_PRG_SEL:
			if((m_pField->getSelect())){
				// J[hL
				m_card[1] = m_pField->getProgress(PLY_MY, m_pField->getSelect()->m_num);
				m_state = PHASE_MAIN_SHIFT_PRG_ENE;
			}
			// ENbN߂
			else if(m_pMouse->getInputR() == MOUSE_PUSH){
				m_state = PHASE_MAIN_FREE;
				m_canOpenDlg = true;
				m_pField->selLockAll(SELECT_NON);
			}
			break;
		//PRGVtgGiW[gp
		case PHASE_MAIN_SHIFT_PRG_ENE:
			m_pField->useEnergy(PLY_MY, m_pField->getShiftCost(m_card[1], m_card[0]));
			// I
			m_state = PHASE_MAIN_SHIFT_PRG_ON;
			break;
		//PRGVtg
		case PHASE_MAIN_SHIFT_PRG_ON:{
if(m_card[1])printf("%s fނ\n", m_card[1]->m_ci.name);
printf("%s Vtg܂\n", m_card[0]->m_ci.name);
			int shift=m_pField->getSelect()->m_num;
			m_pField->shiftProgress(PLY_MY, m_card[0]->m_num, shift);
			m_card[0]=m_pField->getProgress(PLY_MY, shift);
			// Vtg̋L
			m_pField->m_shiftPRG[PLY_MY][shift] = true;
			// oꎞʂΔ
			m_skillNum = m_pSkill->searchTinimg(m_card[0], SKILL_TIMING_PLAY_FIRST);
			if(m_skillNum != -1){
				m_state = PHASE_MAIN_PRG_INVOKE;
			}else{
				// I
				m_state = PHASE_MAIN_FREE;
				m_canOpenDlg = true;
				m_pField->selLockAll(SELECT_NON);
			}
			break;
		}
		//ACVtgGiW[gp
		case PHASE_MAIN_SHIFT_AC_ENE:
			m_card[1] = m_pField->getAction(PLY_MY);
			m_pField->useEnergy(PLY_MY, m_pField->getShiftCost(m_card[1], m_card[0]));
			// I
			m_state = PHASE_MAIN_SHIFT_AC_ON;
			break;
		//ACVtg
		case PHASE_MAIN_SHIFT_AC_ON:
printf("%s Vtg܂\n", m_card[0]->m_ci.name);
			m_pField->shiftAction(PLY_MY, m_card[0]->m_num);
			m_card[0]=m_pField->getAction(PLY_MY);
			// Vtg̋L
			m_pField->m_shiftAC[PLY_MY] = true;
			// oꎞʂΔ
			m_skillNum = m_pSkill->searchTinimg(m_card[0], SKILL_TIMING_ACTION_FIRST);
			if(m_skillNum != -1){
				m_state = PHASE_MAIN_AC_INVOKE;
			}else{
				// I
				m_state = PHASE_MAIN_FREE;
			}
			break;

		//PRG
		case PHASE_MAIN_PRG_INVOKE:
			if(m_pSkill->invoke(m_card[0], m_skillNum) == SKILL_RET_END){
				// I
				m_state = PHASE_MAIN_FREE;
			}
			break;

		//AC
		case PHASE_MAIN_AC_INVOKE:
			if(m_pSkill->invoke(m_card[0], m_skillNum) == SKILL_RET_END){
				// I
				m_state = PHASE_MAIN_FREE;
			}
			break;
	}
}
//! A^bNtFCY
void Phase::attackPhase(void)
{
	switch(m_state){
		//vOXI
		case PHASE_ATTACK_SELECT:{
			const DWORD retCode = m_pDialog->getResult();
			if(HIWORD(retCode) == DLG_ATTACK){
				if(LOWORD(retCode) == BTN_ID_ATTACK){
					m_state = PHASE_ATTACK_FALL;
					// J[hL
					m_card[0] = m_pField->getSelect();
					m_pDialog->close();
				}
			}
			break;
		}
		//tH[
		case PHASE_ATTACK_FALL:{
			Card* oppoPrg;
			oppoPrg = m_pField->attackProgress(PLY_MY, m_card[0]->m_num);
			// vOX邩
			if(oppoPrg){
				m_card[1] = oppoPrg;
				m_state = PHASE_ATTACK_GUARD_SEND;
			}
			else{
				m_state = PHASE_ATTACK_DAMAGE_TEMP;
			}
if(m_card[1])printf("%s \n", m_card[1]->m_ci.name);
printf("%s ōU܂\n", m_card[0]->m_ci.name);
			break;
		}
		//K[hڍs
		case PHASE_ATTACK_GUARD_SEND:
#if defined (_LOCAL_)
			if(changePlayer()){
				m_state = PHASE_ATTACK_GUARD;
				m_selectNum = m_pField->selLockValueExcept(PLY_MY, ZONE_HAND, CI_GUARD, 0, ">");
				m_pDialog->open(DLG_TEXT, DLG_PLACE_TOP, NULL, "K[hJ[hIĉ\nENbNŏI");
printf("vC[ւ܂(vC[𑀍삵Ă܂)\n");
			}
#elif defined (_NET_)
			m_isLink = true;
			m_state = PHASE_ATTACK_GUARD;
#endif
			break;

		//FK[h
		case PHASE_ATTACK_GUARD:
			if(m_pMouse->getInputR() == MOUSE_PUSH){
				int sel = m_pField->getSelectNum();
				for(int i = 0; i < sel; i++){
printf("p[+%d(%s)\n", m_pField->getSelect(sel-i-1)->m_ci.guard, m_pField->getSelect(sel-i-1)->m_ci.name);
						m_pField->guardProgress(PLY_MY, m_pField->getSelect(sel-i-1)->m_num, m_card[1]->m_num);
				}
				while(m_pField->getSelect()){
					// ڂŉE
					m_pField->dumpHand(PLY_MY, m_pField->getSelect(m_pField->getSelectNum()-1)->m_num);
				}
				m_pDialog->close();
				m_state = PHASE_ATTACK_GUARD_RECV;
				m_pField->selLockAll(SELECT_NON);
				m_selectNum = 1;
printf("vC[ɖ߂܂\n");
			}
			break;

		//vC[
		case PHASE_ATTACK_GUARD_RECV:
#if defined (_LOCAL_)
			if(changePlayer()){
				m_skillNum = m_pSkill->searchTinimg(m_card[0], SKILL_TIMING_LINK_FIRST);
				if(m_skillNum != -1){
					m_state = PHASE_ATTACK_ISLINK;
					m_pDialog->open(DLG_T_YESNO, DLG_PLACE_CENTER, m_card[0], "N܂H");
printf("N܂H\n");
				}else{
					m_state = PHASE_ATTACK_ISATTACK;
				}
			}
#endif
			break;

		//N邩
		case PHASE_ATTACK_ISLINK:{
			int ret = LOWORD(m_pDialog->getResult());
			if(ret == BTN_ID_YES){
				m_state = PHASE_ATTACK_LINK;
				m_pDialog->close();
			}else if(ret == BTN_ID_NO){
				m_state = PHASE_ATTACK_ISATTACK;
				m_pDialog->close();
			}
			break;
		}
		//N
		case PHASE_ATTACK_LINK:
			if(m_pSkill->invoke(m_card[0], m_skillNum) == SKILL_RET_END){
				m_state = PHASE_ATTACK_ISATTACK;
			}
			break;

		//Uʉߔ
		case PHASE_ATTACK_ISATTACK:
			if(m_pField->isSuccessAttack(PLY_MY, m_card[0]->m_num)){
printf("U܂(");
				m_state = PHASE_ATTACK_DAMAGE_TEMP;
			}
			else{
printf("Us܂(");
				m_state = PHASE_ATTACK_RESET;
			}
if(m_card[1])printf("%d vs %d)\n", m_card[0]->getSumPower(), m_card[1]->getSumPower());
			break;

		//_[WO
		case PHASE_ATTACK_DAMAGE_TEMP:
			if(m_card[0]->getSumStrike() > 0){
				if(checkDraw(m_card[0]->getSumStrike(), m_pField->addTemp(PLY_OPPO))){
					m_state = PHASE_ATTACK_DAMAGE;
				}
			}else{
printf("XgCN0Ȃ̂Ń_[W͂܂\n");
				m_state = PHASE_ATTACK_RESET;
			}
			break;
		//_[W
		case PHASE_ATTACK_DAMAGE:
			m_pField->giveDamage(PLY_OPPO, m_card[0]->getSumStrike());
			m_state = PHASE_ATTACK_RESET;
			break;
		//̃ogI
		case PHASE_ATTACK_RESET:
			for(int ply = 0; ply < PLY_NUM; ply++){
				for(int i = 0; i < PROGRESS_MAX; i++){
					Card* pCard = m_pField->getProgress(ply, i);
					if(!pCard) continue;
					for(IteTV ite = pCard->m_addPower.begin(); ite != pCard->m_addPower.end();){
						if(ite->turn == 0){
							ite = pCard->m_addPower.erase(ite);
							continue;
						}
						ite++;
					}
					for(IteTV ite = pCard->m_addStrike.begin(); ite != pCard->m_addStrike.end();){
						if(ite->turn == 0){
							ite = pCard->m_addStrike.erase(ite);
							continue;
						}
						ite++;
					}
				}
			}
			m_state = PHASE_ATTACK_SELECT;
			break;
	}
}
//! GhtFCY
void Phase::endPhase(void)
{
	switch(m_state){
		//\͒lZbg
		case PHASE_END_RESET:
#if defined(_LOCAL_)
			for(int ply = 0; ply < PLY_NUM; ply++){
#elif defined(_NET_)
			int ply = PLY_MY;
			{
#endif
				if(ply == PLY_MY){
					// tB[hZbg
					for(int i = 0; i < PROGRESS_MAX; i++){
						m_pField->m_shiftPRG[ply][i] = false;
						Card* pCard = m_pField->getProgress(ply, i);
						if(pCard){
							MEMARY(pCard->m_useSkill, 0);

							// u[Xgދp
							if(pCard->m_ci.boost){
printf("u[Xgʂɂ%sދp܂\n", pCard->m_ci.name);
								m_pField->dumpProgress(ply, i);
							}
						}
					}
					m_pField->m_shiftAC[ply] = false;

					// ANV̂Ă
					if(m_pField->getAction(ply)){
						m_pField->dumpAction(ply);
					}
				}

				// ZlZbg
				IteTV it;
				VecTV* pAdd;
				Card* pCard;
				for(int i = 0; i < PROGRESS_MAX; i++){
					pCard = m_pField->getProgress(ply, i);
					if(pCard){
						// p/s/l3
						for(int j = 0; j < 3; j++){
							switch(j){
								case 0:	pAdd = &pCard->m_addPower;	break;
								case 1:	pAdd = &pCard->m_addStrike;	break;
								case 2:	pAdd = &pCard->m_addLink;	break;
							}
						
							// vf̌
							for(it = pAdd->begin(); it != pAdd->end();){
								// ^[o
								if(it->turn != -1){
									it->turn--;
								}
								// ^[0ɂȂĂvf
								if(it->turn == 0){
									it = pAdd->erase(it);
									continue;
								}
								it++;
							}
						}
					}
				}
			}

			if(m_pField->getHandNum(PLY_MY) > 7){
				m_selectNum = m_pField->getHandNum(PLY_MY) - 7;
				m_state = PHASE_END_DUMP_HAND;
printf("D8ȏ゠܂ %d̂Ăĉ\n", m_selectNum);
printf("w薇IƎŎ̎Dɑ܂\n");
			}
			else{
				changePhase(PHASE_TURN);
			}
			break;
		//D
		case PHASE_END_DUMP_HAND:
			if(m_pField->getSelectNum() >= m_selectNum){
				for(int i = 0; i < m_selectNum; i++){
					m_pField->dumpHand(PLY_MY, m_pField->getSelect()->m_num);
				}
				changePhase(PHASE_TURN);
			}
			break;


	}

}
//! ^[ύXtFCY
void Phase::turnPhase(void)
{
//	m_turn = !m_turn;
//	m_phase = PHASE_OPPO;

#if defined (_LOCAL_)
	if(changePlayer()){
		m_phase = PHASE_AWAKE;
printf("^[Ił vC[ύX܂\n");
	}
#endif
}
//! ^[
void Phase::oppoPhase(void)
{
}

//! CFڍs
void Phase::mainFree(void)
{
	if(m_pMouse->getInputR() & MOUSE_PUSH){
		if(m_pField->getSelect()){
			m_pField->getSelect()->m_select = SELECT_NON;
			m_pDialog->close();
		}
	}

	if(m_pDialog->isExist()){
		DWORD retCode = m_pDialog->getResult();

		switch(HIWORD(retCode)){
			//DvOX
			case DLG_HAND_PROGRESS:
				switch(LOWORD(retCode)){
					//Vtg
					case BTN_ID_SHIFT:
						if(m_pField->getSelect()){
							// IJ[hL
							m_card[0] = m_pField->getSelect();

							// Vtg\fނ̃bN
							m_pField->selLockZoneExcept(PLY_MY, ZONE_PROGRESS);
							int cost;
							for(int i = 0; i < PROGRESS_MAX; i++){
								cost = m_pField->getAwakeEnergyNum(PLY_MY) - m_pField->getShiftCost(m_pField->getProgress(PLY_MY, i), m_card[0]);
								if(m_pField->m_shiftPRG[PLY_MY][i] || (cost < 0)){
									m_pField->selLockOnce(PLY_MY, ZONE_PROGRESS, i);
									m_pField->selLockPrgDmy(PLY_MY, SELECT_LOCK, i);
								}else{
									m_pField->selLockPrgDmy(PLY_MY, SELECT_NON, i);
								}
							}
							m_selectNum = 1;

							// I
							m_state = PHASE_MAIN_SHIFT_PRG_SEL;
							m_pDialog->close();
							m_canOpenDlg = false;
						}
						break;
					//
					case BTN_ID_INVOKE:
						m_pDialog->close();
						break;
				}
				break;
			//DANV
			case DLG_HAND_ACTION:
				switch(LOWORD(retCode)){
					//Vtg
					case BTN_ID_SHIFT:
						if(m_pField->getSelect()){
							// IJ[hL
							m_card[0] = m_pField->getSelect();

							// I
							m_state = PHASE_MAIN_SHIFT_AC_ENE;
							m_pDialog->close();
						}
						break;
				}
				break;

			//vOX
			case DLG_PROGRESS:
				switch(LOWORD(retCode)){
					//
					case BTN_ID_INVOKE:
						if(m_pField->getSelect()){
							for(int i = 0; i < SKILL_MAX; i++){
								// N
								if(m_pSkill->invoke(m_pField->getSelect(), i, SKILL_CODE_CHECK_TIMING) == SKILL_TIMING_STARTUP){
									// RXgx\
									if(m_pSkill->invoke(m_pField->getSelect(), i, SKILL_CODE_CHECK_COST)){
										// IJ[hL
										m_card[0] = m_pField->getSelect();
										m_skillNum = i;

										// I
										m_state = PHASE_MAIN_PRG_INVOKE;
										m_pDialog->close();
									}
								}
							}
						}
						break;
				}
				break;

			//ANV
			case DLG_ACTION:
				switch(LOWORD(retCode)){
					//
					case BTN_ID_INVOKE:
						if(m_pField->getSelect()){
							// IJ[hL
							m_card[0] = m_pField->getSelect();

							// I
							m_state = PHASE_MAIN_AC_INVOKE;
							m_pDialog->close();
						}
						break;
				}
				break;
		}
	}
}

//! h[
bool Phase::checkDraw(int num, bool isDraw)
{
	bool ret = false;
	bool isRemake = false;

	// Zbg
	if(m_drawNum == 0){
		m_drawNum = num;
		m_drawNow = 0;
	}

	// 
	if(isDraw){
		// ݒlAȊOł͕ύXȂ߃CN
		m_drawNow++;

		// 傤ǖȂꍇCN
		if(m_pField->getDeckNum(PLY_MY) == 0 || m_pField->getDeckNum(PLY_OPPO) == 0){
			isRemake = true;
		}

		// w薇ΏI
		if(m_drawNow >= m_drawNum){
			ret = true;
			// Zbg
			m_drawNum = 0;
			m_drawNow = 0;
		}
	}else{
		isRemake = true;
	}

	if(isRemake){
		m_pField->wait();
		m_isRemake = true;
		m_pDialog->close();
		m_canOpenDlg = true;
printf("fbLȂ܂ACN܂\nOt[J[h1Iŉ\n");
	}

	return(ret);
}

#if defined (_LOCAL_)
//! vC[ύX
bool Phase::changePlayer(void)
{
	bool bRet = false;

	if(m_cnt <= 100){
		// [J - vC[ւ
		if(m_cnt < 50){
			m_pCamera->m_look.z -= 0.1f;
			m_cnt++;
		}else if(m_cnt > 50){
			m_pCamera->m_look.z += 0.1f;
			m_cnt++;
		}else if(m_cnt == 50){
			// SJ[h̍Wւ
			Card* pCard;
			m_isChange = !m_isChange;
			m_my = !m_my;
			for(int ply = 0; ply < PLY_NUM; ply++){
				for(int i = 0; i < DECK_MAX; i++){
					pCard = m_pField->getCard(ply, i);
					if(pCard->m_zone == ZONE_HAND){
						pCard->m_reverse = (pCard->m_reverse == CARD_FRONT ? CARD_BACK : CARD_FRONT);
					}
					pCard->setPos(m_pField->getFieldPos(ply, pCard->m_zone, pCard->m_num, m_pField->getZoneNum(ply, pCard->m_zone)));
					pCard->setDegree(m_pField->getFieldDegree(ply, pCard->m_zone, pCard->m_num, pCard->m_awake == CARD_AWAKE, pCard->m_reverse == CARD_FRONT));
				}
				for(int i = 0; i < PROGRESS_MAX; i++){
					pCard = m_pField->getPrgDmy(ply, i);
					pCard->setPos(m_pField->getFieldPos(ply, pCard->m_zone, pCard->m_num));
					pCard->setDegree(m_pField->getFieldDegree(ply, pCard->m_zone, pCard->m_num, true, true));
				}
			}
		}
		m_cnt++;
	}
	else{
		m_cnt = 0;
		bRet = true;
if(m_isChange){
printf("vC[ύX܂A2P쒆ł\n");
}else{
printf("vC[ύX܂A1P쒆ł\n");
}
	}

	return(bRet);
}
#endif
