
/* _/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/

	FILE	: Phase.h

+ ------ Explanation of file --------------------------------------------------------------------------

	Aj̓sfill܂ȂƂȂ
	t[ŏĂ͂Ȃ

+ _/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/ */

#ifndef _Phase_H_
#define _Phase_H_

#include "Button.h"

class Scene;
class Mouse;
class Field;
class Skill;
class Dialog;
class Card;
class animeCalcClass;
class TextGraphic;

// tFCY
enum{
	PHASE_NON	= -2,	// 
	PHASE_INIT,			// 
	// m_btn[]pɂ0
	PHASE_AWAKE	= 0,	// AEFCN
	PHASE_DRAW,			// h[
	PHASE_ENERGY,		// GiW[
	PHASE_MAIN,			// C
	PHASE_ATTACK,		// A^bN
	PHASE_END,			// Gh
	PHASE_TURN,			// ^[I
	PHASE_OPPO,			// ^[

	PHASE_NUM	= 6,
};

// ڍ
enum{
	// 
	PHASE_INIT_ZERO,		// Lv0T[`
	PHASE_INIT_ZERO_PUT,	// Lv0Zbg
	PHASE_INIT_SHUFFLE,		// fbLVbt
	PHASE_INIT_JANKEN,		// 񂯂
	PHASE_INIT_DRAW,		// h[
	PHASE_INIT_HAND,		// D
	PHASE_INIT_ENERGY,		// GiW[Zbg
	PHASE_INIT_OPEN,		// Lv0\
	// C
	PHASE_MAIN_FREE,			// ڍs
	PHASE_MAIN_SHIFT_PRG_SEL,	// PRGVtgΏۑI
	PHASE_MAIN_SHIFT_PRG_ENE,	// PRGVtgGiW[gp
	PHASE_MAIN_SHIFT_PRG_ON,	// PRGVtg
	PHASE_MAIN_SHIFT_AC_ENE,	// ACVtgGiW[gp
	PHASE_MAIN_SHIFT_AC_ON,		// ACVtg
	PHASE_MAIN_PRG_INVOKE,		// PRG
	PHASE_MAIN_AC_INVOKE,		// AC
	// A^bN
	PHASE_ATTACK_SELECT,		// ڍs
	PHASE_ATTACK_FALL,			// tH[
	PHASE_ATTACK_GUARD_SEND,	// K[hڍs
	PHASE_ATTACK_GUARD,			// K[h
	PHASE_ATTACK_GUARD_RECV,	// K[hI
	PHASE_ATTACK_ISLINK,		// N邩
	PHASE_ATTACK_LINK,			// N
	PHASE_ATTACK_ISATTACK,		// Uʉߔ
	PHASE_ATTACK_DAMAGE_TEMP,	// _[WO
	PHASE_ATTACK_DAMAGE,		// _[W
	PHASE_ATTACK_RESET,			// ̃ogI
	// Gh
	PHASE_END_RESET,			// \͒lZbg
	PHASE_END_DUMP_HAND,		// D
};

#define PLY_MY			(phase.m_my)		// 
#define PLY_OPPO		(!phase.m_my)		// 

#define PHASE_CARD_MAX	10

enum DISPTEXT{
	DISPTEXT_PRG1,			// vOXp[
	DISPTEXT_PRG2,
	DISPTEXT_PRG3,
	DISPTEXT_PRG4,
	DISPTEXT_DECK,			// fbL
	DISPTEXT_DISCARD,		// ̎D
	DISPTEXT_DISCARD_FRAME,	// ̎Dt[
	DISPTEXT_DISCARD_ALL,	// ̎D0t[
	DISPTEXT_EXCUDE,		// O

	DISPTEXT_MAX,
};

class Phase
{
	private:
		Scene*	m_pCamera;				// J
		Mouse*	m_pMouse;				// }EX
		Field*	m_pField;				// tB[h
		Skill*	m_pSkill;				// XL
		Dialog*	m_pDialog;				// _CAO

		TextGraphic*	m_pDispText[PLY_NUM][DISPTEXT_MAX];	// KCh\eLXg

	private:
		void	release(void);			// 

public:
		Phase();
		~Phase();

		int		m_my;					// ΏۃvC[
		int		m_turn;					// ݂̃^[
		int		m_phase;				// ݂̃tFCY
		int		m_state;				// ݉Ă邩
		int		m_selectNum;			// I𐔏
		bool	m_canOpenDlg;			// _CAO\tO
		Card*	m_card[PHASE_CARD_MAX];	// ėpJ[h|C^
		Button	m_btn[PHASE_NUM];		// tFCYڍs{^
		bool	m_isLink;				// N邩
		int		m_linkNum;				// N
		int		m_drawNum;				// h[
		int		m_drawNow;				// 
		int		m_skillNum;				// ʔΏ۔ԍ
		bool	m_isRemake;				// CN

		void init(Field* pField, Skill* pSkill, Dialog* pDlg);	// 
		void update(void);	// XV
		void draw(void);	// `

		void updateGuide	(void);		// KChXV
		void updateRemake	(void);		// CNXV
		void updatePhase	(void);		// tFCYXV
		void updateList		(void);		// XgXV

		void changePhase	(int phase);// tFCYύX

		void initPhase	(void);	// 
		void awakePhase	(void);	// AEFCNtFCY
		void drawPhase	(void);	// h[tFCY
		void energyPhase(void);	// GiW[tFCY
		void mainPhase	(void);	// CtFCY
		void attackPhase(void);	// A^bNtFCY
		void endPhase	(void);	// GhtFCY
		void turnPhase	(void);	// ^[ύX
		void oppoPhase	(void);	// ^[

		void mainFree	(void);	// CFڍs

		inline void deleteCard	(void){ for(int i = 0; i < PHASE_CARD_MAX; i++){ m_card[i] = NULL; } }

		bool checkDraw(int num, bool isDraw);	// h[

#if defined (_LOCAL_)
		int  m_cnt;
		bool m_isChange;			// vC[tɂȂĂ邩
		bool changePlayer(void);	// SJ[h̍Wւ
#endif
};

extern Phase phase;

#endif /* _Phase_H_ */