
/* _/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/

	FILE	: Renderer.h

+ ------ Explanation of file --------------------------------------------------------------------------

	`摍܂Ƃ

+ _/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/ */

#ifndef _Renderer_h_
#define _Renderer_h_

#include "Clipping.h"
class WindowManager;
class Scene;

#define NEAR_CLIP	0.1f
#define FAR_CLIP	1000.0f

enum TextureName
{
	eTexBlock,
	eTexCard,
	eTexGround,
	eTexCloud,
};

// _[NX
class Renderer
{
	private:
		WindowManager*			m_pWinMan;		// EBhEǗ
		Scene*					m_pCamera;		// J

    public:
		LPDIRECT3D9				m_pD3D;			// IDirect3D9C^[tFCXւ̃|C^
	    LPDIRECT3DDEVICE9		m_pD3DDevice;	// IDirect3DDevice9C^[tFCXւ̃|C^
	    D3DPRESENT_PARAMETERS	m_D3DPP;		// foCX̃v[e[Vp[^
		int						m_dispHeight;	// fBXvC
		D3DXMATRIX				m_proj;			// ˉes
		D3DXMATRIX				m_view;			// r[s

		Clipping				m_clip;			// NbsO@\A`@\o

	    Renderer();
	    ~Renderer();

		void	init(bool isFullScr = false);
	    void	release(void);

		void	drawStart(void);	// `Jn
		void	drawEnd(void);		// `I
		void	set3D(void);		// 2Dݒ
		void	set2D(void);		// 3Dݒ

		VEC3	conv3Dto2D(VEC3 pos);	// [hWtoXN[W

	private:
		WindowManager*	getWinMan(void){ return(m_pWinMan); }
		Scene*	getCamera(void){ return(m_pCamera); }
};

extern Renderer renderer;


#endif //_Renderer_h_


