/* _/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/

	FILE	: Scene.cpp

+ ------ Explanation of file --------------------------------------------------------------------------

+ _/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/ */

#include "Common.h"

#include "Scene.h"

// RXgN^
Scene::Scene()
{
}

// fXgN^
Scene::~Scene()
{
}

// 
void Scene::create(void)
{
	m_eye.x = 0.0f;
	m_eye.y = 6.2f;
	m_eye.z = -5.2f;
	m_look.x = m_eye.x;
	m_look.y = -2.0f;
	m_look.z = 0.5f;
	m_up.x = 0.0f;
	m_up.y = 1.0f;
	m_up.z = 0.0f;
	m_lookDegX = -90.0f;
	m_lookDegY = 35.0f;
	m_cameraMode = eCameraFix;
}

void Scene::update(void)
{
	Camera();
}
void Scene::Camera()
{
	// J[hύX
	if(GetAsyncKeyState('R'))
		m_cameraMode = eCameraFree;
	if(GetAsyncKeyState('T'))
		m_cameraMode = eCameraTPS;
	if(GetAsyncKeyState('Y'))
		m_cameraMode = eCameraFPS;

	// Jړ
//	switch(m_cameraMode)
	switch(-1)
	{
		case eCameraFree:
			FreeCamera();
			break;

		case eCameraTPS:
			TPSCamera();
			break;

		case eCameraFPS:
			FPSCamera();
			break;
	}
}
void Scene::RotateCamera()
{
	if(GetAsyncKeyState(VK_SHIFT))
	{
		if(GetAsyncKeyState(VK_LEFT))
			m_lookDegX += 2.5f;
		if(GetAsyncKeyState(VK_RIGHT))
			m_lookDegX -= 2.5f;

		if(GetAsyncKeyState(VK_UP))
		{
			if((m_lookDegY < 90))
				m_lookDegY -= 2.5f;
			else
				m_lookDegY += 2.5f;
		}
		if(GetAsyncKeyState(VK_DOWN))
		{
			if((m_lookDegY < 90))
				m_lookDegY += 2.5f;
			else
				m_lookDegY -= 2.5f;
		}
	}
}
// JF3l̎_
void Scene::TPSCamera()
{
}
// JF1l̎_
void Scene::FPSCamera()
{
}
// JFRړ
void Scene::FreeCamera()
{
	float c;

	// J̌ύX
	RotateCamera();

	if(GetAsyncKeyState(VK_SHIFT))
	{
		// J{̈ړ
		if(GetAsyncKeyState('A'))
			MoveCamera(eLeft);
		if(GetAsyncKeyState('D'))
			MoveCamera(eRight);
		if(GetAsyncKeyState('W'))
			MoveCamera(eFront);
		if(GetAsyncKeyState('S'))
			MoveCamera(eBack);

		// ㉺ړ
		if(GetAsyncKeyState('Q'))
		{
			m_eye.y += 0.05f;
			m_look.y += 0.05f;
		}
		if(GetAsyncKeyState('E'))
		{
			m_eye.y -= 0.05f;
			m_look.y -= 0.05f;
		}
	}
	m_look.y = (float)(sin(m_lookDegY * 3.1415 / 180) * 10.0f * -1.0f + m_eye.y);
	c		 = (float)(cos(m_lookDegY * 3.1415 / 180) * 10.0f * -1.0f);
	m_look.x = (float)(c * cos(m_lookDegX * 3.1415 / 180) + m_eye.x);
	m_look.z = (float)(c * sin(m_lookDegX * 3.1415 / 180) + m_eye.z);
}
// JFsړ
void Scene::MoveCamera(int dir)
{
	float x, z;
	float c, m;
	float degree;

	// ړOɌ悤ɒ_ppxύX
	if(dir == eFront)
		degree =m_lookDegX;
	if(dir == eBack)
		degree =m_lookDegX + 180.0f;
	if(dir == eLeft)
		degree =m_lookDegX + 90.0f;
	if(dir == eRight)
		degree =m_lookDegX - 90.0f;

	// ēx_vZ
	x = (float)(cos(degree * 3.1415 / 180) * 5 * -1);
	z = (float)(sin(degree * 3.1415 / 180) * 5 * -1);

	c = sqrt((x * x) + (z * z));	// Εӂ̒(ړ)
	m = 0.05f / c;						// ړʂۂ̈ړʂɍ킹{vZ

	x *= m;
	z *= m;

	m_eye.x += x;
	m_eye.z += z;
	m_look.x += x;
	m_look.z += z;
}



