/* _/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/

	FILE	: Skill.cpp

+ ------ Explanation of file --------------------------------------------------------------------------

	ADS̓eLXg͂ŔɌʃXNvggނ炵
	AW͌ʕŒ肾łȂƂȂ

+ _/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/ */

#include "Common.h"

#include "CardData.h"
#include "Phase.h"
#include "Field.h"
#include "Mouse.h"
#include "Dialog.h"

#include "Skill.h"

// ֐&֐Xg
SKILL_NAME gSkillName[] = {
	// SkillTiming
	{"stLinkStepStart",		&Skill::stLinkStepStart},
	{"stPlayActionZone",	&Skill::stPlayActionZone},
	{"stPlay",				&Skill::stPlay},
	{"stAlways",			&Skill::stAlways},
	{"stStartup",			&Skill::stStartup},
	// SkillCost
	{"scFall",				&Skill::scFall},
	{"scFallNum",			&Skill::scFallNum},
	{"scDumpHand",			&Skill::scDumpHand},
	// SkillIf
	{"siLink",				&Skill::siLink},
	{"siColorNum",			&Skill::siColorNum},
	{"siUseNum",			&Skill::siUseNum},
	{"siEnergyFallAll",		&Skill::siEnergyFallAll},
	// SkillEffect
	// B1
	{"seDraw",				&Skill::seDraw},
	{"seShuffle",			&Skill::seShuffle},
	{"seAwake",				&Skill::seAwake},
	{"seAwakeEnergy",		&Skill::seAwakeEnergy},
	{"seDamage",			&Skill::seDamage},
	{"seDumpHand",			&Skill::seDumpHand},
	{"seDumpHandOp",		&Skill::seDumpHandOp},
	{"seDumpDeck",			&Skill::seDumpDeck},
	{"seDumpDamage",		&Skill::seDumpDamage},
	{"seSearchDeckPrg",		&Skill::seSearchDeckPrg},
	{"seSearchDisCardPrg",	&Skill::seSearchDisCardPrg},
	{"seAddEnergy",			&Skill::seAddEnergy},
	{"sePutDisCardPrg",		&Skill::sePutDisCardPrg},
	{"sePowerUp",			&Skill::sePowerUp},
	{"sePowerUpAll",		&Skill::sePowerUpAll},
	{"sePowerUpNum",		&Skill::sePowerUpNum},
	{"sePowerUpHand",		&Skill::sePowerUpHand},
	{"sePowerUpEnergy",		&Skill::sePowerUpEnergy},
	{"seStrikeUp",			&Skill::seStrikeUp},
	{"seBouncePrg",			&Skill::seBouncePrg},
	{"seBouncePrgDeck",		&Skill::seBouncePrgDeck},
	{"seRemovePrg",			&Skill::seRemovePrg},
	{"seChangeHandDamage",	&Skill::seChangeHandDamage},
	{"seDamageFront",		&Skill::seDamageFront},
	{"seDeckTopMoveTorD",	&Skill::seDeckTopMoveTorD},
};

#define ARGINT(n, d)	((n) < (*m_pFuncList)[m_state]->argInt.size() ? (*m_pFuncList)[m_state]->argInt[(n)] : (d))
#define ARGSTR(n, d)	((n) < (*m_pFuncList)[m_state]->argStr.size() ? (*m_pFuncList)[m_state]->argStr[(n)].c_str() : (d))
#define COSTERROR		{printf("RXgx܂\n"); return(SKILL_RET_END);}

Skill::Skill()
{
	m_state = 0;
	m_sState = 0;
	m_skillNum = -1;
	m_pFuncList = NULL;
}

Skill::~Skill()
{
	release();
}

void Skill::init(Phase* pPhase, Field* pField, Dialog* pDlg)
{
	m_pPhase = pPhase;
	m_pField = pField;
	m_pDialog = pDlg;

	readBinary();
}

//! 
int Skill::invoke(Card* card, int skillNo, int code)
{
	m_ret = -1;
	// XĽ
	if(m_skillNum == -1){
		if(searchSkill(card, skillNo)){
			// 
			m_state = 0;
			m_sState = 0;
			m_linkNum = 0;
			m_invokeNum = 0;
			m_pPhase->m_canOpenDlg = false;
if(code==SKILL_CODE_INVOKE)printf("ʔ܂\n");
		}
	}

	if(m_skillNum != -1){
		// ֐XgZbg
		if(!m_pFuncList){
			switch(code){
				case SKILL_CODE_INVOKE:
					m_pFuncList = &m_scriptList[m_skillNum]->skill;
					break;
				case SKILL_CODE_CHECK_TIMING:
					m_pFuncList = &m_scriptList[m_skillNum]->chkTmg;
					break;
				case SKILL_CODE_CHECK_COST:
					m_pFuncList = &m_scriptList[m_skillNum]->chkCst;
					break;
			}
		}

		// eJ[ȟʂĂ
		if(!m_pFuncList->empty()){
			m_ret = (this->*gSkillName[(*m_pFuncList)[m_state]->fncNum].func)();
		}else{
			switch(code){
				case SKILL_CODE_INVOKE:			m_ret = SKILL_RET_END;	break;
				case SKILL_CODE_CHECK_TIMING:	m_ret = FALSE;			break;
				case SKILL_CODE_CHECK_COST:		m_ret = TRUE;			break;
			}
		}
		// `FbN̏ꍇ͂̂܂܃Zbg
		if(code == SKILL_CODE_CHECK_COST || code == SKILL_CODE_CHECK_TIMING){
			m_skillNum = -1;
			m_pPhase->m_canOpenDlg = true;
			m_pFuncList = NULL;
		}else if(m_ret == SKILL_RET_END){
			m_invokeNum++;
			if(m_pFuncList && m_state >= (int)m_pFuncList->size() && m_invokeNum < m_linkNum){
				// 񐔂cĂ̂ŏčēx
				m_state = 0;
				m_sState = 0;
				m_card[0]->m_useSkill[skillNo]++;
				m_ret = SKILL_RET_INVOKE;
			}else{
printf("[]I܂\n");
				clear(code, skillNo);
			}
		}
	}

	return(m_ret);
}
//! XL
bool Skill::searchSkill(Card* card, int skillNo)
{
	bool bRet = false;

	const char*	serStr = SNtSS(HIWORD(card->m_ci.cardNo));
	int			serNum = LOWORD(card->m_ci.cardNo);

	// vXNvg
	for(iteScript ite = m_scriptList.begin(); ite != m_scriptList.end(); ite++){
		if(	(strcmp((*ite)->serStr.c_str(), serStr) == 0) &&
			(serNum == (*ite)->serNum) && (skillNo == (*ite)->sklNum))
		{
			int num = distance(m_scriptList.begin(), ite);
			if(m_scriptList[num]->skill.size() > 0){
				// ΏۃJ[hL
				m_card[0] = card;
				m_skillNum = num;
				bRet = true;
				break;
			}
		}
	}

	return(bRet);
}
//! ^C~OvXL
int Skill::searchTinimg(Card* card, int timing)
{
	int iRet = -1;
	
	for(int i = 0; i < SKILL_MAX; i++){
		if(invoke(card, i, SKILL_CODE_CHECK_TIMING) == timing){
			iRet = i;
			break;
		}
	}

	return(iRet);
}

//! 
void Skill::release(void)
{
	for(iteScript iScr = m_scriptList.begin(); iScr != m_scriptList.end(); iScr++){
		vecFunc* vFunc[SKILLTYPE_MAX] = {&(*iScr)->chkTmg, &(*iScr)->chkCst, &(*iScr)->skill};
		for(int i = 0; i < SKILLTYPE_MAX; i++){
			for(iteFunc iFnc = vFunc[i]->begin(); iFnc != vFunc[i]->end(); iFnc++){
				delete(*iFnc);
			}
			vFunc[i]->clear();
		}
		delete(*iScr);
	}
}

//! oCiǂݍ
void Skill::readBinary(void)
{
#define READNUM(num)		{memcpy_s(&num, sizeof(int), &scriptData[index], sizeof(int)); index += sizeof(int);}
#define READSTR(str)		{str = &scriptData[index]; index += strlen(&scriptData[index])+1;}
#define PUSHNUM(vNum)		{int n; READNUM(n); vNum.push_back(n);}
#define PUSHSTR(vStr)		{char* c; READSTR(c); vStr.push_back(c);}

	FILE*			fp;
	SCRIPT_DATA*	pScript;
	FUNC_DATA*		pFunc;
	char*			scriptData;
	int				fileStart;
	int				fileSize;
	int				index = 0;
	int				scriptNum;
	int				funcNum;
	int				argNum;

	fopen_s(&fp, "Data\\CardScript.dat", "rb");
	if(!fp){
		printf("error:CardScript.dat݂܂\n");
		return;
	}

	// TCY擾
	fileStart = fseek(fp, 0, SEEK_END);
	fileSize = ftell(fp);
	fseek(fp, fileStart, SEEK_SET);

	// obt@ɓǂݍ
	scriptData = (char*)malloc(fileSize);
	fread_s(scriptData, fileSize, fileSize, 1, fp);
	fclose(fp);

	// obt@番
	READNUM(scriptNum);		// XNvg
	for(int scr = 0; scr < scriptNum; scr++){
		m_scriptList.push_back(new SCRIPT_DATA());
		pScript = m_scriptList.back();

		READSTR(pScript->serStr);	// V[Y
		READNUM(pScript->serNum);	// V[Yԍ
		READNUM(pScript->sklNum);	// XLԍ

		// ^C~O, RXg, ʊ֐
		vecFunc* vFunc[SKILLTYPE_MAX] = {&pScript->chkTmg, &pScript->chkCst, &pScript->skill};
		for(int fnc = 0; fnc < SKILLTYPE_MAX; fnc++){
			READNUM(funcNum);	// e퐔

			for(int i = 0; i < funcNum; i++){
				vFunc[fnc]->push_back(new FUNC_DATA());
				pFunc = vFunc[fnc]->back();

				READSTR(pFunc->name);		// ֐

//				READNUM(argNum);			// ^Cv
//				for(int j = 0; j < argNum; j++){
//					PUSHNUM(pFunc->argTyp);	// ^Cv
//				}

				READNUM(argNum);			// l
				for(int j = 0; j < argNum; j++){
					PUSHNUM(pFunc->argInt);	// l
				}

				READNUM(argNum);			// 
				for(int j = 0; j < argNum; j++){
					PUSHSTR(pFunc->argStr);	// 
				}

				// ֐to֐ԍ
				int size = SIZEARY(gSkillName);
				for(int j = 0; j < size; j++){
					if(strcmp(pFunc->name.c_str(), gSkillName[j].name)==0){
						pFunc->fncNum = j;
						break;
					}
				}
			}
		}
	}

	free(scriptData);
#undef READNUM
#undef READSTR
#undef PUSHNUM
#undef PUSHSTR
}

//! ʏI
void Skill::clear(int code, int skillNo)
{
	m_pField->selLockAll(SELECT_NON);

	// gp񐔉Z
	m_card[0]->m_useSkill[skillNo-1]++;

	// J[h
	for(int i = 0; i < 10; i++){
		m_card[i] = NULL;
	}
	m_state = 0;
	m_sState = 0;
	m_skillNum = -1;
	m_pFuncList = NULL;
	m_pPhase->m_canOpenDlg = true;
	m_pPhase->m_selectNum = 1;
}

//! Xe[g
void Skill::nextState(int state)
{
	m_pDialog->close();
	m_state += state;
	m_sState = 0;
	// ʂcĂȂΏI
	if(m_state >= (int)m_pFuncList->size()){
		m_ret = SKILL_RET_END;
	}
}

//! --- SkillTiming ---
//! NXebvJn
int Skill::stLinkStepStart(void)
{
	return(SKILL_TIMING_LINK_FIRST);
}
//! ANV][ɒuꂽ
int Skill::stPlayActionZone(void)
{
	return(SKILL_TIMING_ACTION_FIRST);
}
//! oꂵ
int Skill::stPlay(void)
{
	return(SKILL_TIMING_PLAY_FIRST);
}
//! ݌
int Skill::stAlways(void)
{
	return(SKILL_TIMING_ALWAYS);
}
//! N
int Skill::stStartup(void)
{
	return(SKILL_TIMING_STARTUP);
}

//! --- SkillCost ---
//! gtH[
int Skill::scFall(void)
{
	int isMust	= ARGINT(0, -1);	// K
	int	isCheck	= ARGINT(1, -1);	// RXg`FbN

	if(isCheck){
		return(!isMust || m_card[0]->m_awake != CARD_FALL);
	}

	switch(m_sState){
		case 0:
			if(isMust){
				m_sState = 2;
			}else{
				m_pPhase->m_canOpenDlg = true;
				m_pDialog->open(DLG_T_YESNO, DLG_PLACE_CENTER, NULL, "RXg𕥂܂H");
				m_pPhase->m_canOpenDlg = false;
				m_sState++;
			}
			break;
		case 1:
			if(LOWORD(m_pDialog->getResult()) == BTN_ID_YES){
				m_pDialog->close();
				m_sState++;
			}else if(LOWORD(m_pDialog->getResult()) == BTN_ID_NO){
				m_pDialog->close();
				nextState(99);
			}
			break;
		case 2:
			if(m_card[0]->m_awake != CARD_FALL){
				m_pField->fallProgress(PLY_MY, m_card[0]->m_num);
				nextState();
printf("[RXg]%stH[܂\n", m_card[0]->m_ci.name);
			}else{
				COSTERROR;
			}
			break;
	}
	
	return(m_ret);
}
//! ntH[
int Skill::scFallNum(void)
{
	int	num		= ARGINT(0, -1);	// tH[
	int	isMy	= ARGINT(1, -1);	// gΏۂ
	int isMust	= ARGINT(2, -1);	// K
	int	isCheck	= ARGINT(3, -1);	// RXg`FbN

	// Ώۃ`FbN
	int my = 0;
	if(isMy && m_card[0]->m_ci.type == TYPE_PG){
		if(m_card[0]->m_awake != CARD_AWAKE){
			my = 1;
		}
	}

	// RXg`FbN
	if(isCheck){
		return(!isMust || m_pField->getValueNum(PLY_MY, ZONE_PROGRESS, CD_AWAKE, CARD_AWAKE) - my >= num);
	}

	switch(m_sState){
		case 0:
			if(isMust){
				m_sState = 2;
			}else{
				m_pPhase->m_canOpenDlg = true;
				m_pDialog->open(DLG_T_YESNO, DLG_PLACE_CENTER, NULL, "RXg𕥂܂H");
				m_pPhase->m_canOpenDlg = false;
				m_sState++;
			}
			break;
		case 1:
			if(LOWORD(m_pDialog->getResult()) == BTN_ID_YES){
				m_pDialog->close();
				m_sState++;
			}else if(LOWORD(m_pDialog->getResult()) == BTN_ID_NO){
				m_pDialog->close();
				nextState(99);
			}
			break;
		case 2:
			if(m_pField->getValueNum(PLY_MY, ZONE_PROGRESS, CD_AWAKE, CARD_AWAKE) - my < num){
				COSTERROR;
			}else{
				m_pField->selLockValueExcept(PLY_MY, ZONE_PROGRESS, CD_AWAKE, CARD_AWAKE);
				if(!isMy && m_card[0]->m_ci.type == TYPE_PG){
					m_pField->selLockOnce(PLY_MY, ZONE_PROGRESS, m_card[0]->m_num);
				}
				m_pPhase->m_selectNum = num;
				m_sState++;

				m_pPhase->m_canOpenDlg = true;
				char text[256] = {};
				wsprintf(text, "[RXg]tH[vOX\n%dIĉ", num);
				m_pDialog->open(DLG_TEXT, DLG_PLACE_SEEMY, NULL, text);
				m_pPhase->m_canOpenDlg = false;
			}
			break;
		case 3:
			if(m_pField->getSelectNum() == num){
				for(int i = 0; i < num; i++){
					m_pField->fallProgress(PLY_MY, m_pField->getSelect(i)->m_num);
printf("[RXg]%stH[܂\n", m_pField->getSelect(i)->m_ci.name);
				}
				nextState();
			}
			break;
	}

	return(m_ret);
}
//! D̂Ă
int Skill::scDumpHand(void)
{
	int	num		= ARGINT(0, -1);	// ̂Ă閇
	int isMust	= ARGINT(1, -1);	// K
	int	isCheck	= ARGINT(2, -1);	// RXg`FbN

	if(isCheck){
		return(!isMust || m_pField->getHandNum(PLY_MY) >= num);
	}

	switch(m_sState){
		case 0:
			if(isMust){
				m_sState = 2;
			}else{
				m_pPhase->m_canOpenDlg = true;
				m_pDialog->open(DLG_T_YESNO, DLG_PLACE_CENTER, NULL, "RXg𕥂܂H");
				m_pPhase->m_canOpenDlg = false;
				m_sState++;
			}
			break;
		case 1:
			if(LOWORD(m_pDialog->getResult()) == BTN_ID_YES){
				m_pDialog->close();
				m_sState++;
			}else if(LOWORD(m_pDialog->getResult()) == BTN_ID_NO){
				m_pDialog->close();
				nextState(99);
			}
			break;
		case 2:{
			if(m_pField->getHandNum(PLY_MY) < num){
				COSTERROR;
			}
			m_pField->selLockZoneExcept(PLY_MY, ZONE_HAND);
			m_pPhase->m_selectNum = num;
			m_sState++;

			m_pPhase->m_canOpenDlg = true;
			char text[256] = {};
			wsprintf(text, "[RXg]̂ĂD%dIĉ", num);
			m_pDialog->open(DLG_TEXT, DLG_PLACE_CENTER, NULL, text);
			m_pPhase->m_canOpenDlg = false;
			break;
		}
		case 3:
			if(m_pField->getSelectNum() == num){
				while(m_pField->getSelectNum() > 0){
printf("[RXg]%s̎Dɒu܂\n", m_pField->getSelect()->m_ci.name);
					m_pField->dumpHand(PLY_MY, m_pField->getSelect()->m_num);
				}
				nextState();
			}
			break;
	}

	return(m_ret);
}

//! --- SkillIf ---
//! N
int Skill::siLink(void)
{
	enum {
		REST_ANY,	REST_SGM,	REST_OMG,	// N܂ł̎ct[
		TEMP_ALL,	TEMP_SGM,	TEMP_OMG,	// ̎ct[
		DAM_REV,							// _[Wo[XtO
	};
	int	link	= ARGINT(0, -1);	// N
	int	any		= ARGINT(1, -1);	// CӃACR
	int	sigma	= ARGINT(2, -1);	// VO}
	int	omega	= ARGINT(3, -1);	// IK
	int next	= ARGINT(4, 99);	// XLbv

	// temp[0~2] : e탊NvZc萔
	// temp[3~5] : t[
	// temp[6]	 : _[Wo[X

	switch(m_sState){
		// h[
		case 0:
			// 񃊃N
			if(m_linkNum > 0){
				nextState();
			}else{
if(m_pField->getDeckNum(PLY_MY)>0){
switch(m_pField->getDeck(PLY_MY, m_pField->getDeckNum(PLY_MY)-1)->m_ci.frame){
case FRAME_NON:  printf("t[F   ");break;
case FRAME_SIGMA:printf("t[F ");break;
case FRAME_OMEGA:printf("t[F ");break;
case FRAME_ALL:  printf("t[F ");break;
}printf("(%s)\n", m_pField->getDeck(PLY_MY, m_pField->getDeckNum(PLY_MY)-1)->m_ci.name);
}
				if(m_pPhase->checkDraw(link + m_card[0]->getAddLink(), m_pField->addTemp(PLY_MY))){
					m_pField->wait();
					m_temp[DAM_REV] = 0;
					m_sState++;
				}
			}
			break;

		// NvZ
		case 1:
			m_linkNum = 0;
			ZeroMemory(m_temp, sizeof(int)*(TEMP_OMG+1));
			// ̃t[
			for(int i = 0; i < m_pField->getTempNum(PLY_MY); i++){
				switch(m_pField->getTemp(PLY_MY, i)->m_ci.frame){
					case FRAME_SIGMA:	m_temp[TEMP_SGM]++;		break;
					case FRAME_OMEGA:	m_temp[TEMP_OMG]++;		break;
					case FRAME_ALL	:	m_temp[TEMP_ALL] += 2;	break;	// ͂2ɂȂ
				}
			}
			// _[Wo[X̓I[ƂĈ
			m_temp[TEMP_ALL] += m_temp[DAM_REV];

			while(1){
				// tempɕۑ
				m_temp[REST_ANY] = any;
				m_temp[REST_SGM] = sigma;
				m_temp[REST_OMG] = omega;

				// ƃ̔
				while(1){
					if((m_temp[TEMP_SGM] > 0) && (m_temp[REST_SGM] > 0)){
						m_temp[TEMP_SGM]--;
						m_temp[REST_SGM]--;
					}else if((m_temp[TEMP_OMG] > 0) && (m_temp[REST_OMG] > 0)){
						m_temp[TEMP_OMG]--;
						m_temp[REST_OMG]--;
					}else{
						break;
					}
				}

				// ANY̔
				int nextLinkReq[FRAME_NUM] = {any, sigma, omega};	// ɕKvȃNv
				int restLinkReq[FRAME_NUM];							// _ŎcĂ郊Nv

				memcpy_s(restLinkReq, sizeof(restLinkReq), &m_temp[TEMP_ALL], sizeof(restLinkReq));

				// ɕKvȕی삷
				while(1){
					if((restLinkReq[REST_SGM] > 0) && (nextLinkReq[REST_SGM] > 0)){
						restLinkReq[REST_SGM]--;
						nextLinkReq[REST_SGM]--;
					}else if((restLinkReq[REST_OMG] > 0) && (nextLinkReq[REST_OMG] > 0)){
						restLinkReq[REST_OMG]--;
						nextLinkReq[REST_OMG]--;
					}else{
						break;
					}
				}

				while(1){
					// یΏۊOgpANY𔻒
					if((restLinkReq[REST_SGM] > 0) && (m_temp[REST_ANY] > 0)){
						restLinkReq[REST_SGM]--;
						m_temp[TEMP_SGM]--;
						m_temp[REST_ANY]--;
					}else if((restLinkReq[REST_OMG] > 0) && (m_temp[REST_ANY] > 0)){
						restLinkReq[REST_OMG]--;
						m_temp[TEMP_OMG]--;
						m_temp[REST_ANY]--;
					}else{
						// یΏۊÔ݂ŏIł
						if(m_temp[REST_ANY] <= 0){
							break;
						}else{
							// łȂ̂ŕی֌WANY𔻒
							if(m_temp[TEMP_SGM] > 0){
								m_temp[TEMP_SGM]--;
								m_temp[REST_ANY]--;
							}else if(m_temp[TEMP_OMG] > 0){
								m_temp[TEMP_SGM]--;
								m_temp[REST_ANY]--;
							}else{
								break;
							}
						}
					}
				}

				// ͂̔
				while(1){
					if(m_temp[TEMP_ALL] > 0){
						if(m_temp[REST_SGM] > 0){
							m_temp[TEMP_ALL]--;
							m_temp[REST_SGM]--;
						}else if(m_temp[REST_OMG] > 0){
							m_temp[TEMP_ALL]--;
							m_temp[REST_OMG]--;
						}else if(m_temp[REST_ANY] > 0){
							m_temp[TEMP_ALL]--;
							m_temp[REST_ANY]--;
						}else{
							break;
						}
					}else{
						break;
					}
				}

				// N
				if((m_temp[REST_SGM] <= 0) && (m_temp[REST_OMG] <= 0) && (m_temp[REST_ANY] <= 0)){
					m_linkNum++;

					// t[ȂȂĂΏI
					if((m_temp[TEMP_ALL] <= 0) && (m_temp[TEMP_SGM] <= 0) && (m_temp[TEMP_OMG] <= 0)){
						m_sState++;
						break;
					}
				}else{
					m_sState++;
					break;
				}
			}
			break;

		// _[Wo[XmF
		case 2:{
			int isLink = -1;
// DEBUG
if(GetKeyState('1') < 0)m_linkNum = 1;
if(GetKeyState('2') < 0)m_linkNum = 2;
if(GetKeyState('3') < 0)m_linkNum = 3;
printf("%d񐬌Ă܂\n", m_linkNum);
printf("sANY%d, %d, %dł\n", m_temp[REST_ANY], m_temp[REST_SGM], m_temp[REST_OMG]);

			// _[Wo[XmF
			if(m_temp[DAM_REV] <= 0){
				int sel = m_pField->selLockValueExcept(PLY_MY, ZONE_DAMAGE, CD_REVERSE, CARD_FRONT);
				if(sel > 0){
					m_sState++;

					char text[100] = {};
					int tmp[3];
					if(m_temp[REST_ANY] + m_temp[REST_SGM] + m_temp[REST_OMG] > 0){
						tmp[0] = m_temp[REST_ANY];
						tmp[1] = m_temp[REST_SGM];
						tmp[2] = m_temp[REST_OMG];
					}else{
						tmp[0] = any;
						tmp[1] = sigma;
						tmp[2] = omega;
					}
					wsprintf(text, "%d񐬌Ă܂\n_[Wo[Xgp܂H\ns ANY:%d :%d :%d", m_linkNum, tmp[0], tmp[1], tmp[2]);
					m_pPhase->m_canOpenDlg = true;
					m_pDialog->open(DLG_T_YESNO, DLG_PLACE_TOP, m_card[0], text);
					m_pPhase->m_canOpenDlg = false;
				}else{
					if(m_linkNum > 0){
						isLink = TRUE;
					}else{
						isLink = FALSE;
					}
				}
			}else if(m_linkNum > 0){
				isLink = TRUE;
			}else{
				isLink = FALSE;
			}

			if(isLink != -1){
				if(isLink == TRUE){
					// NŃXgCN+1
					m_card[0]->m_addStrike.push_back(TURN_VALUE(1, TURN_NOW_BATTLE));
					nextState();
printf("NŃXgCN+1܂\n");
				}else{
					nextState(next);
printf("Ns܂\n");
				}
				// j
				int temp = m_pField->getTempNum(PLY_MY);
				// ڂŉE
				for(int i = temp - 1; i >= 0 ; i--){
					m_pField->dumpTemp(PLY_MY, i);
				}
			}
			break;
		}
		// _[Wo[XmF
		case 3:{
			int ret = LOWORD(m_pDialog->getResult());
			if(ret == BTN_ID_YES){
				m_sState++;
				m_pDialog->close();
printf("Ԃ_[W1IĂ\n");
			}else if(ret == BTN_ID_NO){
				if(m_linkNum > 0){
					// NŃXgCN+1
					m_card[0]->m_addStrike.push_back(TURN_VALUE(1, TURN_NOW_BATTLE));
					nextState();
printf("NŃXgCN+1܂\n");
				}else{
					nextState(next);
					m_pDialog->close();
printf("Ns܂\n");
				}
				// j
				int temp = m_pField->getTempNum(PLY_MY);
				// ڂŉE
				for(int i = temp - 1; i >= 0 ; i--){
					m_pField->dumpTemp(PLY_MY, i);
				}
			}
			break;
		}
		// _[Wo[X
		case 4:
			if(m_pField->getSelect()){
				m_pField->damageReverse(PLY_MY, m_pField->getSelect()->m_num);
				m_temp[DAM_REV] = 1;
				// Ĕ
				m_sState = 1;
			}
			break;
	}

	return(m_ret);
}
//! wFnȏ
int Skill::siColorNum(void)
{
	int	num		= ARGINT(0, -1);	// 
	int	color	= ARGINT(1, -1);	// F
	int next	= ARGINT(2, 99);	// XLbv

	if(m_pField->getValueNum(PLY_MY, ZONE_PROGRESS, CI_COLOR, color) >= num){
		nextState();
	}else{
switch(color){
case COL_BLUE:	printf("%dȏア܂\n", num);break;
case COL_BLACK:	printf("%dȏア܂\n", num);break;
case COL_RED:	printf("Ԃ%dȏア܂\n", num);break;
case COL_WHITE:	printf("%dȏア܂\n", num);break;
case COL_GREEN:	printf("΂%dȏア܂\n", num);break;
}
		nextState(next);
	}

	return(m_ret);
}
//! n܂
int Skill::siUseNum(void)
{
	int	skill	= ARGINT(0, -1);	// XLԍ(sXX_YYY_Z : Z)
	int	num		= ARGINT(1, -1);	// 
	int next	= ARGINT(2, 99);	// XLbv

	if(m_card[0]->m_useSkill[skill-1] < num){
		nextState();
	}else{
printf("񐔂%d𒴂Ă܂\n", num);
		nextState(next);
	}

	return(m_ret);
}
//! GiW[SătH[
int Skill::siEnergyFallAll(void)
{
	int next	= ARGINT(0, 99);	// XLbv

	if(m_pField->getAwakeEnergyNum(PLY_MY) <= 0){
		nextState();
	}else{
printf("GiW[SătH[Ă܂\n");
		nextState(next);
	}

	return(m_ret);
}

//! --- SkillEffect ---
//! h[
int Skill::seDraw(void)
{
	int	num	= ARGINT(0, -1);	// h[

	if(m_pPhase->checkDraw(num, m_pField->drawCard(PLY_MY))){
		nextState();
printf("%dh[܂\n", num);
	}

	return(m_ret);
}
//! Vbt
int Skill::seShuffle(void)
{
	int	isMy	= ARGINT(0, -1);	// 

	if(isMy){
		m_pField->shuffleDeck(PLY_MY);
printf("fbLVbt܂\n");
	}else{
		m_pField->shuffleDeck(PLY_OPPO);
printf("̃fbLVbt܂\n");
	}
	nextState();

	return(m_ret);
}
//! gAEFCN
int Skill::seAwake(void)
{
	if(m_card[0]->m_awake == CARD_FALL){
		m_pField->awakeProgress(PLY_MY, m_card[0]->m_num);
		printf("%sAEFCN܂\n", m_card[0]->m_ci.name);
	}else{
		printf("%s͊ɃAEFCNĂ܂\n", m_card[0]->m_ci.name);
	}
	nextState();

	return(m_ret);
}
//! GiW[AEFCN
int Skill::seAwakeEnergy(void)
{
	int	num	= ARGINT(0, -1);	// AEFCN

	switch(m_sState){
		case 0:{
			m_pPhase->m_selectNum = MIN(m_pField->getFallEnergyNum(PLY_MY), num);
			if(m_pPhase->m_selectNum > 0){
				m_pField->selLockValueExcept(PLY_MY, ZONE_ENERGY, CD_AWAKE, CARD_FALL);
				m_sState++;

				m_pPhase->m_canOpenDlg = true;
				char text[256] = {};
				wsprintf(text, "AEFCNGiW[%dIĉ", m_pPhase->m_selectNum);
				m_pDialog->open(DLG_TEXT, DLG_PLACE_SEEMY, NULL, text);
				m_pPhase->m_canOpenDlg = false;
			}else{
				nextState();
printf("AEFCNGiW[܂\n");
			}
			break;
		}
		case 1:
			if(m_pField->getSelectNum() == m_pPhase->m_selectNum){
printf("debug:GiW[I\n");
				for(int i = 0; i < m_pPhase->m_selectNum; i++){
printf("debug:AEFCNΏ0x%x\n", m_pField->getSelect(i));
printf("%sAEFCN܂\n", m_pField->getSelect(i)->m_ci.name);
					m_pField->awakeEnergy(PLY_MY, m_pField->getSelect(i)->m_num);
printf("debug:AEFCN%d\n", i+1);
				}
				nextState();
			}
			break;
	}

	return(m_ret);
}
//! _[W^
int Skill::seDamage(void)
{
	int	num	= ARGINT(0, -1);	// _[W

	switch(m_sState){
		case 0:
			if(m_pPhase->checkDraw(num, m_pField->addTemp(PLY_OPPO))){
				m_sState++;
			}
			break;
		case 1:
			m_pField->giveDamage(PLY_OPPO, num);
			nextState();
			break;
	}

	return(m_ret);
}
//! D̂Ă
int Skill::seDumpHand(void)
{
	int	num	= ARGINT(0, -1);	// ̂Ă閇

	switch(m_sState){
		case 0:{
			m_pField->selLockZoneExcept(PLY_MY, ZONE_HAND);
			m_pPhase->m_selectNum = MIN(m_pField->getHandNum(PLY_MY), num);
			m_sState++;

			m_pPhase->m_canOpenDlg = true;
			char text[256] = {};
			wsprintf(text, "̂ĂD%dIĉ", m_pPhase->m_selectNum);
			m_pDialog->open(DLG_TEXT, DLG_PLACE_CENTER, NULL, text);
			m_pPhase->m_canOpenDlg = false;
			break;
		}
		case 1:
			if(m_pField->getSelectNum() == m_pPhase->m_selectNum){
				while(m_pField->getSelectNum() > 0){
printf("%s̎Dɒu܂\n", m_pField->getSelect()->m_ci.name);
					m_pField->dumpHand(PLY_MY, m_pField->getSelect()->m_num);
				}
				nextState();
			}
			break;
	}

	return(m_ret);
}
//! 肪D̂Ă
int Skill::seDumpHandOp(void)
{
	int	num	= ARGINT(0, -1);	// ̂Ă閇

#if defined(_LOCAL_)
	switch(m_sState){
		case 0:
			if(m_pPhase->changePlayer()){
				m_sState++;
			}
			break;
		case 1:
			m_pPhase->m_selectNum = MIN(m_pField->getHandNum(PLY_MY), num);
			if(m_pPhase->m_selectNum > 0){
				m_pField->selLockZoneExcept(PLY_MY, ZONE_HAND);
				m_sState++;

				m_pPhase->m_canOpenDlg = true;
				char text[256] = {};
				wsprintf(text, "̂ĂD%dIĉ", m_pPhase->m_selectNum);
				m_pDialog->open(DLG_TEXT, DLG_PLACE_CENTER, NULL, text);
				m_pPhase->m_canOpenDlg = false;
			}else{
printf("̂ĂD͂܂\n");
				m_sState = 3;
			}
			break;
		case 2:
			if(m_pField->getSelectNum() == m_pPhase->m_selectNum){
				while(m_pField->getSelectNum() > 0){
printf("%s̎Dɒu܂\n", m_pField->getSelect()->m_ci.name);
					m_pField->dumpHand(PLY_MY, m_pField->getSelect()->m_num);
				}
				m_sState++;
			}
			break;
		case 3:
			if(m_pPhase->changePlayer()){
				nextState();
			}
			break;
	}
#elif defined(_NET_)
	nextState();
#endif

	return(m_ret);
}
//! fbL̂Ă
int Skill::seDumpDeck(void)
{
	int	num	= ARGINT(0, -1);	// ̂Ă閇

	if(m_pPhase->checkDraw(num, m_pField->dumpDeck(PLY_MY, m_pField->getDeckNum(PLY_MY)-1))){
		nextState();
printf("fbL%d̎Dɒu܂\n", num);
	}

	return(m_ret);
}
//! _[ŴĂ
int Skill::seDumpDamage(void)
{
	int	num	= ARGINT(0, -1);	// ̂Ă閇

	switch(m_sState){
		case 0:
			m_pPhase->m_selectNum = MIN(m_pField->getDamageNum(PLY_MY), num);
			if(m_pPhase->m_selectNum > 0){
				m_pField->selLockZoneExcept(PLY_MY, ZONE_DAMAGE);
				m_sState++;

				m_pPhase->m_canOpenDlg = true;
				char text[256] = {};
				wsprintf(text, "̂Ă_[W%dIĉ", m_pPhase->m_selectNum);
				m_pDialog->open(DLG_TEXT, DLG_PLACE_CENTER, NULL, text);
				m_pPhase->m_canOpenDlg = false;
			}else{
				nextState();
printf("̂Ă_[W܂\n");
			}
			break;
		case 1:
			if(m_pField->getSelectNum() == m_pPhase->m_selectNum){
				while(m_pField->getSelectNum() > 0){
if(m_pField->getSelect()->m_reverse==CARD_FRONT){
printf("%s̎Dɒu܂\n", m_pField->getSelect()->m_ci.name);
}else{
printf("_[W̎Dɒu܂\n");
}
					m_pField->dumpDamage(PLY_MY, m_pField->getSelect()->m_num);
				}
				nextState();
			}
			break;
	}

	return(m_ret);
}
//! fbLvOXDɉ
int Skill::seSearchDeckPrg(void)
{
	int	num		= ARGINT(0, -1);	// 閇
	int	isOpen	= ARGINT(1, -1);	// J
	int	isUntil	= ARGINT(1, -1);	// ܂Ŏw

	switch(m_sState){
		case 0:
			m_pPhase->m_canOpenDlg = true;
			m_pDialog->open(DLG_CARDLIST, DLG_PLACE_CENTER);
			for(int i = 0; i < m_pField->getDeckNum(PLY_MY); i++){
				if(m_pField->getDeck(PLY_MY, i)->m_ci.type == TYPE_PG){
					m_pDialog->m_cardList.addImage(m_pField->getDeck(PLY_MY, i)->m_ci.serNo);
				}
			}
			m_pDialog->m_cardList.m_selMax = MIN(m_pDialog->m_cardList.m_image.size(), (unsigned int)num);
			if(m_pDialog->m_cardList.m_selMax > 0){
				m_sState++;
if(isUntil)printf("fbLDɉvOX%d܂őIĉ\n", m_pDialog->m_cardList.m_selMax);
else printf("fbLDɉvOX%dIĉ\n", m_pDialog->m_cardList.m_selMax);

			}else{
				m_pDialog->close();
				nextState();
printf("fbLɑΏۃvOX܂\n");
			}
			break;
		case 1:{
			VecInt selList;
			m_pDialog->m_cardList.getSelList(&selList);
			m_pDialog->m_btnList[0]->setEnable(isUntil || selList.size() == (unsigned int)m_pDialog->m_cardList.m_selMax);
			if(m_pDialog->m_btnList[0]->isSelect()){
				for(IteInt ite = selList.begin(); ite != selList.end(); ite++){
					for(int i = 0; i < m_pField->getDeckNum(PLY_MY); i++){
						if(m_pField->getDeck(PLY_MY, i)->m_ci.serNo == *ite){
							if(isOpen){
								m_pField->toTemp(PLY_MY, ZONE_DECK, i);
							}else{
								m_pField->searchDeck(PLY_MY, i);
printf("%sDɉ܂\n", m_pField->getHand(PLY_MY, m_pField->getHandNum(PLY_MY)-1)->m_ci.name);
							}
							break;
						}
					}
					m_pField->fillDeck(PLY_MY);
				}
				m_pDialog->close();
				if(isOpen){
					m_pField->wait();
					m_sState++;
				}else{
					nextState();
				}
			}
			break;
		}
		case 2:
			while(m_pField->getTemp(PLY_MY, 0)){
				m_pField->fromTemp(PLY_MY, ZONE_HAND, m_pField->getHandNum(PLY_MY));
			}
			nextState();
			break;
	}

	return(m_ret);
}
//! ̎DvOXDɉ
int Skill::seSearchDisCardPrg(void)
{
	int	num		= ARGINT(0, -1);	// 閇
	int	level	= ARGINT(1, -1);	// Ώۃx(def:)

	switch(m_sState){
		case 0:
			m_pPhase->m_canOpenDlg = true;
			m_pDialog->open(DLG_CARDLIST, DLG_PLACE_CENTER);
			for(int i = 0; i < m_pField->getDisCardNum(PLY_MY); i++){
				if(m_pField->getDisCard(PLY_MY, i)->m_ci.type == TYPE_PG){
					if(level == -1 || m_pField->getDisCard(PLY_MY, i)->m_ci.level <= level){
						m_pDialog->m_cardList.addImage(m_pField->getDisCard(PLY_MY, i)->m_ci.serNo);
					}
				}
			}
			m_pDialog->m_cardList.m_selMax = MIN(m_pDialog->m_cardList.m_image.size(), (unsigned int)num);
			if(m_pDialog->m_cardList.m_selMax > 0){
				m_sState++;
printf("̎DDɉvOX%dIĉ\n", m_pDialog->m_cardList.m_selMax);
			}else{
				m_pDialog->close();
				nextState();
printf("̎DɑΏۃvOX܂\n");
			}
			break;
		case 1:{
			VecInt selList;
			m_pDialog->m_cardList.getSelList(&selList);
			m_pDialog->m_btnList[0]->setEnable(selList.size() == m_pDialog->m_cardList.m_selMax);
			if(m_pDialog->m_btnList[0]->isSelect()){
				for(IteInt ite = selList.begin(); ite != selList.end(); ite++){
					for(int i = 0; i < m_pField->getDisCardNum(PLY_MY); i++){
						if(m_pField->getDisCard(PLY_MY, i)->m_ci.serNo == *ite){
printf("%sDɉ܂\n", m_pField->getDisCard(PLY_MY, i)->m_ci.name);
							m_pField->searchDisCard(PLY_MY, i);
							break;
						}
					}
					m_pField->fillDisCard(PLY_MY);
				}
				m_pDialog->close();
				nextState();
			}
			break;
		}
	}

	return(m_ret);
}
//! fbLGiW[ɉ
int Skill::seAddEnergy(void)
{
	int	num		= ARGINT(0, -1);	// 閇
	int	isAwake	= ARGINT(1, -1);	// true:AEFCN, false:tH[

	if(m_pPhase->checkDraw(num, m_pField->addEnergy(PLY_MY, isAwake ? true : false))){
		nextState();
printf("GiW[%dZbg܂\n", num);
	}

	return(m_ret);
}
//! ̎DvOXu
int Skill::sePutDisCardPrg(void)
{
	int	num		= ARGINT(0, -1);	// 閇
	int	isAwake	= ARGINT(1, -1);	// true:AEFCN, false:tH[
	int	level	= ARGINT(2, -1);	// Ώۃx(def:)

	// temp[0-3]: I̎Dʒu
	// temp[9]	: c薇

	switch(m_sState){
		//J[hXg
		case 0:
			m_pPhase->m_canOpenDlg = true;
			m_pDialog->open(DLG_CARDLIST, DLG_PLACE_CENTER);
			// vOXo^
			for(int i = 0; i < m_pField->getDisCardNum(PLY_MY); i++){
				if(m_pField->getDisCard(PLY_MY, i)->m_ci.type == TYPE_PG){
					if(level == -1 || m_pField->getDisCard(PLY_MY, i)->m_ci.level <= level){
						m_pDialog->m_cardList.addImage(m_pField->getDisCard(PLY_MY, i)->m_ci.serNo);
					}
				}
			}
			m_pDialog->m_cardList.m_selMax = MIN(m_pDialog->m_cardList.m_image.size(), (unsigned int)num);
			m_pPhase->m_selectNum = MIN(m_pDialog->m_cardList.m_image.size(), (unsigned int)num);
			if(m_pPhase->m_selectNum > 0){
				m_sState++;
printf("̎DvCvOX%dIĉ\n", num);
			}else{
				m_pDialog->close();
				nextState();
printf("̎DɑΏۃvOX܂\n");
			}
			break;
		//IJ[hL
		case 1:{
			VecInt selList;
			m_pDialog->m_cardList.getSelList(&selList);
			m_pDialog->m_btnList[0]->setEnable(selList.size() == m_pPhase->m_selectNum);
			if(m_pDialog->m_btnList[0]->isSelect()){
				MEMARY(m_temp, -1);
				int i = 0;
				for(IteInt ite = selList.begin(); ite != selList.end(); ite++, i++){
					for(int j = 0; j < m_pField->getDisCardNum(PLY_MY); j++){
						if(m_pField->getDisCard(PLY_MY, j)->m_ci.serNo == *ite){
							// d`FbN
							bool b = true;
							for(int k = 0; k < 10; k++){
								if(m_temp[k] == j){
									b = false;
									break;
								}
							}
							// ʒuo^
							if(b){
								m_temp[i] = j;
								break;
							}
						}
					}
				}
				m_pDialog->close();
				m_pPhase->m_canOpenDlg = false;
				m_pField->selLockZoneExcept(PLY_MY, ZONE_PROGRESS);
				m_temp[9] = m_pPhase->m_selectNum;
				m_sState++;
printf("J[huʒuIĉ\n");
			}
			break;
		}
		//̎Du
		case 2:
			if(m_temp[9] > 0){
				if(m_pField->getSelect()){
					int prg = m_pField->getSelect()->m_num;
printf("%svC܂\n", m_pField->getSelect()->m_ci.name);
					m_pField->entryDisCard(PLY_MY, m_temp[m_temp[9]-1], prg, isAwake ? true : false);
					m_temp[9]--;
				}
			}else{
				nextState();
			}
			break;
	}

	return(m_ret);
}
//! g̍U̓Abv
int Skill::sePowerUp(void)
{
	int	power	= ARGINT(0, -1);			// U͏㏸l
	int	turn	= ARGINT(1, TURN_MY_END);	// ^[(def:̃^[)

	m_card[0]->m_addPower.push_back(TURN_VALUE(power, turn));
	nextState();
printf("%s̃p[%dAbv܂\n", m_card[0]->m_ci.name, power);

	return(m_ret);
}
//! Ŝ̍U̓Abv
int Skill::sePowerUpAll(void)
{
	int	power	= ARGINT(0, -1);			// U͏㏸l
	int	isMy	= ARGINT(1, -1);			// gΏۂ
	int	color	= ARGINT(2, -1);			// ΏېF(def:)
	int	turn	= ARGINT(3,	TURN_MY_END);	// ^[(def:̃^[)

	for(int i = 0; i < PROGRESS_MAX; i++){
		if(m_pField->getProgress(PLY_MY, i)){
			if(!isMy && i == m_card[0]->m_num){
				continue;
			}
			if(color == -1 || m_pField->getProgress(PLY_MY, i)->m_ci.color == color){
				m_pField->getProgress(PLY_MY, i)->m_addPower.push_back(TURN_VALUE(power, turn));
printf("%s̃p[%dAbv܂\n", m_pField->getProgress(PLY_MY, i)->m_ci.name, power);
			}
		}
	}
	nextState();

	return(m_ret);
}
//! n̍U̓Abv
int Skill::sePowerUpNum(void)
{
	int	power	= ARGINT(0, -1);			// U͏㏸l
	int	num		= ARGINT(1, -1);			// Ώۖ
	int	isMy	= ARGINT(2, -1);			// gΏۂ
	int	color	= ARGINT(3, -1);			// ΏېF(def:)
	int	turn	= ARGINT(4,	TURN_MY_END);	// ^[(def:̃^[)

	switch(m_sState){
		case 0:{
			m_pField->selLockZoneExcept(PLY_MY, ZONE_PROGRESS);
			int selNum = (isMy || m_card[0]->m_ci.type == TYPE_AC ? 0 : 1);
			if(color != -1){
				m_pPhase->m_selectNum = MIN(num, m_pField->getValueNum(PLY_MY, ZONE_PROGRESS, CI_COLOR, color) - selNum);
			}else{
				m_pPhase->m_selectNum = MIN(num, m_pField->getProgressNum(PLY_MY) - selNum);
			}

			if(m_pPhase->m_selectNum > 0){
				if(color != -1){
					m_pField->selLockValueExcept(PLY_MY, ZONE_PROGRESS, CI_COLOR, color);
				}
				if(!isMy){
					m_pField->selLockOnce(PLY_MY, ZONE_PROGRESS, m_card[0]->m_num);
				}
				m_sState++;

				m_pPhase->m_canOpenDlg = true;
				char text[256] = {};
				wsprintf(text, "p[AbvvOX\n%dIĉ", m_pPhase->m_selectNum);
				m_pDialog->open(DLG_TEXT, DLG_PLACE_SEEMY, NULL, text);
				m_pPhase->m_canOpenDlg = false;
			}else{
				nextState();
printf("p[AbvΏۃvOX܂\n");
			}
			break;
		}
		case 1:
			if(m_pField->getSelectNum() == m_pPhase->m_selectNum){
				for(int i = 0; i < m_pPhase->m_selectNum; i++){
					m_pField->getSelect(i)->m_addPower.push_back(TURN_VALUE(power, turn));
printf("%s̃p[%dAbv܂\n", m_pField->getSelect(i)->m_ci.name, power);
				}
				nextState();
			}
			break;
	}

	return(m_ret);
}
//! DnƂɍU̓Abv
int Skill::sePowerUpHand(void)
{
	int	power	= ARGINT(0, -1);			// U͏㏸l
	int	hand	= ARGINT(1, -1);			// Ώۖ
	int	turn	= ARGINT(2, TURN_MY_END);	// ^[(̃^[)

	int pow = (m_pField->getHandNum(PLY_MY) / hand) * power;
	m_card[0]->m_addPower.push_back(TURN_VALUE(pow, turn));
	nextState();
printf("D%dȂ̂%s̃p[%dAbv܂\n", m_pField->getHandNum(PLY_MY), m_card[0]->m_ci.name, pow);

	return(m_ret);
}
//! GiW[nƂɍU̓Abv
int Skill::sePowerUpEnergy(void)
{
	int	power	= ARGINT(0, -1);			// U͏㏸l
	int	ene		= ARGINT(1, -1);			// Ώۖ
	int	turn	= ARGINT(2, TURN_MY_END);	// ^[(̃^[)

	int pow = (m_pField->getEnergyNum(PLY_MY) / ene) * power;
	m_card[0]->m_addPower.push_back(TURN_VALUE(pow, turn));
	nextState();
printf("GiW[%dȂ̂%s̃p[%dAbv܂\n", m_pField->getEnergyNum(PLY_MY), m_card[0]->m_ci.name, pow);

	return(m_ret);
}
//! g̃XgCNAbv
int Skill::seStrikeUp(void)
{
	int	strike	= ARGINT(0, -1);			// XgCN㏸l
	int	turn	= ARGINT(1, TURN_MY_END);	// ^[(̃^[)

	m_card[0]->m_addStrike.push_back(TURN_VALUE(strike, turn));
	nextState();
printf("%s̃XgCN%dAbv܂\n", m_card[0]->m_ci.name, strike);

	return(m_ret);
}
//! vOXDɖ߂
int Skill::seBouncePrg(void)
{
	int	num		= ARGINT(0, -1);	// ߂
	int	level	= ARGINT(1, -1);	// Ώۃx(def:)

	switch(m_sState){
		case 0:
			m_pField->selLockZoneExcept(PLY_OPPO, ZONE_PROGRESS);
			if(level != -1){
				m_pPhase->m_selectNum = MIN(m_pField->getValueNum(PLY_OPPO, ZONE_PROGRESS, CI_LEVEL, level, "<="), num);
			}else{
				m_pPhase->m_selectNum = MIN(m_pField->getProgressNum(PLY_MY), num);
			}
			if(m_pPhase->m_selectNum > 0){
				if(level != -1){
					m_pField->selLockValueExcept(PLY_OPPO, ZONE_PROGRESS, CI_LEVEL, level, "<=");
				}
				m_sState++;

				m_pPhase->m_canOpenDlg = true;
				char text[256] = {};
				wsprintf(text, "Dɖ߂vOX%dIĉ", m_pPhase->m_selectNum);
				m_pDialog->open(DLG_TEXT, DLG_PLACE_SEEOPPO, NULL, text);
				m_pPhase->m_canOpenDlg = false;
			}else{
				nextState();
printf("Dɖ߂ΏۃvOX܂\n");
			}
			break;
		case 1:
			if(m_pField->getSelectNum() == m_pPhase->m_selectNum){
				while(m_pField->getSelect()){
printf("%s𑊎̎Dɖ߂܂\n", m_pField->getSelect()->m_ci.name);
					m_pField->bounceProgress(PLY_OPPO, m_pField->getSelect()->m_num);
				}
				nextState();
			}
			break;
	}

	return(m_ret);
}
//! vOXfbLɖ߂
int Skill::seBouncePrgDeck(void)
{
	int	num		= ARGINT(0, -1);	// ߂
	int	place	= ARGINT(1, -1);	// ߂ꏊ
	int	level	= ARGINT(2, -1);	// Ώۃx(def:)

	switch(m_sState){
		case 0:
			m_pField->selLockZoneExcept(PLY_OPPO, ZONE_PROGRESS);
			if(level != -1){
				m_pPhase->m_selectNum = MIN(m_pField->getProgressNum(PLY_MY), num);
			}else{
				m_pPhase->m_selectNum = MIN(m_pField->getValueNum(PLY_OPPO, ZONE_PROGRESS, CI_LEVEL, level, "<="), num);
			}

			if(m_pPhase->m_selectNum > 0){
				if(level != -1){
					m_pField->selLockValueExcept(PLY_OPPO, ZONE_PROGRESS, CI_LEVEL, level, "<=");
				}
				m_sState++;

				m_pPhase->m_canOpenDlg = true;
				char text[256] = {};
				wsprintf(text, "fbLɖ߂vOX%dIĉ", m_pPhase->m_selectNum);
				m_pDialog->open(DLG_TEXT, DLG_PLACE_SEEOPPO, NULL, text);
				m_pPhase->m_canOpenDlg = false;
			}else{
				nextState();
printf("fbLɖ߂ΏۃvOX܂\n");
			}
			break;
		case 1:
			if(m_pField->getSelectNum() == m_pPhase->m_selectNum){
				while(m_pField->getSelect()){
					if(place == DIR_UP){
printf("%s𑊎̃fbLgbvɖ߂܂\n", m_pField->getSelect()->m_ci.name);
						int sel = m_pField->getSelect()->m_num;
						m_pField->backProgress(PLY_OPPO, sel, m_pField->getDeckNum(PLY_OPPO));
					}else if(place == DIR_DOWN){
printf("%s𑊎̃fbLɖ߂܂\n", m_pField->getSelect()->m_ci.name);
						m_pField->liftDeck(PLY_OPPO);
						int sel = m_pField->getSelect()->m_num;
						m_pField->backProgress(PLY_OPPO, sel, 0);
					}
				}
				nextState();
			}
			break;
	}

	return(m_ret);
}
//! vOXދp
int Skill::seRemovePrg(void)
{
	int	num		= ARGINT(0, -1);	// ދp
	int	level	= ARGINT(1, -1);	// Ώۃx(def:)

	switch(m_sState){
		case 0:
			m_pField->selLockZoneExcept(PLY_OPPO, ZONE_PROGRESS);
			if(level != -1){
				m_pPhase->m_selectNum = MIN(m_pField->getProgressNum(PLY_MY), num);
			}else{
				m_pPhase->m_selectNum = MIN(m_pField->getValueNum(PLY_OPPO, ZONE_PROGRESS, CI_LEVEL, level, "<="), num);
			}

			if(m_pPhase->m_selectNum > 0){
				if(level != -1){
					m_pField->selLockValueExcept(PLY_OPPO, ZONE_PROGRESS, CI_LEVEL, level, "<=");
				}
				m_sState++;

				m_pPhase->m_canOpenDlg = true;
				char text[256] = {};
				wsprintf(text, "ދpvOX%dIĉ", m_pPhase->m_selectNum);
				m_pDialog->open(DLG_TEXT, DLG_PLACE_SEEOPPO, NULL, text);
				m_pPhase->m_canOpenDlg = false;
			}else{
				nextState();
printf("ދpΏۃvOX܂\n");
			}
			break;
		case 1:
			if(m_pField->getSelectNum() == m_pPhase->m_selectNum){
				while(m_pField->getSelect()){
printf("%sދp܂\n", m_pField->getSelect()->m_ci.name);
					m_pField->dumpProgress(PLY_OPPO, m_pField->getSelect()->m_num);
				}
				nextState();
			}
			break;
	}

	return(m_ret);
}
//! Dƕ\_[Wւ
int Skill::seChangeHandDamage(void)
{
	int	num	= ARGINT(0, -1);	// ւ

	// card[1`n]	: ID
	// card[n+1`m]	: I_[W

	switch(m_sState){
		case 0:
			m_pField->selLockZoneExcept(PLY_MY, ZONE_HAND);
			m_pPhase->m_selectNum = MIN(MIN(m_pField->getHandNum(PLY_MY), m_pField->getValueNum(PLY_MY, ZONE_DAMAGE, CD_REVERSE, CARD_FRONT)), num);
			if(m_pPhase->m_selectNum > 0){
				m_sState++;

				m_pPhase->m_canOpenDlg = true;
				char text[256] = {};
				wsprintf(text, "ւD%dIĉ", m_pPhase->m_selectNum);
				m_pDialog->open(DLG_TEXT, DLG_PLACE_CENTER, NULL, text);
				m_pPhase->m_canOpenDlg = false;
			}else{
				nextState();
printf("ւłΏۃJ[h܂\n");
			}
			break;
		case 1:
			if(m_pField->getSelectNum() == m_pPhase->m_selectNum){
				for(int i = 0; i < m_pPhase->m_selectNum; i++){
					m_card[1 + i] = m_pField->getSelect(i);
				}
				m_pField->selLockValueExcept(PLY_MY, ZONE_DAMAGE, CD_REVERSE, CARD_FRONT);
				m_sState++;

				m_pPhase->m_canOpenDlg = true;
				char text[256] = {};
				wsprintf(text, "ւ_[W%dIĉ", m_pPhase->m_selectNum);
				m_pDialog->open(DLG_TEXT, DLG_PLACE_CENTER, NULL, text);
				m_pPhase->m_canOpenDlg = false;
			}
			break;
		case 2:
			if(m_pField->getSelectNum() == m_pPhase->m_selectNum){
				for(int i = 0; i < m_pPhase->m_selectNum; i++){
					m_card[1 + m_pPhase->m_selectNum + i] = m_pField->getDamage(PLY_MY, i);
				}
				m_sState++;
			}
			break;
		case 3:
			for(int i = 0; i < m_pPhase->m_selectNum; i++){
				m_pField->replaceCard(m_card[1 + i], m_card[1 + m_pPhase->m_selectNum + i], true, true, true, true);
printf("%s%sւ܂\n", m_card[1 + i]->m_ci.name, m_card[1 + m_pPhase->m_selectNum + i]->m_ci.name);
			}
			nextState();
			break;
	}

	return(m_ret);
}
//! _[W\ɂ
int Skill::seDamageFront(void)
{
	int	num	= ARGINT(0, -1);	// Ώۖ

	switch(m_sState){
		case 0:
			m_pPhase->m_selectNum = MIN(m_pField->getValueNum(PLY_MY, ZONE_DAMAGE, CD_REVERSE, CARD_BACK), num);
			if(m_pPhase->m_selectNum > 0){
				m_pField->selLockValueExcept(PLY_MY, ZONE_DAMAGE, CD_REVERSE, CARD_BACK);
				m_sState++;

				m_pPhase->m_canOpenDlg = true;
				char text[256] = {};
				wsprintf(text, "\ɂ_[W%dIĉ", m_pPhase->m_selectNum);
				m_pDialog->open(DLG_TEXT, DLG_PLACE_CENTER, NULL, text);
				m_pPhase->m_canOpenDlg = false;
			}else{
				nextState();
printf("\ɂ_[W܂\n");
			}
			break;
		case 1:
			if(m_pField->getSelectNum() == m_pPhase->m_selectNum){
				for(int i = 0; i < m_pPhase->m_selectNum; i++){
					m_pField->reverseDamage(PLY_MY, m_pField->getSelect(i)->m_num, true);
printf("%s\ɂ܂\n", m_pField->getSelect(i)->m_ci.name);
				}
			}
			nextState();
			break;
	}

	return(m_ret);
}
//! fbLgbvォ̎Dɒu
int Skill::seDeckTopMoveTorD(void)
{
	switch(m_sState){
		case 0:
			m_pField->reverseDeck(PLY_MY, m_pField->getDeckNum(PLY_MY)-1, true);
			m_sState++;
			m_pPhase->m_canOpenDlg = true;
			m_pDialog->open(DLG_T_UPDUMP, DLG_PLACE_CENTER, m_card[0], "fbLgbvƎ̎Dǂɒu܂H");
			break;
		case 1:
			if(LOWORD(m_pDialog->getResult()) == BTN_ID_UP){
				m_pField->reverseDeck(PLY_MY, m_pField->getDeckNum(PLY_MY)-1, false);
				nextState();
printf("%sfbLgbvɖ߂܂\n", m_pField->getDeck(PLY_MY, m_pField->getDeckNum(PLY_MY)-1)->m_ci.name);
			}else if(LOWORD(m_pDialog->getResult()) == BTN_ID_DISCARD){
printf("%s̎Dɒu܂\n", m_pField->getDeck(PLY_MY, m_pField->getDeckNum(PLY_MY)-1)->m_ci.name);
				m_pField->dumpDeck(PLY_MY, m_pField->getDeckNum(PLY_MY)-1);
				m_pDialog->close();
				nextState();
			}
			break;
	}

	return(m_ret);
}

