/* _/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/

FILE	: animeCalc.cpp

+ ------ Explanation of file --------------------------------------------------------------------------

+ _/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/ */

#include "Common.h"

#include <mmsystem.h>

#include "animeCalc.h"

#define GETTIME		(float)(timeGetTime() / 1000.0f)

//! vector\[gp
bool operator<(const ANIMECALC& left, const ANIMECALC& right)
{
	return left.id < right.id;
}
bool operator>(const ANIMECALC& left, const ANIMECALC& right)
{
	return left.id > right.id;
}

//! f[^Zbg
void animeCalcClass::set(int id, float time, VEC3 pos, VEC3 deg, float scale)
{
	ANIMECALC	anime;
	anime.id = id;
	anime.time = time;
	anime.pos = pos;
	anime.degree = deg;
	anime.scale = scale;

	m_animeList.push_back(anime);
}

//! 
void animeCalcClass::clear(void)
{
	m_state = ANIMESTATE_NON;
	m_animeID = -1;
	m_startTime = 0.0f;
	m_elapsedTime = 0.0f;
	m_delayTime = 0.0f;
	m_isLoop = false;
	m_animeList.clear();
}

//! Jn
void animeCalcClass::start(void)
{
	sort(m_animeList.begin(), m_animeList.end());
	m_state = ANIMESTATE_RUN;
	m_animeID = m_animeList.begin()->id;
	m_startTime = GETTIME;
	m_elapsedTime = 0.0f;
}

//! ĊJ
void animeCalcClass::resume(void)
{
	m_state = ANIMESTATE_RUN;
	m_startTime = GETTIME - m_elapsedTime;	// oߎԂ̂܂܂
}

//! ~
void animeCalcClass::stop(void)
{
	m_state = ANIMESTATE_STOP;
	m_elapsedTime = GETTIME - m_startTime;	// XV
}

//! XLbv
void animeCalcClass::skip(void)
{
	m_state = ANIMESTATE_END;
	m_animeID = -1;
}

//! vZ
ANIMECALC animeCalcClass::calc(void)
{
	ANIMECALC ret;

	if(m_state == ANIMESTATE_END){
		ret = m_animeList.back();
	}else{
		// ԍXV
		if(m_state == ANIMESTATE_RUN){
			m_elapsedTime = GETTIME - m_startTime;
		}

		// xȂ̂ŊJnȂ
		if(m_elapsedTime < m_delayTime){
			ret = m_animeList.front();
		}else{
			// ĐAj擾
			ANIMECALC	now, back;								// ݃Aj, OAj
			float		elapsed = m_elapsedTime - m_delayTime;	// oߎԌvZ
			float		time = 0.0f;							// ݃Aj܂ł̌oߎ
			bool		isAnime = false;						// Đ
			for(iteAnmCalc ite = m_animeList.begin(); ite != m_animeList.end(); ite++){
				if(elapsed < time + ite->time){
					m_animeID = ite->id;
					if(ite->id == m_animeList.begin()->id){
						// vf
						now = back = *ite;
					}else{
						now = *ite;
						back = *(ite - 1);
					}
					isAnime = true;
					break;
				}
				time += ite->time;
			}

			if(isAnime){
				float prog = (elapsed - time) / now.time;		// ݃Aj̐isx
				ret.pos		= back.pos	 + ((now.pos	- back.pos	) * prog);
				ret.degree	= back.degree+ ((now.degree	- back.degree) * prog);
				ret.scale	= back.scale + ((now.scale	- back.scale) * prog);
			}else if(m_isLoop){
				// ČvZ
				m_startTime += getSumTime();
				ret = calc();
			}else{
				m_state = ANIMESTATE_END;
				m_animeID = -1;
				ret = m_animeList.back();
			}
		}
	}

	return(ret);
}

//! W擾
VEC3 animeCalcClass::getPos(void)
{
	return(calc().pos);
}

//! px擾
VEC3 animeCalcClass::getDegree(void)
{
	return(calc().degree);
}

//! gk擾
float animeCalcClass::getScale(void)
{
	return(calc().scale);
}

//! vԎ擾
float animeCalcClass::getSumTime(void)
{
	float ret = 0.0f;
	for(iteAnmCalc ite = m_animeList.begin(); ite != m_animeList.end(); ite++){
		ret += ite->time;
	}

	return(ret);
}

//! s
bool animeCalcClass::isRun(void)
{
	return(m_state == ANIMESTATE_RUN);
}

//! I
bool animeCalcClass::isEnd(void)
{
	return(m_state == ANIMESTATE_END);
}

