/* _/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/
|
|   avbbs.cpp
|
+ -------------------------------------------------------------------------------------------------
|
+ _/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/ */

#include "Common.h"

#include <time.h>

#include "gameManager.h"
#include "systemManager.h"
#include "windowManager.h"

#include "avbbs.h"

//! Gg|Cg
int APIENTRY WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance, LPSTR lpCmdLine, int nCmdShow)
{
	avbbsClass::getInstance()->init(hInstance, lpCmdLine, nCmdShow);
	avbbsClass::getInstance()->run();

	return(1);
}


//! RXgN^
avbbsClass::avbbsClass(void)
{
}

//! fXgN^
avbbsClass::~avbbsClass()
{
	release();
}

//! 
void avbbsClass::release(void)
{
	SAFE_DELETE(m_pGameMan);
}

//! 
void avbbsClass::init(HINSTANCE hInst, char* cmdLine, int cmdShow)
{
	// 
	srand((unsigned)time(NULL));

	m_pWindowMan = WindowManager::getInstance();
	m_pSystemMan = SystemManager::getInstance();
	m_pGameMan = new GameManager();

	m_pWindowMan->init(hInst, cmdLine, cmdShow);
	m_pWindowMan->createWindow(WINDOW_W, WINDOW_H);
	m_pSystemMan->init();
	m_pGameMan->init();
}

//! s
void avbbsClass::run(void)
{
	MSG msg;
	while(true){
        if(PeekMessage(&msg, NULL, 0, 0, PM_REMOVE)){
			if(msg.message == WM_QUIT) break;

			TranslateMessage(&msg);
			DispatchMessage(&msg);
        }else{
			m_pSystemMan->update();
			m_pGameMan->update();
			m_pGameMan->draw();
		}
    }

	release();
}

//! CX^X擾
avbbsClass* avbbsClass::getInstance(void)
{
	static avbbsClass avbbs;
	return(&avbbs);
}
