/* _/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/
|
|   gameManager.cpp
|
+ -------------------------------------------------------------------------------------------------
|
+ _/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/ */

#include "Common.h"

#include "systemManager.h"
#include "Renderer.h"
#include "GridLine.h"
#include "Ground.h"
#include "Phase.h"
#include "Field.h"
#include "FieldMenu.h"
#include "Dialog.h"
#include "Mouse.h"
#include "Skill.h"
#include "CardData.h"

#include "gameManager.h"

//! RXgN^
GameManager::GameManager()
{
}

//! fXgN^
GameManager::~GameManager()
{
	release();
}

//! 
void GameManager::release(void)
{
	SAFE_DELETE(m_pGridLine);
	SAFE_DELETE(m_pGround);
	SAFE_DELETE(m_pCardData);
	SAFE_DELETE(m_pMenu);
	SAFE_DELETE(m_pDialog);
	SAFE_DELETE(m_pSkill);
}

//! 
void GameManager::init(void)
{
	m_pSysMan = SystemManager::getInstance();
	m_pGridLine = new GridLine();
	m_pGround = new Ground();
	m_pCardData = new CardData();
	m_pField = &field;
	m_pPhase = &phase;
	m_pMenu = new FieldMenu();
	m_pDialog = new Dialog();
	m_pSkill = new Skill();

	m_pCardData->readBinary();
	m_pCardData->readDeck(PLY_1P, "Deck\\test1.deck");
	m_pCardData->readDeck(PLY_2P, "Deck\\test2.deck");

	m_pField->init(m_pPhase, m_pDialog, m_pMenu, m_pCardData);
	m_pPhase->init(m_pField, m_pSkill, m_pDialog);
	m_pMenu->init(m_pCardData);
	m_pDialog->init(m_pSkill);
	m_pSkill->init(m_pPhase, m_pField, m_pDialog);

	m_pGridLine->create();
	m_pGround->create();
	m_pMenu->create(0, 0, MENU_W, MENU_H);
}

//! XV
void GameManager::update(void)
{
	m_pDialog->update();
	m_pPhase->update();
	m_pField->update();
}

//! `
void GameManager::draw(void)
{
	Renderer* pRenderer = m_pSysMan->getRenderer();

	pRenderer->drawStart();
	{
		pRenderer->set3D();
		{
			m_pGround->draw();
			m_pGridLine->draw();
			m_pField->draw();
		}
		pRenderer->set2D();
		{
			m_pMenu->draw();
			m_pPhase->draw();
			m_pDialog->draw();
		}
		pRenderer->set3D();
	}
	pRenderer->drawEnd();
}


