/* _/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/
|
|   windowManager.cpp
|
+ -------------------------------------------------------------------------------------------------
|
+ _/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/ */

#include "Common.h"

#include "systemManager.h"
#include "Mouse.h"

#include "windowManager.h"

//! R[obN
LRESULT CALLBACK MessageProc(HWND hWnd, UINT msg, WPARAM wParam, LPARAM lParam)
{
	return(WindowManager::getInstance()->messageProc(hWnd, msg, wParam, lParam));
}

//! RXgN^
WindowManager::WindowManager()
{
}

//! fXgN^
WindowManager::~WindowManager()
{
	release();
}

//! 
void WindowManager::release(void)
{
}

//! 
void WindowManager::init(HINSTANCE hInst, char* cmdLine, int cmdShow)
{
	m_instanceHandle = hInst;
	m_cmdLine = cmdLine;
	m_cmdShowNum = cmdShow;
}

//! EBhE
void WindowManager::createWindow(int width, int height)
{
	m_winWidth = width;
	m_winHeight = height;

	char    winName[]	= "AngeViergeBBS";	// EBhENX

	// EBhENX̏
	WNDCLASSEX	wcex = {
		sizeof(WNDCLASSEX),				// ̍\̂̃TCY
		NULL,							// EChẼX^C(default)
		MessageProc,					// bZ[W֐̓o^
		0,								// ʏ͎gȂ̂ŏ0
		0,								// ʏ͎gȂ̂ŏ0
		m_instanceHandle,				// CX^Xւ̃nh
		NULL,							// ACRiȂj
		LoadCursor(NULL, IDC_ARROW),	// J[\̌`
		NULL, NULL,						// wiȂAj[Ȃ
		winName,						// NX̎w
		NULL							// ACRiȂj
	};

	// EBhENX̓o^
	RegisterClassEx(&wcex);
	
	// ʑŜ̕ƍ擾
	int sw = GetSystemMetrics(SM_CXSCREEN);
	int sh = GetSystemMetrics(SM_CYSCREEN);

	if(false){
		// tXN[
		m_windowHandle = CreateWindow(winName, winName, WS_POPUP, 0, 0, sw, sh, NULL, NULL, m_instanceHandle, NULL);
	}else{
		// EBhE[h
		m_windowHandle = CreateWindow(winName, winName, WS_OVERLAPPEDWINDOW, 0, 0, width, height, NULL, NULL, m_instanceHandle, NULL);

		// EBhETCYĐݒ肷
		RECT rect;
		int ww, wh;
		int cw, ch;
		int x, y;

		// NCAg̈̊O̕vZ
		GetClientRect(m_windowHandle, &rect);	// NCAg̃TCY̎擾
		cw = rect.right - rect.left;			// NCAg̈ỎvZ
		ch = rect.bottom - rect.top;			// NCAg̈ȌcvZ

		// EChEŜ̉̕vZ
		GetWindowRect(m_windowHandle, &rect);	// EChEŜ̃TCY擾
		ww = rect.right - rect.left;			// EChEŜ̉̕vZ
		wh = rect.bottom - rect.top;			// EChEŜ̏̕cvZ
		x = (sw - ww) / 2;
		y = (sh - wh) / 2;
		ww -= cw;								// NCAg̈ȊOɕKvȕ
		wh -= ch;								// NCAg̈ȊOɕKvȍ

		// EBhETCY̍ČvZ
		ww += width;		// KvȃEChE̕
		wh += height;		// KvȃEChE̍

		// EChETCY̍Đݒ
		SetWindowPos(m_windowHandle, HWND_TOP, x, y, ww, wh, 0);
	}

    ShowWindow(m_windowHandle, m_cmdShowNum);	// EBhE̕\
	ValidateRect(m_windowHandle, 0);			// WM_PAINTĂ΂Ȃ悤ɂ
}

//! bZ[W
LRESULT WindowManager::messageProc(HWND hWnd, UINT msg, WPARAM wParam, LPARAM lParam)
{
	LRESULT	ret = 0;

	switch(msg){
		case WM_CLOSE:
			PostQuitMessage(0);
			break;

		case WM_KEYDOWN:
			if(wParam == VK_ESCAPE){
				PostQuitMessage(0);
			}
			break;

		case WM_MOUSEWHEEL:
			SystemManager::getInstance()->getMouse()->setWheel(GET_WHEEL_DELTA_WPARAM(wParam)/WHEEL_DELTA);
			break;

		default:
			ret = DefWindowProc(hWnd, msg, wParam, lParam); 
	}

	return(ret);
}

//! CX^X擾
WindowManager* WindowManager::getInstance(void)
{
	static WindowManager winMan;
	return(&winMan);
}

