﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.Threading;

using System.Runtime.InteropServices;




namespace twilauncher
{
    public partial class Form1 : Form
    {
        const int MOD_ALT = 0x0001;
        const int MOD_CONTROL = 0x0002;
        const int MOD_SHIFT = 0x0004;
        const int WM_HOTKEY = 0x0312;

        const int HOTKEY_ID = 0x0001;  // 0x0000～0xbfff 内の適当な値でよい
        // 0xc000～0xffff は DLL 用なので 使用不可！
        const int HOTKEY_ID_Q = 0x0002;  // 0x0000～0xbfff 内の適当な値でよい

        [DllImport("user32.dll")]
        extern static int RegisterHotKey(IntPtr HWnd, int ID, int MOD_KEY, int KEY);
        // 返り値:  成功 = 0以外,  失敗 = 0(既に他が登録済み)

        [DllImport("user32.dll")]
        extern static int UnregisterHotKey(IntPtr HWnd, int ID);
        // 返り値:  成功 = 0以外,  失敗 = 0
        /*ここまでホットキー*/

        twittermain tm;
        public delegate void mydel();
        public string last="";

        public Form1()
        {
            InitializeComponent();
            tm = new twittermain();
            if (!tm.ini())
            {
                this.Close();
            }
            
            Properties.Settings.Default.Reload();
            if(Properties.Settings.Default.hkey==0){
            RegisterHotKey(this.Handle, HOTKEY_ID, MOD_CONTROL, (int)Keys.End);
            Properties.Settings.Default.hkey = (int)Keys.End;
            Properties.Settings.Default.Save();
            }
            else {
                int re,key;
                bool shift, alt, ctrl;
                shift = Properties.Settings.Default.shift;
                alt = Properties.Settings.Default.alt;
                ctrl = Properties.Settings.Default.ctrl;
                key = Properties.Settings.Default.hkey;
                if (shift && !alt && !ctrl) { re = RegisterHotKey(this.Handle, HOTKEY_ID, MOD_SHIFT, key); }
                if (!shift && alt && !ctrl) { re = RegisterHotKey(this.Handle, HOTKEY_ID, MOD_ALT, key); }
                if (!shift && !alt && ctrl) { re = RegisterHotKey(this.Handle, HOTKEY_ID, MOD_CONTROL, key); }
                if (shift && alt && !ctrl) { re = RegisterHotKey(this.Handle, HOTKEY_ID, MOD_SHIFT | MOD_ALT, key); }
                if (shift && !alt && ctrl) { re = RegisterHotKey(this.Handle, HOTKEY_ID, MOD_CONTROL | MOD_SHIFT, key); }
                if (!shift && alt && ctrl) { re = RegisterHotKey(this.Handle, HOTKEY_ID, MOD_CONTROL | MOD_ALT, key); }
                if (shift && alt && ctrl) { re = RegisterHotKey(this.Handle, HOTKEY_ID, MOD_CONTROL | MOD_ALT | MOD_SHIFT, key); }

              //  RegisterHotKey(this.Handle, HOTKEY_ID, MOD_CONTROL, Properties.Settings.Default.hkey); 
            
             //if (r == 0) { MessageBox.Show("割り当て失敗"); }
            }
            int r = RegisterHotKey(this.Handle, HOTKEY_ID_Q, MOD_CONTROL, (int)Keys.Q);
        }

        private void button1_Click(object sender, EventArgs e)
        {
            this.Visible = false;
        }

     
        private void richTextBox1_KeyDown(object sender, KeyEventArgs e)
        {
            if (e.KeyCode == Keys.Enter)
            {
                e.Handled = true;
                if (!e.Control && e.Modifiers!=Keys.Shift)
                {
                    string tweet;
                    
                    tweet = richTextBox1.Text;
                    if (tweet.Length > 140)
                    {
                        //MessageBox.Show("140文字を超えています");
                        DialogResult result = MessageBox.Show("140文字を超えています、削っていいですか？",
                             "質問",
                             MessageBoxButtons.YesNo,
                             MessageBoxIcon.Exclamation,
                             MessageBoxDefaultButton.Button2);

                        //何が選択されたか調べる
                        if (result == DialogResult.Yes)
                        {
                            //「はい」が選択された時
                            // Console.WriteLine("「はい」が選択されました");
                            tweet = tweet.Substring(0, 140);
                        }
                        else
                        {
                            this.Visible = true;
                            this.Activate();
                        }
                    }
                    if(tweet.Length<=140){
                        richTextBox1.Text = "";
                        this.Visible = false;
                        if (tweet != last)
                        {
                            last = tweet;
                            /*
                            Thread thread = null;
                            thread = new Thread(new ThreadStart(th));
                            thread.Start();*/
                            tm.Do_tweet(tweet);

                        }
                        richTextBox1.Clear();
                    }
                }
                if (!e.Control && e.Modifiers == Keys.Shift)
                {
                    richTextBox1.AppendText("\r\n");
                }
            }

            if (e.KeyCode == Keys.Escape)
            {
                this.Visible = false;
            }

        }
        public void th()
        {
            
            mydel del = new mydel(tweet_th);
            this.Invoke(del);
            
        }

        public void tweet_th(){
            string tweet;
            tweet = richTextBox1.Text;
            //MessageBox.Show(tweet);
            richTextBox1.Clear();
            tm.Do_tweet(tweet);

    }

        private void Form1_FormClosing(object sender, FormClosingEventArgs e)
        {
            if (e.CloseReason == CloseReason.UserClosing && this.Visible == true)
            {
                e.Cancel = true;
                this.Visible = false;
            }
            else
            {


            }
        }

        private void ホットキー設定ToolStripMenuItem_Click(object sender, EventArgs e)
        {
            // ホットキーの登録 "ALT + SHIFT + A"
            //RegisterHotKey(this.Handle, HOTKEY_ID, MOD_ALT | MOD_SHIFT, (int)Keys.A);
            int key;
            bool shift, alt, ctrl;
            int re=0;
            UnregisterHotKey(this.Handle, HOTKEY_ID);//ホットキー抹消
            inputhotkey ik = new inputhotkey();
            ik.ShowDialog();
            key = ik.key; shift = ik.shift; alt = ik.alt; ctrl = ik.ctrl;
            //MessageBox.Show(key.ToString());


            Properties.Settings.Default.shift = shift;
            Properties.Settings.Default.alt = alt;
            Properties.Settings.Default.ctrl = ctrl;
            Properties.Settings.Default.hkey = key;
            Properties.Settings.Default.Save();

            if (shift && !alt && !ctrl){re = RegisterHotKey(this.Handle, HOTKEY_ID, MOD_SHIFT, key);}
            if (!shift && alt && !ctrl) { re = RegisterHotKey(this.Handle, HOTKEY_ID, MOD_ALT, key); }
            if (!shift && !alt && ctrl) { re = RegisterHotKey(this.Handle, HOTKEY_ID, MOD_CONTROL, key); }
            if (shift && alt && !ctrl) { re = RegisterHotKey(this.Handle, HOTKEY_ID, MOD_SHIFT | MOD_ALT, key); }
            if (shift && !alt && ctrl) { re = RegisterHotKey(this.Handle, HOTKEY_ID, MOD_CONTROL | MOD_SHIFT, key); }
            if (!shift && alt && ctrl) { re = RegisterHotKey(this.Handle, HOTKEY_ID, MOD_CONTROL |MOD_ALT, key); }
            if (shift && alt && ctrl) { re = RegisterHotKey(this.Handle, HOTKEY_ID, MOD_CONTROL | MOD_ALT | MOD_SHIFT, key); }


            if (re == 0) { MessageBox.Show("割り当て失敗"); }
        }

        private void ホットキー削除ToolStripMenuItem_Click(object sender, EventArgs e)
        {
            // ホットキーの登録抹消
            UnregisterHotKey(this.Handle, HOTKEY_ID);
        }

        protected override void WndProc(ref Message m)
        {
            base.WndProc(ref m);

            if (m.Msg == WM_HOTKEY)
            {
                if ((int)m.WParam == HOTKEY_ID)
                {
                    /* ホットキーの処理 */
                    //MessageBox.Show("ホットキーを押した");
                    if (this.Visible == true) { this.Visible = false; }
                    else { this.Visible = true; this.Activate(); }
                }
                if ((int)m.WParam == HOTKEY_ID_Q)
                {
                    Application.Exit();
                }
            }
        }

        private void notifyIcon1_DoubleClick(object sender, EventArgs e)
        {
            if (this.Visible)
            { this.Visible = false; }
            else
            {
                this.Visible = true; // フォームの表示
                if (this.WindowState == FormWindowState.Minimized)
                {
                    this.WindowState = FormWindowState.Normal; // 最小化をやめる
                }
                this.Activate(); // フォームをアクティブにする
            }
        }

        private void 終了ToolStripMenuItem1_Click(object sender, EventArgs e)
        {
            //this.Visible = true;
            notifyIcon1.Visible = false; // アイコンをトレイから取り除く
            Application.Exit(); // アプリケーションの終了
            /* this.Close();
             this.Dispose(); */
        }

        private void Form1_Deactivate(object sender, EventArgs e)
        {
            this.Visible = false;
        }

    }
}
