import logging
from tg import config
from ming.orm import session

from . import base

from allura import model as M
from allura.lib import helpers as h

log = logging.getLogger(__name__)

class CreateTroveCategoriesCommand(base.Command):
    min_args=None
    max_args=None
    usage = '<ini file>'
    summary = 'Remove any existing trove categories and load new ones'
    parser = base.Command.standard_parser(verbose=True)

    def create_trove_cat(self,cat_data):
        M.TroveCategory(trove_cat_id=cat_data[0], trove_parent_id=cat_data[1],
                        shortname=cat_data[2], fullname=cat_data[3], fullpath=cat_data[4])

    def command(self):
        self.basic_setup()
        M.TroveCategory.query.remove()
        self.create_trove_cat((617,274,"kirghiz","Kirghiz","Translations :: Kirghiz"))
        self.create_trove_cat((372,274,"croatian","Croatian","Translations :: Croatian"))
        self.create_trove_cat((351,274,"thai","Thai","Translations :: Thai"))
        self.create_trove_cat((349,274,"tamil","Tamil","Translations :: Tamil"))
        self.create_trove_cat((347,274,"romanian","Romanian","Translations :: Romanian"))
        self.create_trove_cat((339,274,"korean","Korean","Translations :: Korean"))
        self.create_trove_cat((632,160,"cobol","COBOL","Programming Language :: COBOL"))
        self.create_trove_cat((598,160,"aspectj","AspectJ","Programming Language :: AspectJ"))
        self.create_trove_cat((167,160,"euler","Euler","Programming Language :: Euler"))
        self.create_trove_cat((185,160,"shell","Unix Shell","Programming Language :: Unix Shell"))
        self.create_trove_cat((184,160,"asp","ASP","Programming Language :: ASP"))
        self.create_trove_cat((273,160,"Pike","Pike","Programming Language :: Pike"))
        self.create_trove_cat((271,160,"csharp","C#","Programming Language :: C#"))
        self.create_trove_cat((170,160,"lisp","Lisp","Programming Language :: Lisp"))
        self.create_trove_cat((169,160,"fortran","Fortran","Programming Language :: Fortran"))
        self.create_trove_cat((625,160,"simulink","Simulink","Programming Language :: Simulink"))
        self.create_trove_cat((626,160,"matlab","MATLAB","Programming Language :: MATLAB"))
        self.create_trove_cat((1,0,"audience","Intended Audience","Intended Audience"))
        self.create_trove_cat((618,535,"nonprofit","Non-Profit Organizations","Intended Audience :: by Industry or Sector :: Non-Profit Organizations"))
        self.create_trove_cat((599,535,"aerospace","Aerospace","Intended Audience :: by Industry or Sector :: Aerospace"))
        self.create_trove_cat((569,535,"government","Government","Intended Audience :: by Industry or Sector :: Government"))
        self.create_trove_cat((363,535,"informationtechnology","Information Technology","Intended Audience :: by Industry or Sector :: Information Technology"))
        self.create_trove_cat((361,535,"financialinsurance","Financial and Insurance Industry","Intended Audience :: by Industry or Sector :: Financial and Insurance Industry"))
        self.create_trove_cat((362,535,"healthcareindustry","Healthcare Industry","Intended Audience :: by Industry or Sector :: Healthcare Industry"))
        self.create_trove_cat((367,535,"scienceresearch","Science/Research","Intended Audience :: by Industry or Sector :: Science/Research"))
        self.create_trove_cat((359,535,"customerservice","Customer Service","Intended Audience :: by Industry or Sector :: Customer Service"))
        self.create_trove_cat((360,535,"education","Education","Intended Audience :: by Industry or Sector :: Education"))
        self.create_trove_cat((365,535,"manufacturing","Manufacturing","Intended Audience :: by Industry or Sector :: Manufacturing"))
        self.create_trove_cat((368,535,"telecommunications","Telecommunications Industry","Intended Audience :: by Industry or Sector :: Telecommunications Industry"))
        self.create_trove_cat((166,160,"eiffel","Eiffel","Programming Language :: Eiffel"))
        self.create_trove_cat((550,160,"oberon","Oberon","Programming Language :: Oberon"))
        self.create_trove_cat((553,160,"realbasic","REALbasic","Programming Language :: REALbasic"))
        self.create_trove_cat((178,160,"python","Python","Programming Language :: Python"))
        self.create_trove_cat((179,160,"rexx","Rexx","Programming Language :: Rexx"))
        self.create_trove_cat((177,160,"prolog","Prolog","Programming Language :: Prolog"))
        self.create_trove_cat((176,160,"perl","Perl","Programming Language :: Perl"))
        self.create_trove_cat((175,160,"pascal","Pascal","Programming Language :: Pascal"))
        self.create_trove_cat((536,534,"enduser_advanced","Advanced End Users","Intended Audience :: by End-User Class :: Advanced End Users"))
        self.create_trove_cat((4,534,"sysadmins","System Administrators","Intended Audience :: by End-User Class :: System Administrators"))
        self.create_trove_cat((471,456,"ui_swing","Java Swing","User Interface :: Graphical :: Java Swing"))
        self.create_trove_cat((469,456,"ui_dotnet",".NET/Mono","User Interface :: Graphical :: .NET/Mono"))
        self.create_trove_cat((231,456,"gnome","Gnome","User Interface :: Graphical :: Gnome"))
        self.create_trove_cat((229,456,"x11","X Window System (X11)","User Interface :: Graphical :: X Window System (X11)"))
        self.create_trove_cat((475,456,"ui_opengl","OpenGL","User Interface :: Graphical :: OpenGL"))
        self.create_trove_cat((474,456,"ui_framebuffer","Framebuffer","User Interface :: Graphical :: Framebuffer"))
        self.create_trove_cat((472,456,"ui_swt","Java SWT","User Interface :: Graphical :: Java SWT"))
        self.create_trove_cat((470,456,"ui_awt","Java AWT","User Interface :: Graphical :: Java AWT"))
        self.create_trove_cat((230,456,"win32","Win32 (MS Windows)","User Interface :: Graphical :: Win32 (MS Windows)"))
        self.create_trove_cat((232,456,"kde","KDE","User Interface :: Graphical :: KDE"))
        self.create_trove_cat((310,456,"cocoa","Cocoa (MacOS X)","User Interface :: Graphical :: Cocoa (MacOS X)"))
        self.create_trove_cat((476,456,"ui_tabletpc","TabletPC","User Interface :: Graphical :: TabletPC"))
        self.create_trove_cat((314,456,"handhelds","Handheld/Mobile/PDA","User Interface :: Graphical :: Handheld/Mobile/PDA"))
        self.create_trove_cat((462,225,"ui_groupingdesc","Grouping and Descriptive Categories (UI)","User Interface :: Grouping and Descriptive Categories (UI)"))
        self.create_trove_cat((466,462,"ui_meta_3d","Project is a 3D engine","User Interface :: Grouping and Descriptive Categories (UI) :: Project is a 3D engine"))
        self.create_trove_cat((464,462,"ui_meta_template","Project is a templating system","User Interface :: Grouping and Descriptive Categories (UI) :: Project is a templating system"))
        self.create_trove_cat((463,462,"ui_meta_system","Project is a user interface (UI) system","User Interface :: Grouping and Descriptive Categories (UI) :: Project is a user interface (UI) system"))
        self.create_trove_cat((465,462,"ui_meta_windowmanager","Project is a window manager","User Interface :: Grouping and Descriptive Categories (UI) :: Project is a window manager"))
        self.create_trove_cat((467,462,"ui_meta_toolkit","Project is a graphics toolkit","User Interface :: Grouping and Descriptive Categories (UI) :: Project is a graphics toolkit"))
        self.create_trove_cat((468,462,"ui_meta_remotecontrol","Project is a remote control application","User Interface :: Grouping and Descriptive Categories (UI) :: Project is a remote control application"))
        self.create_trove_cat((237,225,"web","Web-based","User Interface :: Web-based"))
        self.create_trove_cat((238,225,"daemon","Non-interactive (Daemon)","User Interface :: Non-interactive (Daemon)"))
        self.create_trove_cat((457,225,"textual_ui","Textual","User Interface :: Textual"))
        self.create_trove_cat((460,457,"ui_consoleterm","Console/Terminal","User Interface :: Textual :: Console/Terminal"))
        self.create_trove_cat((459,457,"ui_commandline","Command-line","User Interface :: Textual :: Command-line"))
        self.create_trove_cat((225,0,"environment","User Interface","User Interface"))
        self.create_trove_cat((461,225,"ui_plugins","Plugins","User Interface :: Plugins"))
        self.create_trove_cat((583,461,"eclipse_plugins","Eclipse","User Interface :: Plugins :: Eclipse"))
        self.create_trove_cat((458,225,"ui_toolkit","Toolkits/Libraries","User Interface :: Toolkits/Libraries"))
        self.create_trove_cat((495,458,"ui_othertoolkit","Other toolkit","User Interface :: Toolkits/Libraries :: Other toolkit"))
        self.create_trove_cat((493,458,"ui_motif","Motif/LessTif","User Interface :: Toolkits/Libraries :: Motif/LessTif"))
        self.create_trove_cat((491,458,"ui_crystalspace","Crystal Space","User Interface :: Toolkits/Libraries :: Crystal Space"))
        self.create_trove_cat((489,458,"ui_clanlib","ClanLib","User Interface :: Toolkits/Libraries :: ClanLib"))
        self.create_trove_cat((516,500,"db_group_objmap","Project is a relational object mapper","Database Environment :: Grouping and Descriptive Categories (DB) :: Project is a relational object mapper"))
        self.create_trove_cat((487,458,"ui_ggi","GGI","User Interface :: Toolkits/Libraries :: GGI"))
        self.create_trove_cat((485,458,"ui_directx","DirectX","User Interface :: Toolkits/Libraries :: DirectX"))
        self.create_trove_cat((483,458,"ui_svgalib","SVGAlib","User Interface :: Toolkits/Libraries :: SVGAlib"))
        self.create_trove_cat((481,458,"ui_wxwidgets","wxWidgets","User Interface :: Toolkits/Libraries :: wxWidgets"))
        self.create_trove_cat((511,500,"db_group_mgmt","Project is a database management tool","Database Environment :: Grouping and Descriptive Categories (DB) :: Project is a database management tool"))
        self.create_trove_cat((479,458,"ui_qt","Qt","User Interface :: Toolkits/Libraries :: Qt"))
        self.create_trove_cat((477,458,"ui_gtk","GTK+","User Interface :: Toolkits/Libraries :: GTK+"))
        self.create_trove_cat((513,500,"db_group_netdbms","Project is a network-based DBMS (database system)","Database Environment :: Grouping and Descriptive Categories (DB) :: Project is a network-based DBMS (database system)"))
        self.create_trove_cat((228,458,"newt","Newt","User Interface :: Toolkits/Libraries :: Newt"))
        self.create_trove_cat((227,458,"curses","Curses/Ncurses","User Interface :: Toolkits/Libraries :: Curses/Ncurses"))
        self.create_trove_cat((515,500,"db_group_conv","Project is a database conversion tool","Database Environment :: Grouping and Descriptive Categories (DB) :: Project is a database conversion tool"))
        self.create_trove_cat((478,458,"ui_tk","Tk","User Interface :: Toolkits/Libraries :: Tk"))
        self.create_trove_cat((480,458,"ui_sdl","SDL","User Interface :: Toolkits/Libraries :: SDL"))
        self.create_trove_cat((33,28,"postoffice","Post-Office","Topic :: Communications :: Email :: Post-Office"))
        self.create_trove_cat((514,500,"db_group_propfmt","Project is a tool for a proprietary database file format","Database Environment :: Grouping and Descriptive Categories (DB) :: Project is a tool for a proprietary database file format"))
        self.create_trove_cat((482,458,"ui_aalib","AAlib","User Interface :: Toolkits/Libraries :: AAlib"))
        self.create_trove_cat((484,458,"ui_fltk","FLTK","User Interface :: Toolkits/Libraries :: FLTK"))
        self.create_trove_cat((512,500,"db_group_filedbms","Project is a file-based DBMS (database system)","Database Environment :: Grouping and Descriptive Categories (DB) :: Project is a file-based DBMS (database system)"))
        self.create_trove_cat((486,458,"ui_plib","Plib","User Interface :: Toolkits/Libraries :: Plib"))
        self.create_trove_cat((488,458,"ui_glide","Glide","User Interface :: Toolkits/Libraries :: Glide"))
        self.create_trove_cat((510,500,"db_group_api","Project is a database abstraction layer (API)","Database Environment :: Grouping and Descriptive Categories (DB) :: Project is a database abstraction layer (API)"))
        self.create_trove_cat((490,458,"ui_glut","GLUT","User Interface :: Toolkits/Libraries :: GLUT"))
        self.create_trove_cat((492,458,"ui_allegro","Allegro","User Interface :: Toolkits/Libraries :: Allegro"))
        self.create_trove_cat((500,496,"db_grouping","Grouping and Descriptive Categories (DB)","Database Environment :: Grouping and Descriptive Categories (DB)"))
        self.create_trove_cat((494,458,"ui_quartz","Quartz","User Interface :: Toolkits/Libraries :: Quartz"))
        self.create_trove_cat((456,225,"graphical_ui","Graphical","User Interface :: Graphical"))
        self.create_trove_cat((276,274,"french","French","Translations :: French"))
        self.create_trove_cat((473,456,"ui_carbon","Carbon (Mac OS X)","User Interface :: Graphical :: Carbon (Mac OS X)"))
        self.create_trove_cat((535,1,"by_industrysector","by Industry or Sector","Intended Audience :: by Industry or Sector"))
        self.create_trove_cat((364,535,"legalindustry","Legal Industry","Intended Audience :: by Industry or Sector :: Legal Industry"))
        self.create_trove_cat((353,274,"ukrainian","Ukrainian","Translations :: Ukrainian"))
        self.create_trove_cat((330,274,"dutch","Dutch","Translations :: Dutch"))
        self.create_trove_cat((343,274,"persian","Persian","Translations :: Persian"))
        self.create_trove_cat((344,274,"polish","Polish","Translations :: Polish"))
        self.create_trove_cat((455,274,"irish_gaelic","Irish Gaelic","Translations :: Irish Gaelic"))
        self.create_trove_cat((413,274,"lithuanian","Lithuanian","Translations :: Lithuanian"))
        self.create_trove_cat((414,274,"albanian","Albanian","Translations :: Albanian"))
        self.create_trove_cat((415,274,"malagasy","Malagasy","Translations :: Malagasy"))
        self.create_trove_cat((416,274,"mongolian","Mongolian","Translations :: Mongolian"))
        self.create_trove_cat((417,274,"maltese","Maltese","Translations :: Maltese"))
        self.create_trove_cat((380,274,"slovenian","Slovene","Translations :: Slovene"))
        self.create_trove_cat((374,274,"icelandic","Icelandic","Translations :: Icelandic"))
        self.create_trove_cat((376,274,"macedonian","Macedonian","Translations :: Macedonian"))
        self.create_trove_cat((377,274,"latin","Latin","Translations :: Latin"))
        self.create_trove_cat((375,274,"latvian","Latvian","Translations :: Latvian"))
        self.create_trove_cat((373,274,"czech","Czech","Translations :: Czech"))
        self.create_trove_cat((369,274,"afrikaans","Afrikaans","Translations :: Afrikaans"))
        self.create_trove_cat((357,274,"finnish","Finnish","Translations :: Finnish"))
        self.create_trove_cat((186,160,"visualbasic","Visual Basic","Programming Language :: Visual Basic"))
        self.create_trove_cat((505,499,"db_pear","PHP Pear::DB","Database Environment :: Database API :: PHP Pear::DB"))
        self.create_trove_cat((507,499,"db_api_xml","XML-based","Database Environment :: Database API :: XML-based"))
        self.create_trove_cat((509,499,"db_api_other","Other API","Database Environment :: Database API :: Other API"))
        self.create_trove_cat((532,497,"db_net_hsql","HSQL","Database Environment :: Network-based DBMS :: HSQL"))
        self.create_trove_cat((547,160,"applescript","AppleScript","Programming Language :: AppleScript"))
        self.create_trove_cat((173,160,"modula","Modula","Programming Language :: Modula"))
        self.create_trove_cat((337,274,"italian","Italian","Translations :: Italian"))
        self.create_trove_cat((333,274,"hebrew","Hebrew","Translations :: Hebrew"))
        self.create_trove_cat((331,274,"esperanto","Esperanto","Translations :: Esperanto"))
        self.create_trove_cat((329,274,"catalan","Catalan","Translations :: Catalan"))
        self.create_trove_cat((327,274,"bengali","Bengali","Translations :: Bengali"))
        self.create_trove_cat((332,274,"greek","Greek","Translations :: Greek"))
        self.create_trove_cat((341,274,"marathi","Marathi","Translations :: Marathi"))
        self.create_trove_cat((355,274,"vietnamese","Vietnamese","Translations :: Vietnamese"))
        self.create_trove_cat((275,274,"english","English","Translations :: English"))
        self.create_trove_cat((345,274,"portuguese","Portuguese","Translations :: Portuguese"))
        self.create_trove_cat((171,160,"logo","Logo","Programming Language :: Logo"))
        self.create_trove_cat((502,499,"db_api_jdbc","JDBC","Database Environment :: Database API :: JDBC"))
        self.create_trove_cat((504,499,"db_api_perldbi","Perl DBI/DBD","Database Environment :: Database API :: Perl DBI/DBD"))
        self.create_trove_cat((274,0,"natlanguage","Translations","Translations"))
        self.create_trove_cat((506,499,"db_python","Python Database API","Database Environment :: Database API :: Python Database API"))
        self.create_trove_cat((526,497,"db_net_oracle","Oracle","Database Environment :: Network-based DBMS :: Oracle"))
        self.create_trove_cat((524,497,"db_net_mysql","MySQL","Database Environment :: Network-based DBMS :: MySQL"))
        self.create_trove_cat((525,497,"db_net_pgsql","PostgreSQL (pgsql)","Database Environment :: Network-based DBMS :: PostgreSQL (pgsql)"))
        self.create_trove_cat((527,497,"db_net_ibmdb2","IBM DB2","Database Environment :: Network-based DBMS :: IBM DB2"))
        self.create_trove_cat((529,497,"db_net_sybase","Sybase","Database Environment :: Network-based DBMS :: Sybase"))
        self.create_trove_cat((531,497,"db_net_sqlite","SQLite","Database Environment :: Network-based DBMS :: SQLite"))
        self.create_trove_cat((533,497,"db_net_other","Other network-based DBMS","Database Environment :: Network-based DBMS :: Other network-based DBMS"))
        self.create_trove_cat((497,496,"db_networkbased","Network-based DBMS","Database Environment :: Network-based DBMS"))
        self.create_trove_cat((426,199,"os_emu_api","Emulation and API Compatibility","Operating System :: Emulation and API Compatibility"))
        self.create_trove_cat((311,236,"macos9","Apple Mac OS Classic","Operating System :: Other Operating Systems :: Apple Mac OS Classic"))
        self.create_trove_cat((224,236,"beos","BeOS","Operating System :: Other Operating Systems :: BeOS"))
        self.create_trove_cat((215,236,"msdos","MS-DOS","Operating System :: Other Operating Systems :: MS-DOS"))
        self.create_trove_cat((421,236,"mswin_95","Win95","Operating System :: Other Operating Systems :: Win95"))
        self.create_trove_cat((508,499,"db_api_sql","SQL-based","Database Environment :: Database API :: SQL-based"))
        self.create_trove_cat((499,496,"db_api","Database API","Database Environment :: Database API"))
        self.create_trove_cat((378,274,"serbian","Serbian","Translations :: Serbian"))
        self.create_trove_cat((379,274,"slovak","Slovak","Translations :: Slovak"))
        self.create_trove_cat((371,274,"chinesetraditional","Chinese (Traditional)","Translations :: Chinese (Traditional)"))
        self.create_trove_cat((410,274,"belarusian","Belarusian","Translations :: Belarusian"))
        self.create_trove_cat((411,274,"estonian","Estonian","Translations :: Estonian"))
        self.create_trove_cat((412,274,"galician","Galician","Translations :: Galician"))
        self.create_trove_cat((34,33,"pop3","POP3","Topic :: Communications :: Email :: Post-Office :: POP3"))
        self.create_trove_cat((35,33,"imap","IMAP","Topic :: Communications :: Email :: Post-Office :: IMAP"))
        self.create_trove_cat((29,28,"filters","Filters","Topic :: Communications :: Email :: Filters"))
        self.create_trove_cat((30,28,"listservers","Mailing List Servers","Topic :: Communications :: Email :: Mailing List Servers"))
        self.create_trove_cat((597,80,"card_games","Card Games","Topic :: Games/Entertainment :: Card Games"))
        self.create_trove_cat((63,18,"editors","Text Editors","Topic :: Text Editors"))
        self.create_trove_cat((366,535,"religion","Religion","Intended Audience :: by Industry or Sector :: Religion"))
        self.create_trove_cat((534,1,"by_enduser","by End-User Class","Intended Audience :: by End-User Class"))
        self.create_trove_cat((528,497,"db_net_firebird","Firebird/InterBase","Database Environment :: Network-based DBMS :: Firebird/InterBase"))
        self.create_trove_cat((3,534,"developers","Developers","Intended Audience :: by End-User Class :: Developers"))
        self.create_trove_cat((530,497,"db_net_mssql","Microsoft SQL Server","Database Environment :: Network-based DBMS :: Microsoft SQL Server"))
        self.create_trove_cat((2,534,"endusers","End Users/Desktop","Intended Audience :: by End-User Class :: End Users/Desktop"))
        self.create_trove_cat((498,496,"db_filebased","File-based DBMS","Database Environment :: File-based DBMS"))
        self.create_trove_cat((537,534,"enduser_qa","Quality Engineers","Intended Audience :: by End-User Class :: Quality Engineers"))
        self.create_trove_cat((5,1,"other","Other Audience","Intended Audience :: Other Audience"))
        self.create_trove_cat((517,498,"db_file_dbm","Berkeley/Sleepycat/Gdbm (DBM)","Database Environment :: File-based DBMS :: Berkeley/Sleepycat/Gdbm (DBM)"))
        self.create_trove_cat((358,6,"inactive","7 - Inactive","Development Status :: 7 - Inactive"))
        self.create_trove_cat((520,498,"db_file_palm","PalmOS PDB","Database Environment :: File-based DBMS :: PalmOS PDB"))
        self.create_trove_cat((523,498,"db_file_other","Other file-based DBMS","Database Environment :: File-based DBMS :: Other file-based DBMS"))
        self.create_trove_cat((165,160,"cpp","C++","Programming Language :: C++"))
        self.create_trove_cat((163,160,"ada","Ada","Programming Language :: Ada"))
        self.create_trove_cat((328,274,"bulgarian","Bulgarian","Translations :: Bulgarian"))
        self.create_trove_cat((546,274,"swahili","Swahili","Translations :: Swahili"))
        self.create_trove_cat((348,274,"swedish","Swedish","Translations :: Swedish"))
        self.create_trove_cat((350,274,"telugu","Telugu","Translations :: Telugu"))
        self.create_trove_cat((162,160,"assembly","Assembly","Programming Language :: Assembly"))
        self.create_trove_cat((164,160,"c","C","Programming Language :: C"))
        self.create_trove_cat((161,160,"apl","APL","Programming Language :: APL"))
        self.create_trove_cat((267,160,"zope","Zope","Programming Language :: Zope"))
        self.create_trove_cat((264,160,"erlang","Erlang","Programming Language :: Erlang"))
        self.create_trove_cat((263,160,"euphoria","Euphoria","Programming Language :: Euphoria"))
        self.create_trove_cat((183,160,"php","PHP","Programming Language :: PHP"))
        self.create_trove_cat((182,160,"tcl","Tcl","Programming Language :: Tcl"))
        self.create_trove_cat((181,160,"smalltalk","Smalltalk","Programming Language :: Smalltalk"))
        self.create_trove_cat((180,160,"simula","Simula","Programming Language :: Simula"))
        self.create_trove_cat((174,160,"objectivec","Objective C","Programming Language :: Objective C"))
        self.create_trove_cat((560,160,"xsl","XSL (XSLT/XPath/XSL-FO)","Programming Language :: XSL (XSLT/XPath/XSL-FO)"))
        self.create_trove_cat((293,160,"ruby","Ruby","Programming Language :: Ruby"))
        self.create_trove_cat((265,160,"Delphi","Delphi/Kylix","Programming Language :: Delphi/Kylix"))
        self.create_trove_cat((281,160,"REBOL","REBOL","Programming Language :: REBOL"))
        self.create_trove_cat((454,160,"ocaml","OCaml (Objective Caml)","Programming Language :: OCaml (Objective Caml)"))
        self.create_trove_cat((453,160,"vb_net","Visual Basic .NET","Programming Language :: Visual Basic .NET"))
        self.create_trove_cat((452,160,"visual_foxpro","Visual FoxPro","Programming Language :: Visual FoxPro"))
        self.create_trove_cat((451,160,"haskell","Haskell","Programming Language :: Haskell"))
        self.create_trove_cat((450,160,"lua","Lua","Programming Language :: Lua"))
        self.create_trove_cat((280,160,"JavaScript","JavaScript","Programming Language :: JavaScript"))
        self.create_trove_cat((262,160,"coldfusion","Cold Fusion","Programming Language :: Cold Fusion"))
        self.create_trove_cat((261,160,"xbasic","XBasic","Programming Language :: XBasic"))
        self.create_trove_cat((258,160,"objectpascal","Object Pascal","Programming Language :: Object Pascal"))
        self.create_trove_cat((539,160,"proglang_basic","BASIC","Programming Language :: BASIC"))
        self.create_trove_cat((543,160,"groovy","Groovy","Programming Language :: Groovy"))
        self.create_trove_cat((545,160,"proglang_labview","LabVIEW","Programming Language :: LabVIEW"))
        self.create_trove_cat((548,160,"vbscript","VBScript","Programming Language :: VBScript"))
        self.create_trove_cat((552,160,"d_proglang","D","Programming Language :: D"))
        self.create_trove_cat((551,160,"vhdl_verilog","VHDL/Verilog","Programming Language :: VHDL/Verilog"))
        self.create_trove_cat((549,160,"proglang_lpc","LPC","Programming Language :: LPC"))
        self.create_trove_cat((544,160,"yacc","Yacc","Programming Language :: Yacc"))
        self.create_trove_cat((352,274,"turkish","Turkish","Translations :: Turkish"))
        self.create_trove_cat((354,274,"urdu","Urdu","Translations :: Urdu"))
        self.create_trove_cat((160,0,"language","Programming Language","Programming Language"))
        self.create_trove_cat((542,160,"emacs_lisp","Emacs-Lisp","Programming Language :: Emacs-Lisp"))
        self.create_trove_cat((540,160,"clisp","Common Lisp","Programming Language :: Common Lisp"))
        self.create_trove_cat((12,6,"mature","6 - Mature","Development Status :: 6 - Mature"))
        self.create_trove_cat((538,160,"awk","AWK","Programming Language :: AWK"))
        self.create_trove_cat((572,160,"jsp","JSP","Programming Language :: JSP"))
        self.create_trove_cat((172,160,"ml","Standard ML","Programming Language :: Standard ML"))
        self.create_trove_cat((255,160,"progress","PROGRESS","Programming Language :: PROGRESS"))
        self.create_trove_cat((254,160,"plsql","PL/SQL","Programming Language :: PL/SQL"))
        self.create_trove_cat((242,160,"scheme","Scheme","Programming Language :: Scheme"))
        self.create_trove_cat((624,160,"idl","IDL","Programming Language :: IDL"))
        self.create_trove_cat((198,160,"java","Java","Programming Language :: Java"))
        self.create_trove_cat((589,160,"asp_dot_net","ASP.NET","Programming Language :: ASP.NET"))
        self.create_trove_cat((608,160,"mumps","MUMPS","Programming Language :: MUMPS"))
        self.create_trove_cat((541,160,"dylan","Dylan","Programming Language :: Dylan"))
        self.create_trove_cat((573,160,"s_slash_r","S/R","Programming Language :: S/R"))
        self.create_trove_cat((584,160,"actionscript","ActionScript","Programming Language :: ActionScript"))
        self.create_trove_cat((168,160,"forth","Forth","Programming Language :: Forth"))
        self.create_trove_cat((334,274,"hindi","Hindi","Translations :: Hindi"))
        self.create_trove_cat((336,274,"indonesian","Indonesian","Translations :: Indonesian"))
        self.create_trove_cat((521,498,"db_file_flat","Flat-file","Database Environment :: File-based DBMS :: Flat-file"))
        self.create_trove_cat((519,498,"db_file_xbase","xBase","Database Environment :: File-based DBMS :: xBase"))
        self.create_trove_cat((338,274,"javanese","Javanese","Translations :: Javanese"))
        self.create_trove_cat((518,498,"db_msaccess","Microsoft Access","Database Environment :: File-based DBMS :: Microsoft Access"))
        self.create_trove_cat((522,498,"db_file_proprietary","Proprietary file format","Database Environment :: File-based DBMS :: Proprietary file format"))
        self.create_trove_cat((496,0,"root_database","Database Environment","Database Environment"))
        self.create_trove_cat((501,499,"db_api_odbc","ODBC","Database Environment :: Database API :: ODBC"))
        self.create_trove_cat((503,499,"db_adodb","ADOdb","Database Environment :: Database API :: ADOdb"))
        self.create_trove_cat((340,274,"malay","Malay","Translations :: Malay"))
        self.create_trove_cat((6,0,"developmentstatus","Development Status","Development Status"))
        self.create_trove_cat((342,274,"norwegian","Norwegian","Translations :: Norwegian"))
        self.create_trove_cat((381,274,"portuguesebrazilian","Brazilian Portuguese","Translations :: Brazilian Portuguese"))
        self.create_trove_cat((382,274,"chinesesimplified","Chinese (Simplified)","Translations :: Chinese (Simplified)"))
        self.create_trove_cat((356,274,"danish","Danish","Translations :: Danish"))
        self.create_trove_cat((346,274,"panjabi","Panjabi","Translations :: Panjabi"))
        self.create_trove_cat((370,274,"bosnian","Bosnian","Translations :: Bosnian"))
        self.create_trove_cat((279,274,"german","German","Translations :: German"))
        self.create_trove_cat((278,274,"japanese","Japanese","Translations :: Japanese"))
        self.create_trove_cat((277,274,"spanish","Spanish","Translations :: Spanish"))
        self.create_trove_cat((11,6,"production","5 - Production/Stable","Development Status :: 5 - Production/Stable"))
        self.create_trove_cat((10,6,"beta","4 - Beta","Development Status :: 4 - Beta"))
        self.create_trove_cat((9,6,"alpha","3 - Alpha","Development Status :: 3 - Alpha"))
        self.create_trove_cat((8,6,"prealpha","2 - Pre-Alpha","Development Status :: 2 - Pre-Alpha"))
        self.create_trove_cat((7,6,"planning","1 - Planning","Development Status :: 1 - Planning"))
        self.create_trove_cat((295,274,"russian","Russian","Translations :: Russian"))
        self.create_trove_cat((326,274,"arabic","Arabic","Translations :: Arabic"))
        self.create_trove_cat((335,274,"hungarian","Hungarian","Translations :: Hungarian"))
        self.create_trove_cat((13,0,"license","License","License"))
        self.create_trove_cat((14,13,"osi","OSI-Approved Open Source","License :: OSI-Approved Open Source"))
        self.create_trove_cat((388,14,"osl","Open Software License","License :: OSI-Approved Open Source :: Open Software License"))
        self.create_trove_cat((321,14,"motosoto","Motosoto License","License :: OSI-Approved Open Source :: Motosoto License"))
        self.create_trove_cat((325,14,"attribut","Attribution Assurance License","License :: OSI-Approved Open Source :: Attribution Assurance License"))
        self.create_trove_cat((304,14,"mpl","Mozilla Public License 1.0 (MPL)","License :: OSI-Approved Open Source :: Mozilla Public License 1.0 (MPL)"))
        self.create_trove_cat((398,14,"plan9","Lucent Public License (Plan9)","License :: OSI-Approved Open Source :: Lucent Public License (Plan9)"))
        self.create_trove_cat((187,14,"bsd","BSD License","License :: OSI-Approved Open Source :: BSD License"))
        self.create_trove_cat((393,14,"historical","Historical Permission Notice and Disclaimer","License :: OSI-Approved Open Source :: Historical Permission Notice and Disclaimer"))
        self.create_trove_cat((395,14,"real","RealNetworks Public Source License V1.0","License :: OSI-Approved Open Source :: RealNetworks Public Source License V1.0"))
        self.create_trove_cat((396,14,"rpl","Reciprocal Public License","License :: OSI-Approved Open Source :: Reciprocal Public License"))
        self.create_trove_cat((392,14,"eiffel2","Eiffel Forum License V2.0","License :: OSI-Approved Open Source :: Eiffel Forum License V2.0"))
        self.create_trove_cat((320,14,"w3c","W3C License","License :: OSI-Approved Open Source :: W3C License"))
        self.create_trove_cat((400,14,"frameworx","Frameworx Open License","License :: OSI-Approved Open Source :: Frameworx Open License"))
        self.create_trove_cat((194,14,"python","Python License (CNRI Python License)","License :: OSI-Approved Open Source :: Python License (CNRI Python License)"))
        self.create_trove_cat((296,14,"apache","Apache Software License","License :: OSI-Approved Open Source :: Apache Software License"))
        self.create_trove_cat((298,14,"sissl","Sun Industry Standards Source License (SISSL)","License :: OSI-Approved Open Source :: Sun Industry Standards Source License (SISSL)"))
        self.create_trove_cat((196,13,"other","Other/Proprietary License","License :: Other/Proprietary License"))
        self.create_trove_cat((197,13,"publicdomain","Public Domain","License :: Public Domain"))
        self.create_trove_cat((301,14,"nokia","Nokia Open Source License","License :: OSI-Approved Open Source :: Nokia Open Source License"))
        self.create_trove_cat((319,14,"eiffel","Eiffel Forum License","License :: OSI-Approved Open Source :: Eiffel Forum License"))
        self.create_trove_cat((318,14,"sunpublic","Sun Public License","License :: OSI-Approved Open Source :: Sun Public License"))
        self.create_trove_cat((190,14,"qpl","Qt Public License (QPL)","License :: OSI-Approved Open Source :: Qt Public License (QPL)"))
        self.create_trove_cat((390,14,"oclc","OCLC Research Public License 2.0","License :: OSI-Approved Open Source :: OCLC Research Public License 2.0"))
        self.create_trove_cat((407,14,"nasalicense","NASA Open Source Agreement","License :: OSI-Approved Open Source :: NASA Open Source Agreement"))
        self.create_trove_cat((406,14,"eclipselicense","Eclipse Public License","License :: OSI-Approved Open Source :: Eclipse Public License"))
        self.create_trove_cat((316,14,"opengroup","Open Group Test Suite License","License :: OSI-Approved Open Source :: Open Group Test Suite License"))
        self.create_trove_cat((300,14,"jabber","Jabber Open Source License","License :: OSI-Approved Open Source :: Jabber Open Source License"))
        self.create_trove_cat((297,14,"vovida","Vovida Software License 1.0","License :: OSI-Approved Open Source :: Vovida Software License 1.0"))
        self.create_trove_cat((324,14,"afl","Academic Free License (AFL)","License :: OSI-Approved Open Source :: Academic Free License (AFL)"))
        self.create_trove_cat((189,14,"psfl","Python Software Foundation License","License :: OSI-Approved Open Source :: Python Software Foundation License"))
        self.create_trove_cat((193,14,"rscpl","Ricoh Source Code Public License","License :: OSI-Approved Open Source :: Ricoh Source Code Public License"))
        self.create_trove_cat((17,14,"artistic","Artistic License","License :: OSI-Approved Open Source :: Artistic License"))
        self.create_trove_cat((389,14,"sybase","Sybase Open Watcom Public License","License :: OSI-Approved Open Source :: Sybase Open Watcom Public License"))
        self.create_trove_cat((391,14,"wxwindows","wxWindows Library Licence","License :: OSI-Approved Open Source :: wxWindows Library Licence"))
        self.create_trove_cat((397,14,"entessa","Entessa Public License","License :: OSI-Approved Open Source :: Entessa Public License"))
        self.create_trove_cat((16,14,"lgpl","GNU Library or Lesser General Public License (LGPL)","License :: OSI-Approved Open Source :: GNU Library or Lesser General Public License (LGPL)"))
        self.create_trove_cat((629,14,"educom","Educational Community License","License :: OSI-Approved Open Source :: Educational Community License"))
        self.create_trove_cat((15,14,"gpl","GNU General Public License (GPL)","License :: OSI-Approved Open Source :: GNU General Public License (GPL)"))
        self.create_trove_cat((191,14,"ibm","IBM Public License","License :: OSI-Approved Open Source :: IBM Public License"))
        self.create_trove_cat((192,14,"cvw","MITRE Collaborative Virtual Workspace License (CVW)","License :: OSI-Approved Open Source :: MITRE Collaborative Virtual Workspace License (CVW)"))
        self.create_trove_cat((299,14,"iosl","Intel Open Source License","License :: OSI-Approved Open Source :: Intel Open Source License"))
        self.create_trove_cat((399,14,"php-license","PHP License","License :: OSI-Approved Open Source :: PHP License"))
        self.create_trove_cat((188,14,"mit","MIT License","License :: OSI-Approved Open Source :: MIT License"))
        self.create_trove_cat((405,14,"public102","Lucent Public License Version 1.02","License :: OSI-Approved Open Source :: Lucent Public License Version 1.02"))
        self.create_trove_cat((404,14,"fair","Fair License","License :: OSI-Approved Open Source :: Fair License"))
        self.create_trove_cat((403,14,"datagrid","EU DataGrid Software License","License :: OSI-Approved Open Source :: EU DataGrid Software License"))
        self.create_trove_cat((307,14,"ibmcpl","Common Public License","License :: OSI-Approved Open Source :: Common Public License"))
        self.create_trove_cat((402,14,"cua","CUA Office Public License Version 1.0","License :: OSI-Approved Open Source :: CUA Office Public License Version 1.0"))
        self.create_trove_cat((401,14,"apache2","Apache License V2.0","License :: OSI-Approved Open Source :: Apache License V2.0"))
        self.create_trove_cat((394,14,"nausite","Naumen Public License","License :: OSI-Approved Open Source :: Naumen Public License"))
        self.create_trove_cat((317,14,"xnet","X.Net License","License :: OSI-Approved Open Source :: X.Net License"))
        self.create_trove_cat((195,14,"zlib","zlib/libpng License","License :: OSI-Approved Open Source :: zlib/libpng License"))
        self.create_trove_cat((323,14,"ncsa","University of Illinois/NCSA Open Source License","License :: OSI-Approved Open Source :: University of Illinois/NCSA Open Source License"))
        self.create_trove_cat((322,14,"zope","Zope Public License","License :: OSI-Approved Open Source :: Zope Public License"))
        self.create_trove_cat((302,14,"sleepycat","Sleepycat License","License :: OSI-Approved Open Source :: Sleepycat License"))
        self.create_trove_cat((303,14,"nethack","Nethack General Public License","License :: OSI-Approved Open Source :: Nethack General Public License"))
        self.create_trove_cat((306,14,"apsl","Apple Public Source License","License :: OSI-Approved Open Source :: Apple Public Source License"))
        self.create_trove_cat((305,14,"mpl11","Mozilla Public License 1.1 (MPL 1.1)","License :: OSI-Approved Open Source :: Mozilla Public License 1.1 (MPL 1.1)"))
        self.create_trove_cat((628,14,"adaptive","Adaptive Public License","License :: OSI-Approved Open Source :: Adaptive Public License"))
        self.create_trove_cat((630,14,"cddl","Common Development and Distribution License","License :: OSI-Approved Open Source :: Common Development and Distribution License"))
        self.create_trove_cat((631,14,"catosl","Computer Associates Trusted Open Source License","License :: OSI-Approved Open Source :: Computer Associates Trusted Open Source License"))
        self.create_trove_cat((199,0,"os","Operating System","Operating System"))
        self.create_trove_cat((429,426,"fink","Fink (Mac OS X)","Operating System :: Emulation and API Compatibility :: Fink (Mac OS X)"))
        self.create_trove_cat((427,426,"cygwin","Cygwin (MS Windows)","Operating System :: Emulation and API Compatibility :: Cygwin (MS Windows)"))
        self.create_trove_cat((428,426,"dosemu","DOSEMU","Operating System :: Emulation and API Compatibility :: DOSEMU"))
        self.create_trove_cat((430,426,"wine","WINE","Operating System :: Emulation and API Compatibility :: WINE"))
        self.create_trove_cat((431,426,"emx","EMX (OS/2 and MS-DOS)","Operating System :: Emulation and API Compatibility :: EMX (OS/2 and MS-DOS)"))
        self.create_trove_cat((445,426,"mingw_msys","MinGW/MSYS (MS Windows)","Operating System :: Emulation and API Compatibility :: MinGW/MSYS (MS Windows)"))
        self.create_trove_cat((315,199,"pdasystems","Handheld/Embedded Operating Systems","Operating System :: Handheld/Embedded Operating Systems"))
        self.create_trove_cat((222,315,"wince","WinCE","Operating System :: Handheld/Embedded Operating Systems :: WinCE"))
        self.create_trove_cat((223,315,"palmos","PalmOS","Operating System :: Handheld/Embedded Operating Systems :: PalmOS"))
        self.create_trove_cat((441,315,"ecos","eCos","Operating System :: Handheld/Embedded Operating Systems :: eCos"))
        self.create_trove_cat((443,315,"vxworks","VxWorks","Operating System :: Handheld/Embedded Operating Systems :: VxWorks"))
        self.create_trove_cat((444,315,"symbianos","SymbianOS","Operating System :: Handheld/Embedded Operating Systems :: SymbianOS"))
        self.create_trove_cat((442,315,"qnx","QNX","Operating System :: Handheld/Embedded Operating Systems :: QNX"))
        self.create_trove_cat((440,315,"uclinux","uClinux","Operating System :: Handheld/Embedded Operating Systems :: uClinux"))
        self.create_trove_cat((418,199,"modern_oses","Modern (Vendor-Supported) Desktop Operating Systems","Operating System :: Modern (Vendor-Supported) Desktop Operating Systems"))
        self.create_trove_cat((420,418,"mswin_2000","Win2K","Operating System :: Modern (Vendor-Supported) Desktop Operating Systems :: Win2K"))
        self.create_trove_cat((207,418,"sun","Solaris","Operating System :: Modern (Vendor-Supported) Desktop Operating Systems :: Solaris"))
        self.create_trove_cat((201,418,"linux","Linux","Operating System :: Modern (Vendor-Supported) Desktop Operating Systems :: Linux"))
        self.create_trove_cat((205,418,"openbsd","OpenBSD","Operating System :: Modern (Vendor-Supported) Desktop Operating Systems :: OpenBSD"))
        self.create_trove_cat((203,418,"freebsd","FreeBSD","Operating System :: Modern (Vendor-Supported) Desktop Operating Systems :: FreeBSD"))
        self.create_trove_cat((204,418,"netbsd","NetBSD","Operating System :: Modern (Vendor-Supported) Desktop Operating Systems :: NetBSD"))
        self.create_trove_cat((309,418,"macosx","OS X","Operating System :: Modern (Vendor-Supported) Desktop Operating Systems :: OS X"))
        self.create_trove_cat((419,418,"mswin_xp","WinXP","Operating System :: Modern (Vendor-Supported) Desktop Operating Systems :: WinXP"))
        self.create_trove_cat((236,199,"other","Other Operating Systems","Operating System :: Other Operating Systems"))
        self.create_trove_cat((206,236,"bsdos","BSD/OS","Operating System :: Other Operating Systems :: BSD/OS"))
        self.create_trove_cat((634,236,"console-platforms","Console-based Platforms","Operating System :: Other Operating Systems :: Console-based Platforms"))
        self.create_trove_cat((637,634,"sega-dreamcast","Sega Dreamcast","Operating System :: Other Operating Systems :: Console-based Platforms :: Sega Dreamcast"))
        self.create_trove_cat((635,634,"xbox","Microsoft Xbox","Operating System :: Other Operating Systems :: Console-based Platforms :: Microsoft Xbox"))
        self.create_trove_cat((636,634,"sony-ps2","Sony Playstation 2","Operating System :: Other Operating Systems :: Console-based Platforms :: Sony Playstation 2"))
        self.create_trove_cat((422,236,"mswin_98","Win98","Operating System :: Other Operating Systems :: Win98"))
        self.create_trove_cat((425,422,"mswin_98_osr2","Win98 OSR2","Operating System :: Other Operating Systems :: Win98 :: Win98 OSR2"))
        self.create_trove_cat((424,236,"mswin_me","WinME","Operating System :: Other Operating Systems :: WinME"))
        self.create_trove_cat((423,236,"mswin_nt","WinNT","Operating System :: Other Operating Systems :: WinNT"))
        self.create_trove_cat((220,236,"os2","IBM OS/2","Operating System :: Other Operating Systems :: IBM OS/2"))
        self.create_trove_cat((211,236,"irix","SGI IRIX","Operating System :: Other Operating Systems :: SGI IRIX"))
        self.create_trove_cat((210,236,"aix","IBM AIX","Operating System :: Other Operating Systems :: IBM AIX"))
        self.create_trove_cat((212,236,"other","Other","Operating System :: Other Operating Systems :: Other"))
        self.create_trove_cat((446,236,"openvms","OpenVMS","Operating System :: Other Operating Systems :: OpenVMS"))
        self.create_trove_cat((434,236,"amigaos","AmigaOS","Operating System :: Other Operating Systems :: AmigaOS"))
        self.create_trove_cat((448,236,"mswin_server2003","Microsoft Windows Server 2003","Operating System :: Other Operating Systems :: Microsoft Windows Server 2003"))
        self.create_trove_cat((447,236,"morphos","MorphOS","Operating System :: Other Operating Systems :: MorphOS"))
        self.create_trove_cat((209,236,"hpux","HP-UX","Operating System :: Other Operating Systems :: HP-UX"))
        self.create_trove_cat((208,236,"sco","SCO","Operating System :: Other Operating Systems :: SCO"))
        self.create_trove_cat((240,236,"gnuhurd","GNU Hurd","Operating System :: Other Operating Systems :: GNU Hurd"))
        self.create_trove_cat((217,236,"win31","Microsoft Windows 3.x","Operating System :: Other Operating Systems :: Microsoft Windows 3.x"))
        self.create_trove_cat((432,199,"os_groups","Grouping and Descriptive Categories","Operating System :: Grouping and Descriptive Categories"))
        self.create_trove_cat((218,432,"win95","32-bit MS Windows (95/98)","Operating System :: Grouping and Descriptive Categories :: 32-bit MS Windows (95/98)"))
        self.create_trove_cat((439,432,"os_projectdistrospecific","Project is OS Distribution-Specific","Operating System :: Grouping and Descriptive Categories :: Project is OS Distribution-Specific"))
        self.create_trove_cat((449,432,"eightbit_oses","Classic 8-bit Operating Systems (Apple, Atari, Commodore, etc.)","Operating System :: Grouping and Descriptive Categories :: Classic 8-bit Operating Systems (Apple, Atari, Commodore, etc.)"))
        self.create_trove_cat((436,432,"os_portable","OS Portable (Source code to work with many OS platforms)","Operating System :: Grouping and Descriptive Categories :: OS Portable (Source code to work with many OS platforms)"))
        self.create_trove_cat((438,432,"os_projectdistro","Project is an Operating System Distribution","Operating System :: Grouping and Descriptive Categories :: Project is an Operating System Distribution"))
        self.create_trove_cat((235,432,"independent","OS Independent (Written in an interpreted language)","Operating System :: Grouping and Descriptive Categories :: OS Independent (Written in an interpreted language)"))
        self.create_trove_cat((200,432,"posix","All POSIX (Linux/BSD/UNIX-like OSes)","Operating System :: Grouping and Descriptive Categories :: All POSIX (Linux/BSD/UNIX-like OSes)"))
        self.create_trove_cat((219,432,"winnt","32-bit MS Windows (NT/2000/XP)","Operating System :: Grouping and Descriptive Categories :: 32-bit MS Windows (NT/2000/XP)"))
        self.create_trove_cat((202,432,"bsd","All BSD Platforms (FreeBSD/NetBSD/OpenBSD/Apple Mac OS X)","Operating System :: Grouping and Descriptive Categories :: All BSD Platforms (FreeBSD/NetBSD/OpenBSD/Apple Mac OS X)"))
        self.create_trove_cat((435,432,"mswin_all32bit","All 32-bit MS Windows (95/98/NT/2000/XP)","Operating System :: Grouping and Descriptive Categories :: All 32-bit MS Windows (95/98/NT/2000/XP)"))
        self.create_trove_cat((437,432,"os_projectkernel","Project is an Operating System Kernel","Operating System :: Grouping and Descriptive Categories :: Project is an Operating System Kernel"))
        self.create_trove_cat((64,63,"emacs","Emacs","Topic :: Text Editors :: Emacs"))
        self.create_trove_cat((65,63,"ide","Integrated Development Environments (IDE)","Topic :: Text Editors :: Integrated Development Environments (IDE)"))
        self.create_trove_cat((69,63,"documentation","Documentation","Topic :: Text Editors :: Documentation"))
        self.create_trove_cat((70,63,"wordprocessors","Word Processors","Topic :: Text Editors :: Word Processors"))
        self.create_trove_cat((285,63,"textprocessing","Text Processing","Topic :: Text Editors :: Text Processing"))
        self.create_trove_cat((611,18,"formats_and_protocols","Formats and Protocols","Topic :: Formats and Protocols"))
        self.create_trove_cat((554,611,"data_formats","Data Formats","Topic :: Formats and Protocols :: Data Formats"))
        self.create_trove_cat((559,554,"xml","XML","Topic :: Formats and Protocols :: Data Formats :: XML"))
        self.create_trove_cat((557,554,"sgml","SGML","Topic :: Formats and Protocols :: Data Formats :: SGML"))
        self.create_trove_cat((555,554,"docbook","DocBook","Topic :: Formats and Protocols :: Data Formats :: DocBook"))
        self.create_trove_cat((556,554,"html_xhtml","HTML/XHTML","Topic :: Formats and Protocols :: Data Formats :: HTML/XHTML"))
        self.create_trove_cat((558,554,"tex_latex","TeX/LaTeX","Topic :: Formats and Protocols :: Data Formats :: TeX/LaTeX"))
        self.create_trove_cat((612,611,"protocols","Protocols","Topic :: Formats and Protocols :: Protocols"))
        self.create_trove_cat((616,612,"xml_rpc","XML-RPC","Topic :: Formats and Protocols :: Protocols :: XML-RPC"))
        self.create_trove_cat((614,612,"nntp","NNTP","Topic :: Formats and Protocols :: Protocols :: NNTP"))
        self.create_trove_cat((613,612,"soap","SOAP","Topic :: Formats and Protocols :: Protocols :: SOAP"))
        self.create_trove_cat((615,612,"rss","RSS","Topic :: Formats and Protocols :: Protocols :: RSS"))
        self.create_trove_cat((156,18,"terminals","Terminals","Topic :: Terminals"))
        self.create_trove_cat((157,156,"serial","Serial","Topic :: Terminals :: Serial"))
        self.create_trove_cat((158,156,"virtual","Terminal Emulators/X Terminals","Topic :: Terminals :: Terminal Emulators/X Terminals"))
        self.create_trove_cat((159,156,"telnet","Telnet","Topic :: Terminals :: Telnet"))
        self.create_trove_cat((20,18,"communications","Communications","Topic :: Communications"))
        self.create_trove_cat((37,20,"fido","FIDO","Topic :: Communications :: FIDO"))
        self.create_trove_cat((38,20,"hamradio","Ham Radio","Topic :: Communications :: Ham Radio"))
        self.create_trove_cat((39,20,"usenet","Usenet News","Topic :: Communications :: Usenet News"))
        self.create_trove_cat((40,20,"internetphone","Internet Phone","Topic :: Communications :: Internet Phone"))
        self.create_trove_cat((36,20,"fax","Fax","Topic :: Communications :: Fax"))
        self.create_trove_cat((22,20,"chat","Chat","Topic :: Communications :: Chat"))
        self.create_trove_cat((574,22,"msn_messenger","MSN Messenger","Topic :: Communications :: Chat :: MSN Messenger"))
        self.create_trove_cat((26,22,"aim","AOL Instant Messenger","Topic :: Communications :: Chat :: AOL Instant Messenger"))
        self.create_trove_cat((24,22,"irc","Internet Relay Chat","Topic :: Communications :: Chat :: Internet Relay Chat"))
        self.create_trove_cat((25,22,"talk","Unix Talk","Topic :: Communications :: Chat :: Unix Talk"))
        self.create_trove_cat((23,22,"icq","ICQ","Topic :: Communications :: Chat :: ICQ"))
        self.create_trove_cat((590,20,"streaming_comms","Streaming","Topic :: Communications :: Streaming"))
        self.create_trove_cat((27,20,"conferencing","Conferencing","Topic :: Communications :: Conferencing"))
        self.create_trove_cat((247,20,"telephony","Telephony","Topic :: Communications :: Telephony"))
        self.create_trove_cat((251,20,"filesharing","File Sharing","Topic :: Communications :: File Sharing"))
        self.create_trove_cat((622,251,"bittorrent","BitTorrent","Topic :: Communications :: File Sharing :: BitTorrent"))
        self.create_trove_cat((286,251,"gnutella","Gnutella","Topic :: Communications :: File Sharing :: Gnutella"))
        self.create_trove_cat((241,251,"napster","Napster","Topic :: Communications :: File Sharing :: Napster"))
        self.create_trove_cat((21,20,"bbs","BBS","Topic :: Communications :: BBS"))
        self.create_trove_cat((28,20,"email","Email","Topic :: Communications :: Email"))
        self.create_trove_cat((31,28,"mua","Email Clients (MUA)","Topic :: Communications :: Email :: Email Clients (MUA)"))
        self.create_trove_cat((32,28,"mta","Mail Transport Agents","Topic :: Communications :: Email :: Mail Transport Agents"))
        self.create_trove_cat((234,18,"other","Other/Nonlisted Topic","Topic :: Other/Nonlisted Topic"))
        self.create_trove_cat((129,18,"office","Office/Business","Topic :: Office/Business"))
        self.create_trove_cat((576,129,"enterprise","Enterprise","Topic :: Office/Business :: Enterprise"))
        self.create_trove_cat((579,576,"crm","CRM","Topic :: Office/Business :: Enterprise :: CRM"))
        self.create_trove_cat((577,576,"erp","ERP","Topic :: Office/Business :: Enterprise :: ERP"))
        self.create_trove_cat((578,576,"olap","OLAP","Topic :: Office/Business :: Enterprise :: OLAP"))
        self.create_trove_cat((580,576,"data_warehousing","Data Warehousing","Topic :: Office/Business :: Enterprise :: Data Warehousing"))
        self.create_trove_cat((587,129,"time_tracking","Time Tracking","Topic :: Office/Business :: Time Tracking"))
        self.create_trove_cat((75,129,"financial","Financial","Topic :: Office/Business :: Financial"))
        self.create_trove_cat((76,75,"accounting","Accounting","Topic :: Office/Business :: Financial :: Accounting"))
        self.create_trove_cat((77,75,"investment","Investment","Topic :: Office/Business :: Financial :: Investment"))
        self.create_trove_cat((78,75,"spreadsheet","Spreadsheet","Topic :: Office/Business :: Financial :: Spreadsheet"))
        self.create_trove_cat((79,75,"pointofsale","Point-Of-Sale","Topic :: Office/Business :: Financial :: Point-Of-Sale"))
        self.create_trove_cat((130,129,"scheduling","Scheduling","Topic :: Office/Business :: Scheduling"))
        self.create_trove_cat((585,130,"calendar","Calendar","Topic :: Office/Business :: Scheduling :: Calendar"))
        self.create_trove_cat((586,130,"resource_booking","Resource Booking","Topic :: Office/Business :: Scheduling :: Resource Booking"))
        self.create_trove_cat((131,129,"suites","Office Suites","Topic :: Office/Business :: Office Suites"))
        self.create_trove_cat((588,129,"todo_lists","To-Do Lists","Topic :: Office/Business :: To-Do Lists"))
        self.create_trove_cat((607,129,"project_management","Project Management","Topic :: Office/Business :: Project Management"))
        self.create_trove_cat((66,18,"database","Database","Topic :: Database"))
        self.create_trove_cat((68,66,"frontends","Front-Ends","Topic :: Database :: Front-Ends"))
        self.create_trove_cat((67,66,"engines","Database Engines/Servers","Topic :: Database :: Database Engines/Servers"))
        self.create_trove_cat((43,18,"security","Security","Topic :: Security"))
        self.create_trove_cat((44,43,"cryptography","Cryptography","Topic :: Security :: Cryptography"))
        self.create_trove_cat((55,18,"desktop","Desktop Environment","Topic :: Desktop Environment"))
        self.create_trove_cat((56,55,"windowmanagers","Window Managers","Topic :: Desktop Environment :: Window Managers"))
        self.create_trove_cat((59,56,"enlightenment","Enlightenment","Topic :: Desktop Environment :: Window Managers :: Enlightenment"))
        self.create_trove_cat((60,59,"themes","Themes","Topic :: Desktop Environment :: Window Managers :: Enlightenment :: Themes"))
        self.create_trove_cat((57,55,"kde","K Desktop Environment (KDE)","Topic :: Desktop Environment :: K Desktop Environment (KDE)"))
        self.create_trove_cat((61,57,"themes","Themes","Topic :: Desktop Environment :: K Desktop Environment (KDE) :: Themes"))
        self.create_trove_cat((58,55,"gnome","Gnome","Topic :: Desktop Environment :: Gnome"))
        self.create_trove_cat((62,55,"screensavers","Screen Savers","Topic :: Desktop Environment :: Screen Savers"))
        self.create_trove_cat((80,18,"games","Games/Entertainment","Topic :: Games/Entertainment"))
        self.create_trove_cat((633,80,"console-games","Console-based Games","Topic :: Games/Entertainment :: Console-based Games"))
        self.create_trove_cat((287,80,"boardgames","Board Games","Topic :: Games/Entertainment :: Board Games"))
        self.create_trove_cat((288,80,"sidescrolling","Side-Scrolling/Arcade Games","Topic :: Games/Entertainment :: Side-Scrolling/Arcade Games"))
        self.create_trove_cat((81,80,"realtimestrategy","Real Time Strategy","Topic :: Games/Entertainment :: Real Time Strategy"))
        self.create_trove_cat((82,80,"firstpersonshooters","First Person Shooters","Topic :: Games/Entertainment :: First Person Shooters"))
        self.create_trove_cat((83,80,"turnbasedstrategy","Turn Based Strategy","Topic :: Games/Entertainment :: Turn Based Strategy"))
        self.create_trove_cat((84,80,"rpg","Role-Playing","Topic :: Games/Entertainment :: Role-Playing"))
        self.create_trove_cat((85,80,"simulation","Simulation","Topic :: Games/Entertainment :: Simulation"))
        self.create_trove_cat((86,80,"mud","Multi-User Dungeons (MUD)","Topic :: Games/Entertainment :: Multi-User Dungeons (MUD)"))
        self.create_trove_cat((268,80,"Puzzles","Puzzle Games","Topic :: Games/Entertainment :: Puzzle Games"))
        self.create_trove_cat((88,87,"finger","Finger","Topic :: Internet :: Finger"))
        self.create_trove_cat((89,87,"ftp","File Transfer Protocol (FTP)","Topic :: Internet :: File Transfer Protocol (FTP)"))
        self.create_trove_cat((270,87,"WAP","WAP","Topic :: Internet :: WAP"))
        self.create_trove_cat((90,87,"www","WWW/HTTP","Topic :: Internet :: WWW/HTTP"))
        self.create_trove_cat((91,90,"browsers","Browsers","Topic :: Internet :: WWW/HTTP :: Browsers"))
        self.create_trove_cat((92,90,"dynamic","Dynamic Content","Topic :: Internet :: WWW/HTTP :: Dynamic Content"))
        self.create_trove_cat((95,92,"messageboards","Message Boards","Topic :: Internet :: WWW/HTTP :: Dynamic Content :: Message Boards"))
        self.create_trove_cat((96,92,"cgi","CGI Tools/Libraries","Topic :: Internet :: WWW/HTTP :: Dynamic Content :: CGI Tools/Libraries"))
        self.create_trove_cat((94,92,"counters","Page Counters","Topic :: Internet :: WWW/HTTP :: Dynamic Content :: Page Counters"))
        self.create_trove_cat((93,90,"indexing","Indexing/Search","Topic :: Internet :: WWW/HTTP :: Indexing/Search"))
        self.create_trove_cat((243,90,"sitemanagement","Site Management","Topic :: Internet :: WWW/HTTP :: Site Management"))
        self.create_trove_cat((244,243,"linkchecking","Link Checking","Topic :: Internet :: WWW/HTTP :: Site Management :: Link Checking"))
        self.create_trove_cat((250,90,"httpservers","HTTP Servers","Topic :: Internet :: WWW/HTTP :: HTTP Servers"))
        self.create_trove_cat((149,87,"dns","Name Service (DNS)","Topic :: Internet :: Name Service (DNS)"))
        self.create_trove_cat((245,87,"loganalysis","Log Analysis","Topic :: Internet :: Log Analysis"))
        self.create_trove_cat((45,18,"development","Software Development","Topic :: Software Development"))
        self.create_trove_cat((563,45,"modeling","Modeling","Topic :: Software Development :: Modeling"))
        self.create_trove_cat((46,45,"build","Build Tools","Topic :: Software Development :: Build Tools"))
        self.create_trove_cat((575,45,"testing","Testing","Topic :: Software Development :: Testing"))
        self.create_trove_cat((620,45,"algorithms","Algorithms","Topic :: Software Development :: Algorithms"))
        self.create_trove_cat((621,620,"genetic_algorithms","Genetic Algorithms","Topic :: Software Development :: Algorithms :: Genetic Algorithms"))
        self.create_trove_cat((606,45,"frameworks","Frameworks","Topic :: Software Development :: Frameworks"))
        self.create_trove_cat((564,45,"documentation","Documentation","Topic :: Software Development :: Documentation"))
        self.create_trove_cat((562,45,"swdev_oo","Object Oriented","Topic :: Software Development :: Object Oriented"))
        self.create_trove_cat((409,45,"l10n","L10N (Localization)","Topic :: Software Development :: L10N (Localization)"))
        self.create_trove_cat((408,45,"i18n","I18N (Internationalization)","Topic :: Software Development :: I18N (Internationalization)"))
        self.create_trove_cat((50,45,"objectbrokering","Object Brokering","Topic :: Software Development :: Object Brokering"))
        self.create_trove_cat((51,50,"corba","CORBA","Topic :: Software Development :: Object Brokering :: CORBA"))
        self.create_trove_cat((52,45,"versioncontrol","Version Control","Topic :: Software Development :: Version Control"))
        self.create_trove_cat((53,52,"cvs","CVS","Topic :: Software Development :: Version Control :: CVS"))
        self.create_trove_cat((54,52,"rcs","RCS","Topic :: Software Development :: Version Control :: RCS"))
        self.create_trove_cat((260,52,"SCCS","SCCS","Topic :: Software Development :: Version Control :: SCCS"))
        self.create_trove_cat((259,45,"codegen","Code Generators","Topic :: Software Development :: Code Generators"))
        self.create_trove_cat((47,45,"debuggers","Debuggers","Topic :: Software Development :: Debuggers"))
        self.create_trove_cat((48,45,"compilers","Compilers","Topic :: Software Development :: Compilers"))
        self.create_trove_cat((49,45,"interpreters","Interpreters","Topic :: Software Development :: Interpreters"))
        self.create_trove_cat((561,45,"softwaredev_ui","User Interfaces","Topic :: Software Development :: User Interfaces"))
        self.create_trove_cat((565,45,"quality_assurance","Quality Assurance","Topic :: Software Development :: Quality Assurance"))
        self.create_trove_cat((570,45,"case_tools","CASE","Topic :: Software Development :: CASE"))
        self.create_trove_cat((582,45,"design","Design","Topic :: Software Development :: Design"))
        self.create_trove_cat((593,45,"cross_compilers","Cross Compilers","Topic :: Software Development :: Cross Compilers"))
        self.create_trove_cat((603,45,"profilers","Profiling","Topic :: Software Development :: Profiling"))
        self.create_trove_cat((610,45,"virtual_machines","Virtual Machines","Topic :: Software Development :: Virtual Machines"))
        self.create_trove_cat((619,45,"usability","Usability","Topic :: Software Development :: Usability"))
        self.create_trove_cat((581,71,"library","Library","Topic :: Education :: Library"))
        self.create_trove_cat((604,581,"opac","OPAC","Topic :: Education :: Library :: OPAC"))
        self.create_trove_cat((605,581,"marc_and_metadata","MARC and Book/Library Metadata","Topic :: Education :: Library :: MARC and Book/Library Metadata"))
        self.create_trove_cat((132,18,"religion","Religion and Philosophy","Topic :: Religion and Philosophy"))
        self.create_trove_cat((571,132,"new_age","New Age","Topic :: Religion and Philosophy :: New Age"))
        self.create_trove_cat((136,18,"system","System","Topic :: System"))
        self.create_trove_cat((638,136,"storage","Storage","Topic :: System :: Storage"))
        self.create_trove_cat((601,638,"file_management","File Management","Topic :: System :: Storage :: File Management"))
        self.create_trove_cat((19,638,"archiving","Archiving","Topic :: System :: Storage :: Archiving"))
        self.create_trove_cat((42,19,"compression","Compression","Topic :: System :: Storage :: Archiving :: Compression"))
        self.create_trove_cat((137,19,"backup","Backup","Topic :: System :: Storage :: Archiving :: Backup"))
        self.create_trove_cat((41,19,"packaging","Packaging","Topic :: System :: Storage :: Archiving :: Packaging"))
        self.create_trove_cat((294,136,"shells","System Shells","Topic :: System :: System Shells"))
        self.create_trove_cat((74,136,"emulators","Emulators","Topic :: System :: Emulators"))
        self.create_trove_cat((627,136,"system_search","Search","Topic :: System :: Search"))
        self.create_trove_cat((257,136,"softwaredist","Software Distribution","Topic :: System :: Software Distribution"))
        self.create_trove_cat((122,113,"players","Players","Topic :: Multimedia :: Sound/Audio :: Players"))
        self.create_trove_cat((253,136,"sysadministration","Systems Administration","Topic :: System :: Systems Administration"))
        self.create_trove_cat((289,253,"authentication","Authentication/Directory","Topic :: System :: Systems Administration :: Authentication/Directory"))
        self.create_trove_cat((290,289,"nis","NIS","Topic :: System :: Systems Administration :: Authentication/Directory :: NIS"))
        self.create_trove_cat((291,289,"ldap","LDAP","Topic :: System :: Systems Administration :: Authentication/Directory :: LDAP"))
        self.create_trove_cat((153,136,"power","Power (UPS)","Topic :: System :: Power (UPS)"))
        self.create_trove_cat((150,136,"networking","Networking","Topic :: System :: Networking"))
        self.create_trove_cat((566,150,"wireless","Wireless","Topic :: System :: Networking :: Wireless"))
        self.create_trove_cat((151,150,"firewalls","Firewalls","Topic :: System :: Networking :: Firewalls"))
        self.create_trove_cat((152,150,"monitoring","Monitoring","Topic :: System :: Networking :: Monitoring"))
        self.create_trove_cat((155,152,"watchdog","Hardware Watchdog","Topic :: System :: Networking :: Monitoring :: Hardware Watchdog"))
        self.create_trove_cat((148,136,"logging","Logging","Topic :: System :: Logging"))
        self.create_trove_cat((592,148,"log_rotation","Log Rotation","Topic :: System :: Logging :: Log Rotation"))
        self.create_trove_cat((144,136,"kernels","Operating System Kernels","Topic :: System :: Operating System Kernels"))
        self.create_trove_cat((145,144,"bsd","BSD","Topic :: System :: Operating System Kernels :: BSD"))
        self.create_trove_cat((239,144,"gnuhurd","GNU Hurd","Topic :: System :: Operating System Kernels :: GNU Hurd"))
        self.create_trove_cat((143,144,"linux","Linux","Topic :: System :: Operating System Kernels :: Linux"))
        self.create_trove_cat((147,136,"setup","Installation/Setup","Topic :: System :: Installation/Setup"))
        self.create_trove_cat((146,136,"hardware","Hardware","Topic :: System :: Hardware"))
        self.create_trove_cat((313,146,"mainframe","Mainframes","Topic :: System :: Hardware :: Mainframes"))
        self.create_trove_cat((312,146,"smp","Symmetric Multi-processing","Topic :: System :: Hardware :: Symmetric Multi-processing"))
        self.create_trove_cat((292,146,"drivers","Hardware Drivers","Topic :: System :: Hardware :: Hardware Drivers"))
        self.create_trove_cat((138,136,"benchmark","Benchmark","Topic :: System :: Benchmark"))
        self.create_trove_cat((139,136,"boot","Boot","Topic :: System :: Boot"))
        self.create_trove_cat((140,139,"init","Init","Topic :: System :: Boot :: Init"))
        self.create_trove_cat((141,136,"clustering","Clustering","Topic :: System :: Clustering"))
        self.create_trove_cat((308,136,"distributed_computing","Distributed Computing","Topic :: System :: Distributed Computing"))
        self.create_trove_cat((142,136,"filesystems","Filesystems","Topic :: System :: Filesystems"))
        self.create_trove_cat((154,18,"printing","Printing","Topic :: Printing"))
        self.create_trove_cat((87,18,"internet","Internet","Topic :: Internet"))
        self.create_trove_cat((118,116,"cdripping","CD Ripping","Topic :: Multimedia :: Sound/Audio :: CD Audio :: CD Ripping"))
        self.create_trove_cat((119,113,"conversion","Conversion","Topic :: Multimedia :: Sound/Audio :: Conversion"))
        self.create_trove_cat((120,113,"editors","Editors","Topic :: Multimedia :: Sound/Audio :: Editors"))
        self.create_trove_cat((121,113,"mixers","Mixers","Topic :: Multimedia :: Sound/Audio :: Mixers"))
        self.create_trove_cat((100,99,"graphics","Graphics","Topic :: Multimedia :: Graphics"))
        self.create_trove_cat((109,100,"3dmodeling","3D Modeling","Topic :: Multimedia :: Graphics :: 3D Modeling"))
        self.create_trove_cat((110,100,"3drendering","3D Rendering","Topic :: Multimedia :: Graphics :: 3D Rendering"))
        self.create_trove_cat((111,100,"presentation","Presentation","Topic :: Multimedia :: Graphics :: Presentation"))
        self.create_trove_cat((112,100,"viewers","Viewers","Topic :: Multimedia :: Graphics :: Viewers"))
        self.create_trove_cat((101,100,"capture","Capture","Topic :: Multimedia :: Graphics :: Capture"))
        self.create_trove_cat((104,101,"screencapture","Screen Capture","Topic :: Multimedia :: Graphics :: Capture :: Screen Capture"))
        self.create_trove_cat((103,101,"cameras","Digital Camera","Topic :: Multimedia :: Graphics :: Capture :: Digital Camera"))
        self.create_trove_cat((102,101,"scanners","Scanners","Topic :: Multimedia :: Graphics :: Capture :: Scanners"))
        self.create_trove_cat((105,100,"conversion","Graphics Conversion","Topic :: Multimedia :: Graphics :: Graphics Conversion"))
        self.create_trove_cat((106,100,"editors","Editors","Topic :: Multimedia :: Graphics :: Editors"))
        self.create_trove_cat((108,106,"raster","Raster-Based","Topic :: Multimedia :: Graphics :: Editors :: Raster-Based"))
        self.create_trove_cat((107,106,"vector","Vector-Based","Topic :: Multimedia :: Graphics :: Editors :: Vector-Based"))
        self.create_trove_cat((97,18,"scientific","Scientific/Engineering","Topic :: Scientific/Engineering"))
        self.create_trove_cat((609,97,"molecular_science","Molecular Science","Topic :: Scientific/Engineering :: Molecular Science"))
        self.create_trove_cat((602,97,"robotics","Robotics","Topic :: Scientific/Engineering :: Robotics"))
        self.create_trove_cat((600,97,"simulations","Simulations","Topic :: Scientific/Engineering :: Simulations"))
        self.create_trove_cat((568,97,"ecosystem_sciences","Ecosystem Sciences","Topic :: Scientific/Engineering :: Ecosystem Sciences"))
        self.create_trove_cat((386,97,"interfaceengine","Interface Engine/Protocol Translator","Topic :: Scientific/Engineering :: Interface Engine/Protocol Translator"))
        self.create_trove_cat((384,97,"chemistry","Chemistry","Topic :: Scientific/Engineering :: Chemistry"))
        self.create_trove_cat((252,97,"bioinformatics","Bio-Informatics","Topic :: Scientific/Engineering :: Bio-Informatics"))
        self.create_trove_cat((246,97,"eda","Electronic Design Automation (EDA)","Topic :: Scientific/Engineering :: Electronic Design Automation (EDA)"))
        self.create_trove_cat((135,97,"visualization","Visualization","Topic :: Scientific/Engineering :: Visualization"))
        self.create_trove_cat((134,97,"astronomy","Astronomy","Topic :: Scientific/Engineering :: Astronomy"))
        self.create_trove_cat((133,97,"ai","Artificial Intelligence","Topic :: Scientific/Engineering :: Artificial Intelligence"))
        self.create_trove_cat((591,133,"intelligent_agents","Intelligent Agents","Topic :: Scientific/Engineering :: Artificial Intelligence :: Intelligent Agents"))
        self.create_trove_cat((98,97,"mathematics","Mathematics","Topic :: Scientific/Engineering :: Mathematics"))
        self.create_trove_cat((272,97,"HMI","Human Machine Interfaces","Topic :: Scientific/Engineering :: Human Machine Interfaces"))
        self.create_trove_cat((266,97,"medical","Medical Science Apps.","Topic :: Scientific/Engineering :: Medical Science Apps."))
        self.create_trove_cat((383,97,"gis","GIS","Topic :: Scientific/Engineering :: GIS"))
        self.create_trove_cat((385,97,"informationanalysis","Information Analysis","Topic :: Scientific/Engineering :: Information Analysis"))
        self.create_trove_cat((387,97,"physics","Physics","Topic :: Scientific/Engineering :: Physics"))
        self.create_trove_cat((567,97,"earth_science","Earth Sciences","Topic :: Scientific/Engineering :: Earth Sciences"))
        self.create_trove_cat((282,18,"Sociology","Sociology","Topic :: Sociology"))
        self.create_trove_cat((284,282,"Genealogy","Genealogy","Topic :: Sociology :: Genealogy"))
        self.create_trove_cat((283,282,"History","History","Topic :: Sociology :: History"))
        self.create_trove_cat((71,18,"education","Education","Topic :: Education"))
        self.create_trove_cat((73,71,"testing","Testing","Topic :: Education :: Testing"))
        self.create_trove_cat((72,71,"cai","Computer Aided Instruction (CAI)","Topic :: Education :: Computer Aided Instruction (CAI)"))
        self.create_trove_cat((18,0,"topic","Topic","Topic"))
        self.create_trove_cat((125,99,"video","Video","Topic :: Multimedia :: Video"))
        self.create_trove_cat((594,125,"still_capture","Still Capture","Topic :: Multimedia :: Video :: Still Capture"))
        self.create_trove_cat((596,125,"codec","Codec","Topic :: Multimedia :: Video :: Codec"))
        self.create_trove_cat((127,125,"conversion","Conversion","Topic :: Multimedia :: Video :: Conversion"))
        self.create_trove_cat((128,125,"display","Display","Topic :: Multimedia :: Video :: Display"))
        self.create_trove_cat((256,125,"nonlineareditor","Non-Linear Editor","Topic :: Multimedia :: Video :: Non-Linear Editor"))
        self.create_trove_cat((595,125,"special_effects","Special Effects","Topic :: Multimedia :: Video :: Special Effects"))
        self.create_trove_cat((623,125,"video_realtime","Realtime Processing","Topic :: Multimedia :: Video :: Realtime Processing"))
        self.create_trove_cat((126,125,"vidcapture","Video Capture","Topic :: Multimedia :: Video :: Video Capture"))
        self.create_trove_cat((113,99,"sound","Sound/Audio","Topic :: Multimedia :: Sound/Audio"))
        self.create_trove_cat((123,122,"mp3","MP3","Topic :: Multimedia :: Sound/Audio :: Players :: MP3"))
        self.create_trove_cat((124,113,"speech","Speech","Topic :: Multimedia :: Sound/Audio :: Speech"))
        self.create_trove_cat((114,113,"analysis","Analysis","Topic :: Multimedia :: Sound/Audio :: Analysis"))
        self.create_trove_cat((115,113,"capture","Capture/Recording","Topic :: Multimedia :: Sound/Audio :: Capture/Recording"))
        self.create_trove_cat((248,113,"midi","MIDI","Topic :: Multimedia :: Sound/Audio :: MIDI"))
        self.create_trove_cat((249,113,"synthesis","Sound Synthesis","Topic :: Multimedia :: Sound/Audio :: Sound Synthesis"))
        self.create_trove_cat((116,113,"cdaudio","CD Audio","Topic :: Multimedia :: Sound/Audio :: CD Audio"))
        self.create_trove_cat((117,116,"cdplay","CD Playing","Topic :: Multimedia :: Sound/Audio :: CD Audio :: CD Playing"))
        self.create_trove_cat((99,18,"multimedia","Multimedia","Topic :: Multimedia"))
        session(M.TroveCategory).flush()