unit AbonUnit;

interface
uses
    Windows,Messages, ShellAPI, SysUtils, Classes,StdCtrls,StrUtils;

type
  TAbon = class(TObject)
  private
    { Private 錾 }
    Froot : String;
    FNGwordpath : String;
    Ftokens : array of array of string;
    FAbonString : String;
    FRetStrings : TStringList;
    FCutoffNum : Integer; //̐ȏA铯pNG[hƂ
    FDeleterlo : Boolean; //&rlo;邩
    FReplaceul :Boolean ; //<ul>^O<br>^Oɒu邩
    FReverse : Boolean ;  //NG[hł̂ځ`̌ʂ𔽓]邩
    FAbonPopupRes : Boolean; //X|bvAbv̎ɂځ[񂷂邩
    FCreateNGwordFile : Boolean; //w肳ꂽpathNG[htxtƂɎIɐ邩
    procedure SetTokens(index: integer ; argline:String);

  public
    { Public 錾 }
    constructor Create; // RXgN^
    destructor Destroy; override; // fXgN^
    property Deleterlo: Boolean read FDeleterlo write FDeleterlo  default false;
    property Replaceul: Boolean read FReplaceul write FReplaceul  default false;
    property Reverse: Boolean read FReverse write FReverse  default false;
    property CreateNGwordFile: Boolean read FCreateNGwordFile write FCreateNGwordFile;
    property AbonString : String read FAbonString write FAbonString;
    property  AbonPopupRes : Boolean read FAbonPopupRes write FAbonPopupRes default false;
    procedure Setroot(root :String);
    function Getroot() : String;
    procedure SetNGwordpath(path :String);
    function GetNGwordpath() : String;
    procedure SetCutoffNum(value : Integer);
    function GetCutoffNum() : Integer;
    function LoadFromNGwordFile(path :String) : Boolean;
    function ReLoadFromNGwordFile() : Boolean;
    procedure LoadFromStringList( bufstl : TStringList );
    function CheckAbonPopupRes(line : String) :Boolean;
    function FindNGwords(line : String) : Boolean; //1CpB
    function Cutoff(line : String) : Boolean; //CutOfflȏ̓płtrue
    //ځ`񏈗
    function Execute(DestStrings : TStringList) : TStringList; overload;
    function Execute(DestStrings : TStringList; NGwords : TStringList) : TStringList; overload;
    function Execute(DestStrings : TStringList; NGwords : TStrings) : TStringList; overload;
    //--
    function ExecuteFile(datfilepath : String; NGwordpath : String) : Boolean; overload;//DATt@C𒼂ɂ
    function ExecuteFile(datfilepath : String; resnum : Integer) : Boolean; overload; //DATt@C𒼂ɂ
    function ExecuteFile(datfilepath : String; firstres : Integer; count : Integer) : Boolean; overload; //DATt@C𒼂ɂ
    function ReverseExecuteFile(datfilepath : String) : Boolean; overload; //DATt@C𒼂ɂ
    function ReverseExecuteFile(datfilepath : String; resnum : Integer) : Boolean; overload; //DATt@C𒼂ɂ
    function ReverseExecuteFile(datfilepath : String; firstres : Integer; count : Integer) : Boolean; overload; //DATt@C𒼂ɂ
    //--
    procedure EditNGwords();  //NGword.txtJB
    function ShowAllTokens() : String;  //fobOp
  end;
var
    Abon1 :TAbon;

implementation

constructor TAbon.Create;
begin
    // 
    FAbonString := '&nbsp;<>&nbsp;<>&nbsp;<>&nbsp;&nbsp;<><>';
    FRetStrings := TStringList.Create;
    FCreateNGwordFile := true;
    SetCutoffNum(0);
end;

destructor TAbon.Destroy;
begin
    FRetStrings.Free;
    inherited;
end;



//rootExêtH_
procedure TAbon.Setroot(root :String);
begin
    Froot := root;
end;
function TAbon.Getroot() : String;
begin
    Result := Froot;
end;
//NGwordpathNGword.txt̃tpX
procedure TAbon.SetNGwordpath(path :String);
begin
    FNGwordpath := path;
    LoadFromNGwordFile(FNGwordpath);
end;
function TAbon.GetNGwordpath() : String;
begin
    Result :=  FNGwordpath;
end;
//NGwordt@C̓ǂݍ
function TAbon.LoadFromNGwordFile(path :String) : boolean;
var
    bufstl : TStringList;
    i : integer;
begin
    if AnsiPos(':\',path) <> 2 then begin  //hCũtpX
        if Getroot() = '' then begin
            Result := false;    //rootpXݒ肳ĂȂfalse
            Exit;
        end else begin
            if (Froot[Length(Froot)] = '\') and (path[1] = '\') then begin  //擪\폜
                Delete(path,1,1);
            end;
            Insert( Getroot(), path , 1);//rootpX}
        end;
    end;
    bufstl := TStringList.Create;
    try
        bufstl.LoadFromFile(path);
        LoadFromStringList( bufstl );

    except
        if CreateNGwordFile = true then begin
            bufstl.SaveToFile(path);
        end;
        bufstl.Free;
        Result := false;
        Exit;
    end;
    bufstl.Free;
    Result := true;
end;
//NGwordXgǂݍ
procedure TAbon.LoadFromStringList( bufstl : TStringList );
var
    i : integer;
begin
    try
        for i := bufstl.Count -1  downto 0 do begin
            if bufstl.Strings[i] = '' then begin
                bufstl.Delete(i);
            end;
        end;
        SetLength(Ftokens,bufstl.Count);
        for i := 0  to bufstl.Count -1 do begin
            SetTokens(i , bufstl.Strings[i]);
        end;

    except
        Exit;
    end;
end;
//NGwordpathɐݒ肳ĂƂ̃[hp֐
function TAbon.ReLoadFromNGwordFile() : boolean;
begin
    if GetNGwordpath() ='' then begin
        Result := false;
    end else begin
        Result := LoadFromNGwordFile( GetNGwordpath() );
    end;
end;

//s̒̃g[N؂蕪ăZbg
procedure TAbon.SetTokens(index: integer ; argline : String);
var
    ret : Integer;
    bufstl : TStringList;
    i : Integer;
begin
    bufstl := TStringList.Create;
    bufstl.Delimiter := #9;  //؂qf^ufɐݒ
    bufstl.DelimitedText := argline;
    ret := bufstl.Count;
    SetLength(Ftokens[index],ret);
    for i := 0 to bufstl.Count - 1  do begin
        Ftokens[index][i] := bufstl.Strings[i];
    end;
    bufstl.Free;

end;
procedure TAbon.SetCutoffNum(value : Integer);
begin
    if value > 0 then begin
        FCutoffNum := value;
    end else begin
        FCutoffNum := 0;
    end;
end;
function TAbon.GetCutoffNum() : Integer;
begin
    Result := FCutoffNum;
end;
function TAbon.ShowAllTokens() : String;
var
    i : Integer;
    j : Integer;
    ret : String;
begin
    for i := 0 to High(Ftokens) do begin
        for j := 0 to High(Ftokens[i]) do begin
            ret := ret + Ftokens[i][j];
        end;
    end;
    Result := ret;



end;

//****************************************************************************//
//NG[h܂܂ĂtrueԂB
function TAbon.FindNGwords(line : String) : Boolean;
var
    i : Integer;
    j : Integer;
    hit : Boolean;
begin
    hit := false;
    if AnsiPos(FAbonString,line) <> 1 then begin
        for i := 0 to High(Ftokens) do begin
            hit := true;
            for j := 0 to High(Ftokens[i]) do begin
                if AnsiPos(Ftokens[i][j],line) = 0 then begin
                    hit := false;
                    break;
                end;
            end;
            if hit = true then begin
                break;
            end;
        end;
    end;
    Result := hit;

end;
//CutOfflȏ̓płtrue
function TAbon.Cutoff(line : String) : Boolean;
var
    i : Integer;
    sheed : AnsiChar;
    buf : String;
    ret : Bool;
begin
    ret := false;
    if FCutoffNum <> 0 then begin
        for i := 65 to 90 do begin
            sheed := Chr(i);
            buf := DupeString(sheed, FCutoffNum);
            if AnsiContainsText(line, buf) = true then begin
                ret := true;
                break;
            end;
        end;
    end;
    Result := ret;
end;
//̃u[ltrueƁANG[h܂ނ̂ԂB
function TAbon.Execute(DestStrings : TStringList) : TStringList;
var
    i : Integer;
    j : Integer;
    bufline : String;
begin
    FRetStrings.Clear;

    //if Reverse = false then begin
        for i:=0 to DestStrings.Count - 1 do begin
            if FindNGwords(DestStrings.Strings[i]) <> Reverse  then begin
                FRetStrings.Append(FAbonString);
            end else if FCutoffNum > 0  then begin
                bufline := DestStrings.Strings[i];
                for j := 0 to 2 do begin
                    Delete(bufline,1,Ansipos('<>',bufline)+1);
                end;
                Delete(bufline,Ansipos('<>',bufline),Length(bufline)-Ansipos('<>',bufline)+1);
                if Cutoff(bufline) = true then begin
                    FRetStrings.Append(FAbonString);
                end else begin
                    bufline := DestStrings.Strings[i];
                    if Deleterlo = true then begin
                        bufline := AnsiReplaceText( bufline,'&rlo;','' );
                    end;
                    if Replaceul = true then begin
                        bufline := AnsiReplaceText( bufline,'<ul>','<br>' );
                        bufline := AnsiReplaceText( bufline,'</ul>','<br>' );
                    end;
                    FRetStrings.Append(bufline);
                end;
            end else begin
                bufline := DestStrings.Strings[i];
                if Deleterlo = true then begin
                    bufline := AnsiReplaceText( bufline,'&rlo;','' );
                end;
                if Replaceul = true then begin
                    bufline := AnsiReplaceText( bufline,'<ul>','<br>' );
                    bufline := AnsiReplaceText( bufline,'</ul>','<br>' );
                end;
                FRetStrings.Append(bufline);
            end;
        end;
    {end else begin
        for i:=0 to DestStrings.Count - 1 do begin
            if FindNGwords(DestStrings.Strings[i]) = false then begin
                bufline := DestStrings.Strings[i];
                for j := 0 to 2 do begin
                    Delete(bufline,1,Ansipos('<>',bufline)+1);
                end;
                Delete(bufline,Ansipos('<>',bufline),Length(bufline)-Ansipos('<>',bufline)+1);
                if Cutoff(bufline) = false then begin
                    FRetStrings.Append(FAbonString);
                end else begin
                    bufline := DestStrings.Strings[i];
                    if Deleterlo = true then begin
                        while  AnsiPos('&rlo',bufline) <> 0 do begin
                            Delete(bufline,AnsiPos('&rlo',bufline),4);
                        end;
                    end;
                    if Replaceul = true then begin
                         bufline := AnsiReplaceText( bufline,'<ul>','<br>' );
                        bufline := AnsiReplaceText( bufline,'</ul>','<br>' );
                    end;
                    FRetStrings.Append(bufline);
                end;
            end else begin
                bufline := DestStrings.Strings[i];
                if Deleterlo = true then begin
                    while  AnsiPos('&rlo',bufline) <> 0 do begin
                        Delete(bufline,AnsiPos('&rlo',bufline),4);
                    end;
                end;
                if Replaceul = true then begin
                     bufline := AnsiReplaceText( bufline,'<ul>','<br>' );
                     bufline := AnsiReplaceText( bufline,'</ul>','<br>' );
                end;
                FRetStrings.Append(bufline);
            end;
        end;

    end;}
    Result := FRetStrings;

end;
function TAbon.Execute(DestStrings : TStringList; NGwords : TStringList) : TStringList;
var
    i : Integer;
begin
    SetLength(Ftokens,NGwords.Count);
    for i := 0  to NGwords.Count -1 do begin
        SetTokens(i , NGwords.Strings[i]);
    end;
    Result := Execute(DestStrings);

end;
function TAbon.Execute(DestStrings : TStringList; NGwords : TStrings) : TStringList;
var
    i : Integer;
    buf : TStringList;
begin
    buf := TStringList.Create;
    buf.AddStrings(NGwords);
    SetLength(Ftokens,buf.Count);
    for i := 0  to buf.Count -1 do begin
        SetTokens(i , buf.Strings[i]);
    end;
    Result := Execute(DestStrings);
    buf.Free;
end;


//****************************************************************************//
//DAT𒼂ɂz===========================================================
//NG[h܂ރX̐擪ɂځ[}
function TAbon.ExecuteFile(datfilepath : String; NGwordpath : String) : Boolean; //DATt@C𒼂ɂ
var
    datstl : TStringList;
    ret : Boolean;
    i : Integer;
begin
    datstl := TStringList.Create;
    ret := true;
    try
        try
            datstl.LoadFromFile(datfilepath);
            for i := 0 to datstl.Count -1 do begin
                if FindNGwords(datstl.Strings[i]) = true  then begin
                    datstl.Strings[i] := FAbonString + datstl.Strings[i]
                end;
            end;

            datstl.SaveToFile(datfilepath);
        except
            ret := false;
        end;
    finally
        datstl.Free;
    end;
    Result := ret;

end;
//w肳ꂽXԂ̐擪ɂځ[}
function TAbon.ExecuteFile(datfilepath : String; resnum : Integer) : Boolean; //DATt@C𒼂ɂ
var
    datstl : TStringList;
    ret : Boolean;
begin
    ret := true;
    datstl := TStringList.Create;
    try
        try
            datstl.LoadFromFile(datfilepath);
            if (resnum > 0) and (resnum <= datstl.Count) then begin
                if AnsiPos(FAbonString, datstl.Strings[resnum-1]) <> 1 then begin
                    datstl.Strings[resnum-1] := FAbonString + datstl.Strings[resnum-1];
                end;
            end;
            datstl.SaveToFile(datfilepath);
        except
            ret := false;
        end;
    finally
        datstl.Free;
    end;
    Result := ret;
end;
//firstrescount̃X̐擪ɂځ[}
function TAbon.ExecuteFile(datfilepath : String; firstres : Integer; count : Integer) : Boolean; //DATt@C𒼂ɂ
var
    datstl : TStringList;
    i : Integer;
    endnum : Integer; //ĨX
    ret : Boolean;
begin
    ret := true;
    datstl := TStringList.Create;
    try
        try
            datstl.LoadFromFile(datfilepath);
            if (firstres > 0) and (firstres <= datstl.Count) then begin
                if firstres + count -1 > datstl.Count then begin
                    endnum := datstl.Count;
                end else if count <= 0 then begin
                    endnum := firstres + 1;
                end else begin
                    endnum := firstres + count -1;
                end;

                for i := firstres to endnum do begin
                    if AnsiPos(FAbonString, datstl.Strings[i-1]) <> 1 then begin
                        datstl.Strings[i-1] := FAbonString + datstl.Strings[i-1];
                    end;
                end;
            end;
            datstl.SaveToFile(datfilepath);
        except
            ret := false;
        end;
    finally
        datstl.Free;
    end;
    Result := ret;
end;
//DAT𒼂ɂz==========܂=========================================

//ɖ߂z==================================================================
function TAbon.ReverseExecuteFile(datfilepath : String) : Boolean; //DATt@C𒼂ɂ
var
    datstl : TStringList;
    i : Integer;
    buf : String;
    ret : Boolean;
begin
    ret := true;
    datstl := TStringList.Create;
    try
        try
            datstl.LoadFromFile(datfilepath);
            for i:=0 to datstl.Count -1  do begin
                if AnsiPos(FAbonString, datstl.Strings[i]) = 1 then begin
                    buf := datstl.Strings[i];
                    Delete(buf,1,Length(FAbonString));
                    datstl.Strings[i] := buf;
                end;
            end;
            datstl.SaveToFile(datfilepath);
        except
            ret := false;
        end;
    finally
        datstl.Free;
    end;
    Result := ret;

end;
function TAbon.ReverseExecuteFile(datfilepath : String; resnum : Integer) : Boolean; //DATt@C𒼂ɂ
var
    datstl : TStringList;
    buf : String;
    ret : Boolean;
begin
    ret := true;
    datstl := TStringList.Create;
    try
        try
            datstl.LoadFromFile(datfilepath);
            if (resnum > 0) and (resnum <= datstl.Count) then begin
                if AnsiPos(FAbonString, datstl.Strings[resnum-1]) = 1 then begin
                    buf := datstl.Strings[resnum-1];
                    Delete(buf,1,Length(FAbonString));
                    datstl.Strings[resnum-1] := buf;
                end;
            end;
            datstl.SaveToFile(datfilepath);
        except
            ret := false;
        end;
    finally
        datstl.Free;
    end;
    Result := ret;

end;
function TAbon.ReverseExecuteFile(datfilepath : String; firstres : Integer; count : Integer) : Boolean;//DATt@C𒼂ɂ
var
    datstl : TStringList;
    i : Integer;
    endnum : Integer; //ĨX
    buf : String;
    ret : Boolean;
begin
    ret := true;
    datstl := TStringList.Create;
    try
        try
            datstl.LoadFromFile(datfilepath);
            if (firstres > 0) and (firstres <= datstl.Count) then begin
                if firstres + count -1 > datstl.Count then begin
                    endnum := datstl.Count;
                end else if count <= 0 then begin
                    endnum := firstres + 1;
                end else begin
                    endnum := firstres + count -1;
                end;
                for i := firstres to endnum do begin
                    if AnsiPos(FAbonString, datstl.Strings[i-1]) = 1 then begin
                        buf := datstl.Strings[i-1];
                        Delete(buf,1,Length(FAbonString));
                        datstl.Strings[i-1] := buf;
                    end;
                end;
            end;
            datstl.SaveToFile(datfilepath);
        except
            ret := false;
        end;
    finally
        datstl.Free;
    end;
    Result := ret;
end;
//ɖ߂z=================܂=========================================
//݃ZbgĂNGword.txtJ
procedure TAbon.EditNGwords();
begin
    ShellExecute(0 ,nil,PChar(FNGwordpath),nil,nil,SW_SHOW);
end;
function TAbon.CheckAbonPopupRes(line : String) :Boolean;
var
    i : Integer;
begin
    if FCutoffNum  = 0 then begin
        if AbonPopupRes = true then begin
            Result := FindNGwords(line);
        end else begin
            Result := false;
        end;
    end else begin
        if AbonPopupRes = true then begin
            Result := FindNGwords(line);
            if Result = false then begin
                for i := 0 to 2 do begin
                    Delete(line,1,Ansipos('<>',line)+1);
                end;
                Delete(line,Ansipos('<>',line),Length(line)-Ansipos('<>',line)+1);
                Result := Cutoff(line);
            end;
        end else begin
            Result := false;
        end;
    end;
end;


end.

