unit GikoSystem;

interface

uses
	Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
	ComCtrls, IniFiles, ShellAPI, ActnList, Math,
{$IF Defined(DELPRO) }
	SHDocVw,
	MSHTML,
{$ELSE}
	SHDocVw_TLB,
	MSHTML_TLB,
{$IFEND}
	{HttpApp,} YofUtils, URLMon, IdGlobal, IdURI, {Masks,}
	Setting, BoardGroup, gzip, Dolib, bmRegExp, AbonUnit;

type
	//BBS^Cv
	TGikoBBSType = (gbt2ch);
	//O^Cv
	TGikoLogType = (glt2chNew, glt2chOld);
	//bZ[WACR
	TGikoMessageIcon = (gmiOK, gmiSAD, gmiNG, gmiWhat, gmiNone);
	//URLI[vuEU^Cv
	TGikoBrowserType = (gbtIE, gbtUserApp, gbtAuto);


	TStrTokSeparator = set of Char;
	TStrTokRec = record
		Str: string;
		Pos: Integer;
	end;

	//CfbNXt@CR[h
	TIndexRec = record
		FNo: Integer;
		FFileName: string;
		FTitle: string;
		FCount: Integer;
		FSize: Integer;
//		FRoundNo: Integer;
		FRoundDate: TDateTime;
		FLastModified: TDateTime;
		FKokomade: Integer;
		FNewReceive: Integer;
		FMishiyou: Boolean;	//gp
		FUnRead: Boolean;
		FScrollTop: Integer;
		//Index Ver 1.01
		FAllResCount: Integer;
		FNewResCount: Integer;
		FAgeSage: TGikoAgeSage;
	end;

	//TuWFNgR[h
	TSubjectRec = record
		FFileName: string;
		FTitle: string;
		FCount: Integer;
	end;

	//XR[h
	TResRec = record
		FTitle: string;
		FMailTo: string;
		FName: string;
		FDateTime: string;
		FBody: string;
		FType: TGikoLogType;
	end;

	//URLPathR[h
	TPathRec = record
		FBBS: string;				//BBSID
		FKey: string;				//ThreadID
		FSt: Integer;				//JnX
		FTo: Integer;				//IX
		FFirst: Boolean;		//>>1̕\
		FStBegin: Boolean;  //1`\
		FToEnd: Boolean;		//`Ō܂ŕ\
		FDone: Boolean;			//
	end;

	TGikoSys = class(TObject)
	private
		{ Private 錾 }
		FSetting: TSetting;
		FDolib: TDolib;
		FAWKStr: TAWKStr;
//		FExitWrite: TStringList;
//		function StrToFloatDef(s: string; Default: Double): Double;

	public
		{ Public 錾 }
        FAbon : TAbon;
        FSelectResFilter : TAbon;
		constructor Create;

		destructor Destroy; override;


//		function MsgBox(Msg: string; Title: string; Flags: Longint): integer; overload;
//		function MsgBox(Handle: THandle; Msg: string; Title: string; Flags: Longint): integer; overload;
		function IsNumeric(s: string): boolean;
		function IsFloat(s: string): boolean;
		function DirectoryExistsEx(const Name: string): Boolean;
		function ForceDirectoriesEx(Dir: string): Boolean;
//		function GetVersion: string;

		function GetBoardFileName: string;
		function GetCustomBoardFileName: string;
		function GetHtmlTempFileName: string;
		function GetAppDir: string;
		function GetTempFolder: string;
		function GetSentFileName: string;
		function GetConfigDir: string;
		function GetStyleSheetDir: string;
		function GetOutBoxFileName: string;
		function GetURL(BBSID: string; FileName: string): string;
		function GetUserAgent: string;

		procedure ReadSubjectFile(Board: TBoard);
		procedure CreateThreadDat(Board: TBoard);
		procedure WriteThreadDat(Board: TBoard);
		function ParseIndexLine(Line: string): TIndexRec;
		procedure GetFileList(Path: string; Mask: string; List: TStringList; SubDir: Boolean; IsPathAdd: Boolean);

		procedure CreateHTML2(doc: Variant; ThreadItem: TThreadItem; var sTitle: string);
		function AddAnchorTag(s: string): string;

		function DivideSubject(Line: string): TSubjectRec;
		function DivideStrLine(Line: string): TResRec;

		property Setting: TSetting read FSetting write FSetting;
		property Dolib: TDolib read FDolib write FDolib;

		function UrlToID(url: string): string;
		function UrlToServer(url: string): string;

		function StrTokFirst(const s:string; const sep:TStrTokSeparator; var Rec:TStrTokRec):string;
		function StrTokNext(const sep:TStrTokSeparator; var Rec:TStrTokRec): string;

		function GetFileSize(FileName : string) : longint;
		function GetFileLineCount(FileName : string): longint;
		function Get2chDate(aDate: TDateTime): string;
		function IntToDateTime(val: Int64): TDateTime;
		function DateTimeToInt(ADate: TDateTime): Integer;

		function ReadThreadFile(FileName: string; Line: Integer): string;

		procedure MenuFont(Font: TFont);

		function RemoveToken(var s:string;delimiter:string):string;
		function GetTokenIndex(s: string; delimiter: string; index: Integer): string;

		function DeleteLink(const s: string): string;

		function GetShortName(const LongName: string; ALength: integer): string;
		function ConvRes(const Body, Bbs, Key,	ParamBBS, ParamKey, ParamStart, ParamTo, ParamNoFirst, ParamTrue : string): string;

		function ZenToHan(const s: string): string;
		function VaguePos(const Substr, S: string): Integer;
		function BoolToInt(b: Boolean): Integer;
		function IntToBool(i: Integer): Boolean;
		function GzipDecompress(ResStream: TStream; ContentEncoding: string): string;
		procedure LoadKeySetting(ActionList: TActionList);
		procedure SaveKeySetting(ActionList: TActionList);
		procedure CreateProcess(const AppPath: string; const Param: string);
		procedure OpenBrowser(URL: string; BrowserType: TGikoBrowserType);
		function HTMLDecode(const AStr: String): String;
		function GetHRefText(s: string): string;
		function Is2chHost(Host: string): Boolean;
		function Parse2chURL(const url: string; const path: string; const document: string; var BBSID: string; var BBSKey: string): Boolean;
		function Parse2chURL2(URL: string): TPathRec;
		procedure ParseURI(var URL, Protocol, Host, Path, Document, Port, Bookmark: string);
		function GetVersionBuild: Integer;
	end;

var
	GikoSys: TGikoSys;
const
	LENGTH_RESTITLE     = 40;
	ZERO_DATE: Integer  = 25569;
	BETA_VERSION_NAME_E = 'beta';
	BETA_VERSION_NAME_J = '';
	BETA_VERSION        = 34;
	BETA_VERSION_BUILD  = '';				//debugłȂ

implementation

uses
	Giko, RoundData;

const
	BOARD_FILE_NAME               = 'board.2ch';
	CUSTOMBOARD_FILE_NAME         = 'custom.2ch';
	KEY_SETTING_FILE_NAME         = 'key.ini';
	TEMP_FOLDER                   = 'Temp';
	OUTBOX_FILE_NAME              = 'outbox.ini';
	SENT_FILE_NAME                = 'sent.ini';
	CONFIG_DIR_NAME               = 'config';
	CSS_DIR_NAME									= 'css';
	FOLDER_INDEX_VERSION          = '1.01';
	USER_AGENT                    = 'Monazilla';
	APP_NAME                      = 'gikoNavi';
		DEFAULT_NGWORD_FILE_NAME : String = 'NGword.txt';

(*************************************************************************
 *GikoSysRXgN^
 *************************************************************************)
constructor TGikoSys.Create;
begin
	FSetting := TSetting.Create;
	FDolib := TDolib.Create;
	FAWKStr := TAWKStr.Create(nil);
		FAbon := TAbon.Create;
		FAbon.Setroot(GetAppDir);
		FAbon.SetNGwordpath(DEFAULT_NGWORD_FILE_NAME);
		FSelectResFilter := TAbon.Create;
		FSelectResFilter.Setroot( GetAppDir );
		// iȂꍇ False Ȃ̂łȂ
		// FSelectResFilter.Reverse := True;
		// i荞ނƂ͋ɗ͈ꗗق̂ő͊Sɍ폜
		FSelectResFilter.AbonString := '';
end;

(*************************************************************************
 *GikoSysfXgN^
 *************************************************************************)
destructor TGikoSys.Destroy;
var
	i: Integer;
	FileList: TStringList;
begin
	//Xbhf[^t@CXV
//	FlashExitWrite;

//	FExitWrite.Free;
	FAWKStr.Free;
	FSetting.Free;
	FDolib.Free;

	//e|HTML폜
	FileList := TStringList.Create;
	try
		GetFileList(GetTempFolder, '*.html', FileList, False, True);
		for i := 0 to FileList.Count - 1 do begin
			DeleteFile(FileList[i]);
		end;
	finally
		FileList.Free;
	end;
	inherited;
end;

(*************************************************************************
 *񐔎`FbN
 *************************************************************************)
{$HINTS OFF}
function TGikoSys.IsNumeric(s: string): boolean;
var
	e: integer;
	v: integer;
begin
	Val(s, v, e);
	Result := e = 0;
end;
{$HINTS ON}

(*************************************************************************
 *񕂓_`FbN
 *************************************************************************)
function TGikoSys.IsFloat(s: string): boolean;
var
	v: Extended;
begin
	Result := TextToFloat(PChar(s), v, fvExtended);
end;

(*************************************************************************
 *{[ht@C擾ipX{t@Cj
 *************************************************************************)
function TGikoSys.GetBoardFileName: string;
begin
	Result := GetAppDir + CONFIG_DIR_NAME + '\' + BOARD_FILE_NAME;
end;

(*************************************************************************
 *{[ht@C擾ipX{t@Cj
 *************************************************************************)
function TGikoSys.GetCustomBoardFileName: string;
begin
	Result := GetAppDir + CONFIG_DIR_NAME + '\' + CUSTOMBOARD_FILE_NAME;
end;

(*************************************************************************
 *e|tH_[擾
 *************************************************************************)
function TGikoSys.GetHtmlTempFileName: string;
begin
	Result := TEMP_FOLDER;
end;


(*************************************************************************
 *st@CtH_擾
 *************************************************************************)
function TGikoSys.GetAppDir: string;
begin
	Result := ExtractFilePath(Application.ExeName);
end;

(*************************************************************************
 *TempHtmlt@C擾ipX{t@Cj
 *************************************************************************)
function TGikoSys.GetTempFolder: string;
begin
	Result := GetAppDir + TEMP_FOLDER;
end;

(*************************************************************************
 *sent.init@C擾ipX{t@Cj
 *************************************************************************)
function TGikoSys.GetSentFileName: string;
begin
	Result := GetAppDir + SENT_FILE_NAME;
end;

(*************************************************************************
 *outbox.init@C擾ipX{t@Cj
 *************************************************************************)
function TGikoSys.GetOutBoxFileName: string;
begin
	Result := GetAppDir + OUTBOX_FILE_NAME;
end;

(*************************************************************************
 *ConfigtH_擾
 *************************************************************************)
function TGikoSys.GetConfigDir: string;
begin
	Result := IncludeTrailingPathDelimiter(GetAppDir + CONFIG_DIR_NAME);
end;

function TGikoSys.GetStyleSheetDir: string;
begin
	Result := IncludeTrailingPathDelimiter(GetConfigDir + CSS_DIR_NAME);
end;

(*************************************************************************
 *URL쐬(Rsyp)
 *************************************************************************)
function TGikoSys.GetURL(BBSID: string; FileName: string): string;
var
	Board: TBoard;
begin
	Board := BoardGroup.BBS2ch.GetBoardFromBBSID(BBSID);
	Result := UrlToServer(Board.URL) + 'test/read.cgi/' + UrlToID(Board.URL) + '/' + ChangeFileExt(FileName, '') + '/l50';
	//http://teri.2ch.net/test/read.cgi?bbs=accuse&key=974619522&ls=50
	//http://pc.2ch.net/test/read.cgi/tech/1003664165/l50
end;

// UserAgent擾
function TGikoSys.GetUserAgent: string;
begin
	if Dolib.Connected then begin
		Result := Format('%s %s/%s%d%s', [
								Dolib.UserAgent,
								APP_NAME,
								//MAJOR_VERSION,
								//MINOR_VERSION,
								BETA_VERSION_NAME_E,
								BETA_VERSION,
								BETA_VERSION_BUILD]);
	end else begin
		Result := Format('%s/%s %s/%s%d%s', [
								USER_AGENT,
								Dolib.Version,
								APP_NAME,
								//MAJOR_VERSION,
								//MINOR_VERSION,
								BETA_VERSION_NAME_E,
								BETA_VERSION,
								BETA_VERSION_BUILD]);
	end;
end;

(*************************************************************************
 *Q˂擾
 *************************************************************************)
function TGikoSys.Get2chDate(aDate: TDateTime): string;
var
	d1: TDateTime;
	d2: TDateTime;
begin
	d1 := EncodeDate(1970, 1, 1);
	d2 := aDate - EncodeTime(9, 0, 0, 0);
	Result := FloatToStr(Trunc((d2 - d1) * 24 * 60 * 60));
end;


function TGikoSys.IntToDateTime(val: Int64): TDateTime;
var
	d1: tdatetime;
	d2: tdatetime;
begin
	d1 := EncodeDate(1970, 1, 1);
	d2 := (val * 1000) / (24 * 60 * 60 * 1000);
	Result := d1 + d2;
end;

function TGikoSys.DateTimeToInt(ADate: TDateTime): Integer;
var
	d: TDateTime;
	c: Currency;
begin
	d := EncodeDate(1970, 1, 1);
	c := (ADate - d) * 24 * 60 * 60;
	Result := Trunc(c);
end;


(*************************************************************************
 *Subjectt@CRead
 *************************************************************************)
procedure TGikoSys.ReadSubjectFile(Board: TBoard);
var
	ThreadItem: TThreadItem;
	FileName: string;
	FileList: TStringList;
	TmpFileList: TStringList;
//	SrchRec: TSearchRec;
//	R: integer;
	Index: Integer;
	sl: TStringList;
	i: Integer;
	Rec: TIndexRec;
	UnRead: Integer;
	TmpUpdate: Boolean;
	ini: TMemIniFile;
	ResRec: TResRec;
	RoundItem: TRoundItem;
	idx: Integer;
begin
	Board.Clear;
	UnRead := 0;
	TmpUpdate := False;

	FileName := Board.GetFolderIndexFileName;
	if not FileExists(FileName) then CreateThreadDat(Board);
//	if not FileExists(FileName) then Exit;

	//IsLogFilepDATt@CXg
	FileList := TStringList.Create;
	FileList.Sorted := True;
	GetFileList(ExtractFileDir(Board.GetFolderIndexFileName), '*.dat', FileList, False, False);

	//OُIpTmpt@CXg
	TmpFileList := TStringList.Create;
	TmpFileList.Sorted := True;
	GetFileList(ExtractFileDir(Board.GetFolderIndexFileName), '*.tmp', TmpFileList, False, False);

{	R := FindFirst(ExtractFileDir(Board.GetFolderIndexFileName) + '\*.dat', 0, SrchRec);
	while R = 0 do begin
		FileList.Add(SrchRec.Name);
		R := FindNext(SrchRec);
	end;
	FindClose(SrchRec);}

	sl := TStringList.Create;
	try
		if FileExists(FileName) then
			sl.LoadFromFile(FileName);

		//QsڂiPsڂ̓o[Wj
		for i := 1 to sl.Count - 1 do begin
			Rec := ParseIndexLine(sl[i]);

			ThreadItem := TThreadItem.Create;
			ThreadItem.BeginUpdate;
			ThreadItem.No := Rec.FNo;
			ThreadItem.FileName := Rec.FFileName;
			ThreadItem.Title := Rec.FTitle;
			ThreadItem.Count := Rec.FCount;
			ThreadItem.Size := Rec.FSize;
//			ThreadItem.RoundNo := Rec.FRoundNo;
			ThreadItem.RoundDate := Rec.FRoundDate;
			ThreadItem.LastModified := Rec.FLastModified;
			ThreadItem.Kokomade := Rec.FKokomade;
			ThreadItem.NewReceive := Rec.FNewReceive;
//			ThreadItem.Round := Rec.FRound;
			ThreadItem.UnRead := Rec.FUnRead;
			ThreadItem.ScrollTop := Rec.FScrollTop;
			ThreadItem.AllResCount := Rec.FAllResCount;
			ThreadItem.NewResCount := Rec.FNewResCount;
			ThreadItem.AgeSage := Rec.FAgeSage;
			ThreadItem.ParentBoard := Board;

			//IsLogFile`FbN
			ThreadItem.IsLogFile := False;
			if FileList.Count <> 0 then begin
				if FileList.Find(ThreadItem.FileName, Index) then begin
					ThreadItem.IsLogFile := True;
					FileList.Delete(Index);
				end;
			end;

			//񃊃Xgɑ݂珄tOZbg
			if ThreadItem.IsLogFile then begin
				idx := RoundList.Find(ThreadItem);
				if idx <> -1 then begin
					RoundItem := RoundList.Items[idx, grtItem];
					ThreadItem.RoundName := RoundItem.RoundName;
					ThreadItem.Round := True;
				end;
			end;

			//OُI`FbN
			if TmpFileList.Count <> 0 then begin
				if TmpFileList.Find(ChangeFileExt(ThreadItem.FileName, '.tmp'), Index) then begin
					ini := TMemIniFile.Create(ChangeFileExt(ThreadItem.GetThreadFileName, '.tmp'));
					try
						ThreadItem.RoundDate := ini.ReadDateTime('Setting', 'RoundDate', ZERO_DATE);
						ThreadItem.LastModified := ini.ReadDateTime('Setting', 'LastModified', ZERO_DATE);
						ThreadItem.Size := ini.ReadInteger('Setting', 'Size', 0);
						ThreadItem.Count := ini.ReadInteger('Setting', 'Count', 0);
						ThreadItem.NewReceive := ini.ReadInteger('Setting', 'NewReceive', 0);
						ThreadItem.Round := ini.ReadBool('Setting', 'Round', False);
						ThreadItem.UnRead := False;//ini.ReadBool('Setting', 'UnRead', False);
						ThreadItem.ScrollTop := ini.ReadInteger('Setting', 'ScrollTop', 0);
						ThreadItem.AllResCount := ini.ReadInteger('Setting', 'AllResCount', 0);
						ThreadItem.NewResCount := ini.ReadInteger('Setting', 'NewResCount', 0);
						ThreadItem.AgeSage := TGikoAgeSage(ini.ReadInteger('Setting', 'AgeSage', Ord(gasNone)));
					finally
						ini.Free;
					end;
					TmpFileList.Delete(Index);
				end;
			end;

			ThreadItem.EndUpdate;
			Board.Add(ThreadItem);

//			if (ThreadItem.IsLogFile) and (ThreadItem.Count > ThreadItem.Kokomade) then
			if (ThreadItem.IsLogFile) and (ThreadItem.UnRead) then
				Inc(UnRead);
		end;
		if UnRead <> Board.UnRead then
			Board.UnRead := UnRead;

		//CfbNXɖOǉiCfbNXΉj
		for i := 0 to FileList.Count - 1 do begin
			FileName := ExtractFileDir(Board.GetFolderIndexFileName) + '\' + FileList[i];

			ResRec := DivideStrLine(ReadThreadFile(FileName, 1));
			ThreadItem := TThreadItem.Create;
			ThreadItem.No := Board.Count + 1;
			ThreadItem.FileName := FileList[i];
			ThreadItem.Title := ResRec.FTitle;
			ThreadItem.Count := GetFileLineCount(FileName);
			ThreadItem.AllResCount := ThreadItem.Count;
			ThreadItem.NewResCount := 0;
			ThreadItem.Size := 0;
			ThreadItem.RoundDate := ZERO_DATE;
			ThreadItem.LastModified := ZERO_DATE;
			ThreadItem.Kokomade := -1;
			ThreadItem.NewReceive := 0;
			ThreadItem.ParentBoard := Board;
			ThreadItem.IsLogFile := True;
			ThreadItem.Round := False;
			ThreadItem.UnRead := False;
			ThreadItem.ScrollTop := 0;
			ThreadItem.AgeSage := gasNone;
			Board.Add(ThreadItem);
		end;
	finally
		sl.Free;
	end;
	FileList.Free;
	TmpFileList.Free;
	Board.IsThreadDatRead := True;
end;

(*************************************************************************
 *XbhCfbNXt@C(Folder.idx)쐬
 *************************************************************************)
procedure TGikoSys.CreateThreadDat(Board: TBoard);
var
	i: integer;
	s: string;
	SubjectList: TStringList;
	sl: TStringList;
	Rec: TSubjectRec;
	FileName: string;
	cnt: Integer;
begin
	if not FileExists(Board.GetSubjectFileName) then Exit;
	FileName := Board.GetFolderIndexFileName;

	SubjectList := TStringList.Create;
	try
		SubjectList.LoadFromFile(Board.GetSubjectFileName);
		sl := TStringList.Create;
		try
			cnt := 1;
			sl.Add(FOLDER_INDEX_VERSION);
			for i := 0 to SubjectList.Count - 1 do begin
				Rec := DivideSubject(SubjectList[i]);

				if (Trim(Rec.FFileName) = '') or (Trim(Rec.FTitle) = '') then
					Continue;

				s := Format('%x', [cnt]) + #1					//ԍ
					 + Rec.FFileName + #1								//t@C
					 + Rec.FTitle + #1									//^Cg
					 + Format('%x', [Rec.FCount]) + #1	//JEg
					 + Format('%x', [0]) + #1						//size
					 + Format('%x', [0]) + #1						//RoundDate
					 + Format('%x', [0]) + #1						//LastModified
					 + Format('%x', [0]) + #1						//Kokomade
					 + Format('%x', [0]) + #1						//NewReceive
					 + '0' + #1           							//gp
					 + Format('%x', [0]) + #1						//UnRead
					 + Format('%x', [0]) + #1						//ScrollTop
					 + Format('%x', [Rec.FCount]) + #1	//AllResCount
					 + Format('%x', [0]) + #1						//NewResCount
					 + Format('%x', [0]);								//AgeSage

				sl.Add(s);
				inc(cnt);
			end;
			sl.SaveToFile(FileName);
		finally
			sl.Free;
		end;
	finally
		SubjectList.Free;
	end;
end;

(*************************************************************************
 *XbhCfbNX(Thread.dat)
 *Public
 *************************************************************************)
procedure TGikoSys.WriteThreadDat(Board: TBoard);
//const
//	Values: array[Boolean] of string = ('0', '1');
var
	i: integer;
	FileName: string;
	sl: TStringList;
	s: string;
	FileList: TStringList;
begin
	if not Board.IsThreadDatRead then
		Exit;
	FileName := Board.GetFolderIndexFileName;
	ForceDirectoriesEx(Board.ParentCategory.ParentBBS2ch.GetLogFolder + Board.BBSID);

	sl := TStringList.Create;
	try
		sl.Add(FOLDER_INDEX_VERSION);
		for i := 0 to Board.Count - 1 do begin
			if Board.Items[i].No = 0 then
				Board.Items[i].No := i + 1;

			s := Format('%x', [Board.Items[i].No]) + #1
				 + Board.Items[i].FileName + #1
				 + Board.Items[i].Title + #1
				 + Format('%x', [Board.Items[i].Count]) + #1
				 + Format('%x', [Board.Items[i].Size]) + #1
				 + Format('%x', [DateTimeToInt(Board.Items[i].RoundDate)]) + #1
				 + Format('%x', [DateTimeToInt(Board.Items[i].LastModified)]) + #1
				 + Format('%x', [Board.Items[i].Kokomade]) + #1
				 + Format('%x', [Board.Items[i].NewReceive]) + #1
				 + '0' + #1	//gp
				 + Format('%x', [BoolToInt(Board.Items[i].UnRead)]) + #1
				 + Format('%x', [Board.Items[i].ScrollTop]) + #1
				 + Format('%x', [Board.Items[i].AllResCount]) + #1
				 + Format('%x', [Board.Items[i].NewResCount]) + #1
				 + Format('%x', [Ord(Board.Items[i].AgeSage)]);

			sl.Add(s);
		end;

		sl.SaveToFile(FileName);

		FileList := TStringList.Create;
		try
			GetFileList(ExtractFileDir(Board.GetFolderIndexFileName), '*.tmp', FileList, False, True);
			for i := 0 to FileList.Count - 1 do begin
				DeleteFile(FileList[i]);
			end;
		finally
			FileList.Free;
		end;
	finally
		sl.Free;
	end;
end;

function TGikoSys.ParseIndexLine(Line: string): TIndexRec;
var
	s: string;
	i: Integer;
begin
	for i := 0 to 14 do begin
		s := GetTokenIndex(Line, #1, i);
		case i of
			0: Result.FNo := StrToIntDef('$' + s, 0);
			1: Result.FFileName := s;
			2: Result.FTitle := s;
			3: Result.FCount := StrToIntDef('$' + s, 0);
			4: Result.FSize := StrToIntDef('$' + s, 0);
			5: Result.FRoundDate := IntToDateTime(StrToIntDef('$' + s, ZERO_DATE));
			6: Result.FLastModified := IntToDateTime(StrToIntDef('$' + s, ZERO_DATE));
			7: Result.FKokomade := StrToIntDef('$' + s, -1);
			8: Result.FNewReceive := StrToIntDef('$' + s, 0);
			9: ;	//gp
			10: Result.FUnRead := IntToBool(StrToIntDef('$' + s, 0));
			11: Result.FScrollTop := StrToIntDef('$' + s, 0);
			12: Result.FAllResCount := StrToIntDef('$' + s, 0);
			13: Result.FNewResCount := StrToIntDef('$' + s, 0);
			14: Result.FAgeSage := TGikoAgeSage(StrToIntDef('$' + s, 0));
		end;
	end;
end;

//wtH_̎wt@Cꗗ擾
// ListFiles('c:\', '*.txt', list, True);
procedure TGikoSys.GetFileList(Path: string; Mask: string; List: TStringList; SubDir: Boolean; IsPathAdd: Boolean);
var
	rc: Integer;
	SearchRec : TSearchRec;
	s: string;
begin
	Path := IncludeTrailingPathDelimiter(Path);
	rc := FindFirst(Path + '*.*', faAnyfile, SearchRec);
	try
		while rc = 0 do begin
			if (SearchRec.Name <> '..') and (SearchRec.Name <> '.') then begin
				s := Path + SearchRec.Name;
				//if (SearchRec.Attr and faDirectory > 0) then
				//	s := IncludeTrailingPathDelimiter(s)

				if (SearchRec.Attr and faDirectory = 0) and (MatchesMask(s, Mask)) then
					if IsPathAdd then
						List.Add(s)
					else
						List.Add(SearchRec.Name);
				if SubDir and (SearchRec.Attr and faDirectory > 0) then
					GetFileList(s, Mask, List, True, IsPathAdd);
			end;
			rc := FindNext(SearchRec);
		end;
	finally
		SysUtils.FindClose(SearchRec);
	end;
end;

procedure TGikoSys.CreateHTML2(doc: Variant; ThreadItem: TThreadItem; var sTitle: string);
var
	i: integer;
	No: string;
    bufList : TStringList;
	ReadList: TStringList;
	SaveList: TStringList;
	CSSFileName: string;
	BBSID: string;
	FileName: string;
	NewReceiveNo: Integer;
	Res: TResRec;
begin
	ShortDayNames[1] := '';		ShortDayNames[2] := '';
	ShortDayNames[3] := '';		ShortDayNames[4] := '';
	ShortDayNames[5] := '';		ShortDayNames[6] := '';
	ShortDayNames[7] := 'y';
	BBSID := ThreadItem.ParentBoard.BBSID;
	FileName := ThreadItem.FileName;
	NewReceiveNo := ThreadItem.NewReceive;
	FileName := ThreadItem.GetThreadFileName;
    bufList := TStringList.Create;
	ReadList := TStringList.Create;
    FAbon.Deleterlo := FSetting.AbonDeleterlo;
    FAbon.Replaceul := FSetting.AbonReplaceul;
    FAbon.SetCutoffNum(FSetting.AbonCutoffNum);
    FAbon.AbonPopupRes := FSetting.PopUpAbon;
	try
		if ThreadItem.IsLogFile then begin
            bufList.LoadFromFile(FileName);
            //Boolean̈AboñvpeBɂ
            ReadList.AddStrings( FSelectResFilter.Execute( FAbon.Execute(bufList) ) );
			Res := DivideStrLine(ReadList[0]);
			Res.FTitle := StringReplace(Res.FTitle, 'M', ',', [rfReplaceAll]);
			sTitle := Res.FTitle;

		end else begin
			sTitle := StringReplace(ThreadItem.Title, 'M', ',', [rfReplaceAll]);
		end;
		SaveList := TStringList.Create;
		try
			doc.open;
			doc.charset := 'Shift_JIS';

			CSSFileName := GetStyleSheetDir + Setting.CSSFileName;
			if GikoSys.Setting.UseCSS and FileExists(CSSFileName) then begin
				//CSSgp
				//CSSFileName := GetAppDir + CSS_FILE_NAME;
//				SaveList.Add('<html lang="ja"><head>');
				SaveList.Add('<html><head>');
				SaveList.Add('<meta http-equiv="Content-type" content="text/html; charset=Shift_JIS">');
				SaveList.Add('<title>' + sTitle + '</title>');
				SaveList.Add('<style type="text/css">');
				SaveList.Add('@import url(' + CSSFileName + ');');
				SaveList.Add('</style>');
				SaveList.Add('</head>');
				SaveList.Add('<body>');
				SaveList.Add('<a name="top"></a>');
				SaveList.Add('<div class="title">' + sTitle + '</div>');
				//doc.Write(SaveList.Text);
				//SaveList.Clear;
				//Application.ProcessMessages;
				for i := 0 to ReadList.Count - 1 do begin
					if (Trim(ReadList[i]) <> '') then begin
						No := IntToStr(i + 1);
						if (NewReceiveNo = (i + 1)) or ((NewReceiveNo = 0) and (i = 0)) then begin
							SaveList.Add('<a name="new"></a><div class="new">VX <span class="newdate">' + FormatDateTime('yyyy/mm/dd(ddd) hh:mm', ThreadItem.RoundDate) + '</span></div>');
						end;
						Res := DivideStrLine(ReadList[i]);
						Res.FBody := ConvRes(Res.FBody, ThreadItem.ParentBoard.BBSID, ChangeFileExt(ThreadItem.FileName, ''), 'bbs', 'key', 'st', 'to', 'nofirst', 'true');

						if Res.FType = glt2chOld then begin
							Res.FMailTo := StringReplace(Res.FMailTo, 'M', ',', [rfReplaceAll]);
							Res.FName := StringReplace(Res.FName, 'M', ',', [rfReplaceAll]);
							Res.FBody := StringReplace(Res.FBody, 'M', ',', [rfReplaceAll]);
						end;
						//Res.FBody := StringReplace(Res.FBody, '&amphearts;', '&hearts;', [rfReplaceAll]);
						//Res.FBody := StringReplace(Res.FBody, '&ampnbsp;', '&nbsp;', [rfReplaceAll]);
						//Res.FBody := StringReplace(Res.FBody, '&amp#', '&#', [rfReplaceAll]);
						//Res.FBody := StringReplace(Res.FBody, '&amp', '&amp;', [rfReplaceAll]);
						Res.FBody := AddAnchorTag(Res.FBody);
						if Res.FName = '' then
							Res.FName := '&nbsp;';
						if Res.FMailTo = '' then
							SaveList.Add('<a name="' + No + '"></a>'
												 + '<div class="header"><span class="no"><a href="giko://?no=' + No + '">' + No + '</a></span> '
												 + '<span class="name_label">OF</span> '
												 + '<span class="name"><b>' + Res.FName + '</b></span> '
												 + '<span class="date_label">eF</span> '
												 + '<span class="date">' + Res.FDateTime+ '</span></div>'
												 + '<div class="mes">' + Res.FBody + ' </div>')
						else
							if GikoSys.Setting.ShowMail then
								SaveList.Add('<a name="' + No + '"></a>'
													 + '<div class="header"><span class="no"><a href="giko://?no=' + No + '">' + No + '</a></span>'
													 + '<span class="name_label"> OF </span>'
													 + '<a class="name_mail" href="mailto:' + Res.FMailTo + '">'
													 + '<b>' + Res.FName + '</a></b><span class="mail"> [' + Res.FMailTo + ']</span>'
													 + '<span class="date_label"> eF</span>'
													 + '<span class="date"> ' + Res.FDateTime+ '</span></div>'
													 + '<div class="mes">' + Res.FBody + ' </div>')
							else
								SaveList.Add('<a name="' + No + '"></a>'
													 + '<div class="header"><span class="no"><a href="giko://?no=' + No + '">' + No + '</a></span>'
													 + '<span class="name_label"> OF </span>'
													 + '<a class="name_mail" href="mailto:' + Res.FMailTo + '">'
													 + '<b>' + Res.FName + '</a></b>'
													 + '<span class="date_label"> eF</span>'
													 + '<span class="date"> ' + Res.FDateTime+ '</span></div>'
													 + '<div class="mes">' + Res.FBody + ' </div>');
						if ThreadItem.Kokomade = (i + 1) then begin
							SaveList.Add('<a name="koko"></a><div class="koko">RR܂œǂ</div>');
						end;
					end;
					//if SaveList.Count > 50 then begin
					if i = 20 then begin
						//Sleep(1);
						//Application.ProcessMessages;

						doc.Write(SaveList.Text);
						//while GikoForm.Browser.Busy do begin
						//	Sleep(1);
						//	Application.ProcessMessages;
						//end;
						while (GikoForm.Browser.ReadyState <> READYSTATE_COMPLETE) and
									(GikoForm.Browser.ReadyState <> READYSTATE_INTERACTIVE) do begin
							//Sleep(1);
							//Application.ProcessMessages;
						end;
						SaveList.Clear;
					end;
				end;
				SaveList.Add('<a name="bottom"></a>');
				SaveList.Add('</body></html>');
				SaveList.Add('</dl>');
				SaveList.Add('<a name="last"></a>');
				SaveList.Add('</body></html>');
				doc.Write(SaveList.Text);
			end else begin
				//CSSgp
//				SaveList.Add('<html lang="ja"><head>');
				SaveList.Add('<html><head>');
				SaveList.Add('<meta http-equiv="Content-type" content="text/html; charset=Shift_JIS">');
				SaveList.Add('<title>' + sTitle + '</title></head>');
				SaveList.Add('<body TEXT="#000000" BGCOLOR="#EFEFEF" link="#0000FF" alink="#FF0000" vlink="#660099">');
				SaveList.Add('<a name="top"></a>');
				SaveList.Add('<font size=+1 color="#FF0000">' + sTitle + '</font>');
				SaveList.Add('<dl>');
				doc.Write(SaveList.Text);
				SaveList.Clear;
				//Application.ProcessMessages;
				for i := 0 to ReadList.Count - 1 do begin
					if (Trim(ReadList[i]) <> '') then begin
						No := IntToStr(i + 1);

						if (NewReceiveNo = (i + 1)) or ((NewReceiveNo = 0) and (i = 0)) then begin
							SaveList.Add('</dl>');
							SaveList.Add('<a name="new"></a>');
							SaveList.Add('<table width="100%" bgcolor="#3333CC" cellpadding="0" cellspacing="1"><tr><td align="center" bgcolor="#6666FF" valign="middle"><font size="-1" color="#ffffff"><b>VX ' + FormatDateTime('yyyy/mm/dd(ddd) hh:mm', ThreadItem.RoundDate) + '</b></font></td></tr></table>');
							SaveList.Add('<dl>');
						end;
						Res := DivideStrLine(ReadList[i]);
						Res.FBody := ConvRes(Res.FBody, ThreadItem.ParentBoard.BBSID, ChangeFileExt(ThreadItem.FileName, ''), 'bbs', 'key', 'st', 'to', 'nofirst', 'true');
						if Res.FType = glt2chOld then begin
							Res.FMailTo := StringReplace(Res.FMailTo, 'M', ',', [rfReplaceAll]);
							Res.FName := StringReplace(Res.FName, 'M', ',', [rfReplaceAll]);
							Res.FBody := StringReplace(Res.FBody, 'M', ',', [rfReplaceAll]);
						end;
						//Res.FBody := StringReplace(Res.FBody, '&amphearts;', '&hearts;', [rfReplaceAll]);
						//Res.FBody := StringReplace(Res.FBody, '&ampnbsp;', '&nbsp;', [rfReplaceAll]);
						//Res.FBody := StringReplace(Res.FBody, '&amp#', '&#', [rfReplaceAll]);
						//Res.FBody := StringReplace(Res.FBody, '&amp', '&amp;', [rfReplaceAll]);
						Res.FBody := AddAnchorTag(Res.FBody);
						if Res.FMailTo = '' then
							SaveList.Add('<a name="' + No + '"></a><dt><a href="giko://?no=' + No + '">' + No + '</a> OF<font color="forestgreen"><b> ' + Res.FName + ' </b></font> eF ' + Res.FDateTime+ '<br><dd>' + Res.Fbody + ' <br><br><br>')
						else
							if GikoSys.Setting.ShowMail then
								SaveList.Add('<a name="' + No + '"></a><dt><a href="giko://?no=' + No + '">' + No + '</a> OF<a href="mailto:' + Res.FMailTo + '"><b> ' + Res.FName + ' </B></a> [' + Res.FMailTo + '] eF ' + Res.FDateTime+ '<br><dd>' + Res.Fbody + ' <br><br><br>')
							else
								SaveList.Add('<a name="' + No + '"></a><dt><a href="giko://?no=' + No + '">' + No + '</a> OF<a href="mailto:' + Res.FMailTo + '"><b> ' + Res.FName + ' </B></a> eF ' + Res.FDateTime+ '<br><dd>' + Res.Fbody + ' <br><br><br>');
						if ThreadItem.Kokomade = (i + 1) then begin
							SaveList.Add('</dl>');
							SaveList.Add('<a name="koko"></a><table width="100%" bgcolor="#55AA55" cellpadding="0" cellspacing="1"><tr><td align="center" bgcolor="#77CC77" valign="middle"><font size="-1" color="#ffffff"><b>RR܂œǂ</b></font></td></tr></table>');
							SaveList.Add('<dl>');
						end;
					end;
					if SaveList.Count > 50 then begin
						doc.Write(SaveList.Text);
						SaveList.Clear;
						//Application.ProcessMessages;
					end;
				end;
				SaveList.Add('</dl>');
				SaveList.Add('<a name="bottom"></a>');
				SaveList.Add('</body></html>');
				doc.Write(SaveList.Text);
			end;
		finally
			SaveList.Free;
			doc.Close;
		end;
	finally
        bufList.Free;
		ReadList.Free;
	end;
end;

(*************************************************************************
 *http://̕anchor^OtɂB
 *************************************************************************)
function TGikoSys.AddAnchorTag(s: string): string;
const
	URL_CHAR: string = '0123456789'
									 + 'abcdefghijklmnopqrstuvwxyz'
									 + 'ABCDEFGHIJKLMNOPQRSTUVWXYZ'
									 + '#$%&()*+,-./:;=?@[]^_`{|}~!''\';
var
	wkIdx: array[0..9] of Integer;
	url: string;
	href: string;
	i: Integer;
	idx: Integer;
begin
	Result := '';

	while True do begin
		wkIdx[0] := AnsiPos('http://', s);
		wkIdx[1] := AnsiPos('ttp://', s);
		wkIdx[2] := AnsiPos('tp://', s);
		wkIdx[3] := AnsiPos('ms-help://', s);
		wkIdx[4] := AnsiPos('p://', s);
		wkIdx[5] := AnsiPos('https://', s);
		wkIdx[6] := AnsiPos('www.', s);
		wkIdx[7] := AnsiPos('ftp://', s);
		wkIdx[8] := AnsiPos('news://', s);
		wkIdx[9] := AnsiPos('rtsp://', s);

		idx := MaxInt;
		for i := 0 to 8 do
			if wkIdx[i] <> 0 then idx := Min(wkIdx[i], idx);

		if idx = MaxInt then begin
			//NB
			Result := Result + s;
			Break;
		end;

		if (idx > 1) and (Copy(s, idx - 1, 1) = '"') then begin
			//ɃN^OĂۂƂ̓V
			Result := Result + Copy(s, 0, idx + Length('http://') - 1);
			s := Copy(s, idx + Length('http://'), length(s));
			Continue;
		end;

		Result := Result + Copy(s, 0, idx - 1);

		s := Copy(s, idx, length(s));

		for i := 0 to Length(s) do begin
			idx := AnsiPos(s[i + 1], URL_CHAR);
			if (idx = 0) or (i = (Length(s))) then begin
				//URLȂIƂAȂȂB
				url := Copy(s, 0, i);

				if AnsiPos('ttp://', url) = 1 then
					href := 'h' + url
				else if AnsiPos('tp://', url) = 1 then
					href := 'ht' + url
				else if AnsiPos('p://', url) = 1 then
					href := 'htt' + url
				else if AnsiPos('www.', url) = 1 then
					href := 'http://' + url
				else
					href := url;
				Result := Result + '<a href="' + href + '" target="_blank">' + url + '</a>';
				s := Copy(s, i + 1, Length(s));
				Break;
			end;
		end;
	end;
end;

(*************************************************************************
 *TuWFNgs𕪊
 *************************************************************************)
function TGikoSys.DivideSubject(Line: string): TSubjectRec;
var
	i: integer;
	ws: WideString;
	Delim: string;
	LeftK: string;
	RightK: string;
begin
	Result.FCount := 0;

	if Pos('<>', Line) = 0 then
		Delim := ','
	else
		Delim := '<>';

	Result.FFileName := GetTokenIndex(Line, Delim, 0);
	Result.FTitle := GetTokenIndex(Line, Delim, 1);

	ws := Trim(Result.FTitle);

	if Copy(ws, Length(ws), 1) = ')' then begin
		LeftK := '(';
		RightK := ')';
	end else if Copy(ws, Length(ws), 1) = 'j' then begin
		LeftK := 'i';
		RightK := 'j';
	end else if Copy(ws, Length(ws), 1) = '<' then begin
		LeftK := '<';
		RightK := '>';
	end;

	for i := Length(ws) - 1 downto 1 do begin
		if ws[i] = LeftK then begin
			ws := Copy(ws, i + 1, Length(ws) - i - 1);
			if IsNumeric(ws) then
				Result.FCount := StrToInt(ws);
			Result.FTitle := Trim(StringReplace(Result.FTitle, LeftK + ws + RightK, '', [rfReplaceAll]));
			break;
		end;
	end;
end;

(*************************************************************************
 * datt@C̈ꃉC𕪉
 *************************************************************************)
function TGikoSys.DivideStrLine(Line: string): TResRec;
var
	Delim: string;
    bufbody : String;
begin
	if Pos('<>', Line) = 0 then begin
		Delim := ',';
		Result.FType := glt2chOld;
	end else begin
		Delim := '<>';
		Result.FType := glt2chNew;
	end;
	Result.FName := Trim(GetTokenIndex(Line, Delim, 0));
	Result.FMailTo := Trim(GetTokenIndex(Line, Delim, 1));
	Result.FDateTime := Trim(GetTokenIndex(Line, Delim, 2));
    bufBody := Trim(GetTokenIndex(Line, Delim, 3));
    if (AnsiPos('<br> ',bufbody) = 1) or (bufbody = '') then begin
        Insert('&nbsp;',bufbody, 1);
    end;
    Result.FBody := bufBody;
	Result.FTitle := Trim(GetTokenIndex(Line, Delim, 4));

end;

(*************************************************************************
 * URLBBSID擾
 *************************************************************************)
function TGikoSys.UrlToID(url: string): string;
var
	i: integer;
begin
	Result := '';
	url := Trim(url);

	if url = '' then Exit;

	url := Copy(url, 0, Length(url) - 1);
	for i := Length(url) downto 0 do begin
		if url[i] = '/' then begin
			Result := Copy(url, i + 1, Length(url));
			Break;
		end;
	end;
end;

(*************************************************************************
 *URLBBSIDȊO̕(http://teri.2ch.net/)擾
 *************************************************************************)
function TGikoSys.UrlToServer(url: string): string;
var
	i: integer;
	wsURL: WideString;
begin
	Result := '';
	wsURL := url;
	wsURL := Trim(wsURL);

	if wsURL = '' then exit;

	if Copy(wsURL, Length(wsURL), 1) = '/' then
		wsURL := Copy(wsURL, 0, Length(wsURL) - 1);

	for i := Length(wsURL) downto 0 do begin
		if wsURL[i] = '/' then begin
			Result := Copy(wsURL, 0, i);
			break;
		end;
	end;
end;

(*************************************************************************
 *fBNg݂邩`FbN
 *************************************************************************)
function TGikoSys.DirectoryExistsEx(const Name: string): Boolean;
var
	Code: Integer;
begin
	Code := GetFileAttributes(PChar(Name));
	Result := (Code <> -1) and (FILE_ATTRIBUTE_DIRECTORY and Code <> 0);
end;

(*************************************************************************
 *fBNg쐬iKwΉj
 *************************************************************************)
function TGikoSys.ForceDirectoriesEx(Dir: string): Boolean;
begin
	Result := True;
	if Length(Dir) = 0 then
		raise Exception.Create('tH_쐬o܂');
	Dir := ExcludeTrailingPathDelimiter(Dir);
	if (Length(Dir) < 3) or DirectoryExistsEx(Dir)
		or (ExtractFilePath(Dir) = Dir) then Exit; // avoid 'xyz:\' problem.
	Result := ForceDirectoriesEx(ExtractFilePath(Dir)) and CreateDir(Dir);
end;

(*************************************************************************
 *񂩂g[N̐؂oij
 *FDelphĩpN
 *************************************************************************)
function TGikoSys.StrTokFirst(const s:string; const sep: TStrTokSeparator; var Rec: TStrTokRec): string;
begin
	Rec.Str := s;
	Rec.Pos := 1;
	Result := StrTokNext(sep, Rec);
end;

(*************************************************************************
 *񂩂g[N̐؂o
 *FDelphĩpN
 *************************************************************************)
function TGikoSys.StrTokNext(const sep: TStrTokSeparator; var Rec: TStrTokRec): string;
var
	Len, I: Integer;
begin
	with Rec do	begin
		Len := Length(Str);
		Result := '';
		if Len >= Pos then begin
			while (Pos <= Len) and (Str[Pos] in sep) do begin
			 Inc(Pos);
			end;
			I := Pos;
			while (Pos<= Len) and not (Str[Pos] in sep) do begin
				if IsDBCSLeadByte(Byte(Str[Pos])) then begin
					Inc(Pos);
				end;
				Inc(Pos);
			end;
			Result := Copy(Str, I, Pos - I);
			while (Pos <= Len) and (Str[Pos] in sep) do begin// ͂D
				Inc(Pos);
			end;
		end;
	end;
end;

(*************************************************************************
 *t@CTCY擾
 *************************************************************************)
function TGikoSys.GetFileSize(FileName : string): longint;
var
	F : File;
begin
	try
		if not FileExists(FileName) then begin
			Result := 0;
			Exit;
		end;
		Assign(F, FileName);
		Reset(F, 1);
		Result := FileSize(F);
		CloseFile(F);
	except
		Result := 0;
	end;
end;

(*************************************************************************
 *t@Cs擾
 *************************************************************************)
function TGikoSys.GetFileLineCount(FileName : string): longint;
var
	sl: TStringList;
begin
	Result := 0;
	sl := TStringList.Create;
	try
		sl.LoadFromFile(FileName);
		Result := sl.Count;
	finally
		sl.Free;
	end;
end;

(*************************************************************************
 *Xbht@Cws擾
 *************************************************************************)
function TGikoSys.ReadThreadFile(FileName: string; Line: Integer): string;
const
	BUFFER_SIZE = 1024;
var
	f: TextFile;
	s: string;
	num: Integer;
	ArrBuff: array [1..BUFFER_SIZE] of Char;
begin
	Result := '';
	if FileExists(FileName) then begin
		AssignFile(f, FileName);
		System.SetTextBuf(f, ArrBuff);
		try
			Reset(f);
			num := 1;
			while not Eof(f) do begin
				Readln(f, s);
				if Line = num then begin
					Result := s;
//					CloseFile(f);
					Break;
				end;
				inc(num);
			end;
		finally
			CloseFile(f);
		end;
	end;
end;

(*************************************************************************
 *VXej[tHg̑擾
 *************************************************************************)
procedure TGikoSys.MenuFont(Font: TFont);
var
	lf: LOGFONT;
	nm: NONCLIENTMETRICS;
begin
	nm.cbSize := sizeof(NONCLIENTMETRICS);

	SystemParametersInfo(SPI_GETNONCLIENTMETRICS, 0, @nm, 0);
	lf := nm.lfMenuFont;

	Font.Name := lf.lfFaceName;
	Font.Height := lf.lfHeight;
	Font.Style := [];
	if lf.lfWeight >= 700 then
		Font.Style := Font.Style + [fsBold];
	if lf.lfItalic = 1 then
		Font.Style := Font.Style + [fsItalic];
end;

(*************************************************************************
 *
 *ǂ̃TCg̃pN
 *************************************************************************)
function TGikoSys.RemoveToken(var s: string; delimiter: string): string;
var
	p: Integer;
begin
	p := AnsiPos(delimiter, s);
	if p = 0 then
		Result := s
	else
		Result := Copy(s, 1, p - 1);
	s := Copy(s, Length(Result) + Length(delimiter) + 1, Length(s));
end;

(*************************************************************************
 *
 *ǂ̃TCg̃pN
 *************************************************************************)
function TGikoSys.GetTokenIndex(s: string; delimiter: string; index: Integer): string;
var
	i: Integer;
begin
	Result := '';
	for i := 0 to index do
		Result := RemoveToken(s, delimiter);
end;

(*************************************************************************
 *
 *************************************************************************)
function TGikoSys.DeleteLink(const s: string): string;
var
	s1: string;
	s2: string;
	idx: Integer;
	i: Integer;
begin
	i := 0;
	Result := '';
	while True do begin
		s1 := GetTokenIndex(s, '<a href="', i);
		s2 := GetTokenIndex(s, '<a href="', i + 1);

		idx := Pos('">', s1);
		if idx <> 0 then
			Delete(s1, 1, idx + 1);
		idx := Pos('">', s2);
		if idx <> 0 then
			Delete(s2, 1, idx + 1);

		Result := Result + s1 + s2;

		if s2 = '' then
			Break;

		inc(i, 2);
	end;
end;

//CfbNXXVobt@tbVI
{procedure TGikoSys.FlashExitWrite;
var
	i: Integer;
begin
	//Xbhf[^t@CXV
	for i := 0 to FExitWrite.Count - 1 do
		WriteThreadDat(FExitWrite[i]);
	FExitWrite.Clear;
end;}

(*************************************************************************
 *XȂǂZOɕϊ
 *from HotZonu
 *************************************************************************)
function TGikoSys.GetShortName(const LongName: string; ALength: integer): string;
const
	ERASECHAR : array [1..39] of string =
		('','','','','','','Q','','','',
		 '','','','','','y','z','','s','t',
		 'g','h','k','l','e','f','','','','',
		 'o','p','q','r','w','x','','c', '@');
var
	Chr : array [0..255]  of  char;
	S : string;
	i : integer;
begin
	s := Trim(LongName);
	if (Length(s) <= ALength) then begin
		Result := s;
	end else begin
		S := s;
		for i := Low(ERASECHAR)  to  High(ERASECHAR) do  begin
			S := StringReplace(S, ERASECHAR[i], '', [rfReplaceAll]);
		end;
		if (Length(S) <= ALength) then begin
			Result := S;
		end else begin
			Windows.LCMapString(
					GetUserDefaultLCID(),
					LCMAP_HALFWIDTH,
					PChar(S),
					Length(S) + 1,
					chr,
					Sizeof(chr)
					);
			S := Chr;
			S := Copy(S,1,ALength);
			while true do begin
				if (ByteType(S, Length(S)) = mbLeadByte ) then begin
					S := Copy(S, 1, Length(S) - 1);
				end else begin
					Break;
				end;
			end;
			Result := S;
		end;
	end;
end;

(*************************************************************************
 *
 * from HotZonu
 *************************************************************************)
function TGikoSys.ConvRes(const Body, Bbs, Key,
	ParamBBS, ParamKey, ParamStart, ParamTo, ParamNoFirst, ParamTrue : string): string;
type
	PIndex = ^TIndex;
	TIndex = record
		FIndexFrom  : integer;
		FIndexTo    : integer;
		FNo         : string;
	end;
const
	GT  = '&gt;';
	SN  = '0123456789-';
	ZN  = 'OPQRSTUVWX|';
var
	i : integer;
	s,r : string;
	b : TMbcsByteType;
	sw: boolean;
	sp: integer;
	No: string;
	sx: string;
	List: TList;
	oc  : string;
	st, et: string;
	chk : boolean;
	al : boolean;
	procedure Add(IndexFrom, IndexTo: integer; const No: string);
	var
		FIndex : PIndex;
	begin
		New(FIndex);
		FIndex.FIndexFrom  := IndexFrom;
		FIndex.FIndexTo    := IndexTo;
		FIndex.FNo         := No;
		List.Add(FIndex);
	end;
	function ChooseString(const Text, Separator: string; Index: integer): string;
	var
		S : string;
		i, p : integer;
	begin
		S :=  Text;
		for i :=  0 to  Index - 1 do  begin
			if  (AnsiPos(Separator, S) = 0) then  S :=  ''
			else  S :=  Copy(S, AnsiPos(Separator, S) + Length(Separator), Length(S));
		end;
		p :=  AnsiPos(Separator, S);
		if  (p > 0) then  Result  :=  Copy(S, 1, p - 1) else Result :=  S;
	end;
begin
	{ v1.0 b2 - 03 }
	s   :=  Body;
	r   :=  Body;
	i   :=  1;
	sw  :=  False;
	No  :=  '';
	List:=  TList.Create;
	oc  :=  '';
	sp  :=  0;
	chk :=  False;
	al  :=  False;
	while true  do  begin
		b :=  ByteType(s, i);
		case  b of
			mbSingleByte  : begin
				if  (not sw) and (Copy(s,i,8) = GT + GT) then  begin
					if  (AnsiPos('<A HREF', AnsiUpperCase(oc)) = 0) then  begin
						sw  :=  True;
						sp  :=  i;
						i :=  i + 7;
						oc:='';
						chk :=  True;
					end;
				end else
				if  (not sw) and (Copy(s,i,8) = GT + GT) then  begin
					if  (AnsiPos('<A HREF', AnsiUpperCase(oc)) = 1) then  begin
						i :=  i + 7;
						oc:='';
						chk :=  True;
					end;
				end else
				if  (not sw) and (Copy(s,i,4) = GT) then  begin
					if  (AnsiPos('<A HREF', AnsiUpperCase(oc)) = 0) then  begin
            sw  :=  True;
						sp  :=  i;
						i :=  i + 3;
						oc:='';
            chk :=  True;
					end;
        end else
        if  ((not sw) and (Copy(s,i,1) = ',')) or
						((not sw) and (Copy(s,i,1) = '=')) then  begin
          if  ((not Chk) and (AnsiLowerCase(oc) = '</a>')) or
              ((Chk) and  (oc = '')) or
              ((not Chk) and (al)) then
					begin
						sw  :=  True;
            sp  :=  i;
						//i :=  i + 1;
            oc:='';
          end;
        end else
        if  (sw) then begin
          sx  :=  Copy(s,i,1);
          if  (AnsiPos(sx, SN) > 0)  then  begin
            No  :=  No  + sx;
          end else begin
						if  (No <> '') and (No <> '-')   then  begin
							Add(sp, i, No);
              al := True;
						end;
            sw  :=  False;
            //
						i := i - 1;
						//
            No  := '';
            oc:='';
            //chk :=  False;
          end;
        end else begin
          if  Copy(s,i,1) = '<' then  oc  :=  '';
          oc  :=  oc + Copy(s,i,1);
					chk :=  False;
          al  :=  False;
        end;
      end;
			mbLeadByte  : begin
				if  (not sw) and (Copy(s,i,4) = '') then  begin
					sw  :=  True;
          sp  :=  i;
					i :=  i + 3;
					chk :=  True;
        end else
        if  (not sw) and (Copy(s,i,2) = '') then  begin
          sw  :=  True;
          sp  :=  i;
					i :=  i + 1;
          chk :=  True;
        end else
				if  (sw) then begin
          sx  :=  Copy(s,i,2);
          if  (AnsiPos(sx, ZN) > 0)  then  begin
						No  :=  No  + ZenToHan(sx);
					end else begin
						if  (No <> '') and (No <> '-')  and (No <> '|') then  begin
              Add(sp, i, No);
            end;
            sw  :=  False;
            i := i - 1;
						No  :=  '';
          end;
        end else begin
          oc  :=  '';
          chk :=  False;
				end;
        al  :=  False;
      end;
    end;
    inc(i);
		if  (i > Length(Body))  then  begin
      if  (sw)  then  begin
        if  (No <> '')  then  Add(sp, i, No);
			end;
      Break;
    end;
  end;
	for i :=  List.Count - 1  downto  0 do  begin
    if  (AnsiPos('-', PIndex(List[i]).FNo) > 0) then  begin
			st  :=  ChooseString(PIndex(List[i]).FNo, '-', 0);
			et  :=  ChooseString(PIndex(List[i]).FNo, '-', 1);
    end else begin
			st  :=  PIndex(List[i]).FNo;
			et  :=  PIndex(List[i]).FNo;
    end;
		r :=  Copy(r,0, PIndex(List[i]).FIndexFrom - 1) +
					Format('<a href="../test/read.cgi?%s=%s&%s=%s&%s=%s&%s=%s&%s=%s" target="_blank">',
								[ParamBBS, Bbs, ParamKey, Key, ParamStart, st, ParamTo, et, ParamNoFirst, ParamTrue]) +
					Copy(r,PIndex(List[i]).FIndexFrom, PIndex(List[i]).FIndexTo - PIndex(List[i]).FIndexFrom) + '</A>' +
					Copy(r,PIndex(List[i]).FIndexTo,Length(r));
		Dispose(PIndex(List[i]));
	end;
	List.Free;
	Result  :=  r;
end;

(*************************************************************************
 * Spp
 * from HotZonu
 *************************************************************************)
function TGikoSys.ZenToHan(const s: string): string;
var
	Chr: array [0..255] of char;
begin
	Windows.LCMapString(
		 GetUserDefaultLCID(),
//		 LCMAP_HALFWIDTH,
		 LCMAP_HALFWIDTH or LCMAP_KATAKANA or LCMAP_LOWERCASE,
		 PChar(s),
		 Length(s) + 1,
		 chr,
		 Sizeof(chr)
		 );
	Result := Chr;
end;

(*************************************************************************
 * SppЂ炪ȂȂʂȂPos
 *************************************************************************)
function TGikoSys.VaguePos(const Substr, S: string): Integer;
begin
	Result := Pos(ZenToHan(Substr), ZenToHan(S));
end;

function TGikoSys.BoolToInt(b: Boolean): Integer;
begin
	Result := IfThen(b, 1, 0);
end;

function TGikoSys.IntToBool(i: Integer): Boolean;
begin
	Result := i = 1;
end;

//gzipňkꂽ̂߂
function TGikoSys.GzipDecompress(ResStream: TStream; ContentEncoding: string): string;
const
	BUF_SIZE = 4096;
var
	GZipStream: TGzipDecompressStream;
	TextStream: TStringStream;
	buf: array[0..BUF_SIZE - 1] of Byte;
	cnt: Integer;
	s: string;
	i: Integer;
begin
	Result := '';
	TextStream := TStringStream.Create('');
	try
//m[gE`EBX2003΍(x-gzipƂɂȂ݂)
//		if LowerCase(Trim(ContentEncoding)) = 'gzip' then begin
		if AnsiPos('gzip', LowerCase(Trim(ContentEncoding))) > 0 then begin
			ResStream.Position := 0;
			GZipStream := TGzipDecompressStream.Create(TextStream);
			try
				repeat
					FillChar(buf, BUF_SIZE, 0);
					cnt := ResStream.Read(buf, BUF_SIZE);
					if cnt > 0 then
						GZipStream.Write(buf, BUF_SIZE);
				until cnt = 0;
			finally
				GZipStream.Free;
			end;
		end else begin
			ResStream.Position := 0;
			repeat
				FillChar(buf, BUF_SIZE, 0);
				cnt := ResStream.Read(buf, BUF_SIZE);
				if cnt > 0 then
					TextStream.Write(buf, BUF_SIZE);
			until cnt = 0;
		end;

		//NULL"*"ɂ
		s := TextStream.DataString;
		i := Length(s);
		while (i > 0) and (s[i] = #0) do
			Dec(i);
		s := Copy(s, 1, i);

		i := Pos(#0, s);
		while i <> 0 do begin
			s[i] := '*';
			i := Pos(#0, s);
		end;
		Result := s;
	finally
		TextStream.Free;
	end;
end;

procedure TGikoSys.LoadKeySetting(ActionList: TActionList);
const
	STD_SEC = 'KeySetting';
var
	i: Integer;
	ini: TMemIniFile;
	ActionName: string;
	ActionKey: Integer;
	SecList: TStringList;
	Component: TComponent;
begin
	if not FileExists(GetConfigDir + KEY_SETTING_FILE_NAME) then
		Exit;
	SecList := TStringList.Create;
	ini := TMemIniFile.Create(GetConfigDir + KEY_SETTING_FILE_NAME);
	try
		ini.ReadSection(STD_SEC, SecList);
		for i := 0 to SecList.Count - 1 do begin
			ActionName := SecList[i];
			ActionKey := ini.ReadInteger(STD_SEC, ActionName, -1);
			if ActionKey <> -1 then begin
				Component := ActionList.Owner.FindComponent(ActionName);
				if TObject(Component) is TAction then begin
					TAction(Component).ShortCut := ActionKey;
				end;
			end;
		end;
	finally
		ini.Free;
		SecList.Free;
	end;
end;

procedure TGikoSys.SaveKeySetting(ActionList: TActionList);
const
	STD_SEC = 'KeySetting';
var
	i: Integer;
	ini: TMemIniFile;
begin
	ini := TMemIniFile.Create(GetConfigDir + KEY_SETTING_FILE_NAME);
	try
		for i := 0 to ActionList.ActionCount - 1 do begin
			if ActionList.Actions[i].Tag = -1 then
				Continue;
			ini.WriteInteger(STD_SEC, ActionList.Actions[i].Name, TAction(ActionList.Actions[i]).ShortCut);
		end;
		ini.UpdateFile;
	finally
		ini.Free;
	end;
end;

//
procedure TGikoSys.CreateProcess(const AppPath: string; const Param: string);
var
	PI: TProcessInformation;
	SI: TStartupInfo;
	Path: string;
begin
	Path := '"' + AppPath + '"';
	if Param <> '' then
		Path := Path + ' ' + Param;

	SI.Cb := SizeOf(Si);
	SI.lpReserved  := nil;
	SI.lpDesktop   := nil;
	SI.lpTitle     := nil;
	SI.dwFlags     := 0;
	SI.cbReserved2 := 0;
	SI.lpReserved2 := nil;
	SI.dwysize     := 0;
	Windows.CreateProcess(nil,
								PChar(Path),
								nil,
								nil,
								False,
								0,
								nil,
								nil,
								SI,
								PI);
end;

procedure TGikoSys.OpenBrowser(URL: string; BrowserType: TGikoBrowserType);
begin
	case BrowserType of
		gbtIE:
			HlinkNavigateString(nil, PWideChar(WideString(URL)));
		gbtUserApp, gbtAuto:
			if (Setting.URLApp) and (FileExists(Setting.URLAppFile)) then
				GikoSys.CreateProcess(Setting.URLAppFile, URL)
			else
				HlinkNavigateString(nil, PWideChar(WideString(URL)));
	end;
end;

function TGikoSys.HTMLDecode(const AStr: String): String;
var
	Sp, Rp, Cp, Tp: PChar;
	S: String;
	I, Code: Integer;
	Num: Boolean;
begin
	SetLength(Result, Length(AStr));
	Sp := PChar(AStr);
	Rp := PChar(Result);
	Cp := Sp;
	try
		while Sp^ <> #0 do begin
			case Sp^ of
				'&': begin
							 Cp := Sp;
							 Inc(Sp);
							 case Sp^ of
								 'a': if AnsiStrPos(Sp, 'amp;') = Sp then
											begin
												Inc(Sp, 3);
												Rp^ := '&';
											end;
								 'l',
								 'g': if (AnsiStrPos(Sp, 'lt;') = Sp) or (AnsiStrPos(Sp, 'gt;') = Sp) then
											begin
												Cp := Sp;
												Inc(Sp, 2);
												while (Sp^ <> ';') and (Sp^ <> #0) do
													Inc(Sp);
												if Cp^ = 'l' then
													Rp^ := '<'
												else
													Rp^ := '>';
											end;
								 'q': if AnsiStrPos(Sp, 'quot;') = Sp then
											begin
												Inc(Sp,4);
												Rp^ := '"';
											end;
								 '#': begin
												Tp := Sp;
												Inc(Tp);
												Num := IsNumeric(Copy(Tp, 1, 1));
												while (Sp^ <> ';') and (Sp^ <> #0) do begin
													if (Num) and (not IsNumeric(Copy(Sp, 1, 1))) then
														Break;
													Inc(Sp);
												end;
												SetString(S, Tp, Sp - Tp);
												Val(S, I, Code);
												Rp^ := Chr((I));
											end;
							 //	 else
									 //raise EConvertError.CreateFmt(sInvalidHTMLEncodedChar,
										 //[Cp^ + Sp^, Cp - PChar(AStr)])
							 end;
					 end
			else
				Rp^ := Sp^;
			end;
			Inc(Rp);
			Inc(Sp);
		end;
	except
//		on E:EConvertError do
//			raise EConvertError.CreateFmt(sInvalidHTMLEncodedChar,
//				[Cp^ + Sp^, Cp - PChar(AStr)])
	end;
	SetLength(Result, Rp - PChar(Result));
end;

function TGikoSys.GetHRefText(s: string): string;
var
	Index: Integer;
	Index2: Integer;
begin
	Result := '';
	s := Trim(s);
	if s = '' then
		Exit;

	Index := AnsiPos('href', LowerCase(s));
	if Index = 0 then
		Exit;
	s := Trim(Copy(s, Index + 4, Length(s)));
	s := Trim(Copy(s, 2, Length(s)));

	//n߂̕'"'Ȃ菜
	if Copy(s, 1, 1) = '"' then begin
		s := Trim(Copy(s, 2, Length(s)));
	end;

	Index := AnsiPos('"', s);
	if Index <> 0 then begin
		//'"'܂URLƂ
		s := Copy(s, 1, Index - 1);
	end else begin
		//'"'΃Xy[X">"̑܂łURLƂ
		Index := AnsiPos(' ', s);
		Index2 := AnsiPos('>', s);
		if Index = 0 then
			Index := Index2;
		if Index > Index2 then
			Index := Index2;
		if Index <> 0 then
			s := Copy(s, 1, Index - 1)
		else
			//ȏm
			;
	end;
	Result := Trim(s);
end;

//zXgQǂ`FbN
function TGikoSys.Is2chHost(Host: string): Boolean;
const
	HOST_NAME: array[0..1] of string = ('2ch.net', 'bbspink.com');
var
	i: Integer;
	Len: Integer;
begin
	Result := False;
	OutputDebugString(pchar(HOST_NAME[0]));
	for i := 0 to Length(HOST_NAME) - 1 do begin
		Len := Length(HOST_NAME[i]);
		if AnsiPos(HOST_NAME[i], Host) = (Length(Host) - Length(HOST_NAME[i]) + 1) then begin
			Result := True;
			Exit;
		end;
	end;
end;

function TGikoSys.Parse2chURL(const url: string; const path: string; const document: string; var BBSID: string; var BBSKey: string): Boolean;
const
	READ_PATH: string = 			'/test/read.cgi/';
	OLD_READ_PATH: string =		'/test/read.cgi?';
	KAKO_PATH: string = 			'/kako/';
var
	Index: Integer;
	s: string;
	SList: TStringList;
begin
	BBSID := '';
	BBSKey := '';
	Result := False;

	Index := AnsiPos(READ_PATH, path);
	if Index <> 0 then begin
		s := Copy(path, Length(READ_PATH) + 1, Length(path));
		BBSID := GetTokenIndex(s, '/', 0);
		BBSKey := GetTokenIndex(s, '/', 1);
		if BBSKey = '' then
			BBSKey := Document;
		Result := (BBSID <> '') or (BBSKey <> '');
		Exit;
	end;
	Index := AnsiPos(KAKO_PATH, path);
	if Index <> 0 then begin
		s := Copy(path, 2, Length(path));
		BBSID := GetTokenIndex(s, '/', 0);
		if (BBSID = 'log') and (GetTokenIndex(s, '/', 2) = 'kako') then
			BBSID := GetTokenIndex(s, '/', 1);
		BBSKey := ChangeFileExt(Document, '');
		Result := (BBSID <> '') or (BBSKey <> '');
		Exit;
	end;
	Index := AnsiPos('read.cgi?', URL);
	if Index <> 0 then begin
		SList := TStringList.Create;
		try
			try
//				s := HTMLDecode(Document);
				ExtractHTTPFields(['?', '&'], [], PChar(URL), SList, False);
				BBSID := SList.Values['bbs'];
				BBSKey := SList.Values['key'];
				Result := (BBSID <> '') or (BBSKey <> '');
				Exit;
			except
				Exit;
			end;
		finally
			SList.Free;
		end;
	end;
end;

function TGikoSys.Parse2chURL2(URL: string): TPathRec;
var
	i: Integer;
	s: string;
	wk: string;
	wkMin: Integer;
	wkMax: Integer;
	wkInt: Integer;
	RStart: Integer;
	RLength: Integer;
	SList: TStringList;
begin
	URL := Trim(LowerCase(URL));
	Result.FBBS := '';
	Result.FKey := '';
	Result.FSt := 0;
	Result.FTo := 0;
	Result.FFirst := False;
	Result.FStBegin := False;
	Result.FToEnd := False;
	Result.FDone := False;

	wkMin := 0;
	wkMax := 1;

	FAWKStr.RegExp := 'http://.+\.(2ch\.net|bbspink\.com)/';
	if FAWKStr.Match(FAWKStr.ProcessEscSeq(URL), RStart, RLength) = 0 then
		Exit;
	s := Copy(URL, RStart + RLength - 1, Length(URL));

	//W
	//Ōl50, 10, 10-20, 10n, 10-20n, -10, 10-, 10n- Ȃ
	//http://xxx.2ch.net/test/read.cgi/bbsid/1000000000/
	FAWKStr.RegExp := '/test/read.cgi/.+/[0-9]+/.*';
	if FAWKStr.Match(FAWKStr.ProcessEscSeq(s), RStart, RLength) > 0 then begin
		s := Copy(s, 15, Length(s));

		SList := TStringList.Create;
		try
			SList.Clear;
			FAWKStr.RegExp := '/';
			if FAWKStr.Split(FAWKStr.ProcessEscSeq(s), SList) >= 2 then begin
				Result.FBBS := SList[1];
				Result.FKey := SList[2];
				if SList.Count >= 3 then
					s := SList[3]
				else
					s := '';
			end else
				Exit;

			SList.Clear;
			FAWKStr.LineSeparator := mcls_CRLF;
			FAWKStr.RegExp := '-';
			if FAWKStr.Split(FAWKStr.ProcessEscSeq(s), SList) = 0 then begin
				Result.FFirst := True;
			end else begin
				FAWKStr.RegExp := 'l[0-9]+';
				if FAWKStr.Match(FAWKStr.ProcessEscSeq(s), RStart, RLength) > 0 then begin
					Result.FFirst := True;
				end else begin
					for i := 0 to SList.Count - 1 do begin
						if Trim(SList[i]) = '' then begin
							if i = 0 then
								Result.FStBegin := True;
							if i = (SList.Count - 1) then
								Result.FToEnd := True;
						end else if IsNumeric(SList[i]) then begin
							wkInt := StrToInt(SList[i]);
							wkMax := Max(wkMax, wkInt);
							if wkMin = 0 then
								wkMin := wkInt
							else
								wkMin := Min(wkMin, wkInt);
						end else if Trim(SList[i]) = 'n' then begin
							Result.FFirst := True;
						end else begin
							FAWKStr.RegExp := '^n[0-9]+$|^[0-9]+n$';
							if FAWKStr.Match(FAWKStr.ProcessEscSeq(SList[i]), RStart, RLength) > 0 then begin
								if Copy(SList[i], 1, 1) = 'n' then
									wkInt := StrToInt(Copy(SList[i], 2, Length(SList[i])))
								else
									wkInt := StrToInt(Copy(SList[i], 1, Length(SList[i]) - 1));
								Result.FFirst := True;
								wkMax := Max(wkMax, wkInt);
								if wkMin = 1 then
									wkMin := wkInt
								else
									wkMin := Min(wkMin, wkInt);
							end;
						end;
					end;
					if Result.FStBegin and (not Result.FToEnd) then
						Result.FSt := wkMin
					else if (not Result.FStBegin) and Result.FToEnd then
						Result.FTo := wkMax
					else if (not Result.FStBegin) and (not Result.FToEnd) then begin
						Result.FSt := wkMin;
						Result.FTo := wkMax;
					end;
					//Result.FSt := wkMin;
					//Result.FTo := wkMax;
				end;
			end;
		finally
			SList.Free;
		end;
		Result.FDone := True;
		Exit;
	end;

	//Vkako
	//http://server.2ch.net/ITA_NAME/kako/1000/10000/1000000000.html
	FAWKStr.RegExp := '/.+/kako/[0-9]+/[0-9]+/[0-9]+\.html';
	if FAWKStr.Match(FAWKStr.ProcessEscSeq(s), RStart, RLength) > 0 then begin
		SList := TStringList.Create;
		try
			SList.Clear;
			FAWKStr.RegExp := '/';
			if FAWKStr.Split(FAWKStr.ProcessEscSeq(s), SList) >= 6 then begin
				Result.FBBS := SList[1];
				Result.FKey := ChangeFileExt(SList[5], '');
				Result.FFirst := True;
			end else
				Exit;
		finally
			SList.Free;
		end;
		Result.FDone := True;
		Exit;
	end;

	//kako
	//http://server.2ch.net/ITA_NAME/kako/999/999999999.html
	FAWKStr.RegExp := '/.+/kako/[0-9]+/[0-9]+\.html';
	if FAWKStr.Match(FAWKStr.ProcessEscSeq(s), RStart, RLength) > 0 then begin
		SList := TStringList.Create;
		try
			SList.Clear;
			FAWKStr.RegExp := '/';
			if FAWKStr.Split(FAWKStr.ProcessEscSeq(s), SList) >= 5 then begin
				Result.FBBS := SList[1];
				Result.FKey := ChangeFileExt(SList[4], '');
				Result.FFirst := True;
			end else
				Exit;
		finally
			SList.Free;
		end;
		Result.FDone := True;
		Exit;
	end;

	//logylog2
	//http://server.2ch.net/log/ITA_NAME/kako/999/999999999.html
	//http://server.2ch.net/log2/ITA_NAME/kako/999/999999999.html
	FAWKStr.RegExp := '/log2?/.+/kako/[0-9]+/[0-9]+\.html';
	if FAWKStr.Match(FAWKStr.ProcessEscSeq(s), RStart, RLength) > 0 then begin
		SList := TStringList.Create;
		try
			SList.Clear;
			FAWKStr.RegExp := '/';
			if FAWKStr.Split(FAWKStr.ProcessEscSeq(s), SList) >= 6 then begin
				Result.FBBS := SList[2];
				Result.FKey := ChangeFileExt(SList[5], '');
				Result.FFirst := True;
			end else
				Exit;
		finally
			SList.Free;
		end;
		Result.FDone := True;
		Exit;
	end;


	//URL
	//http://server.2ch.net/test/read.cgi?bbs=ITA_NAME&key=1000000000&st=1&to=5&nofirst=true
	FAWKStr.RegExp := '/test/read\.cgi\?';
	if FAWKStr.Match(FAWKStr.ProcessEscSeq(s), RStart, RLength) > 0 then begin
		s := Copy(s, 16, Length(s));
		SList := TStringList.Create;
		try
			SList.Clear;
			FAWKStr.RegExp := '&';
			if FAWKStr.Split(FAWKStr.ProcessEscSeq(s), SList) >= 2 then begin
				Result.FFirst := True;
				for i := 0 to SList.Count - 1 do begin
					if Pos('bbs=', SList[i]) = 1 then begin
						Result.FBBS := Copy(SList[i], 5, Length(SList[i]));
					end else if Pos('key=', SList[i]) = 1 then begin
						Result.FKey := Copy(SList[i], 5, Length(SList[i]));
					end else if Pos('st=', SList[i]) = 1 then begin
						wk := Copy(SList[i], 4, Length(SList[i]));
						if IsNumeric(wk) then
							Result.FSt := StrToInt(wk)
						else if wk = '' then
							Result.FStBegin := True;
					end else if Pos('to=', SList[i]) = 1 then begin
						wk := Copy(SList[i], 4, Length(SList[i]));
						if IsNumeric(wk) then
							Result.FTo := StrToInt(wk)
						else if wk = '' then
							Result.FToEnd := True;
					end else if Pos('nofirst=', SList[i]) = 1 then begin
						Result.FFirst := False;
					end;
				end;
			end else
				Exit;
		finally
			SList.Free;
		end;

		if (Result.FBBS <> '') and (Result.FKey <> '') then begin
			Result.FDone := True;
		end;
		Exit;
	end;
end;

procedure TGikoSys.ParseURI(var URL, Protocol, Host, Path, Document, Port, Bookmark: string);
var
	URI: TIdURI;
begin
		Protocol := '';
		Host := '';
		Path := '';
		Document := '';
		Port := '';
		Bookmark := '';
		URI := TIdURI.Create(URL);
		try
			Protocol := URI.Protocol;
			Host := URI.Host;
			Path := URI.Path;
			Document := URI.Document;
			Port := URI.Port;
			Bookmark := URI.Bookmark;
		finally
			URI.Free;
		end;
end;

function TGikoSys.GetVersionBuild: Integer;
var
	FixedFileInfo: PVSFixedFileInfo;
	VersionHandle, VersionSize: DWORD;
	pVersionInfo: Pointer;
	ItemLen : UInt;
	AppFile: string;
begin
	Result := 0;
	AppFile := Application.ExeName;
	VersionSize := GetFileVersionInfoSize(pChar(AppFile), VersionHandle);
	if VersionSize = 0 then
		Exit;
	GetMem(pVersionInfo, VersionSize);
	try
		if GetFileVersionInfo(PChar(AppFile),VersionHandle,VersionSize, pVersionInfo) then
			if VerQueryValue(pVersionInfo, '\', Pointer(FixedFileInfo), ItemLen) then
				Result := LOWORD(FixedFileInfo^.dwFileVersionLS);
	finally
		FreeMem(pVersionInfo, VersionSize);
	end;
end;

initialization
	GikoSys := TGikoSys.Create;

finalization
	if GikoSys <> nil then begin
		GikoSys.Free;
		GikoSys := nil;
	end;
end.
