library ExternalBoardPlugIn;

{
	ExternalBoardPlugIn
	O̏jbg
}

uses
	Windows,
	SysUtils,
	Classes,
	Math,
	IdURI,
	PlugInMain in 'PlugInMain.pas',
	ThreadItem in 'ThreadItem.pas',
	BoardItem in 'BoardItem.pas',
	FilePath in 'FilePath.pas';

{$R *.res}

type
	// =========================================================================
	// T2chThreadItem
	// =========================================================================
	T2chThreadItem = class(TThreadItem)
	private
		FIsTemporary	: Boolean;
		FDat					: TStringList;

	public
		constructor	Create( inInstance : DWORD );
		destructor	Destroy; override;

	private
		function	Download : TDownloadState;
		function	Write( inName : string; inMail : string; inMessage : string ) : TDownloadState;
		function	GetRes( inNo : Integer ) : string;
        function	GetDat( inNo : Integer ) : string;
		function	GetHeader( inOptionalHeader : string ) : string;
		function	GetFooter( inOptionalFooter : string ) : string;
		function	GetBoardURL : string;

		procedure	LoadDat;
		procedure	FreeDat;
		function	ReadURL : string;
	end;

	// =========================================================================
	// T2chBoardItem
	// =========================================================================
	T2chBoardItem = class(TBoardItem)
	private
		FIsTemporary	: Boolean;
		FDat					: TStringList;

	public
		constructor	Create( inInstance : DWORD );
		destructor	Destroy; override;

	private
		function	Download : TDownloadState;
		function	ToThreadURL( inFileName : string ) : string;
		procedure	EnumThread( inCallBack : TBoardItemEnumThreadCallBack );

	end;

	// =========================================================================
	// TuWFNgR[h
	// =========================================================================
	TSubjectRec = record
		FFileName: string;
		FTitle: string;
		FCount: Integer;
	end;

const
	LOG_DIR						= '2ch\';

	PLUGIN_NAME				= '2chPlugIn';
	MAJOR_VERSION			= 1;
	MINOR_VERSION			= 0;
	RELEASE_VERSION		= 'beta';
	REVISION_VERSION	= 3;

// =========================================================================
// Gp֐
// =========================================================================

// *************************************************************************
// e|ȃpX̎擾
// *************************************************************************
function TemporaryFile : string;
var
	tempPath : array [0..MAX_PATH] of	char;
begin

	GetTempPath( SizeOf(tempPath), tempPath );
	repeat
		Result := tempPath + IntToStr( Random( $7fffffff ) );
	until not FileExists( Result );

end;

// *************************************************************************
// ܂BBSpOtH_擾
// *************************************************************************
function MyLogFolder : string;
var
	folder : string;
begin

	folder := LogFolder;
	if Length( folder ) = 0 then
		Result := ''
	else
		Result := folder + LOG_DIR;

end;

(*************************************************************************
 *fBNg݂邩`FbN
 *************************************************************************)
function DirectoryExistsEx(const Name: string): Boolean;
var
	Code: Integer;
begin
	Code := GetFileAttributes(PChar(Name));
	Result := (Code <> -1) and (FILE_ATTRIBUTE_DIRECTORY and Code <> 0);
end;

(*************************************************************************
 *fBNg쐬iKwΉj
 *************************************************************************)
function ForceDirectoriesEx(Dir: string): Boolean;
begin
	Result := True;
	if Length(Dir) = 0 then
		raise Exception.Create('tH_쐬o܂');
	Dir := ExcludeTrailingPathDelimiter(Dir);
	if (Length(Dir) < 3) or DirectoryExistsEx(Dir)
		or (ExtractFilePath(Dir) = Dir) then Exit; // avoid 'xyz:\' problem.
	Result := ForceDirectoriesEx(ExtractFilePath(Dir)) and CreateDir(Dir);
end;

// Ƃ肠̑piȂ̂ chrWhite lĂȂƂɒӁIII
procedure ExtractHttpFields(
	const chrSep : TSysCharSet;
	const chrWhite : TSysCharSet;
	const strValue : string;
	var strResult : TStringList;
	unknownFlag : boolean = false
);
var
	last, p, strLen : Integer;
begin

	strLen := Length( strValue );
	p := 1;
	last := 1;

	while p <= strLen do
	begin

		if strValue[ p ] in chrSep then
		begin
			strResult.Add( Copy( strValue, last, p - last ) );
			last := p + 1;
		end;

		p := p + 1;

	end;

	if last <> p then
		strResult.Add( Copy( strValue, last, strLen - last + 1 ) );

end;


function HttpEncode(

	const strValue : string
) : string;
var
	i : Integer;
	strLen : Integer;
	strResult : string;
	b : Integer;
const
	kHexCode : array [0..15] of char = (
				'0', '1', '2', '3', '4', '5', '6', '7',
				'8', '9', 'A', 'B', 'C', 'D', 'E', 'F' );
begin

	strLen := Length( strValue );
	i := 1;

	while i <= strLen do
	begin

		case strValue[ i ] of
		'0' .. '9', 'a' .. 'z', 'A' .. 'Z', '*', '-', '.', '@', '_':
			begin
				strResult := strResult + strValue[ i ];
			end;
		else
			begin
				b := Integer( strValue[ i ] );
				strResult := strResult + '%'
								+ kHexCode[ b div $10 ]
								+ kHexCode[ b mod $10 ];
			end;
		end;

		i := i + 1;

	end;

	Result := strResult;

end;



// =========================================================================
// PlugIn
// =========================================================================

// *************************************************************************
// vOC̃o[Wvꂽ
// *************************************************************************
procedure OnVersionInfo(
	var outAgent		: PChar;	// o[W؊܂܂ȂȖ
	var outMajor		: DWORD;	// W[o[W
	var outMinor		: DWORD;	// }Ci[o[W
	var outRelease	: PChar;	// [XiK
	var outRevision	: DWORD		// rWio[
); stdcall;
begin

	outAgent		:= CreateResultString( PChar( PLUGIN_NAME ) );
	outMajor		:= MAJOR_VERSION;
	outMinor		:= MINOR_VERSION;
	outRelease	:= CreateResultString( PChar( RELEASE_VERSION ) );
	outRevision	:= REVISION_VERSION;

end;

// *************************************************************************
// w肵 URL ̃vOCŎ󂯕t邩ǂ
// *************************************************************************
function OnAcceptURL(
	inURL			: PChar				// fł URL
): TAcceptType; stdcall;	// URL ̎
var
	uri				: TIdURI;
  uriList		: TStringList;
	foundPos	: Integer;
const
	BBS_HOST		= '2ch.net';
  THREAD_MARK	= '/test/read.cgi/';
begin

	try
		// ƂăzXg 2ch.net ŏIꍇ͎󂯕t悤ɂĂ
		uri			:= TIdURI.Create( inURL );
		uriList	:= TStringList.Create;
		try
	 		ExtractHttpFields( ['/'], [], uri.Path, uriList );
			foundPos := AnsiPos( BBS_HOST, uri.Host );
			if (foundPos > 0) and (Length( uri.Host ) - foundPos + 1 = Length( BBS_HOST )) then begin
				foundPos := AnsiPos( THREAD_MARK, uri.Path );
				if foundPos > 0 then
					Result := atThread
				else if (uriList.Count > 1) and (uri.Path <> '/') then	// Ōオ '/' ŕ߂ĂȂ 3
					Result := atBoard
				else
					Result := atBBS;
			end else begin
				Result := atNoAccept;
			end;
		finally
			uri.Free;
			uriList.Free;
		end;
	except
		Result := atNoAccept;
	end;

end;



// =========================================================================
// T2chThreadItem
// =========================================================================

// *************************************************************************
// RXgN^
// *************************************************************************
constructor T2chThreadItem.Create(
	inInstance	: DWORD
);
var
	uri					: TIdURI;
	uriList			: TStringList;
begin

	inherited;

	OnDownload		:= Download;
	OnWrite				:= Write;
	OnGetRes			:= GetRes;
    OnGetDat			:= GetDat;
	OnGetHeader		:= GetHeader;
	OnGetFooter		:= GetFooter;

	FilePath			:= '';
	FIsTemporary	:= False;
	FDat					:= nil;
	URL						:= ReadURL + 'l50';

	uri			:= TIdURI.Create( ReadURL );
	uriList	:= TStringList.Create;
	try
		ExtractHttpFields( ['/', '?'], [], uri.Path, uriList );
		FileName	:= uriList[ 4 ] + '.dat';
		FilePath	:= MyLogFolder + uriList[ 3 ] + '\' + uriList[ 4 ] + '.dat';
		IsLogFile	:= FileExists( FilePath );
	finally
		uri.Free;
		uriList.Free;
	end;

end;

// *************************************************************************
// fXgN^
// *************************************************************************
destructor T2chThreadItem.Destroy;
begin

	FreeDat;

	// ꎞt@C̏ꍇ͍폜
	if FIsTemporary then
		DeleteFile( FilePath );

	inherited;

end;

// *************************************************************************
// w肵 URL ̃Xbh̃_E[hwꂽ
// *************************************************************************
function T2chThreadItem.Download : TDownloadState;
var
	modified			: Double;
	tmp, tmp2			: PChar;
	tmpLen				: Integer;
	responseCode	: Longint;
	logStream			: TFileStream;
	uri						: TIdURI;
	uriList				: TStringList;
	datURL				: string;
	downResult		: TStringList;
const
	LF						= #10;
begin

	Result := dsError;

	uri			:= TIdURI.Create( ReadURL );
	uriList	:= TStringList.Create;
	try
		ExtractHttpFields( ['/', '?'], [], uri.Path, uriList );
		FileName := uriList[ 4 ] + '.dat';
		// http://pc2.2ch.net/test/read.cgi/software/1065250336/l50
		// protocol://host/1/2/3/4/uriList.Count - 1
		if MyLogFolder = '' then begin
			// ǂɕۑĂ̂Ȃ̂ňꎞt@Cɕۑ
			FilePath 			:= TemporaryFile;
			FIsTemporary	:= True;
		end else begin
			FilePath			:= MyLogFolder + uriList[ 3 ] + '\' + uriList[ 4 ] + '.dat';
			FIsTemporary	:= False;
		end;

		// ۑp̃fBNg@
		ForceDirectoriesEx( Copy( FilePath, 1, LastDelimiter( '\', FilePath ) ) );

		if FileExists( FilePath ) then
			logStream := TFileStream.Create( FilePath, fmOpenReadWrite or fmShareDenyWrite )
		else
			logStream := TFileStream.Create( FilePath, fmCreate or fmShareDenyWrite );
		try
			// ƎɃ_E[htB^OsȂꍇ
			// InternalDownload ɔC邱Ƃo
			modified	:= LastModified;
			// http://pc2.2ch.net/software/1000000000.dat
			datURL		:=
				uri.Protocol + '://' + uri.Host + '/' +
				uriList[ 3 ] + '/dat/' + uriList[ 4 ] + '.dat';
			// ځ[`FbN̂ 1 oCgO擾
			// OƎI dat ͉sR[hႤ߃t@CTCYςĂ邱Ƃɒ
			responseCode := InternalDownload( PChar( datURL ), modified, tmp, Max( 0, Size - 1 ) );

			try
				if (responseCode = 200) or (responseCode = 206) then begin
					downResult := TStringList.Create;
					try
						tmpLen					:= StrLen( tmp );

						if Count = 0 then begin
							Result := dsComplete;
							downResult.Text			:= string( tmp ); // JEĝ߂
							logStream.Position	:= logStream.Size;
							logStream.Write( (tmp)^, tmpLen );

							NewReceive		:= Count + 1;
							Count					:= Count + downResult.Count;
							NewResCount		:= downResult.Count;
							Size					:= tmpLen;
						end else if LF = tmp^ then begin
							// VKA܂͒ǋL
							Result := dsDiffComplete;
							downResult.Text			:= string( tmp + 1 ); // JEĝ߂
							logStream.Position	:= logStream.Size;
							logStream.Write( (tmp + 1)^, tmpLen - 1 );

							NewReceive		:= Count + 1;
							Count					:= Count + downResult.Count;
							NewResCount		:= downResult.Count;
							Size					:= Size + tmpLen - 1;
						end else begin
							// ځ[
							Result := dsDiffComplete;
							// Ď擾
							modified			:= LastModified;
							responseCode	:= InternalDownload(
								PChar( datURL ), modified, tmp2, 0, Size );
							logStream.Position := 0;
							logStream.Write( tmp2, StrLen( tmp2 ) );
							logStream.Write( tmp, tmpLen );

							downResult.Text	:= string( tmp2 ) + string( tmp ); // JEĝ߂

							LastModified	:= modified;
							if downResult.Count > Count then
								NewReceive := Count + 1
							else
								NewReceive := 1;
							Count					:= downResult.Count;
							NewResCount		:= Count - NewReceive + 1;
							Size					:= StrLen( tmp2 ) + tmpLen;
						end;

						LastModified	:= modified;
					finally
						downResult.Free;
					end;
				end else if responseCode = 304 then begin
					Result := dsNotModify;
				end;
			finally
				DisposeResultString( tmp );
			end;
		finally
			logStream.Free;
		end;
	finally
		uri.Free;
		uriList.Free;
	end;

end;

// *************************************************************************
// ݂wꂽ
// *************************************************************************
function	T2chThreadItem.Write(
	inName				: string;	// O(nh)
	inMail				: string;	// [AhX
	inMessage			: string	// {
) : TDownloadState;				// ݂ǂ
var
	postData			: string;
	postResult		: PChar;
	uri						: TIdURI;
	uriList				: TStringList;
begin

	MessageBox( 0, PChar( '̃vOC̓JLRɑΉĂ܂B' ), PChar( '' ), MB_OK );
	Result := dsError;
	{
	uri			:= TIdURI.Create( URL );
	uriList	:= TStringList.Create;
	try
		ExtractHttpFields( ['/', '?'], [], uri.Path, uriList );

		// http://jbbs.shitaraba.com/bbs/read.cgi/game/1578/1067968274/l100
		postData	:=
			'NAME='			+ HttpEncode( SJIStoEUC( inName ) ) +
			'&MAIL='		+ HttpEncode( SJIStoEUC( inMail ) ) +
			'&MESSAGE='	+ HttpEncode( SJIStoEUC( inMessage ) ) +
			'&BBS='			+ uriList[ 4 ] +
			'&KEY='			+ uriList[ 5 ] +
			'&DIR='			+ uriList[ 3 ] +
			'&TIME='		+ IntToStr( DateTimeToUnix( Now ) ) +
			'&submit='	+ HttpEncode( SJIStoEUC( '' ) );

		// ƎɒʐMȂꍇ InternalPost ɔC邱Ƃo
		InternalPost( PChar( WriteURL ), PChar( postData ), postResult );
		DisposeResultString( postResult );

		Result := dsComplete
	finally
		uri.Free;
		uriList.Free;
	end;
	}

end;

// *************************************************************************
// Xԍ inNo ɑ΂ html vꂽ
// *************************************************************************
function T2chThreadItem.GetRes(
	inNo		: Integer		// vꂽXԍ
) : string;						// Ή HTML
var
	res		 	: string;
	tmp			: PChar;
begin

	// ƎɃtB^OsȂꍇ
	// InternalAbon  Dat2HTML ɔC邱Ƃo
	LoadDat;
	if FDat = nil then begin
		// Oɑ݂Ȃ̂ł̂܂܏I
		Result := '';
		Exit;
	end;
    res := FDat[ inNo - 1 ];
    tmp := InternalAbonForOne( PChar( res ), PChar( FilePath ), inNo);
	try
		Result	:= Dat2HTML( string( tmp ), inNo );
	finally
		DisposeResultString( tmp );
	end;

end;

// *************************************************************************
// Xԍ inNo ɑ΂ Dat vꂽ
// *************************************************************************
function T2chThreadItem.GetDat(
	inNo		: Integer		// vꂽXԍ
) : string;						// Q˂Dat`
begin
	LoadDat;
	if FDat = nil then begin
		// Oɑ݂Ȃ̂ł̂܂܏I
		Result := '';
		Exit;
	end;
    try
		Result := FDat[ inNo - 1 ];
	except
		Result := '';
	end;

end;

// *************************************************************************
// Xbh̃wb_ html vꂽ
// *************************************************************************
function T2chThreadItem.GetHeader(
	inOptionalHeader : string
) : string;
begin

	// ƎɃtB^OsȂꍇ
	// InternalHeader ɔC邱Ƃo
	Result := InternalHeader(
		'<meta http-equiv="Content-type" content="text/html; charset=Shift_JIS">' +
		inOptionalHeader );


	// GetRes Ă΂邱Ƃ\ẑ FDat 𐶐Ă
	try
		FreeDat;
		LoadDat;
	except
	end;

end;

// *************************************************************************
// Xbh̃tb^ html vꂽ
// *************************************************************************
function T2chThreadItem.GetFooter(
	inOptionalFooter : string
) : string;
begin

	// ƎɃtB^OsȂꍇ
	// InternalFooter ɔC邱Ƃo
	Result := InternalFooter( inOptionalFooter );

	//  GetRes ͌Ă΂ȂƎv̂ FDat JĂ
	try
		FreeDat;
	except
	end;

end;

// *************************************************************************
//  ThreadItem  URL vꂽ
// *************************************************************************
function	T2chThreadItem.GetBoardURL : string;
var
	uri						: TIdURI;
	uriList				: TStringList;
begin

	uri			:= TIdURI.Create( ReadURL );
	uriList := TStringList.Create;
	try
		ExtractHttpFields( ['/', '?'], [], uri.Path, uriList );
		FileName := uriList[ 4 ] + '.dat';
		// http://book.2ch.net/test/read.cgi/bizplus/1067681920/
		// http://book.2ch.net/bizplus/subject.txt
		Result		:= CreateResultString(
			uri.Protocol + '://' + uri.Host + '/' + uriList[ 3 ] + '/' );
	finally
		uri.Free;
		uriList.Free;
	end;

end;

// *************************************************************************
// FDat ̐
// *************************************************************************
procedure	T2chThreadItem.LoadDat;
begin

	if FDat = nil then begin
		if IsLogFile then begin
			// dat ̓ǂݍ
			FDat := TStringList.Create;
			FDat.LoadFromFile( FilePath );
		end;
	end;

end;

// *************************************************************************
// FDat ̊J
// *************************************************************************
procedure	T2chThreadItem.FreeDat;
begin

	if FDat <> nil then begin
		FDat.Free;
		FDat := nil;
	end;

end;

// *************************************************************************
// S( '/' ŏI )ǂݍ݂ URL
// *************************************************************************
function	T2chThreadItem.ReadURL : string;
var
	uri			: TIdURI;
	uriList	: TStringList;
begin

	if Copy( URL, Length( URL ), 1 ) = '/' then
		uri := TIdURI.Create( URL )
	else
		uri := TIdURI.Create( URL + '/' );
	uriList := TStringList.Create;
	try
		ExtractHttpFields( ['/', '?'], [], uri.Path, uriList );
		// http://book.2ch.net/test/read.cgi/bizplus/1067681920/
		Result :=
		 	uri.Protocol + '://' + uri.Host + '/test/read.cgi/' +
			uriList[ 3 ] + '/' + uriList[ 4 ] + '/';
	finally
		uri.Free;
		uriList.Free;
	end;

end;

// *************************************************************************
// TThreadItem ꂽꍇ̏u(T2chThreadItem 𐶐)
// *************************************************************************
procedure ThreadItemOnCreateOfT2chThreadItem(
	inInstance : DWORD
);
var
	threadItem : T2chThreadItem;
begin

	threadItem := T2chThreadItem.Create( inInstance );
	ThreadItemSetLong( inInstance, tipContext, DWORD( threadItem ) );

end;

// *************************************************************************
// TThreadItem jꂽꍇ̏u(T2chThreadItem j)
// *************************************************************************
procedure ThreadItemOnDisposeOfT2chThreadItem(
	inInstance : DWORD
);
var
	threadItem : T2chThreadItem;
begin

	threadItem := T2chThreadItem( ThreadItemGetLong( inInstance, tipContext ) );
	threadItem.Free;

end;

// =========================================================================
// T2chBoardItem
// =========================================================================

// *************************************************************************
// RXgN^
// *************************************************************************
constructor T2chBoardItem.Create(
	inInstance	: DWORD
);
var
	uri					: TIdURI;
	uriList			: TStringList;
begin

	inherited;

	OnDownload						:= Download;
	OnEnumThread					:= EnumThread;
	OnFileName2ThreadURL	:= ToThreadURL;

	FilePath			:= '';
	FIsTemporary	:= False;
	FDat					:= nil;

	if Copy( URL, Length( URL ), 1 ) = '/' then
		uri := TIdURI.Create( URL )
	else
		uri := TIdURI.Create( URL + '/' );
	uriList := TStringList.Create;
	try
		ExtractHttpFields( ['/', '?'], [], uri.Path, uriList );
		// http://2ch.net/hoge/subject.txt
		FilePath	:= MyLogFolder + uriList[ 1 ] + '\' + uri.Document;
		IsLogFile	:= FileExists( FilePath );
	finally
		uri.Free;
		uriList.Free;
	end;

end;
 
// *************************************************************************
// fXgN^
// *************************************************************************
destructor T2chBoardItem.Destroy;
begin

	if FDat <> nil then begin
		try
			FDat.Free;
			FDat := nil;
		except
		end;
	end;

	// ꎞt@C̏ꍇ͍폜
	if FIsTemporary then
		DeleteFile( FilePath );

	inherited;

end;

// *************************************************************************
// w肵Xꗗ̃_E[hvꂽ
// *************************************************************************
function T2chBoardItem.Download : TDownloadState;
var
	modified			: Double;
	downResult		: PChar;
	responseCode	: Longint;
	uri						: TIdURI;
	uriList				: TStringList;
const
	SUBJECT_NAME	= 'subject.txt';
begin

	Result := dsError;

	if Copy( URL, Length( URL ), 1 ) = '/' then
		uri := TIdURI.Create( URL + SUBJECT_NAME )
	else
		uri := TIdURI.Create( URL );
	uriList := TStringList.Create;
	if FDat <> nil then begin
		try
			FDat.Free;
			FDat := nil;
		except
		end;
	end;
	FDat := TStringList.Create;
	// ƎɃ_E[htB^OsȂꍇ
	// InternalDownload ɔC邱Ƃo
	modified := LastModified;
	responseCode := InternalDownload( PChar( uri.URI ), modified, downResult );
	try
		if responseCode = 200 then begin
			try
				// pXZo
				ExtractHttpFields( ['/', '?'], [], uri.Path, uriList );
				if MyLogFolder = '' then begin
					// ǂɕۑĂ̂Ȃ̂ňꎞt@Cɕۑ
					FilePath 			:= TemporaryFile;
					FIsTemporary	:= True;
				end else begin
					FilePath			:= MyLogFolder + uriList[ 1 ] + '\' + uri.Document;
					FIsTemporary	:= False
				end;

				// ۑp̃fBNg@
				ForceDirectoriesEx( Copy( FilePath, 1, LastDelimiter( '\', FilePath ) ) );

				FDat.Text := string( downResult );
				// ۑ
				FDat.SaveToFile( FilePath );

				IsLogFile			:= True;
				RoundDate			:= Now;
				LastModified	:= modified;
				LastGetTime		:= Now;
			finally
				uri.Free;
				uriList.Free;
			end;
			Result := dsComplete;
		end;
	finally
		DisposeResultString( downResult );
	end;

end;

// *************************************************************************
// Xꗗ URL Xbh URL 𓱂o
// *************************************************************************
function T2chBoardItem.ToThreadURL(
	inFileName	: string	// Xbht@C
) : string;							// Xbh URL
var
	threadURL		: string;
	uri					: TIdURI;
	uriList			: TStringList;
	found				: Integer;
begin

	found := Pos( '.', inFileName );
	if found > 0 then
		inFileName := Copy( inFileName, 1, found - 1 );
	if Copy( URL, Length( URL ), 1 ) = '/' then
		uri := TIdURI.Create( URL )
	else
		uri := TIdURI.Create( URL + '/' );
	uriList := TStringList.Create;

	try
		try
			// http://book.2ch.net/bizplus/subject.txt
			// http://book.2ch.net/test/read.cgi/bizplus/1068905348/l50
			ExtractHttpFields( ['/', '?'], [], uri.Path, uriList );
			threadURL	:= uri.Protocol + '://' + uri.Host + '/test/read.cgi/' +
				uriList[ 1 ] + '/' + inFileName + '/l50';
			Result		:= threadURL;
		finally
			uri.Free;
			uriList.Free;
		end;
	except
		Result := '';
	end;

end;

// *************************************************************************
// ̔ɂ̃X邩vꂽ
// *************************************************************************
procedure	T2chBoardItem.EnumThread(
	inCallBack	: TBoardItemEnumThreadCallBack
);
var
	uri		 			: TIdURI;
	uriList			: TStringList;
const
	SUBJECT_NAME	= 'subject.txt';
begin

	try
		if FDat = nil then begin
			FDat := TStringList.Create;

			if Copy( URL, Length( URL ), 1 ) = '/' then
				uri := TIdURI.Create( URL + SUBJECT_NAME )
			else
				uri := TIdURI.Create( URL );
			uriList := TStringList.Create;
			try
				// pXZo
				ExtractHttpFields( ['/', '?'], [], uri.Path, uriList );
				// http://book.2ch.net/bizplus/subject.txt
				FilePath	:= MyLogFolder + uriList[ 1 ] + '\' + uri.Document;
				if FileExists( FilePath ) then
					// ǂݍ
					FDat.LoadFromFile( FilePath );
			finally
				uri.Free;
				uriList.Free;
			end;
		end;

		// ƎɃtB^OsȂꍇ EnumThread ɔC邱Ƃo
		inherited EnumThread( inCallBack, FDat.Text );
	except
	end;

end;

// *************************************************************************
// TBoardItem ꂽꍇ̏u(T2chBoardItem 𐶐)
// *************************************************************************
procedure BoardItemOnCreateOfT2chBoardItem(
	inInstance : DWORD
);
var
	boardItem : T2chBoardItem;
begin

	boardItem := T2chBoardItem.Create( inInstance );
	BoardItemSetLong( inInstance, bipContext, DWORD( boardItem ) );

end;

// *************************************************************************
// TBoardItem jꂽꍇ̏u(T2chBoardItem j)
// *************************************************************************
procedure BoardItemOnDisposeOfT2chBoardItem(
	inInstance : DWORD
);
var
	boardItem : T2chBoardItem;
begin

	boardItem := T2chBoardItem( BoardItemGetLong( inInstance, bipContext ) );
	boardItem.Free;

end;



// =========================================================================
// Gg|Cg
// =========================================================================
procedure DLLEntry(
	ul_reason_for_call : DWORD
);
var
	module : HMODULE;
begin

	case ul_reason_for_call of
		DLL_PROCESS_ATTACH:
		begin
			Randomize;

			module := GetModuleHandle( nil );

			LoadInternalAPI( module );
			LoadInternalFilePathAPI( module );
			LoadInternalThreadItemAPI( module );
			LoadInternalBoardItemAPI( module );

			// ===== CX^X̎舵 TThreadItem  T2chThreadItem ɕύX
			ThreadItemOnCreate	:= ThreadItemOnCreateOfT2chThreadItem;
			ThreadItemOnDispose	:= ThreadItemOnDisposeOfT2chThreadItem;
			// ===== CX^X̎舵 TBoardItem  T2chBoardItem ɕύX
			BoardItemOnCreate		:= BoardItemOnCreateOfT2chBoardItem;
			BoardItemOnDispose	:= BoardItemOnDisposeOfT2chBoardItem;
		end;
		DLL_PROCESS_DETACH:
			;
		DLL_THREAD_ATTACH:
			;
		DLL_THREAD_DETACH:
			;
	end;

end;

exports
	OnVersionInfo,
	OnAcceptURL;

begin

	DllProc := @DLLEntry;
	DLLEntry( DLL_PROCESS_ATTACH );

end.
