unit ResPopupBrowser;
interface
uses
	Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
	ActiveX, OleCtrls, HintWindow,
{$IF Defined(DELPRO) }
	SHDocVw,
	MSHTML
{$ELSE}
	SHDocVw_TLB,
	MSHTML_TLB
{$IFEND}
;

type
	TResPopupBrowser = class(TWebBrowser)
	private
        FChild :TResPopupBrowser;
        FTitle :String;
   		FPopupType: TGikoPopupType;
        function GetBodyStyle(): string;
        function GetWindowHeight : Integer;
	protected
		procedure CreateParams(var Params: TCreateParams); override;
	public
		constructor Create(AOwner: TComponent); override;
		destructor Destroy; override;
        property Child: TResPopupBrowser read FChild;
        property Title: String read FTitle write FTitle;
        function CreateNewBrowser: TResPopupBrowser;
        procedure Write(ADocument: String);
        procedure Clear;
        procedure ChildClear;
        procedure NavigateBlank;
		function CalcRect(MaxHeight: Integer; MaxWidth: Integer): TRect;
		property PopupType: TGikoPopupType read FPopupType write FPopupType;
	end;

implementation
uses MojuUtils, GikoSystem, Setting, Giko;


constructor TResPopupBrowser.Create(AOwner: TComponent);
begin
	inherited Create(AOwner);
    FChild := nil;
    Visible := False;
    Title := '';
end;

destructor TResPopupBrowser.Destroy;
begin
	inherited Destroy;
end;

procedure TResPopupBrowser.CreateParams(var Params: TCreateParams);
begin
	inherited CreateParams(Params);
end;
function TResPopupBrowser.CreateNewBrowser: TResPopupBrowser;
begin
    if (Self.Visible) then begin
        if (FChild <> nil) then begin
            if (FChild.Visible) then begin
                Result := FChild.CreateNewBrowser;
            end else begin
                Result := FChild;
            end;
        end else begin
            FChild := TResPopupBrowser.Create(Self);
            TOleControl(FChild).Parent := nil;
            FChild.NavigateBlank;
            FChild.OnEnter := GikoForm.BrowserEnter;
            FChild.OnBeforeNavigate2 := GikoForm.BrowserBeforeNavigate2;
            FChild.OnStatusTextChange := GikoForm.BrowserStatusTextChange;
            FChild.OnNewWindow2 := GikoForm.BrowserNewWindow2;
            ShowWindow(FChild.Handle, SW_HIDE);
            Result := FChild;
        end;
    end else begin
        TOleControl(Self).Parent := nil;
        Self.NavigateBlank;
        Self.OnEnter := GikoForm.BrowserEnter;
        Self.OnBeforeNavigate2 := GikoForm.BrowserBeforeNavigate2;
        Self.OnStatusTextChange := GikoForm.BrowserStatusTextChange;
        Self.OnNewWindow2 := GikoForm.BrowserNewWindow2;
        Result := Self;
    end;

end;
procedure TResPopupBrowser.NavigateBlank;
begin
    if (not Assigned(Self.Document)) then begin
        Self.Navigate('about:blank');
    end;
    while (Self.ReadyState <> READYSTATE_COMPLETE) and
            (Self.ReadyState <> READYSTATE_INTERACTIVE) do begin
        Forms.Application.ProcessMessages;
    end;
end;
procedure TResPopupBrowser.Write(ADocument: String);
var
    doc: Variant;
   	ARect: TRect;
begin
    try
        // k
        SetWindowPos(Self.Handle, HWND_TOP,
            0, 0, 50 , 50,
            SWP_NOMOVE or SWP_NOACTIVATE or SWP_HIDEWINDOW);

        doc := Idispatch( olevariant(Self.ControlInterface).Document) as IHTMLDocument2;
        doc.open;
        doc.charset := 'Shift_JIS';
        doc.Write('<html><head>'#13#10 +
                '<meta http-equiv="Content-type" content="text/html; charset=Shift_JIS">'#13#10 +
                '<span id="hTitle">' + Title +'</span>'+ GetBodyStyle + '</head><body>' +
                ADocument + '<a name="bottom"></a></body></html>');
        doc.Close;

        ARect := CalcRect(Screen.Height, Screen.Width);
        SetWindowPos(Self.Handle, HWND_TOP,
            ARect.Left, ARect.Top,
            (ARect.Right - ARect.Left) ,
            (ARect.Bottom - ARect.Top),
            SWP_NOACTIVATE or SWP_HIDEWINDOW);
        ShowWindow(Self.Handle, SW_SHOWNOACTIVATE);
        Self.Visible := True;
    except
    end;

end;

function TResPopupBrowser.GetBodyStyle(): string;
var
    i : Integer;
begin

    Result := '<style type="text/css">' +
            'dl { margin :0px; padding :0px}'#13#10 +
            'body { ' +
            'border-width: 1px; border-style: solid;white-space: nowrap; ' +
            'margin: 2px 4px 0px 0px; padding: 0px 4px 0px 0px; ';

	if Length( GikoSys.Setting.HintFontName ) > 0 then
		Result := Result + 'font-family:"' + GikoSys.Setting.HintFontName + '";';
	if GikoSys.Setting.HintFontSize <> 0 then
		Result := Result + 'font-size:' + IntToStr( GikoSys.Setting.HintFontSize ) + 'pt;';
	if GikoSys.Setting.HintFontColor <> -1 then
		Result := Result + 'color:#' + IntToHex( GikoSys.Setting.HintFontColor, 6 ) + ';';
	if GikoSys.Setting.HintBackColor <> -1 then begin
   		i := ColorToRGB( GikoSys.Setting.HintBackColor );
		Result := Result + 'background-color:#' +
            IntToHex( (i shr 16) or (i and $ff00) or ((i and $ff) shl 16), 6 ) + ';';
    end;

    Result := Result + '}';
    if GikoSys.Setting.ResPopupHeaderBold then begin
        Result := Result + #13#10'span#hTitle{font-weight: bold; }';
    end;
    Result := Result + '</style>';
end;

procedure TResPopupBrowser.Clear;
begin
    ChildClear;
    if (Self.Visible) then begin
        Self.Title := '';
        NavigateBlank;
        ShowWindow(Self.Handle, SW_HIDE);
        Self.Visible := False;
    end;
end;
procedure TResPopupBrowser.ChildClear;
begin
    if (FChild <> nil) then begin
        FChild.Clear;
    end;
end;

function TResPopupBrowser.CalcRect(MaxHeight: Integer; MaxWidth: Integer): TRect;
var
	p: TPoint;
    ele: IHTMLElement2;
    h, w: Integer;
begin
	GetCursorpos(p);
    ele := ((Self.Document as IHTMLDocument2).body as IHTMLElement2);
    h := GetWindowHeight + 10;
    w := ele.scrollWidth + 25;
	Result := Rect(0, 0, w, h);
    case GikoSys.Setting.PopupPosition of
        gppRightTop: 		OffsetRect(Result, p.x - w - 2, p.y - h - 2);
        gppRight: 			OffsetRect(Result, p.x - w - 2, p.y - (h div 2));
        gppRightBottom: OffsetRect(Result, p.x - w -2, p.y + 2);
        gppTop:					OffsetRect(Result, p.x - (w div 2), p.y - h - 2);
        gppCenter:			OffsetRect(Result, p.x - (w div 2), p.y - (h div 2));
    	gppBottom:			OffsetRect(Result, p.x - (w div 2), p.y + 2);
        gppLeftTop:			OffsetRect(Result, p.x + 2, p.y - h - 2);
        gppLeft:				OffsetRect(Result, p.x + 2, p.y - (h div 2));
        gppLeftBottom: 	OffsetRect(Result, p.x + 2, p.y + 2);
    end;
    if (Result.Left < 0) then begin
        OffsetRect(Result, -Result.Left, 0);
    end;
    if (Result.Top < 0) then begin
        OffsetRect(Result, 0, -Result.Top);
    end;
    if (Result.Right > MaxWidth) then begin
        OffsetRect(Result, - (Result.Right - MaxWidth), 0);
    end;
    if (Result.Bottom > MaxHeight) then begin
        OffsetRect(Result, 0, - (Result.Bottom - MaxHeight));
    end;
    
    // ōēxƏmFĔяoĂAʃTCY
    if (Result.Left < 0) then begin
        Result := Rect(0, Result.Top,
            Result.Right, Result.Bottom);
    end;
    if (Result.Top < 0) then begin
        Result := Rect(Result.Left, 0,
            Result.Right, Result.Bottom);
    end;
end;
function TResPopupBrowser.GetWindowHeight : Integer;
var
	top: Integer;
	item: OleVariant;
begin
    Result := 0;
    //uEUf[^̓ǂݍݒ͓̎ǂݍ݂҂
    while (Self.ReadyState <> READYSTATE_COMPLETE) and
                (Self.ReadyState <> READYSTATE_INTERACTIVE) do begin
        Sleep(1);
        Forms.Application.ProcessMessages;
    end;

    try
        top := 0;
        item := OleVariant( Self.Document as IHTMLDocument2)
                .anchors.item(OleVariant('bottom'));
        item.focus();
        repeat
            top := top + item.offsetTop;
            item := item.offsetParent;
        until AnsiCompareText(item.tagName, 'body' ) = 0;
        Result := top;
    except
    end;
end;
end.
