unit BrowserRecord;

interface

uses
	Windows, OleCtrls, ActiveX,
{$IF Defined(DELPRO) }
	SHDocVw,
	MSHTML,
{$ELSE}
	SHDocVw_TLB,
	MSHTML_TLB,
{$IFEND}
	BoardGroup, HTMLDocumentEvent;

type
	TBrowserRecord = class( TObject )
	private
		FBrowser	: TWebBrowser;
		FEvent: THTMLDocumentEventSink;	///< uEUhLgCxg
		FThread		: TThreadItem;
		FLastSize	: Integer;
		FRepaint	: Boolean;
		//FMovement	: string;							///< XN[AJ[
	public
		destructor	Destroy; override;
		property	Event : THTMLDocumentEventSink read FEvent write FEvent;
		property	Browser	: TWebBrowser	read FBrowser	write FBrowser;
		property	Thread	: TThreadItem	read FThread	write FThread;
		property	LastSize	: Integer		read FLastSize	write FLastSize;
		property	Repaint		: Boolean		read FRepaint	write FRepaint;
		//property	Movement	: string		read FMovement	write FMovement;
		procedure	Move(const AName: string);
		procedure	IDAnchorPopup(Abody :string);
        procedure OpenFindDialog;
	end;
	// BrowserRecordɂĂFBrowserO
	procedure ReleaseBrowser( BRecord: TBrowserRecord);

implementation

uses
	Forms, SysUtils;

// *************************************************************************
//! BrowserRecordɂĂFBrowserO
// *************************************************************************
procedure ReleaseBrowser( BRecord: TBrowserRecord);
begin
	if BRecord <> nil then begin
		BRecord.Browser := nil;
		if BRecord.Event <> nil then begin
			BRecord.Event.Free;
			BRecord.Event := nil;
		end;
		BRecord.Repaint := true;
	end;
end;
// *************************************************************************
//! BrowserRecord̃fXgN^
// *************************************************************************
destructor	TBrowserRecord.Destroy;
var
	doc :OleVariant;
begin
	if Self.FEvent <> nil then
		Self.FEvent.Free;
	if Self.FBrowser <> nil then begin
		if Self.Thread <> nil then begin
			//^u̕ŕꂽX́A`悳ĂȂƂ̂
			//̂Ƃ̃XN[ʂۑĂ܂ƃgbvɖ߂Ă܂B
			if Self.FBrowser.OleObject.Document.documentElement.innerText <> '' then begin
				doc := Idispatch( olevariant(Self.FBrowser.ControlInterface).Document) as IHTMLDocument2;
				Self.Thread.ScrollTop := doc.Body.ScrollTop;
			end;
		end;
		ShowWindow(Self.FBrowser.Handle, SW_HIDE);
	end;

end;
// *************************************************************************
//! uEUXN[
// *************************************************************************
procedure TBrowserRecord.Move(const AName: string);
var
	top: Integer;
	item: OleVariant;
begin
	//uEUtĂƂ
	if (Self.Browser <> nil) then begin
		//uEUf[^̓ǂݍݒ͓̎ǂݍ݂҂
		while (Self.Browser.ReadyState <> READYSTATE_COMPLETE) and
					(Self.Browser.ReadyState <> READYSTATE_INTERACTIVE) do begin
			Sleep(1);
			Application.ProcessMessages;
		end;

		try
			top := 0;
			item := OleVariant( Self.Browser.Document as IHTMLDocument2)
					.anchors.item(OleVariant(AName));
			item.focus();
			repeat
				top := top + item.offsetTop;
				item := item.offsetParent;
			until AnsiCompareText(item.tagName, 'body' ) = 0;
			OleVariant(Self.Browser.Document as IHTMLDocument2).body.scrollTop := top;
		except
		end;
	end;
end;
//IDAJ[ǉ
procedure TBrowserRecord.IDAnchorPopup(Abody :string);
const
	OUTER_HTML = '<p id="idSearch"></p>';
	HIDDEN = 'hidden';
var
	firstElement: IHTMLElement;
	document: IHTMLDocument2;
	docAll: IHTMLElementCollection;
	doc : Variant;
	nCSS : string;
begin
	if Self.Browser <> nil then begin
		try
			document := Self.Browser.Document as IHTMLDocument2;

			if Assigned(document) then begin
				docAll := document.all;
				firstElement := docAll.item('idSearch', 0) as IHTMLElement;
				if (Assigned(firstElement)) then begin
					if Length(Abody) > 0 then begin
						doc := Idispatch( olevariant(Self.Browser.ControlInterface).Document) as IHTMLDocument2;
						nCSS := '<p id="idSearch" style="position:absolute;top:' + IntToStr(doc.Body.ScrollTop + 10) + 'px;right:5px;' //
							+ 'background-color:window; border:outset 1px infobackground; z-index:10; overflow-y:auto; border-top:none">'
							+ Abody + '</p>';
						firstElement.outerHTML := nCSS;
						firstElement.style.visibility := 'visible';
					end else begin
						firstElement.outerHTML := OUTER_HTML;
						firstElement.style.visibility := HIDDEN;
					end;
				end else if (Assigned(firstElement)) then begin
					firstElement.outerHTML := OUTER_HTML;
					firstElement.style.visibility := HIDDEN;
				end;
			end;
		except
		end;
	end;
end;
{
\brief _CAOĂяo
}
procedure TBrowserRecord.OpenFindDialog();
const
	CGID_WebBrowser: TGUID = '{ED016940-BD5B-11cf-BA4E-00C04FD70816}';
	HTMLID_FIND = 1;
var
	CmdTarget : IOleCommandTarget;
	vaIn, vaOut: OleVariant;
	PtrGUID: PGUID;
begin
	if (Self.Browser <> nil) and (Self.Browser.Document <> nil) then begin
		//uEUf[^̓ǂݍݒ͓̎ǂݍ݂҂
		while (Self.Browser.ReadyState <> READYSTATE_COMPLETE) and
					(Self.Browser.ReadyState <> READYSTATE_INTERACTIVE) do begin
			Sleep(1);
			Application.ProcessMessages;
		end;
        vaIn  := 0;
        vaOut := 0;
		New(PtrGUID);
		PtrGUID^ := CGID_WebBrowser;
        try
    		try
	    		if Self.Browser.Document
                    .QueryInterface(IOleCommandTarget, CmdTarget)
                    = S_OK then begin
		    	    if CmdTarget <> nil then begin
			    	    try
				    	    CmdTarget.Exec(PtrGUID, HTMLID_FIND, 0, vaIn, vaOut);
				        finally
					        CmdTarget._Release;
				        end;
			        end;
                end;
		    except
		    end;
        finally
    		Dispose(PtrGUID);
        end;
	end;
end;

end.
