unit KuroutSetting;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ComCtrls, GikoSystem, GikoUtil, ExtCtrls;

type
  TKuroutOption = class(TForm)
	PageControl1: TPageControl;
	TabSheet1: TTabSheet;
	GroupBox11: TGroupBox;
	Label17: TLabel;
	Label18: TLabel;
	RecvBufferSize: TEdit;
	ProxyProtocolCheckBox: TCheckBox;
	ProtocolCheckBox: TCheckBox;
	GroupBox13: TGroupBox;
	Label24: TLabel;
	Label25: TLabel;
	PostTimeLabel: TLabel;
	Label27: TLabel;
	PostTimeCheckBox: TCheckBox;
	PostTimeEdit: TEdit;
	PutPostTimeRadioButton: TRadioButton;
	BackPostTimeRadioButton: TRadioButton;
	OkBotton: TButton;
	CancelBotton: TButton;
	ApplyButton: TButton;
	ColumnTabSheet: TTabSheet;
	CategoryColumnGroupBox: TGroupBox;
	CUnVisibledListBox: TListBox;
	CVisibledListBox: TListBox;
	CAddButton: TButton;
	CDeleteButton: TButton;
	BoardColumnGroupBox: TGroupBox;
	BUnVisibledListBox: TListBox;
	BVisibledListBox: TListBox;
	BAddButton: TButton;
	BDeleteButton: TButton;
	Label1: TLabel;
	Label2: TLabel;
	Label3: TLabel;
	Label4: TLabel;
	CUpButton: TButton;
	CDownButton: TButton;
	BUpButton: TButton;
	BDownButton: TButton;
    GroupBox1: TGroupBox;
    GengoSupport: TCheckBox;
    Label5: TLabel;
    Label6: TLabel;
    ReadTimeOut: TEdit;
    Label7: TLabel;
    KakikomiTabSheet: TTabSheet;
    CookieGroupBox: TGroupBox;
    Label8: TLabel;
    FixedCookieEdit: TEdit;
    Label9: TLabel;
    GroupBox3: TGroupBox;
    Label10: TLabel;
    MoveHistoryMaxEdit: TEdit;
    Label11: TLabel;
    AHandredGroupBox: TGroupBox;
    AHandredLabeledEdit: TLabeledEdit;
    UpDown1: TUpDown;
    ThreadGroupBox: TGroupBox;
    AddKeywordCheckBox: TCheckBox;
    TabSheet2: TTabSheet;
    SecurityGroupBox: TGroupBox;
    GroupBox2: TGroupBox;
    LocalTrapAtt: TCheckBox;
    RemoteTrapAtt: TCheckBox;
    ReplaceDatCheckBox: TCheckBox;
    Label12: TLabel;
    GroupBox4: TGroupBox;
    SentIniFileSizeEdit: TEdit;
    SentIniFileSizeUpDown: TUpDown;
    Label13: TLabel;
    Label14: TLabel;
	procedure OkBottonClick(Sender: TObject);
	procedure FormCreate(Sender: TObject);
	procedure CDeleteButtonClick(Sender: TObject);
	procedure CAddButtonClick(Sender: TObject);
	procedure BAddButtonClick(Sender: TObject);
	procedure BDeleteButtonClick(Sender: TObject);
    procedure CUpButtonClick(Sender: TObject);
    procedure CDownButtonClick(Sender: TObject);
    procedure BUpButtonClick(Sender: TObject);
    procedure BDownButtonClick(Sender: TObject);
    procedure MoveHistoryMaxEditExit(Sender: TObject);
    procedure AHandredLabeledEditExit(Sender: TObject);
  private
	{ Private 錾 }
	procedure SetValue;
	procedure SaveSetting;
	procedure RecvBufferSizeExit(Sender: TObject);
	procedure PostTimeEditExit(Sender: TObject);
	procedure PostTimeCheckBoxClick(Sender: TObject);
	procedure SetColumnData();
	procedure PostColumnData();
  public
	{ Public 錾 }
  end;

var
  KuroutOption: TKuroutOption;

implementation

uses
	Giko, Setting;

{$R *.dfm}

procedure TKuroutOption.SetValue;
begin
	//Mobt@TCY
	RecvBufferSize.Text := IntToStr(Gikosys.Setting.RecvBufferSize);
	//HTTP1.1gp
	ProtocolCheckBox.Checked := GikoSys.Setting.Protocol;
	//vLVڑHTTP1.1gp
	ProxyProtocolCheckBox.Checked := Gikosys.Setting.ProxyProtocol;
	ReadTimeOut.Text := IntToStr(GikoSys.Setting.ReadTimeOut);

		//ݎ}VԎgpݒ
	PostTimeCheckBox.Checked := GikoSys.Setting.UseMachineTime;
	PostTimeEdit.Text := IntToStr(GikoSys.Setting.TimeAdjustSec);
	if GikoSys.Setting.TimeAdjust then
		PutPostTimeRadioButton.Checked := True
	else
		BackPostTimeRadioButton.Checked := True;

	SetColumnData();

	PageControl1.ActivePageIndex := GikoSys.Setting.KuroutSettingTabIndex;

	//2chAnnai
	GengoSupport.Checked := GikoSys.Setting.GengoSupport;
	//FusianaSet
	LocalTrapAtt.Checked := GikoSys.Setting.LocalTrapAtt;
	RemoteTrapAtt.Checked := GikoSys.Setting.RemoteTrapAtt;
	// Cookie
    FixedCookieEdit.Text := GikoSys.Setting.FixedCookie;
    // Nړ
    MoveHistoryMaxEdit.Text := IntToStr( GikoSys.Setting.MoveHistorySize );
    //@擪\X
    AHandredLabeledEdit.Text := IntToStr( GikoSys.Setting.HeadResCount );
    // ֘AL[[hǉtO
    AddKeywordCheckBox.Checked := GikoSys.Setting.AddKeywordLink;
    // 딽΍
    ReplaceDatCheckBox.Checked := GikoSys.Setting.ReplaceDat;
    SentIniFileSizeUpDown.Position := GikoSys.Setting.SentIniFileSize;
end;

procedure TKuroutOption.SaveSetting;
begin
	//Mobt@TCY
	Gikosys.Setting.RecvBufferSize := StrToIntDef(RecvBufferSize.Text, Gikosys.Setting.RecvBufferSize);
	GikoSys.Setting.ReadTimeOut := StrToIntDef(ReadTimeOut.Text, GikoSys.Setting.ReadTimeOut);
	//HTTP1.1gp
	GikoSys.Setting.Protocol := ProtocolCheckBox.Checked;
	//vLVڑHTTP1.1gp
	Gikosys.Setting.ProxyProtocol := ProxyProtocolCheckBox.Checked;
	//ݎ}VԎgpݒ
	GikoSys.Setting.UseMachineTime := PostTimeCheckBox.Checked;
	if GikoSys.IsNumeric(PostTimeEdit.Text) then
		GikoSys.Setting.TimeAdjustSec := StrToIntDef(PostTimeEdit.Text, GikoSys.Setting.TimeAdjustSec)
	else
		GikoSys.Setting.TimeAdjustSec := 0;
	GikoSys.Setting.TimeAdjust := PutPostTimeRadioButton.Checked;
	//2chT|[g
	GikoSys.Setting.GengoSupport := GengoSupport.Checked;
	GikoSys.SetGikoMessage;
	//[JE[g̼Ōx
	GikoSys.Setting.LocalTrapAtt := LocalTrapAtt.Checked;
	GikoSys.Setting.RemoteTrapAtt := RemoteTrapAtt.Checked;
	// Cookie
	GikoSys.Setting.FixedCookie := FixedCookieEdit.Text;

    // Nړ
    GikoSys.Setting.MoveHistorySize :=
        StrToIntDef( MoveHistoryMaxEdit.Text, 20 );

    //@擪\X
    GikoSys.Setting.HeadResCount :=
        StrToIntDef( AHandredLabeledEdit.Text , 1);

	GikoSys.Setting.KuroutSettingTabIndex := PageControl1.ActivePageIndex;
    // ֘AL[[hǉtO
    GikoSys.Setting.AddKeywordLink := AddKeywordCheckBox.Checked;
    // 딽΍
    GikoSys.Setting.ReplaceDat := ReplaceDatCheckBox.Checked;
    GikoSys.Setting.SentIniFileSize := SentIniFileSizeUpDown.Position;
end;

procedure TKuroutOption.RecvBufferSizeExit(Sender: TObject);
begin
	if not GikoSys.IsNumeric(RecvBufferSize.Text) then
		RecvBufferSize.Text := '4096';
	if StrToInt(RecvBufferSize.Text) < 256 then
		RecvBufferSize.Text := '4096';
end;

procedure TKuroutOption.PostTimeEditExit(Sender: TObject);
begin
	if not GikoSys.IsNumeric(PostTimeEdit.Text) then
		PostTimeEdit.Text := '0';
end;

procedure TKuroutOption.PostTimeCheckBoxClick(Sender: TObject);
begin
	PostTimeLabel.Enabled := PostTimeCheckBox.Checked;
	PostTimeEdit.Enabled := PostTimeCheckBox.Checked;
	PutPostTimeRadioButton.Enabled := PostTimeCheckBox.Checked;
	BackPostTimeRadioButton.Enabled := PostTimeCheckBox.Checked;
end;

procedure TKuroutOption.OkBottonClick(Sender: TObject);
begin
	RecvBufferSizeExit(Sender);
	PostTimeEditExit(Sender);
    MoveHistoryMaxEditExit(Sender);
    AHandredLabeledEditExit(Sender);
    PostColumnData();
	SaveSetting;
end;

procedure TKuroutOption.FormCreate(Sender: TObject);
begin
	SetValue;
	PostTimeCheckBoxClick(Sender);

end;
procedure TKuroutOption.SetColumnData();
var
	i, j : Integer;
	flag : Boolean;
begin

	//===== Xg =====
	for i := 0 to GikoSys.Setting.CategoryColumnOrder.Count - 1 do begin
		for j := 1 to Length( GikoCategoryColumnCaption ) - 1 do begin
			if GikoSys.Setting.CategoryColumnOrder[ i ] = TGikoCategoryColumnID( j ) then begin
				CVisibledListBox.AddItem(GikoCategoryColumnCaption[ j ], nil);
				break;
			end;
		end;
	end;

	for i := 1 to Length( GikoCategoryColumnCaption ) - 1 do begin
		flag := false;
		for j := 0 to GikoSys.Setting.CategoryColumnOrder.Count - 1 do begin
			if GikoSys.Setting.CategoryColumnOrder[ j ] = TGikoCategoryColumnID( i ) then begin
				flag := true;
				break;
			end;
		end;
		if not flag then
			CUnVisibledListBox.AddItem(GikoCategoryColumnCaption[ i ], nil);
	end;

	//===== XXg =====
	for i := 0 to GikoSys.Setting.BoardColumnOrder.Count - 1 do begin
		for j := 1 to Length( GikoBoardColumnCaption ) - 1 do begin
			if GikoSys.Setting.BoardColumnOrder[ i ] = TGikoBoardColumnID( j ) then begin
				BVisibledListBox.AddItem(GikoBoardColumnCaption[ j ], nil);
				Break;
			end;
		end;
	end;

	for i := 1 to Length( GikoBoardColumnCaption ) - 1 do begin
		flag := false;
		for j := GikoSys.Setting.BoardColumnOrder.Count - 1 downto 0 do begin
			if GikoSys.Setting.BoardColumnOrder[ j ] = TGikoBoardColumnID( i ) then begin
				flag := true;
				Break;
			end;
		end;
		if not flag then
			BUnVisibledListBox.AddItem(GikoBoardColumnCaption[ i ], nil);

	end;
end;
procedure TKuroutOption.CDeleteButtonClick(Sender: TObject);
var
	i: Integer;
begin
	for i := 0 to CVisibledListBox.Count - 1 do begin
		if CVisibledListBox.Selected[i] then begin
			CUnVisibledListBox.AddItem(	CVisibledListBox.Items.Strings[ i ], nil);
			CVisibledListBox.DeleteSelected;
			break;
		end;
	end;
end;

procedure TKuroutOption.CAddButtonClick(Sender: TObject);
var
	i: Integer;
begin
	for i := 0 to CUnVisibledListBox.Count - 1 do begin
		if CUnVisibledListBox.Selected[i] then begin
			CVisibledListBox.AddItem(	CUnVisibledListBox.Items.Strings[ i ], nil);
			CUnVisibledListBox.DeleteSelected;
			break;
		end;
	end;
end;

procedure TKuroutOption.BAddButtonClick(Sender: TObject);
var
	i: Integer;
begin
	for i := 0 to BUnVisibledListBox.Count - 1 do begin
		if BUnVisibledListBox.Selected[i] then begin
			BVisibledListBox.AddItem(	BUnVisibledListBox.Items.Strings[ i ], nil);
			BUnVisibledListBox.DeleteSelected;
			break;
		end;
	end;
end;

procedure TKuroutOption.BDeleteButtonClick(Sender: TObject);
var
	i: Integer;
begin
	for i := 0 to BVisibledListBox.Count - 1 do begin
		if BVisibledListBox.Selected[i] then begin
			BUnVisibledListBox.AddItem(	BVisibledListBox.Items.Strings[ i ], nil);
			BVisibledListBox.DeleteSelected;
			break;
		end;
	end;
end;

procedure TKuroutOption.CUpButtonClick(Sender: TObject);
var
	i: Integer;
begin
	for i := 1 to CVisibledListBox.Count - 1 do begin
		if CVisibledListBox.Selected[i] then begin
			CVisibledListBox.Items.Exchange(i, i -1);
			break;
		end;
	end;
end;

procedure TKuroutOption.CDownButtonClick(Sender: TObject);
var
	i: Integer;
begin
	for i := 0 to CVisibledListBox.Count - 2 do begin
		if CVisibledListBox.Selected[i] then begin
			CVisibledListBox.Items.Exchange(i, i + 1);
			break;
		end;
	end;
end;

procedure TKuroutOption.BUpButtonClick(Sender: TObject);
var
	i: Integer;
begin
	for i := 1 to BVisibledListBox.Count - 1 do begin
		if BVisibledListBox.Selected[i] then begin
			BVisibledListBox.Items.Exchange(i, i -1);
			break;
		end;
	end;
end;

procedure TKuroutOption.BDownButtonClick(Sender: TObject);
var
	i: Integer;
begin
	for i := 0 to BVisibledListBox.Count - 2 do begin
		if BVisibledListBox.Selected[i] then begin
			BVisibledListBox.Items.Exchange(i, i + 1);
			break;
		end;
	end;
end;


procedure TKuroutOption.PostColumnData();
var
	i, j : Integer;
begin
	GikoForm.ActiveListColumnSave;

	//===== Xg =====
	for i := GikoSys.Setting.CategoryColumnOrder.Count -1 downto 1 do
		GikoSys.Setting.CategoryColumnOrder.Delete(i);

	for i := 0 to CVisibledListBox.Count - 1 do begin
		for j := 1 to Length( GikoCategoryColumnCaption ) - 1 do begin
			if CVisibledListBox.Items.Strings[ i ] = GikoCategoryColumnCaption[ j ] then begin
				GikoSys.Setting.CategoryColumnOrder.Add(  TGikoCategoryColumnID(j) );
				break;
			end;
		end;
	end;

	//===== XXg =====
	for i := GikoSys.Setting.BoardColumnOrder.Count - 1 downto 1 do
		GikoSys.Setting.BoardColumnOrder.Delete(i);

	for i := 0 to BVisibledListBox.Count - 1 do begin
		for j := 1 to Length( GikoBoardColumnCaption ) - 1 do begin
			if BVisibledListBox.Items.Strings[ i ] = GikoBoardColumnCaption[ j ] then begin
				GikoSys.Setting.BoardColumnOrder.Add( TGikoBoardColumnID(j) );
				Break;
			end;
		end;
	end;
	//Xꗗ̕`̍XV
	GikoForm.SetActiveList(GikoForm.ActiveList);
end;
// Nړ̕ҏW̐ݒ蕶`FbN
procedure TKuroutOption.MoveHistoryMaxEditExit(Sender: TObject);
begin
	if not GikoSys.IsNumeric(MoveHistoryMaxEdit.Text) then
		MoveHistoryMaxEdit.Text := '20';
    if StrToInt(MoveHistoryMaxEdit.Text) < 1 then
        MoveHistoryMaxEdit.Text := '1';
end;
// 擪\X̕ҏW̐ݒ蕶`FbN
procedure TKuroutOption.AHandredLabeledEditExit(Sender: TObject);
begin
	if not GikoSys.IsNumeric(AHandredLabeledEdit.Text) then
		AHandredLabeledEdit.Text := '1';
    if StrToInt(AHandredLabeledEdit.Text) < 1 then
        AHandredLabeledEdit.Text := '1';

end;

end.
