unit Preview;

interface
uses
	Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
	ActiveX, 
{$IF Defined(DELPRO) }
	SHDocVw
{$ELSE}
	SHDocVw_TLB
{$IFEND}
;

type
	TPreviewBrowser = class(TWebBrowser)
	private
	protected
		procedure CreateParams(var Params: TCreateParams); override;
	public
		constructor Create(AOwner: TComponent); override;
		destructor Destroy; override;
        procedure PreviewImage(URL : String);
        function GetWindowRect(Point: TPoint) : TRect;
	end;

implementation
uses MojuUtils, GikoSystem, Setting;

const
	//vr[t@C
	HTML_FILE_NAME 	= 'temp_preview.html';

constructor TPreviewBrowser.Create(AOwner: TComponent);
begin
	inherited Create(AOwner);
end;

destructor TPreviewBrowser.Destroy;
begin
	inherited Destroy;
end;

procedure TPreviewBrowser.CreateParams(var Params: TCreateParams);
begin
	inherited;
end;
{
\brief  w肳ꂽURL̃vr[
\param  URL vr[C[WURL
}
procedure TPreviewBrowser.PreviewImage(URL : String);
var
    html : string;
    HtmlFileName : string;
    sl : TStringList;
    Protocol, Host, Path, Document, Port, Bookmark : string;
    Referer : string;
	Flags: OleVariant;
	TargetFrameName: OleVariant;
	PostData: OleVariant;
  	Headers: OleVariant;
begin
	html := '<html><head>'#13#10
				+ '<SCRIPT>'#13#10
				+ 'function init() {'#13#10
				+ '	if ((document.body.clientHeight >= Image1.height) && (document.body.clientWidth >= Image1.width)) {'#13#10
				+ '	} else {'#13#10
				+ '		var dh, ih;'#13#10
				+ '		dh = document.body.clientWidth / document.body.clientHeight;'#13#10
				+ '		ih = Image1.width / Image1.height;'#13#10
				+ '		if (document.body.clientWidth < document.body.clientHeight) {'#13#10
				+ '			if (ih > dh)'#13#10
				+ '				Image1.width = document.body.clientWidth;'#13#10
				+ '			else'#13#10
				+ '				Image1.height = document.body.clientHeight;'#13#10
				+ '		} else {'#13#10
				+ '			if (ih < dh)'#13#10
				+ '				Image1.height = document.body.clientHeight;'#13#10
				+ '			else'#13#10
				+ '				Image1.width = document.body.clientWidth;'#13#10
				+ '		}'#13#10
				+ '	}'#13#10
				+ '	Message.style.display = "none";'#13#10
				+ '}'#13#10
				+ '</SCRIPT>'#13#10
				+ '</head>'#13#10
				+ '<body topmargin="0" leftmargin="0" style="border-width: 1px; overflow:hidden; border-style: solid;" onLoad="init()">'#13#10
				+ '<div align="center" id="Message">vr[쐬</div>'#13#10
				+ '<div align="center"><img name="Image1" border="0" src="%ImageURL%"></div>'#13#10
				+ '</body></html>';
    
    HtmlFileName := GikoSys.GetAppDir + HTML_FILE_NAME;
	sl := TStringList.Create;
	try
		try
            sl.Text := MojuUtils.
                CustomStringReplace(html, '%ImageURL%', URL, False);
			sl.SaveToFile(HtmlFileName);
		finally
			sl.Free;
		end;
	except
	end;

	GikoSys.ParseURI(URL, Protocol, Host, Path, Document, Port, Bookmark);
	Referer := Protocol + '://' + Host;
	if Port <> '' then
		Referer := Referer + ':' + Port;
	Referer := Referer + Path;
	Headers := 'Referer: ' + Referer;
    Flags := 0;
    TargetFrameName := '';
    PostData := '';

	Navigate(HtmlFileName,Flags, TargetFrameName, PostData, Headers);

end;
{
\breif \EBhETCY擾
\param Point }EXJ[\̍W
}
function TPreviewBrowser.GetWindowRect(Point: TPoint) : TRect;
var
    WindowWidth, WindowHeight : Integer;
begin
    // ݒɂꍇ킯
	case GikoSys.Setting.PreviewSize of
		gpsXSmall: begin
			WindowWidth := 128;
			WindowHeight := 96;
		end;
		gpsSmall: begin
			WindowWidth := 256;
			WindowHeight := 192;
		end;
		gpsLarge: begin
			WindowWidth := 512;
			WindowHeight := 384;
		end;
		gpsXLarge: begin
			WindowWidth := 640;
			WindowHeight := 480;
		end;
		else begin	//gpsMedium
			WindowWidth := 384;
			WindowHeight := 288;
		end;
	end;

	Result := Rect(0, 0, WindowWidth, WindowHeight);

    // oʒuɂ␳
	case GikoSys.Setting.PopupPosition of
		gppRightTop: 		OffsetRect(Result,
            Point.x - WindowWidth - 15, Point.y - WindowHeight -	15);
		gppRight: 			OffsetRect(Result,
            Point.x - WindowWidth - 15, Point.y - (WindowHeight div 2));
		gppRightBottom: OffsetRect(Result,
            Point.x - WindowWidth - 15, Point.y + 15);
		gppTop:				OffsetRect(Result,
            Point.x - (WindowWidth div 2), Point.y - WindowHeight - 15);
		gppCenter:			OffsetRect(Result,
            Point.x - (WindowWidth div 2), Point.y - (WindowHeight div 2));
		gppBottom:			OffsetRect(Result,
            Point.x - (WindowWidth div 2), Point.y + 15);
		gppLeftTop:			OffsetRect(Result,
            Point.x + 15, Point.y - WindowHeight -	15);
		gppLeft:			OffsetRect(Result,
            Point.x + 15, Point.y - (WindowHeight div 2));
		gppLeftBottom: 	OffsetRect(Result, Point.x + 15, Point.y + 15);		//MRirX p[gP453Ɋ
	end;

end;
end.
