unit ThreadItem;

{
	ExternalBoardPlugIn ThreadItem
	Xbhێ TThreadItem NX
}

interface

uses
	Windows, SysUtils,
	PlugInMain;

type
	// Xꗗ̏グtO
	TThreadAgeSage = (tasNone, tasAge, tasSage, tasNew, tasArch, tasNull);

	// TThreadItem ̃vpeBݒ^擾 ID
	TThreadItemProperty = (
		tipContext,							// : DWORD			// Rɐݒ肵Ăl
		tipNo,									// : Integer		// ԍ
		tipFileName,						// : string			// Xbht@C
		tipTitle,								// : string			// Xbh^Cg
		tipRoundDate,						// : TDateTime	// Xbh擾ij
		tipLastModified,				// : TDateTime	// XbhXVĂiT[oj
		tipCount,								// : Integer		// XbhJEgi[Jj
		tipAllResCount,					// : Integer		// XbhJEgiT[oj
		tipNewResCount,					// : Integer		// XbhV
		tipSize,								// : Integer		// XbhTCY
		tipRound,								// : Boolean		// tO
		tipRoundName,						// : string			// 
		tipIsLogFile,						// : Boolean		// O݃tO
		tipKokomade,						// : Integer		// RR܂œǂ񂾔ԍ
		tipNewReceive,					// : Integer		// RRVKM
		tipNewArrival,					// : Boolean		// V
		tipUnRead,							// : Boolean		// ǃtO
		tipScrollTop,						// : Integer		// XN[ʒu
		tipDownloadHost,				// : string			// ̃zXgƈႤꍇ̃zXg
		tipAgeSage,							// : TThreadAgeSage	// ACȅグ
		tipURL,									// : string			// XbhuEUŕ\ۂ URL
		tipFilePath,							// : string			// ̃XۑĂpX
		tipJumpAddress							// : Integer		// JUMP惌Xԍ
	);



	// =========================================================================
	// TThreadItem NXɊւ API
	// =========================================================================

	// *************************************************************************
	// ThreadItemGetLong
	// TThreadItem NX̃vpeB擾
	// *************************************************************************
	TThreadItemGetLong = function(
		instance		: DWORD;
		propertyID	: TThreadItemProperty
	) : DWORD; stdcall;

	// *************************************************************************
	// ThreadItemSetLong
	// TThreadItem NX̃vpeBݒ肷
	// *************************************************************************
	TThreadItemSetLong = procedure(
		instanc			: DWORD;
		propertyID	: TThreadItemProperty;
		param : DWORD
	); stdcall;

	// *************************************************************************
	// ThreadItemGetDouble
	// TThreadItem NX̃vpeB擾
	// *************************************************************************
	TThreadItemGetDouble = function(
		instance		: DWORD;
		propertyID	: TThreadItemProperty
	) : Double; stdcall;

	// *************************************************************************
	// ThreadItemSetDouble
	// TThreadItem NX̃vpeBݒ肷
	// *************************************************************************
	TThreadItemSetDouble = procedure(
		instance		: DWORD;
		propertyID	: TThreadItemProperty;
		param				: Double
	); stdcall;

	// *************************************************************************
	// ThreadItemDat2HTML
	// TThreadItem NXɂQ˂ dat ` 1 s HTML ɕϊ
	// *************************************************************************
	TThreadItemDat2HTML = function(
		inInstance	: DWORD;		// ThreadItem ̃CX^X
		inDatRes		: PChar;		// O<>[<>tID<>{<> ō\ꂽeLXg
		inResNo			: DWORD;		// Xԍ
		inIsNew			: Boolean		// VXȂ True
	) : PChar; stdcall;				// `ꂽ HTML

	// *************************************************************************
	// ThreadItemGetHeader
	// TThreadItem NXɃXbh̃wb_擾
	// *************************************************************************
	TThreadItemGetHeader = function(
		inInstance				: DWORD;			// ThreadItem ̃CX^X
		inOptionalHeader	: PChar = nil	// ǉ̃wb_
	) : PChar; stdcall;								// `ꂽ HTML

	// *************************************************************************
	// ThreadItemGetFooter
	// TThreadItem NXɃXbh̃tb^擾
	// *************************************************************************
	TThreadItemGetFooter = function(
		inInstance				: DWORD;			// ThreadItem ̃CX^X
		inOptionalFooter	: PChar = nil	// ǉ̃tb^
	) : PChar; stdcall;								// `ꂽ HTML

	// *************************************************************************
	// ThreadItemWork
	// _E[h̐i󋵂vO{̂ɓ`
	// *************************************************************************
	TThreadItemWork = procedure(
		inInstance	: DWORD;			// ThreadItem ̃CX^X
		inWorkCount	: Integer			// ݂̐i(JEg)
	); stdcall;

	// *************************************************************************
	// ThreadItemWorkBegin
	// _E[hn܂ƂvO{̂ɓ`
	// *************************************************************************
	TThreadItemWorkBegin = procedure(
		inInstance			: DWORD;	// ThreadItem ̃CX^X
		inWorkCountMax	: Integer	// ʐM̏IJEg
	); stdcall;

	// *************************************************************************
	// ThreadItemWorkEnd
	// _E[hIƂvO{̂ɓ`
	// *************************************************************************
	TThreadItemWorkEnd = procedure(
		inInstance	: DWORD				// ThreadItem ̃CX^X
	); stdcall;



	// =========================================================================
	// TThreadItem NXɊւCxg
	// =========================================================================

	// *************************************************************************
	// TThreadItem ꂽ
	// *************************************************************************
	TThreadItemOnCreateEvent = procedure(
		instance : DWORD
	);

	// *************************************************************************
	// TThreadItem jꂽ
	// *************************************************************************
	TThreadItemOnDisposeEvent = procedure(
		instance : DWORD
	);

	// *************************************************************************
	// _E[hwꂽ
	// *************************************************************************
	TThreadItemOnDownloadEvent = function : TDownloadState of object;

	// *************************************************************************
	// ݂wꂽ
	// *************************************************************************
	TThreadItemOnWriteEvent = function(
		inName		: string;					// O(nh)
		inMail		: string;					// [AhX
		inMessage	: string					// {
	) : TDownloadState of object;	// ݂ǂ

	// *************************************************************************
	// Xԍ inNo ɑ΂ html vꂽ
	// *************************************************************************
	TThreadItemOnGetResEvent = function(
		inNo				: Integer
	) : string of object;

	// *************************************************************************
	// Xԍ inNo ɑ΂ dat vꂽ
	// *************************************************************************
	TThreadItemOnGetDatEvent = function(
		inNo				: Integer
	) : string of object;

	// *************************************************************************
	// Xbh̃wb_ html vꂽ
	// *************************************************************************
	TThreadItemOnGetHeaderEvent = function(
		inOptionalHeader	: string	// ǉ̃wb_
	) : string of object;					// `ꂽ HTML

	// *************************************************************************
	// Xbh̃tb^ html vꂽ
	// *************************************************************************
	TThreadItemOnGetFooterEvent = function(
		inOptionalFooter	: string	// ǉ̃tb^
	) : string of object;					// `ꂽ HTML

	// *************************************************************************
	//  ThreadItem  URL vꂽ
	// *************************************************************************
	TThreadItemOnGetBoardURLEvent = function : string of object;	//  URL




	// =========================================================================
	// TThreadItem NX
	// =========================================================================
	TThreadItem = class(TObject)
	private
		// ThreadItem ̃CX^X
		FInstance				: DWORD;

 		// _E[hwꂽ
 		FOnDownload			: TThreadItemOnDownloadEvent;
		// ݂wꂽ
		FOnWrite				: TThreadItemOnWriteEvent;
		// Xԍ n ɑ΂ html vꂽ
		FOnGetRes				: TThreadItemOnGetResEvent;
		// Xԍ n ɑ΂ dat vꂽ
		FOnGetDat				: TThreadItemOnGetDatEvent;
		// Xbh̃wb_ html vꂽ
		FOnGetHeader		: TThreadItemOnGetHeaderEvent;
		// Xbh̃tb^ html vꂽ
		FOnGetFooter		: TThreadItemOnGetFooterEvent;
		//  ThreadItem  URL vꂽ
		FOnGetBoardURL	: TThreadItemOnGetBoardURLEvent;

	public
		// RXgN^
		constructor Create( inInstance : DWORD );
		// X HTML `vO{̂ɔC
		function	Dat2HTML( inDatRes : string; inNo : Integer; inIsNew : Boolean ) : string; overload;
		// X HTML `vO{̂ɔC(ȗ`)
		function	Dat2HTML( inDatRes : string; inNo : Integer ) : string; overload;
		// wb_ HTML `vO{̂ɔC
		function	InternalHeader( inOptionalHeader : string = '' ) : string;
		// tb^ HTML `vO{̂ɔC
		function	InternalFooter( inOptionalFooter : string = '' ) : string;
		// _E[h̐i󋵂vO{̂ɓ`
		procedure	Work( inWorkCount : Integer );
		// _E[hn܂ƂvO{̂ɓ`
		procedure	WorkBegin( inWorkCountMax : Integer );
		// _E[hIƂvO{̂ɓ`
		procedure	WorkEnd;

	private
		// ===== vpeB̊Ǘ𓝊郉bp
		function	GetLong( propertyID : TThreadItemProperty ) : DWORD;
		procedure	SetLong( propertyID : TThreadItemProperty; param : DWORD );
		function	GetDouble( propertyID : TThreadItemProperty ) : Double;
		procedure	SetDouble( propertyID : TThreadItemProperty; param : Double );

		// ===== vpeB̎擾^ݒ𖖒[ɒ񋟂郉bp
		function	GetNo : Integer;
		procedure	SetNo( param : Integer );
		function	GetFileName : string;
		procedure	SetFileName( param : string );
		function	GetTitle : string;
		procedure	SetTitle( param : string );
		function	GetRoundDate : TDateTime;
		procedure	SetRoundDate( param : TDateTime );
		function	GetLastModified : TDateTime;
		procedure	SetLastModified( param : TDateTime );
		function	GetCount : Integer;
		procedure	SetCount( param : Integer );
		function	GetAllResCount : Integer;
		procedure	SetAllResCount( param : Integer );
		function	GetNewResCount : Integer;
		procedure	SetNewResCount( param : Integer );
		function	GetSize : Integer;
		procedure	SetSize( param : Integer );
		function	GetRound : Boolean;
		procedure	SetRound( param : Boolean );
		function	GetRoundName : string;
		procedure	SetRoundName( param : string );
		function	GetIsLogFile : Boolean;
		procedure	SetIsLogFile( param : Boolean );
		function	GetKokomade : Integer;
		procedure	SetKokomade( param : Integer );
		function	GetNewReceive : Integer;
		procedure	SetNewReceive( param : Integer );
		function	GetNewArrival : Boolean;
		procedure	SetNewArrival( param : Boolean );
		function	GetUnRead : Boolean;
		procedure	SetUnRead( param : Boolean );
		function	GetScrollTop : Integer;
		procedure	SetScrollTop( param : Integer );
		function	GetDownloadHost : string;
		procedure	SetDownloadHost( param : string );
		function	GetAgeSage : TThreadAgeSage;
		procedure	SetAgeSage( param : TThreadAgeSage );
		function	GetURL : string;
		procedure	SetURL( param : string );
		function	GetFilePath : string;
		{procedure	SetFilePath( param : string );}
		procedure	SetJumpAddress( param : Integer );
		function	GetJumpAddress : Integer;
	protected
		property	Instance			: DWORD						read FInstance;

	public
		// ===== Cxg
		property	OnDownload		: TThreadItemOnDownloadEvent		read FOnDownload write FOnDownload;
		property	OnWrite				: TThreadItemOnWriteEvent				read FOnWrite write FOnWrite;
		property	OnGetRes			: TThreadItemOnGetResEvent			read FOnGetRes write FOnGetRes;
        property	OnGetDat			: TThreadItemOnGetDatEvent			read FOnGetDat write FOnGetDat;
		property	OnGetHeader		: TThreadItemOnGetHeaderEvent		read FOnGetHeader write FOnGetHeader;
		property	OnGetFooter		: TThreadItemOnGetFooterEvent		read FOnGetFooter write FOnGetFooter;
		property	OnGetBoardURL	: TThreadItemOnGetBoardURLEvent	read FOnGetBoardURL write FOnGetBoardURL;

		// ===== ThreadItem Ɏ擾^ݒ\ȃvpeB
		// ԍ
		property	No						: Integer					read GetNo write SetNo;
		// Xbht@C
		property	FileName			: string					read GetFileName write SetFileName;
		// Xbh^Cg
		property	Title					: string					read GetTitle write SetTitle;
		// Xbh擾ij
		property	RoundDate			: TDateTime				read GetRoundDate write SetRoundDate;
		// XbhXVĂiT[oj
		property	LastModified	: TDateTime				read GetLastModified write SetLastModified;
		// XbhJEgi[Jj
		property	Count					: Integer					read GetCount write SetCount;
		// XbhJEgiT[oj
		property	AllResCount		: Integer					read GetAllResCount write SetAllResCount;
		// XbhV
		property	NewResCount		: Integer					read GetNewResCount write SetNewResCount;
		// XbhTCY
		property	Size					: Integer					read GetSize write SetSize;
		// tO
		property	Round					: Boolean					read GetRound write SetRound;
		// 
		property	RoundName			: string					read GetRoundName write SetRoundName;
		// O݃tO
		property	IsLogFile			: Boolean					read GetIsLogFile write SetIsLogFile;
		// RR܂œǂ񂾔ԍ
		property	Kokomade			: Integer					read GetKokomade write SetKokomade;
		// RRVKM
		property	NewReceive		: Integer					read GetNewReceive write SetNewReceive;
		// V
		property	NewArrival		: Boolean					read GetNewArrival write SetNewArrival;
		// ǃtO
		property	UnRead				: Boolean					read GetUnRead write SetUnRead;
		// XN[ʒu
		property	ScrollTop			: Integer					read GetScrollTop write SetScrollTop;
		// ̃zXgƈႤꍇ̃zXg
		property	DownloadHost	: string					read GetDownloadHost write SetDownloadHost;
		// ACȅグ
		property	AgeSage				: TThreadAgeSage	read GetAgeSage write SetAgeSage;
		// XbhuEUŕ\ۂ URL
		property	URL						: string					read GetURL write SetURL;
		// ̃XۑĂpX
		property	FilePath			: string					read GetFilePath {write SetFilePath};
		// JUMP惌Xԍ
		property	JumpAddress		: Integer	read GetJumpAddress write SetJumpAddress;
	end;

var
	// ===== API ̃AhX
	ThreadItemGetLong		: TThreadItemGetLong;
	ThreadItemSetLong		: TThreadItemSetLong;
	ThreadItemGetDouble	: TThreadItemGetDouble;
	ThreadItemSetDouble	: TThreadItemSetDouble;
	ThreadItemDat2HTML	: TThreadItemDat2HTML;
	ThreadItemGetHeader	: TThreadItemGetHeader;
	ThreadItemGetFooter	: TThreadItemGetFooter;
	ThreadItemWork			: TThreadItemWork;
	ThreadItemWorkBegin	: TThreadItemWorkBegin;
	ThreadItemWorkEnd		: TThreadItemWorkEnd;
	// ===== Cxgnh
	ThreadItemOnCreate	: TThreadItemOnCreateEvent;
	ThreadItemOnDispose	: TThreadItemOnDisposeEvent;

// ===== TThreadItem NXǗ֐
procedure LoadInternalThreadItemAPI(
	inModule : HMODULE
);
procedure ThreadItemOnCreateOfTThreadItem(
	inInstance : DWORD
);
procedure ThreadItemOnDisposeOfTThreadItem(
	inInstance : DWORD
);

implementation

// *************************************************************************
// TThreadItem ̃RXgN^
// *************************************************************************
constructor TThreadItem.Create(
	inInstance : DWORD											// CX^X
);
begin

	inherited Create;
	FInstance 		:= inInstance;
	OnDownload		:= nil;
	OnWrite				:= nil;
	OnGetRes			:= nil;
    OnGetDat			:= nil;
	OnGetHeader		:= nil;
	OnGetFooter		:= nil;
	OnGetBoardURL	:= nil;

end;

// *************************************************************************
// X HTML `vO{̂ɔC
// *************************************************************************
function	TThreadItem.Dat2HTML(
	inDatRes	: string;											// O<>[<>tID<>{<> ō\ꂽeLXg
	inNo			: Integer;										// Xԍ
	inIsNew		: Boolean											// VXȂ True
) : string;																// `ꂽ HTML
var
	tmp				: PChar;
begin

	tmp			:= ThreadItemDat2HTML( FInstance, PChar( inDatRes ), inNo, inIsNew );
	Result	:= string( tmp );
	DisposeResultString( tmp );

end;

// *************************************************************************
// X HTML `vO{̂ɔC(ȗ`)
// *************************************************************************
function	TThreadItem.Dat2HTML(
	inDatRes	: string;											// O<>[<>tID<>{<> ō\ꂽeLXg
	inNo			: Integer											// Xԍ
) : string;																// `ꂽ HTML
begin

	Result := Dat2HTML( inDatRes, inNo, inNo >= NewReceive );

end;

// *************************************************************************
// wb_ HTML `vO{̂ɔC
// *************************************************************************
function	TThreadItem.InternalHeader(
	inOptionalHeader	: string = ''					// ǉ̃wb_
) : string;																// `ꂽ HTML
var
	tmp								: PChar;
begin

	tmp			:= ThreadItemGetHeader( FInstance, PChar( inOptionalHeader ) );
	Result	:= string( tmp );
	DisposeResultString( tmp );

end;

// *************************************************************************
// tb^ HTML `vO{̂ɔC
// *************************************************************************
function	TThreadItem.InternalFooter(
	inOptionalFooter	: string = ''					// ǉ̃tb^
) : string;																// `ꂽ HTML
var
	tmp								: PChar;
begin

	tmp			:= ThreadItemGetFooter( FInstance, PChar( inOptionalFooter ) );
	Result	:= string( tmp );
	DisposeResultString( tmp );

end;

// *************************************************************************
// _E[h̐i󋵂vO{̂ɓ`
// *************************************************************************
procedure	TThreadItem.Work(
	inWorkCount : Integer			// ݂̐i(JEg)
);
begin

	ThreadItemWork( FInstance, inWorkCount );

end;

// *************************************************************************
// _E[hn܂ƂvO{̂ɓ`
// *************************************************************************
procedure	TThreadItem.WorkBegin(
	inWorkCountMax : Integer	// ʐM̏IJEg
);
begin

	ThreadItemWorkBegin( FInstance, inWorkCountMax );

end;

// *************************************************************************
// _E[hIƂvO{̂ɓ`
// *************************************************************************
procedure	TThreadItem.WorkEnd;
begin

	ThreadItemWorkEnd( FInstance );

end;



// =========================================================================
// TThreadItem ̃vpeB̊Ǘ𓝊郉bp
// =========================================================================
function	TThreadItem.GetLong( propertyID : TThreadItemProperty ) : DWORD;
begin
	Result := ThreadItemGetLong( FInstance, propertyID );
end;

procedure	TThreadItem.SetLong( propertyID : TThreadItemProperty; param : DWORD );
begin
	ThreadItemSetLong( FInstance, propertyID, param );
end;

function	TThreadItem.GetDouble( propertyID : TThreadItemProperty ) : Double;
begin
	Result := ThreadItemGetDouble( FInstance, propertyID );
end;

procedure	TThreadItem.SetDouble( propertyID : TThreadItemProperty; param : Double );
begin
	ThreadItemSetDouble( FInstance, propertyID, param );
end;



// =========================================================================
// 火
// TThreadItem ̃vpeB̎擾^ݒ𖖒[ɒ񋟂郉bp
// =========================================================================
function	TThreadItem.GetNo : Integer;
begin
	Result := GetLong( tipNo );
end;

procedure	TThreadItem.SetNo( param : Integer );
begin
	SetLong( tipNo, param );
end;

function	TThreadItem.GetFileName : string;
var
	tmp : PChar;
begin
	tmp			:= PChar( GetLong( tipFileName ) );
	Result	:= string( tmp );
	DisposeResultString( tmp );
end;

procedure	TThreadItem.SetFileName( param : string );
begin
	SetLong( tipFileName, DWORD( PChar( param ) ) );
end;

function	TThreadItem.GetTitle : string;
var
	tmp : PChar;
begin
	tmp			:= PChar( GetLong( tipTitle ) );
	Result	:= string( tmp );
	DisposeResultString( tmp );
end;

procedure	TThreadItem.SetTitle( param : string );
begin
	SetLong( tipTitle, DWORD( PChar( param ) ) );
end;

function	TThreadItem.GetRoundDate : TDateTime;
begin
	Result := GetDouble( tipRoundDate );
end;

procedure	TThreadItem.SetRoundDate( param : TDateTime );
begin
	SetDouble( tipRoundDate, param );
end;

function	TThreadItem.GetLastModified : TDateTime;
begin
	Result := GetDouble( tipLastModified );
end;

procedure	TThreadItem.SetLastModified( param : TDateTime );
begin
	SetDouble( tipLastModified, param );
end;

function	TThreadItem.GetCount : Integer;
begin
	Result := GetLong( tipCount );
end;

procedure	TThreadItem.SetCount( param : Integer );
begin
	SetLong( tipCount, param );
end;

function	TThreadItem.GetAllResCount : Integer;
begin
	Result := GetLong( tipAllResCount );
end;

procedure	TThreadItem.SetAllResCount( param : Integer );
begin
	SetLong( tipAllResCount, param );
end;

function	TThreadItem.GetNewResCount : Integer;
begin
	Result := GetLong( tipNewResCount );
end;

procedure	TThreadItem.SetNewResCount( param : Integer );
begin
	SetLong( tipNewResCount, param );
end;

function	TThreadItem.GetSize : Integer;
begin
	Result := GetLong( tipSize );
end;

procedure	TThreadItem.SetSize( param : Integer );
begin
	SetLong( tipSize, param );
end;

function	TThreadItem.GetRound : Boolean;
begin
	Result := Boolean( GetLong( tipRound ) );
end;

procedure	TThreadItem.SetRound( param : Boolean );
begin
	SetLong( tipRound, DWORD( param ) );
end;

function	TThreadItem.GetRoundName : string;
var
	tmp : PChar;
begin
	tmp			:= PChar( GetLong( tipRoundName ) );
	Result	:= string( tmp );
	DisposeResultString( tmp );
end;

procedure	TThreadItem.SetRoundName( param : string );
begin
	SetLong( tipRoundName, DWORD( PChar( param ) ) );
end;

function	TThreadItem.GetIsLogFile : Boolean;
begin
	Result := Boolean( GetLong( tipIsLogFile ) );
end;

procedure	TThreadItem.SetIsLogFile( param : Boolean );
begin
	SetLong( tipIsLogFile, DWORD( param ) );
end;

function	TThreadItem.GetKokomade : Integer;
begin
	Result := GetLong( tipKokomade );
end;

procedure	TThreadItem.SetKokomade( param : Integer );
begin
	SetLong( tipKokomade, param );
end;

function	TThreadItem.GetNewReceive : Integer;
begin
	Result := GetLong( tipNewReceive );
end;

procedure	TThreadItem.SetNewReceive( param : Integer );
begin
	SetLong( tipNewReceive, param );
end;

function	TThreadItem.GetNewArrival : Boolean;
begin
	Result := Boolean( GetLong( tipNewArrival ) );
end;

procedure	TThreadItem.SetNewArrival( param : Boolean );
begin
	SetLong( tipNewarrival, DWORD( param ) );
end;

function	TThreadItem.GetUnRead : Boolean;
begin
	Result := Boolean( GetLong( tipUnRead ) );
end;

procedure	TThreadItem.SetUnRead( param : Boolean );
begin
	SetLong( tipUnRead, DWORD( param ) );
end;

function	TThreadItem.GetScrollTop : Integer;
begin
	Result := GetLong( tipScrollTop );
end;

procedure	TThreadItem.SetScrollTop( param : Integer );
begin
	SetLong( tipScrollTop, param );
end;

function	TThreadItem.GetDownloadHost : string;
var
	tmp : PChar;
begin
	tmp			:= PChar( GetLong( tipDownloadHost ) );
	Result	:= string( tmp );
	DisposeResultString( tmp );
end;

procedure	TThreadItem.SetDownloadHost( param : string );
begin
	SetLong( tipDownloadHost, DWORD( PChar( param ) ) );
end;

function	TThreadItem.GetAgeSage : TThreadAgeSage;
begin
	Result := TThreadAgeSage( GetLong( tipAgeSage ) );
end;

procedure	TThreadItem.SetAgeSage( param : TThreadAgeSage );
begin
	SetLong( tipAgeSage, DWORD( param ) );
end;

function	TThreadItem.GetURL : string;
var
	tmp : PChar;
begin
	tmp			:= PChar( GetLong( tipURL ) );
	Result	:= string( tmp );
	DisposeResultString( tmp );
end;

procedure	TThreadItem.SetURL( param : string );
begin
	SetLong( tipURL, DWORD( PChar( param ) ) );
end;

function	TThreadItem.GetFilePath : string;
var
	tmp : PChar;
begin
	tmp			:= PChar( GetLong( tipFilePath ) );
	Result	:= string( tmp );
	DisposeResultString( tmp );
end;
function	TThreadItem.GetJumpAddress : Integer;
begin
	Result := GetLong( tipJumpAddress );
end;

procedure	TThreadItem.SetJumpAddress( param : Integer );
begin
	SetLong( tipJumpAddress, param );
end;
{
procedure	TThreadItem.SetFilePath( param : string );
begin
	SetLong( tipFilePath, DWORD( PChar( param ) ) );
end;
}// =========================================================================
// TThreadItem ̃vpeB̎擾^ݒ𖖒[ɒ񋟂郉bp
// ܂Ł
// =========================================================================



// =========================================================================
// TThreadItem NXǗ֐
// =========================================================================

// *************************************************************************
// TThreadItem ꂽꍇ̃ftHg̏u(TThreadItem 𐶐)
// *************************************************************************
procedure ThreadItemOnCreateOfTThreadItem(
	inInstance : DWORD
);
var
	threadItem : TThreadItem;
begin

	threadItem := TThreadItem.Create( inInstance );
	ThreadItemSetLong( inInstance, tipContext, DWORD( threadItem ) );

end;

// *************************************************************************
// TThreadItem jꂽꍇ̃ftHg̏u(TThreadItem j)
// *************************************************************************
procedure ThreadItemOnDisposeOfTThreadItem(
	inInstance : DWORD
);
var
	threadItem : TThreadItem;
begin

	threadItem := TThreadItem( ThreadItemGetLong( inInstance, tipContext ) );
	threadItem.Free;

end;

// *************************************************************************
// PlugInSDK  TThreadItem Ɋւ API 
// *************************************************************************
procedure LoadInternalThreadItemAPI(
	inModule : HMODULE
);
begin

	// ===== CX^X̃ftHg̎舵 TThreadItem ɂ
	ThreadItemOnCreate	:= ThreadItemOnCreateOfTThreadItem;
	ThreadItemOnDispose	:= ThreadItemOnDisposeOfTThreadItem;

	// ===== TThreadItem vpeB擾ݒ֐
	ThreadItemGetLong := GetProcAddress( inModule, 'ThreadItemGetLong' );
	if not Assigned( ThreadItemGetLong ) then
		System.ExitCode := 1;
	ThreadItemSetLong := GetProcAddress( inModule, 'ThreadItemSetLong' );
	if not Assigned( ThreadItemSetLong ) then
		System.ExitCode := 1;
	ThreadItemGetDouble := GetProcAddress( inModule, 'ThreadItemGetDouble' );
	if not Assigned( ThreadItemGetDouble ) then
		System.ExitCode := 1;
	ThreadItemSetDouble := GetProcAddress( inModule, 'ThreadItemSetDouble' );
	if not Assigned( ThreadItemSetDouble ) then
		System.ExitCode := 1;
	ThreadItemDat2HTML := GetProcAddress( inModule, 'ThreadItemDat2HTML' );
	if not Assigned( ThreadItemDat2HTML ) then
		System.ExitCode := 1;
	ThreadItemGetHeader := GetProcAddress( inModule, 'ThreadItemGetHeader' );
	if not Assigned( ThreadItemGetHeader ) then
		System.ExitCode := 1;
	ThreadItemGetFooter := GetProcAddress( inModule, 'ThreadItemGetFooter' );
	if not Assigned( ThreadItemGetFooter ) then
		System.ExitCode := 1;
	ThreadItemWork := GetProcAddress( inModule, 'ThreadItemWork' );
	if not Assigned( ThreadItemWork ) then
		System.ExitCode := 1;
	ThreadItemWorkBegin := GetProcAddress( inModule, 'ThreadItemWorkBegin' );
	if not Assigned( ThreadItemWorkBegin ) then
		System.ExitCode := 1;
	ThreadItemWorkEnd := GetProcAddress( inModule, 'ThreadItemWorkEnd' );
	if not Assigned( ThreadItemWorkEnd ) then
		System.ExitCode := 1;

end;



// =========================================================================
// TThreadItem NXɊւCxg
// =========================================================================

// *************************************************************************
// TThreadItem ꂽ
// *************************************************************************
procedure ThreadItemCreate(
	inInstance : DWORD
); stdcall;
begin

	try
		ThreadItemOnCreate( inInstance );
	except end;

end;

// *************************************************************************
// TThreadItem jꂽ
// *************************************************************************
procedure ThreadItemDispose(
	inInstance : DWORD
); stdcall;
begin

	try
		ThreadItemOnDispose( inInstance );
	except end;

end;

// *************************************************************************
// _E[hwꂽ
// *************************************************************************
function ThreadItemOnDownload(
	inInstance	: DWORD					// ThreadItem ̃CX^X
) : TDownloadState; stdcall;	// _E[hǂ
var
	context			: Pointer;
	threadItem	: TThreadItem;
begin

	try
		repeat
			context := Pointer( ThreadItemGetLong( inInstance, tipContext ) );
			if not Assigned( context ) then
				Break;

			if not (TObject( context ) is TThreadItem) then
				Break;

			threadItem := TThreadItem( context );
			if not Assigned( threadItem.OnDownload ) then
				Break;

			Result := threadItem.OnDownload;
			Exit;
		until True;
	except end;

	Result := dsError;

end;

// *************************************************************************
// ݂wꂽ
// *************************************************************************
function	ThreadItemOnWrite(
	inInstance	: DWORD;				// ThreadItem ̃CX^X
	inName			: PChar;				// O(nh)
	inMail			: PChar;				// [AhX
	inMessage		: PChar					// {
) : TDownloadState; stdcall;	// ݂ǂ
var
	context			: Pointer;
	threadItem	: TThreadItem;
begin

	try
		repeat
			context := Pointer( ThreadItemGetLong( inInstance, tipContext ) );
			if not Assigned( context ) then
				Break;

			if not (TObject( context ) is TThreadItem) then
				Break;

			threadItem := TThreadItem( context );
			if not Assigned( threadItem.OnWrite ) then
				Break;

			Result := threadItem.OnWrite( string( inName ), string( inMail ), string( inMessage ) );
			Exit;
		until True;
	except end;

	Result := dsError;

end;

// *************************************************************************
// Xԍ n ɑ΂ html vꂽ
// *************************************************************************
function ThreadItemOnGetRes(
	inInstance	: DWORD;		// ThreadItem ̃CX^X
	inNo				: DWORD			// \郌Xԍ
) : PChar; stdcall;				// \ HTML
var
	context			: Pointer;
	threadItem	: TThreadItem;
begin

	try
		repeat
			context := Pointer( ThreadItemGetLong( inInstance, tipContext ) );
			if not Assigned( context ) then
				Break;

			if not (TObject( context ) is TThreadItem) then
				Break;

			threadItem := TThreadItem( context );
			if not Assigned( threadItem.OnGetRes ) then
				Break;

			Result := CreateResultString( threadItem.OnGetRes( inNo ) );
			Exit;
		until True;
	except end;

	Result := nil;

end;

// *************************************************************************
// Xԍ n ɑ΂ Dat vꂽ
// *************************************************************************
function ThreadItemOnGetDat(
	inInstance	: DWORD;		// ThreadItem ̃CX^X
	inNo				: DWORD			// \郌Xԍ
) : PChar; stdcall;				// Q˂Dat`
var
	context			: Pointer;
	threadItem	: TThreadItem;
begin

	try
		repeat
			context := Pointer( ThreadItemGetLong( inInstance, tipContext ) );
			if not Assigned( context ) then
				Break;

			if not (TObject( context ) is TThreadItem) then
				Break;

			threadItem := TThreadItem( context );
			if not Assigned( threadItem.OnGetDat ) then
				Break;

			Result := CreateResultString( threadItem.OnGetDat( inNo ) );
			Exit;
		until True;
	except end;

	Result := nil;

end;

// *************************************************************************
// Xbh̃wb_ html vꂽ
// *************************************************************************
function ThreadItemOnGetHeader(
	inInstance				: DWORD;	// ThreadItem ̃CX^X
	inOptionalHeader	: PChar		// ǉ̃wb_
) : PChar; stdcall;						// `ꂽ HTML
var
	context						: Pointer;
	threadItem				: TThreadItem;
begin

	try
		repeat
			context := Pointer( ThreadItemGetLong( inInstance, tipContext ) );
			if not Assigned( context ) then
				Break;

			if not (TObject( context ) is TThreadItem) then
				Break;

			threadItem := TThreadItem( context );
			if not Assigned( threadItem.OnGetHeader ) then
				Break;

			Result := CreateResultString( threadItem.OnGetHeader( string( inOptionalHeader ) ) );
			Exit;
		until True;
	except end;

	Result := ThreadItemGetHeader( inInstance, inOptionalHeader );

end;

// *************************************************************************
// Xbh̃tb^ html vꂽ
// *************************************************************************
function ThreadItemOnGetFooter(
	inInstance				: DWORD;	// ThreadItem ̃CX^X
	inOptionalFooter	: PChar		// ǉ̃tb^
) : PChar; stdcall;						// `ꂽ HTML
var
	context						: Pointer;
	threadItem				: TThreadItem;
begin

	try
		repeat
			context := Pointer( ThreadItemGetLong( inInstance, tipContext ) );
			if not Assigned( context ) then
				Break;

			if not (TObject( context ) is TThreadItem) then
				Break;

			threadItem := TThreadItem( context );
			if not Assigned( threadItem.OnGetFooter ) then
				Break;

			Result := CreateResultString( threadItem.OnGetFooter( string( inOptionalFooter ) ) );
			Exit;
		until True;
	except end;

	Result := ThreadItemGetFooter( inInstance, inOptionalFooter );

end;

// *************************************************************************
//  ThreadItem  URL vꂽ
// *************************************************************************
function ThreadItemOnGetBoardURL(
	inInstance	: DWORD	// ThreadItem ̃CX^X
) : PChar; stdcall;	 	//  URL
var
	context						: Pointer;
	threadItem				: TThreadItem;
begin

	try
		repeat
			context := Pointer( ThreadItemGetLong( inInstance, tipContext ) );
			if not Assigned( context ) then
				Break;

			if not (TObject( context ) is TThreadItem) then
				Break;

			threadItem := TThreadItem( context );
			if not Assigned( threadItem.OnGetBoardURL ) then
				Break;

			Result := CreateResultString( threadItem.OnGetBoardURL );
			Exit;
		until True;
	except end;

	Result := nil;

end;

exports
	ThreadItemCreate,
	ThreadItemDispose,
	ThreadItemOnDownload,
	ThreadItemOnWrite,
	ThreadItemOnGetRes,
    ThreadItemOnGetDat,
	ThreadItemOnGetHeader,
	ThreadItemOnGetFooter,
	ThreadItemOnGetBoardURL;

end.
