/*
 * CtrlDemoCircleMoveA.h
 *
 *  Created on: 2009/03/19
 *      Author: sambuichi
 */

#ifndef CTRLDEMOCIRCLEMOVEA_H_
#define CTRLDEMOCIRCLEMOVEA_H_

#include "app/grid/SeqAreaCtrl.h"
#include "app/grid/SynthSelectLabel.h"
#include "app/grid/StepPatternSelector.h"
#include "app/grid/InputEventToSeqMessage.h"
#include "app/grid/MouseEventDrawer.h"
#include "app/grid/GridEventDrawer.h"
#include "app/grid/GridPosCtrl.h"

#include "sound/SynthManager.h"
#include "sound/SequenceManage.h"

#include "graphic/AppForm.h"
#include "graphic/primitive/Line.h"
#include "graphic/comp/GridEventView.h"
#include "graphic/comp/InputEvents.h"
#include "graphic/comp/VstiParamList.h"
#include "graphic/comp/GridSheet.h"
#include "graphic/comp/GridFigure.h"
#include "graphic/comp/GirdPositioner.h"

class AppGridSynth:
	public AppForm,
	public SequenceManage,
	public SynthManager,
	public SynthChangedListener {
public:
	AppGridSynth();
	virtual ~AppGridSynth();

	void draw();
	void update();
	void keyFunc(int key, int action);
	void mouseButton(int pos, int state);
	void mousePosition(int x, int y);
	void mouseWheel(int val);
	void windowSizeChanged(int width, int height);

	virtual void metroEvent(Metro *metro);

protected:
	void sequencerEventProcessed(Sequence *seq, Sequence::Message &msg);
	void synthChanged(Synth *synth);

private:
	int mouseLPressing;
	int ctrlCC;

	//! grid
	void drawCell(int pixelx, int pixely);

	GridSheet gsheet;
	GridPositioner gpos;
	GridPosCtrl gposCtrl;
	GridFigureFactory figureFactory;

	SeqAreaCtrl seqAreaCtrl;						//! V[PX̕`GAǗ
	GridEventView gridEventView;
	InputEvents inputEvents;						//! InputEventǗ
	InputEventToSeqMessage inputEventToSeqMessage;	//! InputEventV[PXbZ[W
	MouseEventDrawer mouseEventDrawer;				//! V[PXCxg̕`
	GridEventDrawer gridEventDrawer;				//! V[PXCxg̕`
	SynthSelectLabel synthLabel;					//! JgEVZ̕\x
	StepPatternSelector stepPatternSelector;		//! ̓Xebvp^[̊Ǘ
//	VstiParamList *vstiParamList;

	void deleteSequence(Sequence *seq);
	void deleteRolloverSequence();

	// Input Event
	bool press;
	int pressx;
	int pressy;
	int cnt;

	MousePick lastPress;
	MousePick lastDrug;
};

#endif /* CTRLDEMOCIRCLEMOVEA_H_ */
