/*
 * GridPosCtrl.cpp
 *
 *  Created on: 2009/11/01
 *      Author: ox
 */

#include "GridPosCtrl.h"
#include "common.h"

GridPosCtrl::GridPosCtrl(UnitMng *mng, GridPositioner &gpos) :
	mng(mng),
	gpos(gpos),
	rowCtrl(mng, Layout::listPosX, Layout::listPosY, Layout::listHeight, Layout::numShowListItem),
	colCtrl(mng, Layout::listPosX, Layout::listPosY, Layout::listHeight, Layout::numShowListItem)
{

}

GridPosCtrl::~GridPosCtrl() {
}

inline void GridPosCtrl::getSynthParamStr(Synth *synth, unsigned int paramNum, string &str) {
	char _name[256] = {0};
	char _numstr[10] = {0};

	sprintf(_numstr, "%03d ", paramNum);
	str = _numstr;
	synth->getParamName(paramNum, _name);
	str.append(_name);
}

inline void GridPosCtrl::getSynthParams(Synth *synth, vector<string> &paramStrs) {
	unsigned int numSynthParams = synth->getNumParams();
	string str;
	for(unsigned int i = 0; i < numSynthParams; i++) {
		getSynthParamStr(synth, i, str);
		paramStrs.push_back(str);
	}
}

void GridPosCtrl::press(Synth *synth, int x, int y)
{
	printfunc

	//! gridPositioner̃xNbNꂽꍇ
	if(gpos.colLabel()->isArea(x, y)) {
		vector<string> paramStrs;
		getSynthParams(synth, paramStrs);
		if(colCtrl.isShowing()) {
			colCtrl.hide();
		} else {
			colCtrl.show(paramStrs);
		}
	} else {	// gpos̃xȊONbNꂽꍇ
		if(colCtrl.isShowing()) {	// \ł
			int selectedNumber = colCtrl.select(x, y);
			if(selectedNumber >= 0) {
				string str;
				getSynthParamStr(synth, selectedNumber, str);
				cout << "gpos.colLabel() " << str << endl;
				gpos.colLabel()->setLabel(str);
			}
			colCtrl.hide();
		}
	}

}

void GridPosCtrl::position(int x, int y)
{
	if(rowCtrl.isShowing()) {
		rowCtrl.position(x, y);
	}

	if(colCtrl.isShowing()) {
		colCtrl.position(x, y);
	}

}

void GridPosCtrl::mouseWheel(int val)
{
	static int lastWheelVal = 0;
	int relativeWheelVal = val - lastWheelVal;
	lastWheelVal = val;

	if(relativeWheelVal > 0) {
		rowCtrl.prevPage();
	} else {
		rowCtrl.nextPage();
	}

	if(relativeWheelVal > 0) {
		colCtrl.prevPage();
	} else {
		colCtrl.nextPage();
	}
}



