/*
 * SeqCtrl.h
 *
 *  Created on: 2009/10/20
 *      Author: ox
 */

#ifndef SEQCTRL_H_
#define SEQCTRL_H_

#include "sound/SynthManager.h"
#include "app/grid/SequenceArea.h"
#include "app/grid/SeqTrajectory.h"

#include "graphic/text/FTLabelFactory.h"
#include "graphic/comp/GridFigure.h"
#include "graphic/comp/InputEvents.h"

class SeqAreaCtrl {
public:
	SeqAreaCtrl(GridFigureFactory &figureFactory, float width, float height);
	virtual ~SeqAreaCtrl();

	void show(Sequence *seq);

	void hide(Sequence *seq);

	void rollover(int x, int y);

	//! SV[PX\𔻒
	bool isAllShowing() { return sequenceAreaViewing; }

	//! SV[PX\
	void showAll();

	//! SV[PX\
	void hideAll();

	//! V[PXo^
	void entryInputArea(Sequence *seq, InputEvents &inputEvents);

	//! V[PXo^
	void remove(Sequence *seq) {
		seqAreaMutex.lock();
		hide(seq);	//! seqɑΉSeqGA\
		SequenceArea *removeArea = seqAreaMap[seq];	//! removeSeqArea
		seqAreaMap.erase(seq);
		//! seqɑΉSequenceArea폜
		for(vector<SequenceArea*>::iterator itr = seqAreas.begin(); itr != seqAreas.end();) {
			if(((SequenceArea*)*itr) == removeArea) {
				seqAreas.erase(itr);
			} else {
				itr++;
			}
		}
		SeqTrajectory *removeTraj = seqTrajMap[seq];	//! removeSeqArea
		seqTrajMap.erase(seq);
		for(vector<SeqTrajectory*>::iterator itr = seqTrajs.begin(); itr != seqTrajs.end();) {
			if(((SeqTrajectory*)*itr) == removeTraj) {
				seqTrajs.erase(itr);
			} else {
				itr++;
			}
		}
		seqAreaMutex.unlock();
	}

	//! [I[o[Ԃ̃V[PXQ
	vector<Sequence*> &getRolloverSeq() {
		seqAreaMutex.lock();
		mouseOverSequences.clear();
		for(map<Sequence*,SequenceArea*>::iterator itr = seqAreaMap.begin(); itr != seqAreaMap.end(); itr++) {
			SequenceArea *seqArea = (*itr).second;
			if(seqArea->isRollover()){
				mouseOverSequences.push_back((*itr).first);
			}
		}
		seqAreaMutex.unlock();
		return mouseOverSequences;
	}


private:
	GridFigureFactory &figureFactory;	// `nh
	vector<SequenceArea*> seqAreas;
	vector<SeqTrajectory*> seqTrajs;
	vector<Sequence*> mouseOverSequences;
	map<Sequence*, SequenceArea*> seqAreaMap;
	map<Sequence*, SeqTrajectory*> seqTrajMap;

	Mutex seqAreaMutex;

	float width;
	float height;
//	float width_over;
//	float height_over;
	bool sequenceAreaViewing;
};

#endif /* SEQCTRL_H_ */
